/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASMultiLanResInfo;
import com.kingdee.eas.bs.ml.EASResourceInfo;
import com.kingdee.eas.bs.ml.ILanguage;
import com.kingdee.eas.bs.ml.LanguageCollection;
import com.kingdee.eas.bs.ml.LanguageFactory;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.MetasResourceInfo;
import com.kingdee.eas.bs.ml.PresetDataResourceInfo;
import com.kingdee.eas.bs.ml.TemplateResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class MLFacadeHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.MLFacadeHelper");

    public static void addNewWordsAndTrans(Context ctx, Connection conn, String tempTab, String lan) throws SQLException, BOSException {
        if (ctx == null || conn == null || tempTab == null || lan == null) {
            return;
        }
        StringBuffer quy_sql = new StringBuffer();
        quy_sql.append(" select ml.fid mlID,ml.FCNMD5Code md5,temp.FContent mlRes,temp.FCN res ");
        quy_sql.append(" from ").append(tempTab).append(" temp");
        quy_sql.append(" left join t_res_EASMultiLanRes ml on temp.FMD5 = ml.FCNMD5Code ");
        quy_sql.append(" where ");
        quy_sql.append(" ml.FId is null ");
        PreparedStatement resInsPS = null;
        PreparedStatement mlInsPS = null;
        ResultSet rs = null;
        try {
            String res_ins_sql = "insert into t_res_EASResource(FID,FRes,FMD5Code) values(?,?,?)";
            resInsPS = conn.prepareStatement(res_ins_sql);
            BOSObjectType resBosType = new EASResourceInfo().getBOSType();
            String mlRes_ins_sql = "insert into t_res_EASMultiLanRes(FID,FParentID,FContent,FCNMD5Code,FLanguageID,FTransLatorID,FTransTime,FIsTranslated) values(?,?,?,?,?,?,?,?)";
            mlInsPS = conn.prepareStatement(mlRes_ins_sql);
            BOSObjectType mlBosType = new EASMultiLanResInfo().getBOSType();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp transTime = new Timestamp(System.currentTimeMillis());
            List allLans = MLFacadeHelper.getAllLanguageNum(ctx);
            rs = conn.createStatement().executeQuery(quy_sql.toString());
            int c = 0;
            while (rs.next()) {
                String res = rs.getString("res");
                String mlRes = rs.getString("mlRes");
                if (MLUtils.isEmpty(res) || MLUtils.isEmpty(mlRes)) continue;
                String md5 = MLUtils.md5HashCode(res);
                String resId = BOSUuid.create((BOSObjectType)resBosType).toString();
                resInsPS.setString(1, resId);
                resInsPS.setString(2, res);
                resInsPS.setString(3, md5);
                resInsPS.addBatch();
                for (int i = 0; i < allLans.size(); ++i) {
                    String currLan = allLans.get(i).toString();
                    mlInsPS.setString(1, BOSUuid.create((BOSObjectType)mlBosType).toString());
                    mlInsPS.setString(2, resId);
                    if (lan.equals(currLan)) {
                        mlInsPS.setString(3, mlRes);
                        mlInsPS.setInt(8, 1);
                    } else {
                        mlInsPS.setNull(3, 12);
                        mlInsPS.setInt(8, 0);
                    }
                    mlInsPS.setString(4, md5);
                    mlInsPS.setString(5, currLan);
                    mlInsPS.setString(6, userId);
                    mlInsPS.setTimestamp(7, transTime);
                    mlInsPS.addBatch();
                }
                if (++c <= 2000) continue;
                resInsPS.executeBatch();
                resInsPS.clearBatch();
                mlInsPS.executeBatch();
                mlInsPS.clearBatch();
                c = 0;
            }
            resInsPS.executeBatch();
            mlInsPS.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)resInsPS);
                SQLUtils.cleanup(mlInsPS);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)resInsPS);
        SQLUtils.cleanup((Statement)mlInsPS);
    }

    public static void fetchNewWordsFromMetaRes(Context ctx, Connection conn) throws SQLException {
        if (ctx == null || conn == null) {
            return;
        }
        String[] tabs = new String[]{"t_res_uiResource", "t_res_resResource", "t_res_enumResource", "t_res_entityResource", "t_res_queryResource", "T_Res_PermResource", "t_res_mdbviewResource"};
        String ins_sql = "insert into t_res_EASResource(FID,FRes,FMD5Code,FDomainId) values(?,?,?,?)";
        PreparedStatement ps = conn.prepareStatement(ins_sql);
        String mlIns_sql = "insert into t_res_EASMultiLanRes (FID,FParentId,FLanguageId,FCNMD5Code,FISTRANSLATED) values (?,?,?,?,?)";
        PreparedStatement mlPS = conn.prepareStatement(mlIns_sql);
        String upd_sql = "update t_res_EASResource set FDomainId=? where fid=?";
        PreparedStatement updPs = conn.prepareStatement(upd_sql);
        StringBuffer sb = new StringBuffer();
        BOSObjectType bosType = new EASResourceInfo().getBOSType();
        BOSObjectType mlBosType = new EASMultiLanResInfo().getBOSType();
        LanguageCollection languageCollection = null;
        try {
            ILanguage language = LanguageFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            languageCollection = language.getLanguageCollection(view);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new SQLException(e1.getMessage());
        }
        int c = 0;
        try {
            ResultSet rs;
            for (int i = 0; i < tabs.length; ++i) {
                sb.delete(0, sb.length());
                sb.append(" select distinct metaRes.FMD5 md5,metaRes.Fres cn,metaRes.FDomainId domainID from ");
                sb.append(tabs[i]).append(" metaRes ");
                sb.append(" left join ").append(" t_res_EASResource res ").append(" on res.FMD5code = metaRes.FMD5 ");
                sb.append(" where res.FID is null");
                rs = conn.createStatement().executeQuery(sb.toString());
                while (rs.next()) {
                    String newMd5;
                    String md5;
                    String cn = rs.getString("cn");
                    if (!MLUtils.containChinese(cn) || (md5 = rs.getString("md5")) == null || !md5.equals(newMd5 = MLUtils.md5HashCode(MLUtils.myTrim(cn)))) continue;
                    String resID = BOSUuid.create((BOSObjectType)bosType).toString();
                    ps.setString(1, resID);
                    ps.setString(2, cn);
                    ps.setString(3, md5);
                    String domainID = rs.getString("domainID");
                    ps.setString(4, domainID);
                    ps.addBatch();
                    for (int l = 0; l < languageCollection.size(); ++l) {
                        LanguageInfo languageInfo = languageCollection.get(l);
                        String languageNumber = languageInfo.getNumber();
                        mlPS.setString(1, BOSUuid.create((BOSObjectType)mlBosType).toString());
                        mlPS.setString(2, resID);
                        mlPS.setString(3, languageNumber);
                        mlPS.setString(4, md5);
                        mlPS.setInt(5, 0);
                        mlPS.addBatch();
                    }
                    if (++c <= 4000) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    mlPS.executeBatch();
                    mlPS.clearBatch();
                    c = 0;
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            ps.executeBatch();
            mlPS.executeBatch();
            int updBatchCount = 0;
            for (int k = 0; k < tabs.length; ++k) {
                sb.delete(0, sb.length());
                sb.append("select eas.fid,eas.fdomainId||'#'||res.fdomainId domainId from ").append("(select fid,fdomainId,FMD5code from t_res_EASResource where fdomainId is not null) eas,").append("(select fdomainId,FMD5 from ").append(tabs[k]).append(" where fdomainId is not null) res ").append(" where eas.FMD5code = res.FMD5 and eas.fdomainId not like '%'||res.fdomainID||'%'");
                rs = conn.createStatement().executeQuery(sb.toString());
                while (rs.next()) {
                    updPs.setString(1, rs.getString("domainId"));
                    updPs.setString(2, rs.getString("fid"));
                    updPs.addBatch();
                    if (++updBatchCount <= 4000) continue;
                    updPs.executeBatch();
                    updPs.clearBatch();
                    updBatchCount = 0;
                }
                updPs.executeBatch();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
            SQLUtils.cleanup((Statement)mlPS);
            SQLUtils.cleanup((Statement)updPs);
        }
    }

    public static void fetchNewWordsFromPresetDataRes(Context ctx, Connection conn) throws SQLException {
        if (ctx == null || conn == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct pdRes.FMD5 md5, pdRes.FText_zh_CN cn from t_res_PresetDataRes pdRes ");
        sql.append(" left join t_res_EASResource res on res.FMD5Code = pdRes.FMD5 ");
        sql.append(" where res.FID is null ");
        Statement st = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        PreparedStatement mlPS = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql.toString());
            String ins_sql = "insert into t_res_EASResource(FID,FRes,FMD5Code) values(?,?,?)";
            ps = conn.prepareStatement(ins_sql);
            String mlIns_sql = "insert into t_res_EASMultiLanRes(FID,FParentId,FLanguageId,FCNMD5Code,FISTRANSLATED) values(?,?,?,?,?)";
            mlPS = conn.prepareStatement(mlIns_sql);
            BOSObjectType bosType = new EASResourceInfo().getBOSType();
            BOSObjectType mlBosType = new EASMultiLanResInfo().getBOSType();
            LanguageCollection languageCollection = null;
            try {
                ILanguage language = LanguageFactory.getLocalInstance(ctx);
                EntityViewInfo view = new EntityViewInfo();
                languageCollection = language.getLanguageCollection(view);
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                throw new SQLException(e1.getMessage());
            }
            int c = 0;
            while (rs.next()) {
                String newMd5;
                String md5;
                String cn = rs.getString("cn");
                if (!MLUtils.containChinese(cn) || (md5 = rs.getString("md5")) == null || !md5.equals(newMd5 = MLUtils.md5HashCode(MLUtils.myTrim(cn)))) continue;
                String resID = BOSUuid.create((BOSObjectType)bosType).toString();
                ps.setString(1, resID);
                ps.setString(2, cn);
                ps.setString(3, md5);
                ps.addBatch();
                for (int l = 0; l < languageCollection.size(); ++l) {
                    LanguageInfo languageInfo = languageCollection.get(l);
                    String languageNumber = languageInfo.getNumber();
                    mlPS.setString(1, BOSUuid.create((BOSObjectType)mlBosType).toString());
                    mlPS.setString(2, resID);
                    mlPS.setString(3, languageNumber);
                    mlPS.setString(4, md5);
                    mlPS.setInt(5, 0);
                    mlPS.addBatch();
                }
                if (++c <= 4000) continue;
                ps.executeBatch();
                ps.clearBatch();
                mlPS.executeBatch();
                mlPS.clearBatch();
                c = 0;
            }
            ps.executeBatch();
            mlPS.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(mlPS);
                SQLUtils.cleanup((Statement)st);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)mlPS);
        SQLUtils.cleanup((Statement)st);
    }

    public static void fetchNewWordsFromTemplate(Context ctx, Connection conn) throws SQLDataException, SQLException {
        if (ctx == null || conn == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct tempRes.FMD5 md5,tempRes.FRes cn from T_RES_TempRes tempRes");
        sql.append(" left join t_res_EASResource res on res.FMD5Code = tempRes.FMD5 ");
        sql.append(" where res.FID is null");
        Statement st = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        PreparedStatement mlPS = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(sql.toString());
            String ins_sql = "insert into t_res_EASResource(FID,FRes,FMD5Code) values(?,?,?)";
            ps = conn.prepareStatement(ins_sql);
            String mlIns_sql = "insert into t_res_EASMultiLanRes(FID,FParentId,FLanguageId,FCNMD5Code,FISTRANSLATED) values(?,?,?,?,?)";
            mlPS = conn.prepareStatement(mlIns_sql);
            BOSObjectType bosType = new EASResourceInfo().getBOSType();
            BOSObjectType mlBosType = new EASMultiLanResInfo().getBOSType();
            LanguageCollection languageCollection = null;
            try {
                ILanguage language = LanguageFactory.getLocalInstance(ctx);
                EntityViewInfo view = new EntityViewInfo();
                languageCollection = language.getLanguageCollection(view);
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                throw new SQLException(e1.getMessage());
            }
            int c = 0;
            while (rs.next()) {
                String newMd5;
                String md5;
                String cn = rs.getString("cn");
                if (!MLUtils.containChinese(cn) || (md5 = rs.getString("md5")) == null || !md5.equals(newMd5 = MLUtils.md5HashCode(MLUtils.myTrim(cn)))) continue;
                String resID = BOSUuid.create((BOSObjectType)bosType).toString();
                ps.setString(1, resID);
                ps.setString(2, cn);
                ps.setString(3, md5);
                ps.addBatch();
                for (int l = 0; l < languageCollection.size(); ++l) {
                    LanguageInfo languageInfo = languageCollection.get(l);
                    String languageNumber = languageInfo.getNumber();
                    mlPS.setString(1, BOSUuid.create((BOSObjectType)mlBosType).toString());
                    mlPS.setString(2, resID);
                    mlPS.setString(3, languageNumber);
                    mlPS.setString(4, md5);
                    mlPS.setInt(5, 0);
                    mlPS.addBatch();
                }
                if (++c <= 5000) continue;
                ps.executeBatch();
                ps.clearBatch();
                mlPS.executeBatch();
                mlPS.clearBatch();
                c = 0;
            }
            ps.executeBatch();
            mlPS.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(mlPS);
                SQLUtils.cleanup((Statement)st);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)mlPS);
        SQLUtils.cleanup((Statement)st);
    }

    public static List getSystemResourceFromMetas(Context ctx, Connection conn, String md5) throws SQLException {
        if (ctx == null || md5 == null || conn == null) {
            return Collections.EMPTY_LIST;
        }
        String[] tabs = new String[]{"t_res_uiResource", "t_res_resResource", "t_res_enumResource", "t_res_entityResource", "t_res_queryResource", "t_res_permResource"};
        Statement statement = conn.createStatement();
        ArrayList<MetasResourceInfo> list = new ArrayList<MetasResourceInfo>();
        try {
            for (int i = 0; i < tabs.length; ++i) {
                String sql = "select FPackage pkg,FFileName fn,FKey k,FProject prj from " + tabs[i] + " where FMD5 = '" + md5 + "'";
                ResultSet rs = statement.executeQuery(sql);
                while (rs.next()) {
                    MetasResourceInfo info = new MetasResourceInfo(rs.getString("pkg"), rs.getString("fn"), rs.getString("k"), rs.getString("prj"));
                    list.add(info);
                }
                if (rs == null) continue;
                rs.close();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
        return list;
    }

    public static List getSystemResourceFromPresetData(Context ctx, Connection conn, String md5) throws SQLException {
        if (ctx == null || md5 == null || conn == null) {
            return Collections.EMPTY_LIST;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select ml.FTableName tabName,ml.FFieldName_l2 fn, res.FSourceId srcId from t_res_PresetDataRes res ");
        sb.append(" left join T_RES_MultiFieldMeta ml on res.FParentID = ml.FId ");
        sb.append(" where FMD5 = '").append(md5).append("'");
        Statement st = conn.createStatement();
        ArrayList<PresetDataResourceInfo> list = new ArrayList<PresetDataResourceInfo>();
        try {
            ResultSet rs = st.executeQuery(sb.toString());
            while (rs.next()) {
                PresetDataResourceInfo info = new PresetDataResourceInfo(rs.getString("tabName"), rs.getString("fn"), rs.getString("srcId"));
                list.add(info);
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)st);
        }
        return list;
    }

    public static List getSystemResourceFromTemplate(Context ctx, Connection conn, String md5) throws SQLException {
        if (ctx == null || md5 == null || conn == null) {
            return Collections.EMPTY_LIST;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select res.FType type,wf.FSourceCode srcCode, pt.FFileName fn, pt.FFilePath path from T_RES_TempRes res ");
        sb.append(" left join T_RES_PrintTemp pt on pt.FID = res.FPrintTempID ");
        sb.append(" left join T_RES_workflow wf on wf.FID = res.FWorkFlowTempID ");
        sb.append(" where res.FMD5 = '").append(md5).append("'");
        Statement st = conn.createStatement();
        ArrayList<TemplateResourceInfo> list = new ArrayList<TemplateResourceInfo>();
        try {
            ResultSet rs = st.executeQuery(sb.toString());
            while (rs.next()) {
                int type = rs.getInt("type");
                TemplateResourceInfo info = new TemplateResourceInfo();
                info.setType(type);
                if (0 == type) {
                    info.setWfCode(rs.getString("srcCode"));
                } else {
                    if (1 != type) continue;
                    info.setFileName(rs.getString("fn"));
                    info.setFilePath(rs.getString("path"));
                }
                list.add(info);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Statement)st);
        }
        return list;
    }

    private static List getAllLanguageNum(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        LanguageCollection langColl = LanguageFactory.getLocalInstance(ctx).getLanguageCollection(evi);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < langColl.size(); ++i) {
            list.add(langColl.get(i).getNumber());
        }
        if (!list.contains("zh_TW")) {
            list.add("zh_TW");
        }
        if (!list.contains("en_US")) {
            list.add("en_US");
        }
        return list;
    }
}

