/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.MultiFieldMetaInfo;
import com.kingdee.eas.bs.ml.PresetDataResCollection;
import com.kingdee.eas.bs.ml.PresetDataResInfo;
import com.kingdee.eas.bs.ml.TempResCollection;
import com.kingdee.eas.bs.ml.TempResInfo;
import com.kingdee.eas.bs.ml.WorkflowTempInfo;
import com.kingdee.eas.bs.ml.app.AbstractMLToolsFacadeControllerBean;
import com.kingdee.eas.bs.ml.app.MLFacadeHelper;
import com.kingdee.eas.bs.ml.app.MLToolsFacadeHelper;
import com.kingdee.eas.bs.ml.app.RemoveDuplicatedWordsInTransDB;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.eas.bs.ml.util.ParserHelper;
import com.kingdee.eas.bs.ml.util.PrintFetchWords;
import com.kingdee.eas.bs.ml.util.SafeCheckUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MLToolsFacadeControllerBean
extends AbstractMLToolsFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.MLToolsFacadeControllerBean");
    public static final String Project_MainMenu = "MainMenu";
    public static final String Project_MultiMeta = "MultiMeta";
    public static final int Type_EAS = 0;
    public static final int Type_BOS = 1;
    public static final int Type_MainMenu = 2;
    private static Set ignoreTables = new HashSet();
    private static List suffixList;

    @Override
    protected Map _getExistResource(Context ctx, String pkg, String fileName, String metaType) throws BOSException, EASBizException {
        try {
            return MLToolsFacadeHelper.getExistFileResource(ctx, pkg, fileName, metaType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _saveResource(Context ctx, List list, String metaType) throws BOSException, EASBizException {
        try {
            MLToolsFacadeHelper.saveDataToDB(ctx, list, metaType);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _fetchPresetDataWords(Context ctx) throws BOSException, EASBizException {
        try {
            MLToolsFacadeHelper.fetchNewWordsFromInitDB(ctx, true, true);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _updateMetasMLResource(Context ctx, String lang) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateMultiFieldValue(Context ctx, String lang) throws BOSException, EASBizException {
    }

    @Override
    public void generateTCRes(Context ctx) throws BOSException, EASBizException {
        this._generateTCRes(ctx);
    }

    @Override
    protected void _generateTCRes(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        String[] resTab = new String[]{"t_res_UIResource", "t_res_resResource", "t_res_EnumResource", "t_res_EntityResource", "t_res_queryResource"};
        String[] mlResTab = new String[]{"t_res_UIMultiLan", "t_res_resMultiLan", "t_res_enumMultiLan", "t_res_entityMultiLan", "t_res_queryMultiLan"};
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Statement st = conn.createStatement();
            for (int i = 0; i < resTab.length; ++i) {
                String sql = "select mlTab.fid mlId, tab.FRes res, tab.FRes2 res2  from " + mlResTab[i] + " mlTab left join " + resTab[i] + " tab on tab.FID = mlTab.fResId where mlTab.flanguage = 'zh_TW'";
                ResultSet rs = st.executeQuery(sql);
                String upd = "update " + mlResTab[i] + " set FMLRes = ?, FMLRes2 = ? where FID = ? ";
                PreparedStatement ps = conn.prepareStatement(upd);
                int c = 0;
                while (rs.next()) {
                    String mlId = rs.getString("mlId");
                    if (mlId == null) continue;
                    if (rs.getString("res") != null) {
                        ps.setString(1, STConverter.sc2tc((String)rs.getString("res")));
                    } else {
                        ps.setNull(1, 12);
                    }
                    if (rs.getString("res2") != null) {
                        ps.setString(2, STConverter.sc2tc((String)rs.getString("res2")));
                    } else {
                        ps.setNull(2, 12);
                    }
                    ps.setString(3, mlId);
                    ps.addBatch();
                    if (++c <= 10000) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    c = 0;
                }
                if (c > 0) {
                    ps.executeBatch();
                }
                ps.close();
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    public void upgradeMLData(Context ctx, String lang) throws BOSException, EASBizException {
        this._upgradeMLData(ctx, lang);
    }

    @Override
    protected void _upgradeMLData(Context ctx, String lang) throws BOSException, EASBizException {
        if (!"en_US".equals(lang)) {
            return;
        }
        HashSet<String> ignoreTables = new HashSet<String>();
        ignoreTables.add("t_log_app");
        ignoreTables.add("t_log_his");
        ignoreTables.add("t_pm_user");
        ignoreTables.add("t_pm_permitemchangereport");
        ignoreTables.add("t_bas_message");
        ignoreTables.add("t_fa_assistactitem");
        ignoreTables.add("t_fw_usercustomconfig");
        ignoreTables.add("t_log_logitem");
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sb = new StringBuffer();
            sb.append("select distinct FTableName tn,FFieldName_L1 fn1,FFieldName_L2 fn2,FFieldName_L3 fn3 ");
            sb.append(" from t_res_multifieldmeta ");
            sb.append(" order by tn,fn2,fn1");
            ResultSet rs = conn.createStatement().executeQuery(sb.toString());
            String upd_sql = null;
            String upd_sqlForL2 = null;
            String upd_sqlForL3 = null;
            Statement st = conn.createStatement();
            while (rs.next()) {
                String tn = rs.getString("tn");
                if (ignoreTables.contains(tn.toLowerCase()) || tn.toLowerCase().startsWith("t_wf_") || tn.toLowerCase().startsWith("t_wfr_")) continue;
                String fn1 = rs.getString("fn1");
                String fn2 = rs.getString("fn2");
                String fn3 = rs.getString("fn3");
                if (fn1 == null || fn2 == null) continue;
                String[] params = new String[]{tn, fn2, fn1};
                if (!SafeCheckUtil.checkSql(params)) {
                    logger.error((Object)"MLToolsFacadeControllerBean._upgradeMLData(Context, String) : check sql error !");
                    return;
                }
                upd_sql = "update " + tn + " set " + fn1 + "=" + fn2 + " where " + fn1 + " is null or " + fn1 + "='null' or " + fn1 + "=''";
                upd_sqlForL2 = "update " + tn + " set " + fn2 + "=" + fn1 + " where " + fn2 + " is null or " + fn2 + "='null' or " + fn2 + "=''";
                upd_sqlForL3 = "update " + tn + " set " + fn3 + "=" + fn2 + " where " + fn3 + " is null or " + fn3 + "='null' or " + fn3 + "=''";
                try {
                    st.executeUpdate(upd_sql);
                    st.executeUpdate(upd_sqlForL2);
                    st.executeUpdate(upd_sqlForL3);
                }
                catch (SQLException _) {
                    logger.info((Object)("error sql :" + upd_sql));
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _updateResourceDaomin(Context ctx) throws BOSException, EASBizException {
        MLToolsFacadeHelper.updateDomainIdToDB(ctx);
    }

    @Override
    protected void _fetchDataResource(Context ctx, boolean isFetchMenuResource, boolean isFetchPresetDataResource, boolean isFetchWorkFlowResource, boolean isFetchPrintTemplateResource) throws BOSException, EASBizException {
        if (isFetchMenuResource || isFetchPresetDataResource) {
            try {
                MLToolsFacadeHelper.fetchNewWordsFromInitDB(ctx, isFetchMenuResource, isFetchPresetDataResource);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        if (isFetchWorkFlowResource) {
            this.workFlowFetchWords(ctx);
        }
        if (isFetchPrintTemplateResource) {
            Connection conn = null;
            try {
                PrintFetchWords printFetchWords = new PrintFetchWords();
                String easHome = System.getProperty("EAS_HOME");
                String templatePath = easHome + "/server/deploy/ctrlhome/server/storage/eas/kdnote/template";
                printFetchWords.setPath(templatePath);
                printFetchWords.setContext(ctx);
                conn = this.getConnection(ctx);
                printFetchWords.setConnection(conn);
                printFetchWords.fetchWords();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void workFlowFetchWords(Context ctx) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sb = new StringBuffer();
            sb.append(" select FPROCESSID ,FCode, FPROCESSXML from T_WFD_PROCESSDEF ");
            ps = conn.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            this.parseXML(ctx, rs, "T_WFD_PROCESSDEF", "FPROCESSXML", "FPROCESSID", "FCode");
            sb.delete(0, sb.length());
            sb.append(" select FProcDefId ,FProcCode, FKpdl from T_WFR_ProcDef ");
            ps = conn.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            this.parseXML(ctx, rs, "T_WFR_ProcDef", "FKpdl", "FProcDefId", "FProcCode");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseXML(Context ctx, ResultSet rs, String tabName, String xmlFieldName, String idFieldName, String CodeFiledName) throws BOSException {
        if (rs == null || tabName == null || xmlFieldName == null) {
            return;
        }
        TempResCollection newWords = new TempResCollection();
        try {
            while (rs.next()) {
                String xpath;
                List list;
                String id = rs.getString(idFieldName);
                String code = rs.getString(CodeFiledName);
                SAXReader saxReader = new SAXReader();
                Reader reader = rs.getCharacterStream(xmlFieldName);
                Document doc = saxReader.read(reader);
                if (doc == null || (list = doc.selectNodes(xpath = "//*[name() = 'Resources']/*[name() = 'Resource']/Language[@Locale = 'l2' or @Locale = 'zh_CN']")) == null || list.size() <= 0) continue;
                StringBuffer checkSQL = new StringBuffer();
                checkSQL.append(" select fid from t_res_workFlow ");
                checkSQL.append(" where FSourceId = '").append(id).append("'");
                checkSQL.append(" and FSourceTable = '").append(tabName).append("'");
                checkSQL.append(" and FISInvalid = 0  ");
                IRowSet checkRS = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString());
                String workFlowID = null;
                if (checkRS != null && checkRS.next()) {
                    workFlowID = checkRS.getString("fid");
                } else {
                    Connection conn = null;
                    PreparedStatement ps = null;
                    try {
                        conn = this.getConnection(ctx);
                        conn.setAutoCommit(false);
                        StringBuffer sql = new StringBuffer();
                        sql.append(" insert into t_res_workFlow ");
                        sql.append(" ( FID,FSourceID,FSourceCode,FSourceTable,FSourceField,FISInvalid ) ");
                        sql.append(" values ");
                        sql.append("(?,?,?,?,?,?) ");
                        ps = conn.prepareStatement(sql.toString());
                        BOSUuid pk = BOSUuid.create((String)"4DD128CB");
                        workFlowID = pk.toString();
                        ps.setString(1, workFlowID);
                        ps.setString(2, id);
                        ps.setString(3, code);
                        ps.setString(4, tabName);
                        ps.setString(5, idFieldName);
                        ps.setInt(6, 0);
                        ps.addBatch();
                        ps.executeBatch();
                        conn.commit();
                    }
                    catch (SQLException e) {
                        try {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            throw e;
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(ps, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((Statement)ps, (Connection)conn);
                }
                Set existWords = this.getExistWords(ctx, id, tabName);
                TempResInfo tempResInfo = null;
                WorkflowTempInfo workflowTempInfo = null;
                int j = list.size();
                for (int i = 0; i < j; ++i) {
                    Element el = (Element)list.get(i);
                    Element resourceEl = el.getParent();
                    List languageNodes = resourceEl.selectNodes("Language[@Locale = 'l2' or @Locale = 'zh_CN']");
                    if (languageNodes != null && languageNodes.size() == 2 && "zh_CN".equals(el.attribute("Locale").getValue())) continue;
                    String zh = el.getText();
                    String key = (zh = zh.trim()).length() > 400 ? zh.substring(0, 400).trim() : zh;
                    if (existWords.contains(key)) continue;
                    tempResInfo = new TempResInfo();
                    workflowTempInfo = new WorkflowTempInfo();
                    workflowTempInfo.setId(BOSUuid.read((String)workFlowID));
                    tempResInfo.setWorkFlowTemp(workflowTempInfo);
                    tempResInfo.setRes(zh);
                    newWords.add(tempResInfo);
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.workFlowAddNewWords(ctx, newWords);
    }

    public void workFlowAddNewWords(Context ctx, TempResCollection newWords) throws BOSException {
        if (newWords == null || newWords.size() <= 0) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            conn.setAutoCommit(false);
            StringBuffer sqlTempRes = new StringBuffer();
            sqlTempRes.append(" insert into T_RES_TempRes ");
            sqlTempRes.append(" ( FID,FWorkFlowTempID,FType,FRes,FMD5) ");
            sqlTempRes.append(" values ");
            sqlTempRes.append("(");
            sqlTempRes.append("?,?,?,?,?");
            sqlTempRes.append(" ) ");
            PreparedStatement psTempRes = conn.prepareStatement(sqlTempRes.toString());
            StringBuffer sqlTempMultiLanTW = new StringBuffer();
            sqlTempMultiLanTW.append(" insert into T_RES_TempMultiLan ");
            sqlTempMultiLanTW.append(" ( FID,FResID,FLanguage,FMLRes,FCNMD5) ");
            sqlTempMultiLanTW.append(" values ");
            sqlTempMultiLanTW.append("(");
            sqlTempMultiLanTW.append("?,?,?,?,?");
            sqlTempMultiLanTW.append(" ) ");
            PreparedStatement psTempMultiLanTW = conn.prepareStatement(sqlTempMultiLanTW.toString());
            StringBuffer sqlTempMultiLanEN = new StringBuffer();
            sqlTempMultiLanEN.append(" insert into T_RES_TempMultiLan ");
            sqlTempMultiLanEN.append(" ( FID,FResID,FLanguage,FMLRes,FCNMD5) ");
            sqlTempMultiLanEN.append(" values ");
            sqlTempMultiLanEN.append("(");
            sqlTempMultiLanEN.append("?,?,?,?,?");
            sqlTempMultiLanEN.append(" ) ");
            PreparedStatement psTempMultiLanEN = conn.prepareStatement(sqlTempMultiLanEN.toString());
            TempResInfo workFlowInfo = null;
            int j = newWords.size();
            for (int i = 0; i < j; ++i) {
                workFlowInfo = newWords.get(i);
                if (workFlowInfo == null) continue;
                String zhCN = workFlowInfo.getRes();
                if (zhCN != null && zhCN.length() > 1000) {
                    zhCN = zhCN.substring(0, 999);
                }
                String md5 = MLUtils.md5HashCode(zhCN);
                BOSUuid pkTempRes = BOSUuid.create((String)"7050EC94");
                psTempRes.setString(1, pkTempRes.toString());
                psTempRes.setString(2, workFlowInfo.getWorkFlowTemp().getId().toString());
                psTempRes.setInt(3, 1);
                psTempRes.setString(4, zhCN);
                psTempRes.setString(5, md5);
                psTempRes.addBatch();
                BOSUuid pkTempMultiLan = BOSUuid.create((String)"378F422C");
                psTempMultiLanTW.setString(1, pkTempMultiLan.toString());
                psTempMultiLanTW.setString(2, pkTempRes.toString());
                psTempMultiLanTW.setString(3, "zh_TW");
                psTempMultiLanTW.setString(4, "");
                psTempMultiLanTW.setString(5, md5);
                psTempMultiLanTW.addBatch();
                pkTempMultiLan = BOSUuid.create((String)"378F422C");
                psTempMultiLanEN.setString(1, pkTempMultiLan.toString());
                psTempMultiLanEN.setString(2, pkTempRes.toString());
                psTempMultiLanEN.setString(3, "en_US");
                psTempMultiLanEN.setString(4, "");
                psTempMultiLanEN.setString(5, md5);
                psTempMultiLanEN.addBatch();
            }
            psTempRes.executeBatch();
            psTempMultiLanTW.executeBatch();
            psTempMultiLanEN.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public Set getExistWords(Context ctx, String sourceId, String tabName) throws Exception {
        if (sourceId == null) {
            return Collections.EMPTY_SET;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select FRes from t_res_workFlow,T_RES_TempRes ");
        sql.append(" where t_res_workFlow.fid = T_RES_TempRes.FWorkFlowTempID");
        sql.append(" and FSourceId = '").append(sourceId).append("'");
        sql.append(" and FSourceTable = '").append(tabName).append("'");
        sql.append(" and FISInvalid = 0  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        while (rs.next()) {
            String zh = rs.getString("FRes");
            if (zh == null || zh.trim().length() <= 0) continue;
            set.add(zh);
        }
        return set;
    }

    private void innerDoCommitMetaData(Context ctx, boolean isMainMenu) throws BOSException {
        PresetDataResCollection presetDataResCollection = null;
        ArrayList list = new ArrayList();
        String sql = " SELECT FTableName, FFieldName_l2, FType, fid, FPrimeryKey FROM t_Res_MultiFieldMeta WHERE FIsInvalid=1 ";
        sql = isMainMenu ? sql + " AND FType=2 " : sql + " AND FType IN(0,1) ";
        sql = sql + " ORDER BY FTableName,FFieldName_l2 ";
        try {
            IRowSet data = DbUtil.executeQuery((Context)ctx, (String)sql);
            Object sF = null;
            Object sFsplit = null;
            String tbl = null;
            String fieldName_l2 = null;
            int type = -1;
            String fid = null;
            String primeryKey = null;
            ArrayList errorList = new ArrayList();
            while (data.next()) {
                tbl = data.getString("FTableName");
                if (ignoreTables.contains(tbl.toLowerCase())) continue;
                fieldName_l2 = data.getString("FFieldName_l2");
                type = data.getInt("FType");
                fid = data.getString("fid");
                primeryKey = data.getString("FPrimeryKey");
                if (primeryKey == null || primeryKey.trim().length() == 0) {
                    primeryKey = "FID";
                }
                presetDataResCollection = this.getResInfoByMetaData(ctx, fieldName_l2, tbl, tbl + "|" + fieldName_l2, type, fid, primeryKey, errorList);
                this.executeAddResourceSproc(ctx, presetDataResCollection);
            }
            data.close();
            String deleteDuplicateDataSql = "delete from T_RES_PresetDataRes where FID not in (select min(FID) from T_RES_PresetDataRes group by fparentid, fsourceid)";
            DbUtil.execute((Context)ctx, (String)deleteDuplicateDataSql);
            if (errorList != null && errorList.size() > 0) {
                StringBuffer errorMsg = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    Exception e = (Exception)errorList.get(i);
                    errorMsg.append(e.getMessage()).append("\n");
                }
                throw new BOSException(errorMsg.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private PresetDataResCollection getResInfoByMetaData(Context ctx, String fieldName, String tableName, String filePath, int type, String parentId, String primeryKey, List errorList) throws BOSException, SQLException {
        PresetDataResCollection presetDataResCollection = new PresetDataResCollection();
        PresetDataResInfo presetDataResInfo = null;
        MultiFieldMetaInfo parent = null;
        String sql = null;
        sql = type == 2 ? " SELECT " + primeryKey + " fid, FLongNumber," + fieldName + " FROM " + tableName : " SELECT " + primeryKey + " fid, " + fieldName + " FROM " + tableName;
        IRowSet data = null;
        try {
            data = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            errorList.add(e);
            return presetDataResCollection;
        }
        if (data != null) {
            try {
                String key = null;
                String text_zh_CN = null;
                String sourceId = null;
                String filePath_GJ = filePath;
                String project = null;
                project = type == 2 ? Project_MainMenu : Project_MultiMeta;
                String regEx = "[\\u4e00-\\u9fa5]";
                while (data.next()) {
                    Pattern p;
                    Matcher m;
                    text_zh_CN = data.getString(fieldName);
                    sourceId = data.getString("fid");
                    key = type == 2 ? data.getString("FLongNumber") : text_zh_CN;
                    if (text_zh_CN == null || (text_zh_CN = text_zh_CN.toString().trim()).toString().length() == 0 || !(m = (p = Pattern.compile(regEx)).matcher(text_zh_CN.toString())).find()) continue;
                    int len = text_zh_CN.toString().length();
                    if (len > 450) {
                        len = 450;
                    }
                    String text_zh_CN2 = text_zh_CN.toString().substring(0, len);
                    presetDataResInfo = new PresetDataResInfo();
                    presetDataResInfo.setSourceID(sourceId);
                    presetDataResInfo.setText_zh_CN(text_zh_CN);
                    parent = new MultiFieldMetaInfo();
                    parent.setId(BOSUuid.read((String)parentId));
                    presetDataResInfo.setParent(parent);
                    presetDataResCollection.add(presetDataResInfo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return presetDataResCollection;
    }

    public void executeAddResourceSproc(Context ctx, PresetDataResCollection presetDataResCollection) throws BOSException {
        if (presetDataResCollection == null || presetDataResCollection.size() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PresetDataResInfo presetDataResInfo = null;
        try {
            conn = this.getConnection(ctx);
            conn.setAutoCommit(false);
            StringBuffer sqlTempRes = new StringBuffer();
            sqlTempRes.append(" insert into T_RES_PresetDataRes ");
            sqlTempRes.append(" ( FID,FParentID,FSourceID,FText_zh_CN,FText_zh_TW,FText_en_US,FMD5,FISInvalid) ");
            sqlTempRes.append(" values ");
            sqlTempRes.append("(");
            sqlTempRes.append("?,?,?,?,?,?,?,?");
            sqlTempRes.append(" ) ");
            pstmt = conn.prepareStatement(sqlTempRes.toString());
            for (int i = 0; i < presetDataResCollection.size(); ++i) {
                presetDataResInfo = presetDataResCollection.get(i);
                BOSUuid pkTempRes = BOSUuid.create((String)"C84E2D93");
                String text_zh_CN = presetDataResInfo.getText_zh_CN();
                if (text_zh_CN != null && text_zh_CN.length() > 1000) {
                    text_zh_CN = text_zh_CN.substring(0, 999);
                }
                String md5 = MLUtils.md5HashCode(text_zh_CN);
                pstmt.setString(1, pkTempRes.toString());
                pstmt.setString(2, presetDataResInfo.getParent().getId().toString());
                pstmt.setString(3, presetDataResInfo.getSourceID());
                pstmt.setString(4, text_zh_CN);
                pstmt.setString(5, "");
                pstmt.setString(6, "");
                pstmt.setString(7, md5);
                pstmt.setInt(8, 0);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _fetchDomainResource(Context ctx, EASResourceDomainCollection domainCollection) throws BOSException, EASBizException {
        HashSet<String> domainSet = new HashSet<String>();
        EASResourceDomainInfo domainInfo = null;
        for (int i = 0; domainCollection != null && i < domainCollection.size(); ++i) {
            domainInfo = domainCollection.get(i);
            domainSet.add(domainInfo.getPackageName().replace('\\', '.'));
        }
        String easHome = System.getProperty("EAS_HOME");
        String bosMetasPath = easHome + "/server/metas/bos";
        File file = new File(bosMetasPath);
        this.fetchWords(ctx, file, domainSet);
        String easMetasPath = easHome + "/server/metas/eas";
        file = new File(easMetasPath);
        this.fetchWords(ctx, file, domainSet);
    }

    private void fetchWords(Context ctx, File file, Set domainSet) throws BOSException {
        if (file.isDirectory()) {
            File[] arr = file.listFiles(new FileFilterImpl());
            for (int i = 0; i < arr.length; ++i) {
                this.fetchWords(ctx, arr[i], domainSet);
            }
        } else {
            String fileName = file.getName();
            int idx = fileName.lastIndexOf(".");
            if (idx < 0) {
                return;
            }
            String suffix = fileName.substring(idx + 1);
            if (!suffixList.contains(suffix)) {
                return;
            }
            try {
                if (suffix.equals(MLToolsConstonts.JAR_SUFFIX)) {
                    this.parseJar(ctx, file, domainSet);
                }
                ParserHelper.parse(ctx, file, suffix, domainSet);
            }
            catch (Exception e) {
                logger.error((Object)("parse file " + file.getName() + " error!"));
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void parseJar(Context ctx, File jarFile, Set domainSet) throws Exception {
        JarFile jf = null;
        try {
            jf = new JarFile(jarFile);
        }
        catch (IOException e) {
            logger.error((Object)("error file:" + jarFile.getName()));
            logger.error((Object)e.getMessage());
            throw e;
        }
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            String suffix;
            String name;
            int idx;
            JarEntry entry = en.nextElement();
            if (entry.isDirectory() || (idx = (name = entry.getName()).lastIndexOf(46)) < 0 || !suffixList.contains(suffix = name.substring(idx + 1))) continue;
            InputStream is = null;
            try {
                is = jf.getInputStream(entry);
            }
            catch (IOException e) {
                logger.error((Object)("error file:" + entry.getName()));
                logger.error((Object)e.getMessage());
                throw e;
            }
            SAXReader reader = new SAXReader();
            Document doc = null;
            try {
                doc = reader.read(is);
            }
            catch (Exception ex) {
                logger.error((Object)("error file:" + name));
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            Element root = doc.getRootElement();
            String pkg = root.elementText(MetaDocConst.NODE_PKG);
            name = root.elementText(MetaDocConst.NODE_NAME);
            if (!this.domainCheck(domainSet, pkg)) {
                return;
            }
            ParserHelper.parse(ctx, doc, pkg, name, suffix);
        }
    }

    private boolean domainCheck(Set domainSet, String pkg) {
        String tempPkg;
        Iterator it;
        boolean result = false;
        if (domainSet == null || domainSet.size() == 0) {
            result = true;
            return result;
        }
        if (domainSet.contains(pkg)) {
            result = true;
            return result;
        }
        if (domainSet.size() == 1) {
            it = domainSet.iterator();
            tempPkg = null;
            while (it.hasNext()) {
                tempPkg = (String)it.next();
                if (tempPkg.indexOf("EAS") != 0) continue;
                result = true;
                return result;
            }
        }
        it = domainSet.iterator();
        tempPkg = null;
        while (it.hasNext()) {
            tempPkg = (String)it.next();
            if (pkg.indexOf(tempPkg) != 0) continue;
            result = true;
            domainSet.add(pkg);
            return result;
        }
        return result;
    }

    @Override
    protected Map _autoFetchTranslate(Context ctx, List tableList, int language) throws BOSException, EASBizException {
        Connection conn = null;
        Statement quyResPS = null;
        ResultSet rs = null;
        ResultSet lenRS = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer updatePresetDataResSQL = new StringBuffer();
            updatePresetDataResSQL.append("update T_RES_PresetDataRes bizData set  FText_zh_TW = (select mul.fcontent from T_RES_EASMultiLanRes mul where mul.FCNMD5Code = bizData.FMD5 and mul.flanguageid = 'zh_TW' and mul.fcontent is not null),FText_en_US  = ( select mul.fcontent from T_RES_EASMultiLanRes mul where mul.FCNMD5Code = bizData.FMD5 and mul.flanguageid = 'en_US' and mul.fcontent is not null) where bizData.FText_zh_TW is null or bizData.FText_en_US is null");
            conn.createStatement().executeUpdate(updatePresetDataResSQL.toString());
            this._pushUntranslate(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup(lenRS);
            SQLUtils.cleanup(quyResPS);
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    @Override
    protected Map _applyToBizTable(Context ctx, List idList) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _pushUntranslate(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = super.getConnection(ctx);
            MLFacadeHelper.fetchNewWordsFromPresetDataRes(ctx, conn);
            MLFacadeHelper.fetchNewWordsFromTemplate(ctx, conn);
            RemoveDuplicatedWordsInTransDB.getInstance().RemoveDuplicatedWordsInTransDB(ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected Map _fetchBizTableData2ML(Context ctx, String language, boolean isOverride, List tabs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)language) || tabs == null || tabs.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            MLToolsFacadeHelper.fetchWordsFromDBByLan(ctx, language, isOverride, tabs);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            map.put("hasError", Boolean.TRUE);
            map.put("errorStr", e.getMessage());
        }
        return map;
    }

    static {
        ignoreTables.add("t_log_app");
        ignoreTables.add("t_log_his");
        ignoreTables.add("t_pm_user");
        ignoreTables.add("t_pm_permitemchangereport");
        ignoreTables.add("t_bas_message");
        ignoreTables.add("t_fa_assistactitem");
        ignoreTables.add("t_fw_usercustomconfig");
        suffixList = new ArrayList();
        suffixList.add("query");
        suffixList.add("entity");
        suffixList.add("resource");
        suffixList.add("ui");
        suffixList.add("enum");
        suffixList.add("exception");
        suffixList.add(MLToolsConstonts.JAR_SUFFIX);
        suffixList.add("permission");
        suffixList.add("table");
        suffixList.add("mdbview");
        suffixList.add("wbpage");
        suffixList.add("webui");
    }

    private static class FileFilterImpl
    implements FileFilter {
        private FileFilterImpl() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            if (name.lastIndexOf(".") < 0) {
                return false;
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            return suffixList.contains(suffix);
        }
    }
}

