/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.bs.ml.EASResourceDomainCollection;
import com.kingdee.eas.bs.ml.EASResourceDomainFactory;
import com.kingdee.eas.bs.ml.EASResourceDomainInfo;
import com.kingdee.eas.bs.ml.EntityMultiLanCollection;
import com.kingdee.eas.bs.ml.EntityMultiLanInfo;
import com.kingdee.eas.bs.ml.EntityResourceFactory;
import com.kingdee.eas.bs.ml.EntityResourceInfo;
import com.kingdee.eas.bs.ml.EnumMultiLanCollection;
import com.kingdee.eas.bs.ml.EnumMultiLanInfo;
import com.kingdee.eas.bs.ml.EnumResourceFactory;
import com.kingdee.eas.bs.ml.EnumResourceInfo;
import com.kingdee.eas.bs.ml.IEASResourceDomain;
import com.kingdee.eas.bs.ml.MdbviewResourceFactory;
import com.kingdee.eas.bs.ml.MetaDataTypeEnum;
import com.kingdee.eas.bs.ml.QueryMultiLanCollection;
import com.kingdee.eas.bs.ml.QueryMultiLanInfo;
import com.kingdee.eas.bs.ml.QueryResourceFactory;
import com.kingdee.eas.bs.ml.QueryResourceInfo;
import com.kingdee.eas.bs.ml.ResMultiLanCollection;
import com.kingdee.eas.bs.ml.ResMultiLanInfo;
import com.kingdee.eas.bs.ml.ResResourceFactory;
import com.kingdee.eas.bs.ml.ResResourceInfo;
import com.kingdee.eas.bs.ml.UIMultiLanCollection;
import com.kingdee.eas.bs.ml.UIMultiLanInfo;
import com.kingdee.eas.bs.ml.UIResourceFactory;
import com.kingdee.eas.bs.ml.UIResourceInfo;
import com.kingdee.eas.bs.ml.app.ResourceServerCache;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MetasResourceHelper {
    public static void preSave(Context ctx, IObjectValue model, MetaDataTypeEnum metaType) throws BOSException, EASBizException {
        String mlTabName;
        if (ctx == null || model == null || metaType == null) {
            return;
        }
        CoreBaseInfo newInfo = (CoreBaseInfo)model;
        if (newInfo.getId() == null) {
            return;
        }
        CoreBaseInfo oldInfo = null;
        String mt = metaType.getValue();
        String metaDataType = "";
        if ("entity".equals(mt)) {
            oldInfo = EntityResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_Res_EntityMultiLan";
            metaDataType = "entity";
        } else if ("query".equals(mt)) {
            oldInfo = QueryResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_Res_QueryMultiLan";
            metaDataType = "query";
        } else if ("ui".equals(mt)) {
            oldInfo = UIResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_Res_UIMultiLan";
            metaDataType = "ui";
        } else if ("enum".equals(mt)) {
            oldInfo = EnumResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_Res_EnumMultiLan";
            metaDataType = "enum";
        } else if ("resource".equals(mt)) {
            oldInfo = ResResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_Res_ResMultiLan";
            metaDataType = "resource";
        } else if ("mdbview".equals(mt)) {
            oldInfo = MdbviewResourceFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(newInfo.getId()));
            mlTabName = "T_RES_MdbviewMultiLan";
            metaDataType = "mdbview";
        } else {
            return;
        }
        if (oldInfo == null) {
            return;
        }
        String oldRes = oldInfo.get("res2") == null ? "" : oldInfo.get("res2").toString();
        String newRes = newInfo.get("res2") == null ? "" : newInfo.get("res2").toString();
        Connection connection = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            if (!newRes.equals(oldRes)) {
                String md5code = MLUtils.md5HashCode(newRes);
                newInfo.put("md5", (Object)md5code);
                String sql = "update " + mlTabName + " set FCNMd5 = '" + md5code + "' where FResId = '" + newInfo.getId().toString() + "'";
                connection.createStatement().executeUpdate(sql);
            }
            ResourceServerCache resCache = ResourceServerCache.getInstance();
            String resKey = ctx.getAIS() + "zh_CN" + newInfo.get("packageName") + "\\" + newInfo.get("fileName") + "." + metaDataType;
            resCache.clearCache(resKey);
            String sql = "select Fnumber num from t_res_language";
            ResultSet rs = connection.createStatement().executeQuery(sql);
            while (rs.next()) {
                resKey = ctx.getAIS() + rs.getString("num") + newInfo.get("packageName") + newInfo.get("fileName") + "." + metaDataType;
                resCache.clearCache(resKey);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    public static void updateByDomain(Context ctx, IObjectValue model, MetaDataTypeEnum metaType) throws BOSException, EASBizException {
        int i;
        if (ctx == null || model == null || metaType == null) {
            return;
        }
        CoreBaseInfo newInfo = (CoreBaseInfo)model;
        if (newInfo.getId() == null) {
            return;
        }
        String mt = metaType.getValue();
        String domainId = "";
        String mlRes = "";
        String domainSign = "";
        String language = "";
        String md5code = "";
        if ("entity".equals(mt)) {
            EntityResourceInfo entityResourceInfo = (EntityResourceInfo)model;
            if (entityResourceInfo.getDomain() != null) {
                domainId = entityResourceInfo.getDomain().getId().toString();
            }
            domainSign = entityResourceInfo.getResourceDomainSign();
            language = entityResourceInfo.getLanaguage();
            md5code = entityResourceInfo.getMd5();
            EntityMultiLanCollection entityMultiLanCollection = entityResourceInfo.getMultiLang();
            if (entityMultiLanCollection != null && entityMultiLanCollection.size() > 0) {
                for (i = 0; i < entityMultiLanCollection.size(); ++i) {
                    EntityMultiLanInfo entityMultiLanInfo = entityMultiLanCollection.get(i);
                    if (!language.equals(entityMultiLanInfo.getLanguage())) continue;
                    mlRes = entityMultiLanInfo.getMlRes2();
                    break;
                }
            }
        } else if ("query".equals(mt)) {
            QueryResourceInfo queryResourceInfo = (QueryResourceInfo)model;
            if (queryResourceInfo.getDomain() != null) {
                domainId = queryResourceInfo.getDomain().getId().toString();
            }
            domainSign = queryResourceInfo.getResourceDomainSign();
            language = queryResourceInfo.getLanaguage();
            md5code = queryResourceInfo.getMd5();
            QueryMultiLanCollection queryMultiLanCollection = queryResourceInfo.getMultiLang();
            if (queryMultiLanCollection != null && queryMultiLanCollection.size() > 0) {
                for (i = 0; i < queryMultiLanCollection.size(); ++i) {
                    QueryMultiLanInfo queryMultiLanInfo = queryMultiLanCollection.get(i);
                    if (!language.equals(queryMultiLanInfo.getLanguage())) continue;
                    mlRes = queryMultiLanInfo.getMlRes2();
                    break;
                }
            }
        } else if ("ui".equals(mt)) {
            UIResourceInfo uiResourceInfo = (UIResourceInfo)model;
            if (uiResourceInfo.getDomain() != null) {
                domainId = uiResourceInfo.getDomain().getId().toString();
            }
            domainSign = uiResourceInfo.getResourceDomainSign();
            language = uiResourceInfo.getLanaguage();
            md5code = uiResourceInfo.getMd5();
            UIMultiLanCollection uiMultiLanCollection = uiResourceInfo.getMultiLang();
            if (uiMultiLanCollection != null && uiMultiLanCollection.size() > 0) {
                for (i = 0; i < uiMultiLanCollection.size(); ++i) {
                    UIMultiLanInfo uiMultiLanInfo = uiMultiLanCollection.get(i);
                    if (!language.equals(uiMultiLanInfo.getLanguage())) continue;
                    mlRes = uiMultiLanInfo.getMlRes2();
                    break;
                }
            }
        } else if ("enum".equals(mt)) {
            EnumResourceInfo enumResourceInfo = (EnumResourceInfo)model;
            if (enumResourceInfo.getDomain() != null) {
                domainId = enumResourceInfo.getDomain().getId().toString();
            }
            domainSign = enumResourceInfo.getResourceDomainSign();
            language = enumResourceInfo.getLanaguage();
            md5code = enumResourceInfo.getMd5();
            EnumMultiLanCollection enumMultiLanCollection = enumResourceInfo.getMultiLang();
            if (enumMultiLanCollection != null && enumMultiLanCollection.size() > 0) {
                for (i = 0; i < enumMultiLanCollection.size(); ++i) {
                    EnumMultiLanInfo enumMultiLanInfo = enumMultiLanCollection.get(i);
                    if (!language.equals(enumMultiLanInfo.getLanguage())) continue;
                    mlRes = enumMultiLanInfo.getMlRes2();
                    break;
                }
            }
        } else if ("resource".equals(mt)) {
            ResResourceInfo resResourceInfo = (ResResourceInfo)model;
            if (resResourceInfo.getDomain() != null) {
                domainId = resResourceInfo.getDomain().getId().toString();
            }
            domainSign = resResourceInfo.getResourceDomainSign();
            language = resResourceInfo.getLanaguage();
            md5code = resResourceInfo.getMd5();
            ResMultiLanCollection resMultiLanCollection = resResourceInfo.getMultiLang();
            if (resMultiLanCollection != null && resMultiLanCollection.size() > 0) {
                for (i = 0; i < resMultiLanCollection.size(); ++i) {
                    ResMultiLanInfo resMultiLanInfo = resMultiLanCollection.get(0);
                    if (!language.equals(resMultiLanInfo.getLanguage())) continue;
                    mlRes = resMultiLanInfo.getMlRes2();
                    break;
                }
            }
        } else {
            return;
        }
        if (domainId == null || domainId.length() <= 0 || md5code == null || md5code.length() <= 0 || domainSign == null || !domainSign.equals("true")) {
            return;
        }
        Connection connection = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            StringBuffer sbEntityMultiLan = new StringBuffer();
            sbEntityMultiLan.append(" UPDATE T_Res_EntityMultiLan SET FMLRes2 = '" + mlRes + "' WHERE FResID IN( ");
            sbEntityMultiLan.append("   SELECT FID FROM T_RES_EntityResource WHERE FDomainId = '" + domainId + "' AND FMD5 = '" + md5code + "' ");
            sbEntityMultiLan.append(" ) AND FLanguage = '" + language + "' ");
            connection.createStatement().executeUpdate(sbEntityMultiLan.toString());
            StringBuffer sbQueryMultiLan = new StringBuffer();
            sbQueryMultiLan.append(" UPDATE T_Res_QueryMultiLan SET FMLRes2 = '" + mlRes + "' WHERE FResID IN( ");
            sbQueryMultiLan.append("   SELECT FID FROM T_Res_QueryResource WHERE FDomainId = '" + domainId + "' AND FMD5 = '" + md5code + "' ");
            sbQueryMultiLan.append(" ) AND FLanguage = '" + language + "' ");
            connection.createStatement().executeUpdate(sbQueryMultiLan.toString());
            StringBuffer sbUIMultiLan = new StringBuffer();
            sbUIMultiLan.append(" UPDATE T_Res_UIMultiLan SET FMLRes2 = '" + mlRes + "' WHERE FResID IN( ");
            sbUIMultiLan.append("   SELECT FID FROM T_Res_UIResource WHERE FDomainId = '" + domainId + "' AND FMD5 = '" + md5code + "' ");
            sbUIMultiLan.append(" ) AND FLanguage = '" + language + "' ");
            connection.createStatement().executeUpdate(sbUIMultiLan.toString());
            StringBuffer sbEnumMultiLan = new StringBuffer();
            sbEnumMultiLan.append(" UPDATE T_Res_EnumMultiLan SET FMLRes2 = '" + mlRes + "' WHERE FResID IN( ");
            sbEnumMultiLan.append("   SELECT FID FROM T_Res_EnumResource WHERE FDomainId = '" + domainId + "' AND FMD5 = '" + md5code + "' ");
            sbEnumMultiLan.append(" ) AND FLanguage = '" + language + "' ");
            connection.createStatement().executeUpdate(sbEnumMultiLan.toString());
            StringBuffer sbResMultiLan = new StringBuffer();
            sbResMultiLan.append(" UPDATE T_Res_ResMultiLan SET FMLRes2 = '" + mlRes + "' WHERE FResID IN( ");
            sbResMultiLan.append("   SELECT FID FROM T_Res_ResResource WHERE FDomainId = '" + domainId + "' AND FMD5 = '" + md5code + "' ");
            sbResMultiLan.append(" ) AND FLanguage = '" + language + "' ");
            connection.createStatement().executeUpdate(sbResMultiLan.toString());
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    public static void analyseResourceDomain(Context ctx, MetaDataTypeEnum metaType) throws BOSException, EASBizException {
        if (metaType == null) {
            return;
        }
        IEASResourceDomain iEASResourceDomain = EASResourceDomainFactory.getLocalInstance(ctx);
        EASResourceDomainCollection domainColl = iEASResourceDomain.getEASResourceDomainCollection();
        String sql = "";
        if (domainColl != null && domainColl.size() > 0) {
            for (int i = 0; i < domainColl.size(); ++i) {
                EASResourceDomainInfo domainInfo = domainColl.get(i);
                String domainId = domainInfo.getId().toString();
                String packageName = domainInfo.getPackageName();
                sql = " update T_RES_EntityResource set FDomainId = '' WHERE FDomainId = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId});
                sql = " update T_RES_EntityResource set FDomainId = ? WHERE FPackage like ? ";
                MetasResourceHelper.analyseResourceDomain(ctx, domainId, packageName, sql);
                sql = " update T_RES_QueryResource set FDomainId = '' WHERE FDomainId = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId});
                sql = " update T_RES_QueryResource set FDomainId = ? WHERE FPackage like ? ";
                MetasResourceHelper.analyseResourceDomain(ctx, domainId, packageName, sql);
                sql = " update T_RES_UIResource set FDomainId = '' WHERE FDomainId = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId});
                sql = " update T_RES_UIResource set FDomainId = ? WHERE FPackage like ? ";
                MetasResourceHelper.analyseResourceDomain(ctx, domainId, packageName, sql);
                sql = " update T_RES_EnumResource set FDomainId = '' WHERE FDomainId = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId});
                sql = " update T_RES_EnumResource set FDomainId = ? WHERE FPackage like ? ";
                MetasResourceHelper.analyseResourceDomain(ctx, domainId, packageName, sql);
                sql = " update T_RES_ResResource set FDomainId = '' WHERE FDomainId = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId});
                sql = " update T_RES_ResResource set FDomainId = ? WHERE FPackage like ? ";
                MetasResourceHelper.analyseResourceDomain(ctx, domainId, packageName, sql);
            }
        }
    }

    public static void analyseResourceDomain(Context ctx, String domainId, String packageName, String sql) throws BOSException, EASBizException {
        if (packageName != null && packageName.length() > 0) {
            String[] packageArray = packageName.split(";");
            for (int i = 0; i < packageArray.length; ++i) {
                String packageString = packageArray[i];
                if (packageString == null || packageString.length() <= 0) continue;
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{domainId, packageString + "%"});
            }
        }
    }
}

