/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.EASMultiLanResFactory;
import com.kingdee.eas.bs.ml.EASResourceCollection;
import com.kingdee.eas.bs.ml.EASResourceFactory;
import com.kingdee.eas.bs.ml.EASResourceInfo;
import com.kingdee.eas.bs.ml.IEASMultiLanRes;
import com.kingdee.eas.bs.ml.IEASResource;
import com.kingdee.eas.bs.ml.ILanguage;
import com.kingdee.eas.bs.ml.LanguageCollection;
import com.kingdee.eas.bs.ml.LanguageFactory;
import com.kingdee.eas.bs.ml.LanguageInfo;
import com.kingdee.eas.bs.ml.TranslateStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MultiLangTransmission
extends AbstractDataTransmission {
    EASResourceInfo info = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.bs.ml.MultiLangTransmission");

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            CoreBaseInfo head = null;
            for (int i = 0; i < hsData.size(); ++i) {
                Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
                if (i == 0 && (head = this.createHead(lineData, ctx)) == null) {
                    return null;
                }
                this.createEntry(head, lineData, ctx);
            }
            return head;
        }
        catch (TaskExternalException te) {
            throw te;
        }
        catch (EASBizException ee) {
            logger.info((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)ee));
            throw new TaskExternalException(ee.getMessage());
        }
        catch (Exception e) {
            String excLinkStackTrace = ExceptionUtil.getExcLinkStackTrace((Throwable)e);
            logger.error((Object)excLinkStackTrace);
            throw new TaskExternalException(excLinkStackTrace);
        }
    }

    protected CoreBaseInfo createHead(Hashtable hsData, Context ctx) throws Exception {
        this.info = new EASResourceInfo();
        EASResourceInfo oldInfo = null;
        String sID = (String)((DataToken)hsData.get((Object)"FID")).data;
        if (super.isSltImportUpdate() && sID != null && !sID.equals("")) {
            IEASResource iEASResource = (IEASResource)this.getController(ctx);
            EASResourceCollection resourceCollection = iEASResource.getEASResourceCollection("select *,multiLang.*,multiLang.language.* where id ='" + sID + "'");
            if (resourceCollection != null && resourceCollection.size() > 0) {
                oldInfo = resourceCollection.get(0);
            }
            if (oldInfo != null) {
                this.info = oldInfo;
            }
        }
        if (sID != null && !sID.equals("")) {
            this.info.setId(BOSUuid.read((String)sID));
        } else {
            this.info.setId(BOSUuid.create((String)"840860ED"));
        }
        this.info.setRes((String)((DataToken)hsData.get((Object)"FChinese")).data);
        return this.info;
    }

    protected void createEntry(CoreBaseInfo head, Hashtable hsData, Context ctx) throws Exception {
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EASResourceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putValue(result, "FID", rs.getString("id"));
            this.putValue(result, "FChinese", rs.getString("res"));
            this.putValue(result, "FLanguage", rs.getString("language.number"));
            this.putValue(result, "FContent", rs.getString("multiLang.content"));
            this.putValue(result, "FStatus", TranslateStatusEnum.getEnum(rs.getInt("multiLang.isTranslated")).getAlias(new Locale("l2")));
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private void putValue(Hashtable htable, String key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    protected String[] getMainFields() {
        return new String[]{"FID", "FChinese"};
    }

    public static TranslateStatusEnum getTranslateStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (MultiLangTransmission.EnumEqualByAlias(value, (Enum)TranslateStatusEnum.save)) {
            return TranslateStatusEnum.save;
        }
        if (MultiLangTransmission.EnumEqualByAlias(value, (Enum)TranslateStatusEnum.submit)) {
            return TranslateStatusEnum.submit;
        }
        return null;
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale("l2")));
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public LanguageInfo getLanguageByNumber(String number, Context ctx) throws Exception {
        ILanguage iLanguage = LanguageFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        LanguageCollection languages = iLanguage.getLanguageCollection(viewInfo);
        LanguageInfo info = null;
        if (languages != null && languages.size() > 0) {
            info = new LanguageInfo();
            info.setId(languages.get(0).getId());
        }
        return info;
    }

    public boolean isTranslated(String id, Context ctx) throws Exception {
        IEASMultiLanRes imulti = EASMultiLanResFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)BOSUuid.read((String)id), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("content", null, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        return imulti.exists(filter);
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (this.getMainFields() == null) {
            return super.isSameBlock(firstData, currentData);
        }
        if (firstData == null || currentData == null) {
            return false;
        }
        boolean isSameBlock = true;
        for (int i = 0; i < this.getMainFields().length; ++i) {
            if (firstData.get(this.getMainFields()[i]).equals(currentData.get(this.getMainFields()[i]))) continue;
            isSameBlock = false;
        }
        return isSameBlock;
    }
}

