/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.bs.ml.CleanResourceCacheUtilFactory;
import com.kingdee.eas.bs.ml.app.AbstractResourceFacadeControllerBean;
import com.kingdee.eas.bs.ml.app.ResourceServerCache;
import com.kingdee.eas.bs.ml.util.ICleanResourceCacheUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceFacadeControllerBean
extends AbstractResourceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.ResourceFacadeControllerBean");
    private static final long serialVersionUID = 1L;
    private static ResourceServerCache cache = ResourceServerCache.getInstance();

    @Override
    public Map getFileResource(Context ctx, String pkg, String fileName, String lan, String metaType) throws BOSException {
        return this._getFileResource(ctx, pkg, fileName, lan, metaType);
    }

    @Override
    protected Map _getFileResource(Context ctx, String pkg, String fileName, String lan, String metaType) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        HashMap<String, String> map;
        String ck;
        block26: {
            String sql;
            block25: {
                if (pkg == null) {
                    pkg = "";
                }
                if (pkg == null || fileName == null || lan == null || metaType == null || ctx == null) {
                    return Collections.EMPTY_MAP;
                }
                String ais = ctx.getAIS();
                Boolean b = cache.getDC(ais);
                if (b == null) {
                    b = new Boolean(this.checkMLResourceDB(ctx));
                    cache.putDC(ais, b);
                }
                if (b != null && !b.booleanValue()) {
                    return Collections.EMPTY_MAP;
                }
                ck = ais + "_" + lan + pkg + "\\" + fileName + "." + metaType;
                if (cache.contains(ck)) {
                    return (Map)cache.get(ck);
                }
                map = new HashMap<String, String>(100, 0.75f);
                conn = null;
                ps = null;
                rs = null;
                sql = "";
                conn = EJBFactory.getQueryConnection((Context)ctx);
                if ("ui".equals(metaType) || "wbpage".equals(metaType) || "webui".equals(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.ui_sql : Sql.ui_ml_sql;
                    break block25;
                }
                if ("resource".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.res_sql : Sql.res_ml_sql;
                    break block25;
                }
                if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.em_sql : Sql.em_ml_sql;
                    break block25;
                }
                if ("entity".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.et_sql : Sql.et_ml_sql;
                    break block25;
                }
                if ("query".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.qy_sql : Sql.qy_ml_sql;
                    break block25;
                }
                if ("permission".equalsIgnoreCase(metaType) || "log".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.perm_sql : Sql.perm_ml_sql;
                    break block25;
                }
                if ("mdbview".equalsIgnoreCase(metaType)) {
                    sql = "zh_CN".equalsIgnoreCase(lan) ? Sql.mdbview_sql : Sql.mdbview_ml_sql;
                    break block25;
                }
                Map map2 = Collections.EMPTY_MAP;
                SQLUtils.cleanup((ResultSet)rs);
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup((Connection)conn);
                return map2;
            }
            ps = conn.prepareStatement(sql);
            if ("mdbview".equalsIgnoreCase(metaType)) {
                ps.setString(1, fileName);
                ps.setString(2, lan);
                ps.setString(3, metaType);
            } else {
                ps.setString(1, pkg);
                ps.setString(2, fileName);
                if ("zh_CN".equalsIgnoreCase(lan)) {
                    if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                        ps.setString(3, metaType);
                    }
                } else {
                    ps.setString(3, lan);
                    if ("enum".equalsIgnoreCase(metaType) || "exception".equalsIgnoreCase(metaType)) {
                        ps.setString(4, metaType);
                    }
                }
            }
            rs = ps.executeQuery();
            if (rs != null) break block26;
            Map map3 = Collections.EMPTY_MAP;
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Statement)ps);
            SQLUtils.cleanup((Connection)conn);
            return map3;
        }
        try {
            while (rs.next()) {
                map.put(rs.getString("k"), rs.getString("vl"));
            }
            cache.put(ck, map);
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return map;
    }

    @Override
    protected void _clearResourceCache(Context ctx) throws BOSException {
        ICleanResourceCacheUtil iCRCUtil = CleanResourceCacheUtilFactory.getInstance();
        MDLoader.createInstance((Context)ctx).clearAll();
        cache.clearCache();
        iCRCUtil.synClearCache();
        iCRCUtil.synClearDcList();
        String webCacheSQL = "delete from T_DYN_StaticWebPage";
        DbUtil.execute((Context)ctx, (String)webCacheSQL);
        this.updateServerTimestamp(ctx);
    }

    private void updateServerTimestamp(Context ctx) {
        String now = String.valueOf(System.currentTimeMillis());
        String updateSql = "update T_Res_CacheTime set FCacheTime='" + now + "'";
        try {
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean _checkExistInitMLDB(Context ctx) throws BOSException {
        Boolean bo = cache.getDC(ctx.getAIS());
        if (bo != null) {
            return bo;
        }
        return this.checkMLResourceDB(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMLResourceDB(Context ctx) throws BOSException {
        Connection conn = null;
        boolean b = false;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ResultSet rs = conn.createStatement().executeQuery(" select count(*) c from t_res_UIResource ");
            ResultSet mlRs = conn.createStatement().executeQuery(" select count(*) c from t_res_UIMultiLan ");
            if (rs.next() && mlRs.next() && rs.getInt("c") > 0 && mlRs.getInt("c") > 0) {
                b = true;
            }
        }
        catch (SQLException ex) {
            b = false;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return b;
    }

    private static class Sql {
        public static String ui_sql = " select FKey k, FRes2 vl from T_Res_UIResource where FPackage = ? and FFileName = ? ";
        public static String ui_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_UIResource res  inner join T_Res_UIMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? ";
        public static String res_sql = " select FKey k, FRes2 vl from T_Res_resResource where FPackage = ? and FFileName = ? ";
        public static String res_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_resResource res  inner join T_Res_resMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? ";
        public static String em_sql = " select FKey k, FRes2 vl from T_Res_EnumResource where FPackage = ? and FFileName = ? and FMetaType = ? ";
        public static String em_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_EnumResource res  inner join T_Res_EnumMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? and res.FMetaType = ? ";
        public static String et_sql = " select FKey k, FRes2 vl from T_Res_EntityResource where FPackage = ? and FFileName = ? ";
        public static String et_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_EntityResource res  inner join T_Res_EntityMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? ";
        public static String qy_sql = " select FKey k, FRes2 vl from T_Res_QueryResource where FPackage = ? and FFileName = ? ";
        public static String qy_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_QueryResource res  inner join T_Res_QueryMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? ";
        public static String perm_sql = " select FKey k, FRes2 vl from T_Res_PermResource where FPackage = ? and FFileName = ? ";
        public static String perm_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_Res_PermResource res  inner join T_Res_PermMultiLan  ml on res.FId = ml.FResId  where res.FPackage = ? and res.FFileName = ? and ml.FLanguage = ? ";
        public static String mdbview_sql = " select FKey k, FRes2 vl from T_RES_MdbviewResource where FPackage = ? and FFileName = ? and FMetaType = ? ";
        public static String mdbview_ml_sql = " select res.FKey k, ml.FMLRes2 vl from T_RES_MdbviewResource res  inner join T_RES_MdbviewMultiLan  ml on res.FId = ml.FResId  where res.FFileName = ? and ml.FLanguage = ? and res.FMetaType = ? ";

        private Sql() {
        }
    }
}

