/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.log.app.LogServiceThread;
import com.kingdee.eas.bs.ml.smartmalle.IMallERecord;
import com.kingdee.eas.bs.ml.smartmalle.MallERecordFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallERecordInfo;
import com.kingdee.eas.bs.ml.smartmalle.app.RecordQueue;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class RecordServiceThread
extends Thread {
    private Logger logger = Logger.getLogger((String)LogServiceThread.class.getName());
    private volatile boolean stop;
    private static RecordServiceThread thr = null;

    public void stopThread() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    private RecordServiceThread() {
        super("MallERecordServiceThread");
    }

    public static RecordServiceThread getInstance() {
        if (thr == null) {
            thr = new RecordServiceThread();
        }
        return thr;
    }

    public static void close() {
        thr = null;
    }

    @Override
    public void run() {
        MallERecordInfo recData = null;
        this.stop = false;
        while (!this.stop) {
            try {
                recData = RecordQueue.getInstance().dequeue();
                this.writeRec(recData);
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                this.stop = true;
            }
        }
    }

    private void writeRec(MallERecordInfo recData) throws BOSException, EASBizException {
        Context ctx = ContextUtils.getContextFromSession();
        IMallERecord iRec = MallERecordFactory.getLocalInstance(ctx);
        iRec.addnew(recData);
    }
}

