/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataCollection;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEParserHelper;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MallEFetchDEPInfoUtil {
    private static Logger logger = Logger.getLogger((String)MallEFetchDEPInfoUtil.class.getName());

    public static void parseDepSegment(Context ctx, String metaDataPK, String lan) throws Exception {
        MallEFetchDEPInfoUtil.parseDepSegmentNew(ctx, metaDataPK, lan);
    }

    public static void parseDepSegmentNew(Context ctx, String metaDataPK, String lan) throws Exception {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp != null) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                if (!StringUtils.isEmpty((String)metaDataPK)) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("metaDatapk", (Object)metaDataPK, CompareType.EQUALS));
                    view.setFilter(filter);
                }
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add("id");
                view.setSelector(selectorColl);
                IDynamicMetadata iDmc = null;
                iDmc = ctx != null ? DynamicMetadataFactory.getLocalInstance((Context)ctx) : DynamicMetadataFactory.getRemoteInstance();
                DynamicMetadataCollection dmc = iDmc.getCollection(view);
                Document doc = null;
                for (int j = 0; j < dmc.size(); ++j) {
                    DynamicMetadataInfo dmi = dmc.get(j);
                    dmi = iDmc.getValue((IObjectPK)new ObjectUuidPK(dmi.getId()));
                    String metaType = MallEFetchDEPInfoUtil.getMetasBosType(dmi.getBosType());
                    byte[] segment = dmi.getSegment();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(segment);
                    doc = MallEFetchDEPInfoUtil.parseXML(byteArrayInputStream, metaType);
                    MallEFetchDEPInfoUtil.parseDoc(ctx, doc, lan);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
                throw new Exception(e);
            }
        }
    }

    public static String getMetasBosType(String bosType) {
        String metasType = "";
        if (bosType != null && "enty".equals(bosType)) {
            metasType = "entity";
        } else if (bosType != null && ("jqye".equals(bosType) || "uqye".equals(bosType) || "baqu".equals(bosType) || "vqye".equals(bosType))) {
            metasType = "query";
        } else if (bosType != null && "uioj".equals(bosType)) {
            metasType = "ui";
        } else if (bosType != null && "perm".equals(bosType)) {
            metasType = "permission";
        } else if (bosType != null && "logs".equals(bosType)) {
            metasType = "log";
        } else if (bosType != null && "bien".equals(bosType)) {
            metasType = "enum";
        } else if (bosType != null && "bize".equals(bosType)) {
            metasType = "exception";
        } else if (bosType != null && "wbui".equals(bosType)) {
            metasType = "resource";
        } else if (bosType != null && "datb".equals(bosType)) {
            metasType = "table";
        } else if (bosType != null && "wbpe".equals(bosType)) {
            metasType = "wbpage";
        } else if (bosType != null && "webui".equals(bosType)) {
            metasType = "webui";
        }
        return metasType;
    }

    public static Document parseXML(InputStream inputStream, String metaType) throws Exception {
        if (inputStream == null) {
            throw new IllegalArgumentException("The argument inputStream is null");
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(inputStream);
            if (doc != null) {
                doc.setName(metaType);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new Exception(ex);
        }
        return doc;
    }

    private static void parseDoc(Context ctx, Document doc, String lan) throws Exception {
        String suffix = doc.getName().toString();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_PKG).replace(".", "\\");
        String name = root.elementText(MetaDocConst.NODE_NAME);
        if (suffix != null && !"".equals(suffix)) {
            MallEParserHelper.parse(ctx, doc, pkg, name, suffix, lan);
        }
    }
}

