/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistor;
import com.kingdee.eas.bs.ml.smartmalle.MallEResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class MallEPermAndLogResourceParser {
    private MallEPermAndLogResourceParser() {
    }

    public static MallEPermAndLogResourceParser getInstance() {
        return new MallEPermAndLogResourceParser();
    }

    public List parser(Context ctx, Document doc, Map completedWords, Map mulExistsWords, Map resWords, String metaType, String lan) throws Exception {
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MallEResourceInfo> list = new ArrayList<MallEResourceInfo>();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_PKG);
        String name = root.elementText(MetaDocConst.NODE_NAME);
        if (name == null || name.trim().length() <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (pkg != null && pkg.trim().length() > 0) {
            pkg = pkg.replaceAll("\\.", "\\\\");
        }
        Element permissionItems = root.element("permissionItems");
        Element resource = root.element("resource");
        if (resource == null || permissionItems == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = permissionItems.elementIterator();
        while (rsIt.hasNext()) {
            MallEResourceInfo resInfo;
            String trans;
            boolean hasmulwords;
            boolean hascnwords;
            String key;
            Element permissionItem = (Element)rsIt.next();
            String innerID = permissionItem.element("innerID").getTextTrim();
            if (innerID == null) continue;
            String itemName = permissionItem.elementTextTrim("name");
            String aliasKey = permissionItem.element("alias").getTextTrim();
            String alias_CN = MLUtils.myTrim(MallEPermAndLogResourceParser.getCNResource(resource, aliasKey));
            String md5 = MLUtils.md5HashCode(alias_CN);
            if (alias_CN != null && alias_CN.length() > 0 && !alias_CN.equals("null")) {
                key = itemName + ".alias";
                hascnwords = true;
                hasmulwords = true;
                if (!completedWords.containsKey(key)) {
                    if (!mulExistsWords.containsKey(key)) {
                        hasmulwords = false;
                    }
                    if (!resWords.containsKey(key)) {
                        hascnwords = false;
                    }
                    trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, alias_CN, lan, md5, metaType);
                    resInfo = new MallEResourceInfo(alias_CN, trans, pkg, name, key, metaType, false, hascnwords, hasmulwords, false);
                    list.add(resInfo);
                } else if (!md5.equals(completedWords.get(key))) {
                    trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, alias_CN, lan, md5, metaType);
                    resInfo = new MallEResourceInfo(alias_CN, trans, pkg, name, key, metaType, true, hascnwords, hasmulwords, false);
                    list.add(resInfo);
                }
            }
            String desc_CN = null;
            if (permissionItem.element("description") != null) {
                desc_CN = MLUtils.myTrim(MallEPermAndLogResourceParser.getCNResource(resource, permissionItem.element("description").getTextTrim()));
            }
            md5 = MLUtils.md5HashCode(desc_CN);
            if (desc_CN == null || desc_CN.length() <= 0 || desc_CN.equals("null")) continue;
            key = itemName + ".desc";
            hascnwords = true;
            hasmulwords = true;
            if (!completedWords.containsKey(key)) {
                if (!mulExistsWords.containsKey(key)) {
                    hasmulwords = false;
                }
                if (!resWords.containsKey(key)) {
                    hascnwords = false;
                }
                trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, alias_CN, lan, md5, metaType);
                resInfo = new MallEResourceInfo(alias_CN, trans, pkg, name, key, metaType, false, hascnwords, hasmulwords, false);
                list.add(resInfo);
                continue;
            }
            if (md5.equals(completedWords.get(key))) continue;
            trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, name, alias_CN, lan, md5, metaType);
            resInfo = new MallEResourceInfo(alias_CN, trans, pkg, name, key, metaType, true, hascnwords, hasmulwords, false);
            list.add(resInfo);
        }
        return list;
    }

    private static String getCNResource(Element resource, String resKey) {
        if (resKey == null) {
            return null;
        }
        String xpath = "//*[name() = 'rs' and @key = '" + resKey + "']/*[name() = 'lang' and @locale = 'zh_CN']";
        Element el = (Element)resource.selectSingleNode(xpath);
        if (el != null) {
            return el.attribute("value").getText();
        }
        return null;
    }
}

