/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.smartmalle.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.bs.ml.smartmalle.MallEAssistor;
import com.kingdee.eas.bs.ml.smartmalle.MallEResourceInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDocConst;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class MallEWebPageResourceParser {
    private static Set includeProp = new HashSet();

    private MallEWebPageResourceParser() {
    }

    public static MallEWebPageResourceParser getInstance() {
        return new MallEWebPageResourceParser();
    }

    private static void initIncludeProperties() {
        includeProp.add("text");
        includeProp.add("caption");
        includeProp.add("alias");
        includeProp.add("validator.errMsg");
        includeProp.add("title");
        includeProp.add("label");
        includeProp.add("tips");
        includeProp.add("groupText");
        includeProp.add("titleText");
        includeProp.add("rootName");
        includeProp.add("dateFormat");
    }

    public List parser(Context ctx, Document doc, Map completedWords, Map mulExistsWords, Map resWords, String metaType, String lan) throws Exception {
        String project;
        if (doc == null || metaType == null) {
            return Collections.EMPTY_LIST;
        }
        if (!"wbpage".equalsIgnoreCase(metaType)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList uiResList = new ArrayList();
        Element root = doc.getRootElement();
        String pkg = root.elementText(MetaDocConst.NODE_UI_ReleasePackage);
        if (pkg == null || "".equals(pkg)) {
            pkg = root.elementText(MetaDocConst.NODE_PKG);
        }
        if ((project = pkg.replaceAll("com.kingdee.eas.", "")).indexOf(".") > 0) {
            project = project.substring(0, project.indexOf("."));
        }
        pkg = pkg.replaceAll("\\.", "\\\\");
        String name = root.elementText(MetaDocConst.NODE_UI_ReleaseClass);
        if (name == null || "".equals(name)) {
            name = root.elementText(MetaDocConst.NODE_NAME);
        }
        uiResList.addAll(this.processResNode(ctx, root, completedWords, mulExistsWords, resWords, pkg, name, lan));
        uiResList.addAll(this.processFrontResNode(ctx, root, completedWords, mulExistsWords, resWords, pkg, name, lan));
        return uiResList;
    }

    private List processResNode(Context ctx, Element root, Map completedWords, Map mulExistsWords, Map resWords, String pkg, String className, String lan) throws EASBizException, BOSException {
        ArrayList uiResList = new ArrayList();
        HashMap mulRsMap = new HashMap();
        Set<String> mulRsSet = this.getXmlMulFieldKeySet(root);
        if (mulRsSet == null) {
            return uiResList;
        }
        Element resourceElement = root.element(MetaDocConst.NODE_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        while (rsIt.hasNext()) {
            Element rsElement = (Element)rsIt.next();
            String key = rsElement.attribute(MetaDocConst.ATT_KEY).getText();
            String realKey = null;
            if (!mulRsSet.contains(key)) continue;
            String suffix = null;
            if (key.indexOf("components") > 0) {
                suffix = key.substring(key.indexOf(".properties.property[") + ".properties.property[".length());
                suffix = suffix.substring(0, suffix.indexOf("]"));
                realKey = key.substring(key.indexOf(".components.component[") + ".components.component[".length());
                realKey = realKey.substring(0, realKey.indexOf("]"));
                realKey = realKey + "." + suffix;
            } else {
                realKey = key.substring(key.lastIndexOf("."));
                realKey = "this" + realKey;
            }
            this.dealWithKey(ctx, uiResList, rsElement, completedWords, mulExistsWords, resWords, pkg, className, key, realKey, lan);
        }
        return uiResList;
    }

    private void dealWithKey(Context ctx, List uiResList, Element rsElement, Map completedWords, Map mulExistsWords, Map resWords, String pkg, String className, String key2, String realKey, String lan) throws EASBizException, BOSException {
        Iterator langIt = rsElement.elementIterator();
        while (langIt.hasNext()) {
            Element localeElement = (Element)langIt.next();
            String locale = localeElement.attribute("locale").getText();
            if (!locale.equals("zh_CN")) continue;
            String zh_CN = localeElement.attribute("value").getText();
            String md5 = MLUtils.md5HashCode(zh_CN);
            boolean hascnwords = true;
            boolean hasmulwords = true;
            if (!completedWords.containsKey(realKey)) {
                boolean hasTrans = false;
                if (!mulExistsWords.containsKey(realKey)) {
                    hasmulwords = false;
                }
                if (!resWords.containsKey(realKey)) {
                    hascnwords = false;
                }
                String trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, className, zh_CN, lan, md5, "ui");
                MallEResourceInfo resInfo = new MallEResourceInfo(zh_CN, trans, pkg, className, realKey, "wbpage", false, hascnwords, hasmulwords, hasTrans);
                uiResList.add(resInfo);
                continue;
            }
            if (md5 == null || md5.equals(completedWords.get(realKey))) continue;
            String trans = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, className, zh_CN, lan, md5, "ui");
            MallEResourceInfo resInfo = new MallEResourceInfo(zh_CN, trans, pkg, className, realKey, "wbpage", true, hascnwords, hasmulwords, false);
            uiResList.add(resInfo);
        }
    }

    private List processFrontResNode(Context ctx, Element root, Map completedWords, Map mulExistsWords, Map resWords, String pkg, String className, String lan) throws EASBizException, BOSException {
        ArrayList<MallEResourceInfo> uiResList = new ArrayList<MallEResourceInfo>();
        Element resourceElement = root.element(MetaDocConst.NODE_FRONT_RES);
        if (resourceElement == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator rsIt = resourceElement.elementIterator();
        while (rsIt.hasNext()) {
            MallEResourceInfo resInfo;
            String mul;
            Element rsElement = (Element)rsIt.next();
            String key = null;
            String value = null;
            Iterator keyIt = rsElement.elementIterator();
            while (keyIt.hasNext()) {
                Element keyElement = (Element)keyIt.next();
                if (keyElement.getName().equalsIgnoreCase("name")) {
                    key = keyElement.getText();
                    continue;
                }
                if (!keyElement.getName().equalsIgnoreCase("zh_CN")) continue;
                value = keyElement.getText();
            }
            String md5 = MLUtils.md5HashCode(value);
            boolean hascnwords = true;
            boolean hasMulWords = true;
            boolean hasTrans = false;
            if (!completedWords.containsKey(key)) {
                if (!mulExistsWords.containsKey(key)) {
                    hasMulWords = false;
                }
                if (!resWords.containsKey(key)) {
                    hascnwords = false;
                }
                mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, className, value, lan, md5, "wbpage");
                resInfo = new MallEResourceInfo(value, mul, pkg, className, key, "wbpage", false, hascnwords, hasMulWords, hasTrans);
                uiResList.add(resInfo);
                continue;
            }
            if (md5 == null || md5.equals(completedWords.get(key))) continue;
            mul = MallEAssistor.AutoTranslator.autoTranslate(ctx, pkg, className, value, lan, md5, "wbpage");
            resInfo = new MallEResourceInfo(value, mul, pkg, className, key, "wbpage", false, hascnwords, hasMulWords, hasTrans);
            uiResList.add(resInfo);
        }
        return uiResList;
    }

    private Set<String> getXmlMulFieldKeySet(Element root) {
        Element componentsElement;
        HashSet<String> mulRsSet = new HashSet<String>();
        Element aliasElement = root.element(MetaDocConst.NODE_ALIAS);
        if (aliasElement != null && aliasElement.getText() != null && aliasElement.getText() != "") {
            mulRsSet.add(aliasElement.getText());
        }
        if ((componentsElement = root.element(MetaDocConst.NODE_COMPONENTS)) == null) {
            return null;
        }
        Iterator compIt = componentsElement.elementIterator();
        while (compIt.hasNext()) {
            Element compElement = (Element)compIt.next();
            Element proptsElement = compElement.element(MetaDocConst.NODE_PROPERTIES);
            if (proptsElement == null) continue;
            Iterator proptsIt = proptsElement.elementIterator();
            while (proptsIt.hasNext()) {
                Element proptyElement = (Element)proptsIt.next();
                Element isMulElement = proptyElement.element(MetaDocConst.NODE_ISMULTILAN);
                if (isMulElement == null || !"true".equalsIgnoreCase(isMulElement.getText())) continue;
                mulRsSet.add(proptyElement.elementText(MetaDocConst.ATT_VALUE));
            }
        }
        return mulRsSet;
    }

    static {
        MallEWebPageResourceParser.initIncludeProperties();
    }
}

