/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.smartmalle.MallERobComponentServer;
import com.kingdee.eas.bs.ml.smartmalle.tool.MallEFetchDEPInfoUtil;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEParserHelper;
import com.kingdee.eas.bs.ml.smartmalle.util.MallEWebCache;
import com.kingdee.util.LocaleUtils;
import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASResourceListenerHelper {
    private static Logger logger = Logger.getLogger((String)MallEParserHelper.class.getName());

    public static String getMetaDataType(BOSObjectType bosType) {
        if (MetaDataTypeList.UIOBJECT.equals((Object)bosType)) {
            return "ui";
        }
        if (MetaDataTypeList.BIZENUM.equals((Object)bosType)) {
            return "enum";
        }
        if (MetaDataTypeList.BIZEXCEPTION.equals((Object)bosType)) {
            return "exception";
        }
        if (MetaDataTypeList.RESOURCE_TYPE.equals((Object)bosType) || MetaDataTypeList.MULTILANGUAGE.equals((Object)bosType)) {
            return "resource";
        }
        if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
            return "entity";
        }
        if (MetaDataTypeList.JOINQUERY.equals((Object)bosType) || MetaDataTypeList.UNIONQUERY.equals((Object)bosType)) {
            return "query";
        }
        if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
            return "permission";
        }
        if (MetaDataTypeList.WEBPAGEOBJECT.equals((Object)bosType)) {
            return "wbpage";
        }
        if (MetaDataTypeList.METADATABRIEFVIEW.equals((Object)bosType)) {
            return "mdbview";
        }
        return null;
    }

    public static File getCacheDictionary(String ais, String lan) {
        String fileSepa = System.getProperty("file.separator");
        String dic = System.getProperty("user.dir") + fileSepa + "cache" + fileSepa + "EASResourceCache" + fileSepa + ais + fileSepa + lan;
        return new File(dic);
    }

    public static File getCacheFile(String dicPath, String pkg, String name, String metaType, String lan) {
        if (pkg == null) {
            pkg = "";
        }
        if ((pkg = pkg.replaceAll("\\\\", "_")).startsWith("com_kingdee_")) {
            pkg = pkg.replaceAll("com_kingdee_", "");
        }
        String fileName = pkg + "_" + name + "_" + metaType + "_" + lan + ".properties";
        String fileSepa = System.getProperty("file.separator");
        return new File(dicPath + fileSepa + fileName);
    }

    public static String generateCacheKey(String ais, String name, String pkg, String metaType, String lan) {
        return ais + "_" + lan + pkg + "\\" + name + "." + metaType;
    }

    public static Map getWebResource(String packageName, String resFileName, Locale lc) throws BOSException {
        if (packageName == null || resFileName == null || lc == null) {
            return Collections.EMPTY_MAP;
        }
        String pkg = packageName.replaceAll("\\.", "\\\\");
        String lan = LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)lc));
        return ResourceFacadeFactory.getRemoteInstance().getFileResource(pkg, resFileName, lan, "resource");
    }

    public static Map getWebPageResource(String packageName, String resFileName, Locale lc) throws BOSException {
        if (packageName == null || resFileName == null || lc == null) {
            return Collections.EMPTY_MAP;
        }
        String pkg = packageName.replaceAll("\\.", "\\\\");
        String lan = LocaleUtils.getLocaleString((Locale)LocaleUtils.getFirstOriginLocale((Locale)lc));
        String metaDataPK = packageName + "." + resFileName;
        Context ctx = null;
        try {
            ctx = ContextUtils.getContextFromSessionNoException();
        }
        catch (Exception e) {
            logger.error((Object)"malle\u83b7\u53d6context\u51fa\u9519 ", (Throwable)e);
        }
        boolean isServerMallEOn = MallERobComponentServer.isThisServerMallEon(ctx);
        if (isServerMallEOn && !MallEWebCache.containsKey(metaDataPK)) {
            try {
                MallEFetchDEPInfoUtil.parseDepSegment(ctx, metaDataPK, lan);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            MallEWebCache.put(metaDataPK, metaDataPK);
        }
        return ResourceFacadeFactory.getRemoteInstance().getFileResource(pkg, resFileName, lan, "wbpage");
    }
}

