/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IBizParamItemDeal;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.app.ParamSetModify;
import com.kingdee.eas.base.param.app.service.IParamHanderService;
import com.kingdee.eas.base.param.app.service.IParamQueryService;
import com.kingdee.eas.base.param.app.service.framework.BaseService;
import com.kingdee.eas.base.param.app.service.impl.ParamQueryServiceImpl;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ParamHanderServiceImpl
extends BaseService
implements IParamHanderService {
    Logger logger = Logger.getLogger((String)ParamHanderServiceImpl.class.getName());
    protected IParamQueryService paramQueryService = null;

    public ParamHanderServiceImpl() {
        this.paramQueryService = new ParamQueryServiceImpl();
    }

    public ParamHanderServiceImpl(IParamQueryService paramQueryService) {
        this.paramQueryService = paramQueryService;
    }

    private void initGroupControlParamItemFromParams(Context ctx, ParamCollection paramCO) throws EASBizException, BOSException {
        if (paramCO == null || paramCO.size() == 0) {
            return;
        }
        HashMap<String, ParamInfo> groupMap = new HashMap<String, ParamInfo>();
        for (int i = 0; i < paramCO.size(); ++i) {
            ParamInfo pi = paramCO.get(i);
            String paramId = pi.getId().toString();
            groupMap.put(paramId, pi);
        }
        OrgUnitInfo orgUnit = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select pFid from (").append(" select p.fid pFid,pi.fid piFid from t_bas_param p left join t_Bas_Paramitem pi on p.fid=pi.fkeyid ").append(" WHERE fsubSysID = '0000' AND forgType = -1 AND fuserEdit = 0 ) param where piFid is null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            while (rowSet.next()) {
                String paramId = rowSet.getString("pFid");
                ParamInfo paramInfo = (ParamInfo)groupMap.get(paramId);
                String descFieldName = "FDesc_" + ContextUtils.getLocaleFromEnv();
                String updateStr = "update t_bas_param set " + descFieldName + " = " + descFieldName + " where fid = '" + paramId + "'";
                DbUtil.execute((Context)ctx, (String)updateStr);
                ParamItemCollection pic = this.paramQueryService.getParamItemByKeyIDAndOrgUnit(null, paramId, sic, ctx, false);
                if (pic == null || pic.size() < 1) {
                    ParamItemInfo pii = this.getParamItemByParamInfo(ctx, paramInfo, orgUnit, null);
                    IObjectPK pk = iParamItem.addnewNoVerify(pii, paramInfo);
                    this.updateParamItemTimeAndUser(ctx, pk.toString());
                }
                DbUtil.execute((Context)ctx, (String)updateStr);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void initParamItemsFromParams(Context ctx, ParamCollection paramCO, OrgUnitInfo orgUnit, String orgTreeId) throws EASBizException, BOSException {
        String message = "";
        if (paramCO == null) {
            return;
        }
        if (paramCO.size() < 1) {
            return;
        }
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        for (int i = 0; i < paramCO.size(); ++i) {
            ParamInfo pi = paramCO.get(i);
            ParamItemCollection pic = null;
            pic = !OrgCommonUtils.isBasicOrgType((OrgType)pi.getOrgType()) ? (pi.isIsGroupControl() ? this.paramQueryService.getParamItemByKeyIDAndOrgTree(null, pi.getId().toString(), coll, ctx) : this.paramQueryService.getParamItemByKeyIDAndOrgTree(orgTreeId, pi.getId().toString(), coll, ctx)) : (pi.isIsGroupControl() ? this.paramQueryService.getParamItemByKeyIDAndOrgUnit(null, pi.getId().toString(), coll, ctx, false) : this.paramQueryService.getParamItemByKeyIDAndOrgUnit(orgUnit == null ? null : orgUnit.getId().toString(), pi.getId().toString(), coll, ctx, false));
            if (pic != null && pic.size() >= 1) continue;
            try {
                String descFieldName = "FDesc_" + ContextUtils.getLocaleFromEnv();
                String updateStr = "update t_bas_param set " + descFieldName + " = " + descFieldName + " where fid = '" + pi.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateStr);
                pic = !OrgCommonUtils.isBasicOrgType((OrgType)pi.getOrgType()) ? (pi.isIsGroupControl() ? this.paramQueryService.getParamItemByKeyIDAndOrgTree(null, pi.getId().toString(), coll, ctx) : this.paramQueryService.getParamItemByKeyIDAndOrgTree(orgTreeId, pi.getId().toString(), coll, ctx)) : (pi.isIsGroupControl() ? this.paramQueryService.getParamItemByKeyIDAndOrgUnit(null, pi.getId().toString(), coll, ctx, false) : this.paramQueryService.getParamItemByKeyIDAndOrgUnit(orgUnit == null ? null : orgUnit.getId().toString(), pi.getId().toString(), coll, ctx, false));
                if (pic == null || pic.size() < 1) {
                    ParamItemInfo pii = this.getParamItemByParamInfo(ctx, pi, orgUnit, orgTreeId);
                    if (pi != null && orgUnit != null) {
                        message = "pi=" + pi.getNumber() + " orgUnit=" + orgUnit.getId() + " orgTreeId=" + orgTreeId;
                    }
                    IObjectPK pk = iParamItem.addnewNoVerify(pii, pi);
                    this.updateParamItemTimeAndUser(ctx, pk.toString());
                }
                DbUtil.execute((Context)ctx, (String)updateStr);
                continue;
            }
            catch (Exception ex) {
                throw new BOSException(message, (Throwable)ex);
            }
        }
    }

    private void dealBizParamItem(Context ctx, IObjectValue originalOrgUnit, IObjectCollection destinationOrgUnit) throws BOSException {
        try {
            String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)"ED2A979A", IBizParamItemDeal.class);
            if (checkers != null && checkers.length > 0) {
                IBizParamItemDeal checker = null;
                for (int i = 0; i < checkers.length; ++i) {
                    checker = (IBizParamItemDeal)Class.forName(checkers[i]).newInstance();
                    checker.copyParam(ctx, originalOrgUnit, destinationOrgUnit);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean compareValue(ParamItemInfo paramItemA, ParamItemInfo paramItemB) {
        boolean isSameValue = false;
        isSameValue = paramItemA.getValue() == null ? paramItemB.getValue() == null : (paramItemB.getValue() == null ? false : paramItemA.getValue().equals(paramItemB.getValue()));
        return isSameValue;
    }

    private boolean checkCanCopy(ParamInfo tempParamInfo, FullOrgUnitInfo tempDestOrgUnit) {
        boolean canCopyFlag = false;
        canCopyFlag = tempParamInfo.getOrgType().equals((Object)OrgType.NONE) ? true : OrgCommonUtils.isOrgType((OrgUnitInfo)tempDestOrgUnit, (OrgType)tempParamInfo.getOrgType());
        return canCopyFlag;
    }

    private ParamCollection getParamCollectionFromParamItemCollection(Context ctx, CoreBaseCollection paramItemCollection) throws BOSException {
        if (paramItemCollection == null || paramItemCollection.size() < 1) {
            return null;
        }
        ParamCollection paramCollection = null;
        paramCollection = new ParamCollection();
        Iterator iterator = paramItemCollection.iterator();
        ParamItemInfo tempParamItemInfo = null;
        StringBuffer paramIdSet = new StringBuffer();
        while (iterator.hasNext()) {
            tempParamItemInfo = (ParamItemInfo)iterator.next();
            paramIdSet.append(tempParamItemInfo.getKeyID().getId()).append(",");
        }
        paramIdSet.deleteCharAt(paramIdSet.lastIndexOf(","));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramIdSet.toString(), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        paramCollection = ParamFactory.getLocalInstance(ctx).getParamCollection(viewInfo);
        return paramCollection;
    }

    private ParamItemInfo orgUnitContainParamItem(Context ctx, FullOrgUnitInfo orgUnit, ParamItemInfo paramItem) throws BOSException, EASBizException {
        ParamItemInfo paramItemInfo = null;
        ParamItemCollection paramItemCollection = null;
        paramItemCollection = this.paramQueryService.getParamItemByKeyIDAndOrgUnit(orgUnit.getId().toString(), paramItem.getKeyID().getId().toString(), ctx);
        if (paramItemCollection == null || paramItemCollection.size() < 1) {
            return null;
        }
        if (paramItemCollection.size() != 1) {
            this.logger.error((Object)("B paramitem Dumplicate:orgid is:" + orgUnit.getId().toString() + ",keyid is" + paramItem.getKeyID().getId().toString()));
            throw new ParamException(ParamException.CANNOTPARAMITEMINSAMEPARAMANDORGUNIT);
        }
        paramItemInfo = paramItemCollection.get(0);
        return paramItemInfo;
    }

    private ParamItemInfo generateParamItem(Context ctx, ParamItemInfo paramItemVO, FullOrgUnitInfo fullOrgUnitInfo) throws ParamException, EASBizException, BOSException {
        ParamItemInfo paramitem = new ParamItemInfo();
        paramitem.setIsControlSub(false);
        ParamSetModify paramSetModify = new ParamSetModify(ctx);
        paramitem.setIsModify(paramSetModify.isModify(paramItemVO.getKeyID()));
        paramitem.setOrgTreeID(null);
        paramitem.setOrgUnitID(fullOrgUnitInfo);
        paramitem.setKeyID(paramItemVO.getKeyID());
        MutilLangeToolForParam.muti2Obj((IObjectValue)paramItemVO, "Value", (IObjectValue)paramitem, "Value", ctx);
        MutilLangeToolForParam.muti2Obj((IObjectValue)paramItemVO, "valueAlias", (IObjectValue)paramitem, "valueAlias", ctx);
        this.setParamItemOrgTreeID(paramitem, paramitem.getKeyID().getOrgType());
        return paramitem;
    }

    public void setParamItemOrgTreeID(ParamItemInfo paramItem, OrgType type) {
        paramItem.setOrgTreeID(OrgCommonUtils.getOrgTreeId((OrgType)type));
    }

    @Override
    public IObjectCollection getParamsBySubSysAndOrgType(Context ctx, String subsys, int orgtype, OrgUnitInfo orgUnitId, String orgTreeId) throws BOSException, ParamException {
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("subSysID", (Object)subsys, CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("orgType", (Object)new Integer(orgtype), CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("userEdit", (Object)new Integer(0), CompareType.EQUALS));
        i.setMaskString("#0 and #1 and #2");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("defaultValue"));
        sic.add(new SelectorItemInfo("valueAlias"));
        sic.add(new SelectorItemInfo("isGroupControl"));
        sic.add(new SelectorItemInfo("number"));
        evi.setSelector(sic);
        ParamCollection pc = iParam.getParamCollection(evi);
        try {
            if ("0000".equals(subsys) && orgtype == -1 && orgUnitId == null && orgTreeId == null) {
                this.initGroupControlParamItemFromParams(ctx, pc);
            } else {
                this.initParamItemsFromParams(ctx, pc, orgUnitId, orgTreeId);
            }
        }
        catch (EASBizException e) {
            throw new BOSException();
        }
        catch (BOSException e) {
            throw e;
        }
        return pc;
    }

    @Override
    public IObjectCollection copyParam(Context ctx, IObjectValue originalOrgUnit, IObjectCollection destinationOrgUnit) throws BOSException, EASBizException {
        if (originalOrgUnit == null || destinationOrgUnit == null || destinationOrgUnit.size() < 1) {
            this.logger.info((Object)"Parameters invalid.");
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)((FullOrgUnitInfo)originalOrgUnit).getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CoreBaseCollection paramItemCollection = null;
        paramItemCollection = ParamItemFactory.getLocalInstance(ctx).getCollection(viewInfo);
        if (paramItemCollection == null || paramItemCollection.size() < 1) {
            throw new ParamException(ParamException.NOPARAMITEMINORIGINALORGUNIT);
        }
        Iterator destinationOrgUnitIterator = null;
        FullOrgUnitInfo tempDestOrgUnit2 = null;
        Iterator paramItemIterator = paramItemCollection.iterator();
        ParamItemInfo tempParamItemInfo = null;
        CoreBaseCollection newParamItemCollection = new CoreBaseCollection();
        CoreBaseCollection updateParamItemCollection = new CoreBaseCollection();
        ParamItemCollection copyFailParamItemCollection = new ParamItemCollection();
        ParamItemInfo tempNewParamItemInfo = null;
        boolean canCopyFlag = false;
        ParamInfo tempParamInfo = null;
        IParam iParam = null;
        iParam = ParamFactory.getLocalInstance(ctx);
        while (paramItemIterator.hasNext()) {
            tempParamItemInfo = (ParamItemInfo)paramItemIterator.next();
            for (FullOrgUnitInfo tempDestOrgUnit2 : destinationOrgUnit) {
                tempParamInfo = null;
                try {
                    tempParamInfo = iParam.getParamInfo((IObjectPK)new ObjectUuidPK(tempParamItemInfo.getKeyID().getId().toString()));
                }
                catch (BOSException e) {
                    this.logger.error((Object)"Get Param Error. ", (Throwable)e);
                }
                if (tempParamInfo == null) continue;
                tempParamItemInfo.setKeyID(tempParamInfo);
                canCopyFlag = this.checkCanCopy(tempParamInfo, tempDestOrgUnit2);
                if (!canCopyFlag) continue;
                tempNewParamItemInfo = this.orgUnitContainParamItem(ctx, tempDestOrgUnit2, tempParamItemInfo);
                if (tempNewParamItemInfo != null) {
                    tempNewParamItemInfo.setKeyID(tempParamItemInfo.getKeyID());
                    tempNewParamItemInfo.setOrgUnitID(tempDestOrgUnit2);
                    if (this.compareValue(tempParamItemInfo, tempNewParamItemInfo)) continue;
                    if (!tempNewParamItemInfo.getKeyID().isCanBeModified() && tempNewParamItemInfo.isIsModify()) {
                        copyFailParamItemCollection.add(tempNewParamItemInfo);
                        continue;
                    }
                    MutilLangeToolForParam.muti2Obj((IObjectValue)tempParamItemInfo, "Value", (IObjectValue)tempNewParamItemInfo, "Value", ctx);
                    MutilLangeToolForParam.muti2Obj((IObjectValue)tempParamItemInfo, "valueAlias", (IObjectValue)tempNewParamItemInfo, "valueAlias", ctx);
                    this.setParamItemOrgTreeID(tempNewParamItemInfo, tempNewParamItemInfo.getKeyID().getOrgType());
                    updateParamItemCollection.add((CoreBaseInfo)tempNewParamItemInfo);
                    continue;
                }
                tempNewParamItemInfo = this.generateParamItem(ctx, tempParamItemInfo, tempDestOrgUnit2);
                newParamItemCollection.add((CoreBaseInfo)tempNewParamItemInfo);
            }
        }
        if (updateParamItemCollection != null && updateParamItemCollection.size() > 0) {
            Iterator iterator = updateParamItemCollection.iterator();
            ParamItemInfo tempParamItem = null;
            IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
            while (iterator.hasNext()) {
                tempParamItem = (ParamItemInfo)iterator.next();
                try {
                    iParamItem.update((IObjectPK)new ObjectUuidPK(tempParamItem.getId().toString()), tempParamItem, tempParamItem.getKeyID());
                }
                catch (Exception e) {
                    this.logger.info((Object)"Update paramItem error.", (Throwable)e);
                    copyFailParamItemCollection.add(tempParamItem);
                }
            }
        }
        if (newParamItemCollection != null && newParamItemCollection.size() > 0) {
            ParamItemFactory.getLocalInstance(ctx).addnew(newParamItemCollection);
        }
        this.dealBizParamItem(ctx, originalOrgUnit, destinationOrgUnit);
        return copyFailParamItemCollection;
    }

    @Override
    public IObjectCollection deleteOrgUnitParam(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null || orgUnitId.trim().length() < 1) {
            this.logger.info((Object)"Parameters invalid.");
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isModify", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        CoreBaseCollection modifiedParamItemCollection = null;
        ParamCollection modifiedParamCollection = null;
        modifiedParamItemCollection = ParamItemFactory.getLocalInstance(ctx).getCollection(viewInfo);
        if (modifiedParamItemCollection != null && modifiedParamItemCollection.size() > 0) {
            modifiedParamCollection = this.getParamCollectionFromParamItemCollection(ctx, modifiedParamItemCollection);
            return modifiedParamCollection;
        }
        String deleteSql = "delete from t_bas_paramitem where forgunitid = '" + orgUnitId + "'";
        this.logger.debug((Object)("deleteSql: " + deleteSql));
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(deleteSql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return null;
    }
}

