/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.base.param.util.INationalPlanServerCache;
import com.kingdee.eas.base.param.util.INationalPlanUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class NationalPlanUtilFactory
implements INationalPlanUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.param.util.NationalPlanUtilFactory");
    private List<INationalPlanServerCache> servers = new ArrayList<INationalPlanServerCache>();

    private NationalPlanUtilFactory() {
    }

    public static INationalPlanUtil getInstance() {
        NationalPlanUtilFactory syn = new NationalPlanUtilFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        String url = null;
        for (int i = 0; i < ss.length; ++i) {
            try {
                IRPCServer s = ss[i];
                if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || NationalPlanUtilFactory.isLocal(url)) continue;
                INationalPlanServerCache pcs = (INationalPlanServerCache)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.base.param.app.NationalPlanServerCache", INationalPlanServerCache.class);
                syn.servers.add(pcs);
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)("url: " + url + "----" + th.getMessage()), th);
            }
        }
        return syn;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean synClearNationPlanCache() throws EASBizException, BOSException {
        boolean result = false;
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            try {
                result = this.servers.get(i).clearCache();
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)"\u6e05\u9664\u5176\u4ed6\u5b9e\u4f8b\u7f13\u5b58\u51fa\u9519", th);
            }
        }
        return result;
    }

    @Override
    public boolean synCclearNationPlanCache(String userID) {
        boolean result = false;
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            try {
                result = this.servers.get(i).clearCache(userID);
                continue;
            }
            catch (Throwable th) {
                logger.error((Object)"\u6e05\u9664\u5176\u4ed6\u5b9e\u4f8b\u7f13\u5b58\u51fa\u9519", th);
            }
        }
        return result;
    }
}

