/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.receiver.util.receiver;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.message.IMAGroupOrgFacade;
import com.kingdee.eas.base.message.MAGroupOrgFacadeFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.util.MessageUtils;
import com.kingdee.eas.base.receiver.util.PersonItem;
import com.kingdee.eas.base.receiver.util.ReceiverItem;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReceiverMessageUtils {
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";
    public static final String MID_BRACKET = ".";
    public static final String COMPAT_BRACKET = ";   ";
    public static final char COMPAT_EN = ';';
    public static final char COMPAT_CH = '\uff1b';
    public static String RECEIVER_MAP = "RECEIVER_MAP";
    public static String RECEIVER_MAGROUP = "RECEIVER_MAGROUP";
    public static final String PERSONVIRTUALTREE = "PERSONVIRTUALTREE";
    public static final String PERSONTREE = "PERSONTREE";

    public void setReceiverInfo(BasReceiverCollection receivers, Object ob) {
        receivers.add(this.getRptReceiverInfo(ob));
    }

    public void setReceiverInfo(BasReceiverCollection receivers, BasReceiverInfo rptReceiverInfo) {
        receivers.add(rptReceiverInfo);
    }

    public BasReceiverInfo getRptReceiverInfo(Object ob) {
        BasReceiverInfo receiverInfo = new BasReceiverInfo();
        if (ob instanceof OrgUserInfo) {
            OrgUserInfo tmpInfo = (OrgUserInfo)ob;
            if (tmpInfo.getUserOrOrg().equals("1")) {
                receiverInfo.setType("8");
            } else if (tmpInfo.getUserOrOrg().equals("0")) {
                receiverInfo.setType("0");
            } else if (tmpInfo.getUserOrOrg().equals("2")) {
                receiverInfo.setType("9");
            }
            receiverInfo.setValue(tmpInfo.getOrgUserID().toString());
            receiverInfo.setDesc(tmpInfo.getOrgUserName());
        } else if (ob instanceof MAGroupResolventInfo) {
            MAGroupResolventInfo mAGroupResolventInfo = (MAGroupResolventInfo)ob;
            receiverInfo.setType("2");
            receiverInfo.setValue(mAGroupResolventInfo.getId().toString());
            receiverInfo.setDesc(mAGroupResolventInfo.getName());
        } else if (ob instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)ob;
            receiverInfo.setType("3");
            receiverInfo.setValue(userInfo.getId().toString());
            receiverInfo.setDesc(userInfo.getName());
        } else if (ob instanceof String) {
            String tempstr = ob.toString();
            Pattern p = Pattern.compile("^[0-9]*[1-9][0-9]*$");
            Matcher m = p.matcher(tempstr);
            boolean isNumber = m.matches();
            if (isNumber) {
                receiverInfo.setType("6");
                receiverInfo.setValue(ob.toString());
            } else {
                receiverInfo.setType("7");
                receiverInfo.setValue(ob.toString());
            }
        } else if (ob instanceof PersonInfo) {
            PersonInfo personInfo = (PersonInfo)ob;
            receiverInfo.setType("8");
            receiverInfo.setDesc(personInfo.getName().toString());
            receiverInfo.setValue(personInfo.getId().toString());
        } else if (ob instanceof PersonItem) {
            PersonItem personItem = (PersonItem)ob;
            receiverInfo.setType("8");
            receiverInfo.setValue(personItem.getId().toString());
            if (SysContext.getSysContext().getLocale().toString().toLowerCase().equals("l2")) {
                receiverInfo.setDesc(personItem.getName_l2());
            } else {
                receiverInfo.setDesc(personItem.getName_l3());
            }
        } else if (ob instanceof OrgStructureInfo) {
            OrgStructureInfo orgStructureInfo = (OrgStructureInfo)ob;
            receiverInfo.setType("0");
            receiverInfo.setValue(orgStructureInfo.getUnit().getId().toString());
            receiverInfo.setDesc(orgStructureInfo.getUnit().getName());
        } else if (ob instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)ob;
            receiverInfo.setType("0");
            receiverInfo.setValue(fullOrgUnitInfo.getId().toString());
            receiverInfo.setDesc(fullOrgUnitInfo.getName());
        }
        receiverInfo.setIsShow(true);
        return receiverInfo;
    }

    private boolean putReceiverMap(String key, Object ob, HashMap inputReceiverMap) {
        boolean isRe = false;
        if (!inputReceiverMap.containsKey(key)) {
            isRe = true;
            inputReceiverMap.put(key, ob);
        }
        return isRe;
    }

    public FilterInfo searchFilter(String field, KDCheckBox cb) {
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (cb.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + field + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + field + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + field + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + field + "%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1 or #2 or #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)field, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)field, CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
        }
        return filter;
    }

    public boolean initSB(StringBuffer sbReceivers, Object ob, HashMap inputReceiverMap) {
        String key = "";
        boolean isRe = false;
        if (ob instanceof UserInfo) {
            UserInfo userInfo = (UserInfo)ob;
            key = LEFT_BRACKET + userInfo.getName() + MID_BRACKET + userInfo.getNumber() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(userInfo.getName()).append(MID_BRACKET).append(userInfo.getNumber()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        } else if (ob instanceof OrgStructureInfo) {
            OrgStructureInfo orgStructureInfo = (OrgStructureInfo)ob;
            key = LEFT_BRACKET + orgStructureInfo.getUnit().getName() + MID_BRACKET + orgStructureInfo.getUnit().getNumber() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(orgStructureInfo.getUnit().getName()).append(MID_BRACKET).append(orgStructureInfo.getUnit().getNumber()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        } else if (ob instanceof MAGroupResolventInfo) {
            MAGroupResolventInfo resolventinfo = (MAGroupResolventInfo)ob;
            key = LEFT_BRACKET + resolventinfo.getName() + MID_BRACKET + resolventinfo.getNumber() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(resolventinfo.getName()).append(MID_BRACKET).append(resolventinfo.getNumber()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        } else if (ob instanceof OrgUserInfo) {
            OrgUserInfo tmpInfo = (OrgUserInfo)ob;
            key = LEFT_BRACKET + tmpInfo.getOrgUserName() + MID_BRACKET + tmpInfo.getNumber() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(tmpInfo.getOrgUserName()).append(MID_BRACKET).append(tmpInfo.getNumber()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        } else if (ob instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)ob;
            key = LEFT_BRACKET + fullOrgUnitInfo.getName() + MID_BRACKET + fullOrgUnitInfo.getNumber() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(fullOrgUnitInfo.getName()).append(MID_BRACKET).append(fullOrgUnitInfo.getNumber()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        } else if (ob instanceof PersonInfo) {
            PersonInfo personInfo = (PersonInfo)ob;
            key = LEFT_BRACKET + personInfo.getName() + MID_BRACKET + personInfo.getNumber() + MID_BRACKET + personInfo.getCell() + RIGHT_BRACKET;
            isRe = this.putReceiverMap(key, ob, inputReceiverMap);
            if (isRe) {
                sbReceivers.append(LEFT_BRACKET).append(personInfo.getName()).append(MID_BRACKET).append(personInfo.getNumber()).append(MID_BRACKET).append(personInfo.getCell()).append(RIGHT_BRACKET).append(COMPAT_BRACKET);
            }
        }
        return isRe;
    }

    private void initReceiverInfo(Object ob, StringBuffer sb, BasReceiverCollection receivers, HashMap inputReceiverMap) {
        if (MessageUtils.init().initSB(sb, ob, inputReceiverMap)) {
            MessageUtils.init().setReceiverInfo(receivers, ob);
        }
    }

    public void putReceiver(List list, StringBuffer sb, BasReceiverCollection receivers, HashMap inputReceiverMap) {
        HashMap map2 = null;
        for (HashMap map2 : list) {
            this.putReceiverPerson(map2.get("person"), sb, receivers, inputReceiverMap);
            this.putReceiverOrg(map2.get("org"), sb, receivers, inputReceiverMap);
        }
    }

    private void putReceiverUser(Object ob, StringBuffer sb, BasReceiverCollection receivers, HashMap inputReceiverMap) {
        if (ob != null && ob instanceof UserCollection) {
            UserCollection ucol = (UserCollection)ob;
            for (int i = 0; i < ucol.size(); ++i) {
                this.initReceiverInfo(ucol.get(i), sb, receivers, inputReceiverMap);
            }
        }
    }

    private void putReceiverPerson(Object ob, StringBuffer sb, BasReceiverCollection receivers, HashMap inputReceiverMap) {
        if (ob != null && ob instanceof PersonCollection) {
            PersonCollection ucol = (PersonCollection)ob;
            for (int i = 0; i < ucol.size(); ++i) {
                this.initReceiverInfo(ucol.get(i), sb, receivers, inputReceiverMap);
            }
        }
    }

    private void putReceiverOrg(Object ob, StringBuffer sb, BasReceiverCollection receivers, HashMap inputReceiverMap) {
        if (ob != null && ob instanceof FullOrgUnitCollection) {
            FullOrgUnitCollection ucol = (FullOrgUnitCollection)ob;
            for (int i = 0; i < ucol.size(); ++i) {
                this.initReceiverInfo(ucol.get(i), sb, receivers, inputReceiverMap);
            }
        }
    }

    public HashMap initInputText(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(this.replaceString(str), COMPAT_BRACKET.trim());
        String temp = "";
        String temp1 = "";
        StringTokenizer st1 = null;
        while (st.hasMoreElements()) {
            temp = st.nextElement().toString();
            if (temp.indexOf(LEFT_BRACKET) == -1) continue;
            st1 = new StringTokenizer(temp, LEFT_BRACKET);
            while (st1.hasMoreElements()) {
                temp1 = st1.nextElement().toString();
                if (temp1.lastIndexOf(RIGHT_BRACKET) != temp1.length() - 1) continue;
                map.put(LEFT_BRACKET + temp1, "");
            }
        }
        return map;
    }

    public String replaceString(String str) {
        return str.trim().replace('\uff1b', ';');
    }

    public HashMap compareHashMap(HashMap oldMap, HashMap nowMap) {
        Map.Entry entry2 = null;
        HashMap reMap = (HashMap)oldMap.clone();
        for (Map.Entry entry2 : nowMap.entrySet()) {
            if (!reMap.containsKey(entry2.getKey())) continue;
            reMap.remove(entry2.getKey());
        }
        return reMap;
    }

    public String deleteString(HashMap map) {
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            entry = it.next();
            sb.append(entry.getKey()).append(COMPAT_BRACKET);
        }
        return sb.toString().trim();
    }

    private void delMap2initMap(BasReleaseInfo receiverInfo, HashMap oldMap, HashMap newMap, Object ob, boolean isDel) {
        Iterator it1 = null;
        String id = "";
        OrgUserInfo oui = null;
        OrgStructureInfo osi = null;
        BasReceiverInfo rInfo2 = null;
        if (ob instanceof OrgUserInfo) {
            oui = (OrgUserInfo)ob;
            id = oui.getOrgUserID();
        } else if (ob instanceof OrgStructureInfo) {
            osi = (OrgStructureInfo)ob;
            id = osi.getUnit().getId().toString();
        }
        if (oldMap.get(id) != null) {
            List list = (List)oldMap.get(id);
            newMap.put(id, oldMap.get(id));
            for (BasReceiverInfo rInfo2 : list) {
                if (!(ob instanceof OrgStructureInfo) && !(ob instanceof OrgUserInfo)) continue;
                if (isDel) {
                    receiverInfo.getReceiver().remove(rInfo2);
                    continue;
                }
                receiverInfo.getReceiver().add(rInfo2);
            }
            oldMap.remove(id);
        }
    }

    public String batchReceiversInfo(BasReleaseInfo receiverInfo, HashMap map, HashMap inputReceiverMap, HashMap inputMuReceiverMap, HashMap deleteMuMap, boolean isDel) {
        Map.Entry entry = null;
        StringBuffer sb = new StringBuffer();
        Iterator it = ((HashMap)map.clone()).entrySet().iterator();
        String key = "";
        Object ob = null;
        while (it.hasNext()) {
            entry = it.next();
            key = entry.getKey().toString().trim();
            sb.append(key).append(COMPAT_BRACKET);
            if (isDel) {
                ob = inputReceiverMap.get(key);
                receiverInfo.getReceiver().remove(this.getRptReceiverInfo(inputReceiverMap.get(key)));
                map.put(key, inputReceiverMap.get(key));
                inputReceiverMap.remove(key);
                this.delMap2initMap(receiverInfo, inputMuReceiverMap, deleteMuMap, ob, isDel);
                continue;
            }
            ob = map.get(key);
            receiverInfo.getReceiver().add(this.getRptReceiverInfo(map.get(key)));
            inputReceiverMap.put(key, map.get(key));
            map.remove(key);
            this.delMap2initMap(receiverInfo, deleteMuMap, inputMuReceiverMap, ob, isDel);
        }
        return sb.toString().trim();
    }

    public void addReceiversInfo(BasReleaseInfo receiverInfo, Object ob) {
        receiverInfo.getReceiver().add(this.getRptReceiverInfo(ob));
    }

    public void delReceiversInfo(BasReleaseInfo receiverInfo, Object ob) {
        receiverInfo.getReceiver().remove(this.getRptReceiverInfo(ob));
    }

    public DefaultKingdeeTreeNode searchNode(DefaultKingdeeTreeNode node, FullOrgUnitInfo foui) {
        if (node == null) {
            return null;
        }
        if (this.checkNode(node, foui)) {
            return node;
        }
        int childCount = node.getChildCount();
        DefaultKingdeeTreeNode tmpNode = null;
        for (int i = 0; i < childCount; ++i) {
            tmpNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (!tmpNode.isLeaf()) {
                this.searchNode(tmpNode, foui);
                continue;
            }
            if (!this.checkNode(tmpNode, foui)) continue;
            return tmpNode;
        }
        return null;
    }

    private boolean checkNode(DefaultKingdeeTreeNode node, FullOrgUnitInfo foui) {
        if (node.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
            return osi.getUnit().getId().toString().equals(foui.getId().toString());
        }
        return false;
    }

    public void initNodeMap(HashMap map, DefaultKingdeeTreeNode root) {
        this.putNodeMap(map, root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.initNodeMap(map, (DefaultKingdeeTreeNode)root.getChildAt(i));
        }
    }

    private void putNodeMap(HashMap map, DefaultKingdeeTreeNode root) {
        Object ob;
        if (map == null) {
            map = new HashMap<String, DefaultKingdeeTreeNode>();
        }
        if ((ob = root.getUserObject()) instanceof OrgStructureInfo) {
            OrgStructureInfo si = (OrgStructureInfo)root.getUserObject();
            map.put(si.getUnit().getId().toString(), root);
        }
    }

    public DefaultKingdeeTreeNode getChildOfSltedRecRoot(KDTree tree, int index) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        return (DefaultKingdeeTreeNode)node.getChildAt(index);
    }

    public void setMapReceiverInfo(Object ob, HashMap map, List list, BasReceiverCollection receivers, DefaultKingdeeTreeNode dkt) {
        String id = "";
        if (ob instanceof OrgStructureInfo) {
            id = ((OrgStructureInfo)ob).getUnit().getId().toString();
        } else if (ob instanceof OrgUserInfo) {
            id = ((OrgUserInfo)ob).getOrgUserID();
        }
        if (!map.containsKey(id)) {
            map.put(id, dkt);
            BasReceiverInfo rptReceiverInfo = MessageUtils.init().getRptReceiverInfo(ob);
            MessageUtils.init().setReceiverInfo(receivers, rptReceiverInfo);
            list.add(rptReceiverInfo);
        }
    }

    public String getKey(boolean isAllTree, boolean isHaveUser) {
        String str = "";
        if (isAllTree && isHaveUser) {
            str = "1";
        } else if (!isAllTree && !isHaveUser) {
            str = "2";
        } else if (isAllTree && !isHaveUser) {
            str = "3";
        } else if (!isAllTree && isHaveUser) {
            str = "4";
        }
        return str;
    }

    public BasReleaseInfo createRptReleaseInfo(Context ctx, ReceiverItem receiverItem, BasReleaseInfo releaseInfo) throws BOSException {
        Map.Entry entry;
        Iterator it;
        if (receiverItem.getInputMap() != null) {
            releaseInfo.getReceiver().addCollection(this.createBasReceiverCollection(receiverItem.getInputMap()));
        }
        if (receiverItem.getInputChilderOrg() != null) {
            it = receiverItem.getInputChilderOrg().entrySet().iterator();
            entry = null;
            Object ob = null;
            BasReceiverCollection rrcol = new BasReceiverCollection();
            while (it.hasNext()) {
                entry = it.next();
                ob = entry.getValue();
                if (ob == null) continue;
                Iterator it1 = ((List)ob).iterator();
                while (it1.hasNext()) {
                    MessageUtils.init().setReceiverInfo(rrcol, it1.next());
                }
            }
            releaseInfo.getReceiver().addCollection(rrcol);
        }
        if (receiverItem.getSelectedGroup() != null) {
            it = receiverItem.getSelectedGroup().entrySet().iterator();
            entry = null;
            BasReceiverCollection rrcol = new BasReceiverCollection();
            IMAGroupOrgFacade ima = null;
            ima = ctx == null ? MAGroupOrgFacadeFactory.getRemoteInstance() : MAGroupOrgFacadeFactory.getLocalInstance((Context)ctx);
            while (it.hasNext()) {
                entry = it.next();
                UserCollection coluser = ima.getMAGroupResolventToUser((String)entry.getKey());
                if (coluser.size() == 0) continue;
                for (int j = 0; j < coluser.size(); ++j) {
                    MessageUtils.init().setReceiverInfo(rrcol, coluser.get(j));
                }
            }
            releaseInfo.getReceiver().addCollection(rrcol);
        }
        return releaseInfo;
    }

    public BasReceiverCollection OrgNodeMap2BasReceiverCollection(HashMap map) {
        BasReceiverCollection receivers = new BasReceiverCollection();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        DefaultKingdeeTreeNode dn2 = null;
        while (it.hasNext()) {
            entry = it.next();
            if (entry.getValue() == null) continue;
            for (DefaultKingdeeTreeNode dn2 : (List)entry.getValue()) {
                MessageUtils.init().setReceiverInfo(receivers, dn2.getUserObject());
            }
        }
        return receivers;
    }

    public BasReceiverCollection createBasReceiverCollection(HashMap map) {
        BasReceiverCollection receivers = new BasReceiverCollection();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            MessageUtils.init().setReceiverInfo(receivers, entry2.getValue());
        }
        return receivers;
    }
}

