/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget_bi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget_bi.app.AbstractBgBiCommFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgBiCommFacadeControllerBean
extends AbstractBgBiCommFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget_bi.app.BgBiCommFacadeControllerBean");

    protected void _getAll(Context ctx) throws BOSException, EASBizException {
        this._getBgElement(ctx);
        this._getBgPeriod(ctx);
        this._getCostCenter(ctx);
        this._getBgScheme(ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _getBgElement(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        Statement pstmtCanCreat = null;
        Statement pstmtCreat = null;
        PreparedStatement pstmtIns = null;
        PreparedStatement pstmtDel = null;
        ResultSet rst = null;
        try {
            String delSql = "delete from DW_Dim_BgElement;";
            String insertSql = "insert into DW_Dim_BgElement (Fid, Fname_L1, Fname_L2, Fname_L3, FNumber) select t.fid, t.fname_l1, t.fname_l2, t.fname_l3, t.Fnumber from T_BG_BgElement t ;";
            conn = this.getConnection(ctx);
            pstmtDel = conn.prepareStatement(delSql);
            pstmtDel.executeUpdate();
            pstmtIns = conn.prepareStatement(insertSql);
            pstmtIns.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmtCreat, conn);
                SQLUtils.cleanup(pstmtIns);
                SQLUtils.cleanup(pstmtDel);
                SQLUtils.cleanup(pstmtCanCreat);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, pstmtCreat, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmtIns);
        SQLUtils.cleanup((Statement)pstmtDel);
        SQLUtils.cleanup(pstmtCanCreat);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _getBgPeriod(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmtIns = null;
        PreparedStatement pstmtDel = null;
        PreparedStatement pstmtSel = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet rst = null;
        HashMap<String, String> periodNum = new HashMap<String, String>();
        HashSet<String> befPerN = new HashSet<String>();
        HashMap<String, String> perLonNum = new HashMap<String, String>();
        try {
            String delSql = "delete from DW_Dim_BgPeriod;";
            String insertSql = "insert into DW_Dim_BgPeriod (Fid ,FParentID , Fname_L1, Fname_L2, Fname_L3, FNumber, FLastYearNumber) select t.fid, t.FParentID, t.fname_l1, t.fname_l2, t.fname_l3, t.fnumber, null from T_BG_Bgperiod t ;";
            conn = this.getConnection(ctx);
            rst = null;
            pstmtDel = conn.prepareStatement(delSql);
            pstmtDel.executeUpdate();
            pstmtIns = conn.prepareStatement(insertSql);
            pstmtIns.executeUpdate();
            String selSql = "select fid, fnumber from DW_Dim_BgPeriod where fid not in (select fid from t_bg_bgperiod where FPeriodType = 8);";
            String selSql2 = "select fnumber, flongNumber from t_bg_bgPeriod where fnumber in ";
            String selSql3 = "";
            pstmtSel = conn.prepareStatement(selSql);
            rst = pstmtSel.executeQuery();
            while (rst.next()) {
                periodNum.put(rst.getString(1), rst.getString(2));
            }
            SQLUtils.cleanup((Statement)pstmtSel);
            String number = null;
            String befNum = null;
            Map.Entry entry = null;
            int i = 0;
            int n = 0;
            Iterator ite = periodNum.entrySet().iterator();
            while (ite.hasNext()) {
                entry = ite.next();
                befNum = null;
                number = (String)entry.getValue();
                befNum = BgNPeriodHelper.getOffsetBgPeriodNumberForYear((String)number, (int)-1);
                ++n;
                if (befNum != null) {
                    befPerN.add(befNum);
                    if (++i == 100 || n == periodNum.size()) {
                        i = 0;
                        selSql3 = selSql2 + BgHelper.tranSet2String(befPerN);
                        pstmtSel = conn.prepareStatement(selSql3);
                        rst = pstmtSel.executeQuery();
                        while (rst.next()) {
                            perLonNum.put(rst.getString(1), rst.getString(2));
                        }
                        befPerN.clear();
                        SQLUtils.cleanup((Statement)pstmtSel);
                    }
                }
                if (befNum != null) {
                    entry.setValue(befNum);
                    continue;
                }
                ite.remove();
            }
            String lonNum = null;
            Iterator ite2 = periodNum.entrySet().iterator();
            while (ite2.hasNext()) {
                entry = ite2.next();
                befNum = null;
                number = (String)entry.getValue();
                if (perLonNum.containsKey(number)) {
                    lonNum = (String)perLonNum.get(number);
                    lonNum = this.getLongBefNum(lonNum);
                    entry.setValue(lonNum);
                    continue;
                }
                ite2.remove();
            }
            String updateSql = "update DW_Dim_BgPeriod set FLastYearNumber = ? where FID = ? ";
            String id2222222 = null;
            pstmtUpdate = conn.prepareStatement(updateSql);
            for (String id2222222 : periodNum.keySet()) {
                pstmtUpdate.setString(1, (String)periodNum.get(id2222222));
                pstmtUpdate.setString(2, id2222222);
                pstmtUpdate.addBatch();
            }
            pstmtUpdate.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(pstmtIns);
                SQLUtils.cleanup(pstmtDel);
                SQLUtils.cleanup(pstmtSel);
                SQLUtils.cleanup(pstmtUpdate);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)pstmtIns);
        SQLUtils.cleanup((Statement)pstmtDel);
        SQLUtils.cleanup((Statement)pstmtSel);
        SQLUtils.cleanup((Statement)pstmtUpdate);
        SQLUtils.cleanup((Connection)conn);
    }

    private String getLongBefNum(String befLonNum) {
        String num = befLonNum;
        num = num.replaceAll("!", "].[");
        return num;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _getCostCenter(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        Statement pstmtCanCreat = null;
        Statement pstmtCreat = null;
        PreparedStatement pstmtIns = null;
        PreparedStatement pstmtDel = null;
        ResultSet rst = null;
        try {
            String delSql = "delete from DW_Dim_Org_CostCenter;";
            String insertSql = "insert into DW_Dim_Org_CostCenter (Fid, Fname_L1, Fname_L2, Fname_L3, Fnumber, FparentID) select t.fid, t.fname_l1, t.fname_l2, t.fname_l3, t.fNumber, t.fparentid from t_org_costcenter t ;";
            conn = this.getConnection(ctx);
            pstmtDel = conn.prepareStatement(delSql);
            pstmtDel.executeUpdate();
            pstmtIns = conn.prepareStatement(insertSql);
            pstmtIns.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmtCreat, conn);
                SQLUtils.cleanup(pstmtIns);
                SQLUtils.cleanup(pstmtDel);
                SQLUtils.cleanup(pstmtCanCreat);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, pstmtCreat, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmtIns);
        SQLUtils.cleanup((Statement)pstmtDel);
        SQLUtils.cleanup(pstmtCanCreat);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _getBgScheme(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        Statement pstmtCanCreat = null;
        Statement pstmtCreat = null;
        PreparedStatement pstmtIns = null;
        PreparedStatement pstmtDel = null;
        ResultSet rst = null;
        try {
            String delSql = "delete from DW_Dim_BgScheme;";
            String insertSql = "insert into DW_Dim_BgScheme (Fid, Fname_L1, Fname_L2, Fname_L3, Fnumber) select t.frootid, t.fname_l1, t.fname_l2, t.fname_l3, t.Fnumber from t_bg_bgscheme t where t.fid = t.frootid ;";
            conn = this.getConnection(ctx);
            pstmtDel = conn.prepareStatement(delSql);
            pstmtDel.executeUpdate();
            pstmtIns = conn.prepareStatement(insertSql);
            pstmtIns.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmtCreat, conn);
                SQLUtils.cleanup(pstmtIns);
                SQLUtils.cleanup(pstmtDel);
                SQLUtils.cleanup(pstmtCanCreat);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, pstmtCreat, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmtIns);
        SQLUtils.cleanup((Statement)pstmtDel);
        SQLUtils.cleanup(pstmtCanCreat);
    }
}

