/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ap.BillTemplateCollection;
import com.kingdee.eas.cp.ap.BillTemplateInfo;
import com.kingdee.eas.cp.ap.BillTemplatePersonInfo;
import com.kingdee.eas.cp.ap.BillTemplateShareCUInfo;
import com.kingdee.eas.cp.ap.BillTypeCollection;
import com.kingdee.eas.cp.ap.BillTypeFactory;
import com.kingdee.eas.cp.ap.BillTypeInfo;
import com.kingdee.eas.cp.ap.ShareStatu;
import com.kingdee.eas.cp.ap.TypeStatus;
import com.kingdee.eas.cp.ap.app.AbstractBillTemplateControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BillTemplateControllerBean
extends AbstractBillTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.ap.app.BillTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.saveFile(ctx, model, pk);
        return pk;
    }

    private void saveFile(Context ctx, IObjectValue model, IObjectPK pk) {
        String sql = "select FEntity from T_CP_DocExchange where fid = ? ";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        try {
            obj[0] = model.getString("fileName");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            if (rows.next()) {
                blob = rows.getBlob(1);
                in = blob.getBinaryStream();
            }
            sql = "update T_CP_BillTemplate SET FDocEntity = ? WHERE FID = ?";
            PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
            logger.info((Object)("Remove DocEntity Size is:" + in.available()));
            ps.setBinaryStream(1, in, in.available());
            ps.setString(2, pk.toString());
            ps.execute();
            in.close();
            sql = "delete T_CP_DocExchange where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _invocation(Context ctx, IObjectPK billID) throws BOSException {
        try {
            BillTemplateInfo tempModel = this.getBillTemplateInfo(ctx, billID);
            if (tempModel != null) {
                tempModel.setStatus(TypeStatus.enable);
                super._save(ctx, (IObjectValue)tempModel);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _forbidden(Context ctx, IObjectPK billID) throws BOSException {
        try {
            BillTemplateInfo tempModel = this.getBillTemplateInfo(ctx, billID);
            if (tempModel != null) {
                tempModel.setStatus(TypeStatus.disable);
                super._save(ctx, (IObjectValue)tempModel);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _savePermission(Context ctx, IObjectValue info) throws BOSException {
        try {
            if (info != null) {
                BillTemplateInfo tempModel = (BillTemplateInfo)info;
                tempModel.remove("docEntity");
                super._save(ctx, (IObjectValue)tempModel);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _dispenseTemplate(Context ctx, IObjectCollection CUSet, BOSUuid billTemplateId) throws BOSException {
        if (CUSet != null && CUSet.size() > 0 && billTemplateId != null) {
            try {
                String sql = "";
                sql = "select *, billType.* where id ='" + billTemplateId.toString() + "'";
                BillTemplateInfo sourceInfo = this.getBillTemplateInfo(ctx, sql);
                BillTemplateInfo tempInfo = null;
                CtrlUnitCollection cuCol = (CtrlUnitCollection)CUSet;
                ArrayList<String> IDList = new ArrayList<String>();
                for (int i = 0; i < cuCol.size(); ++i) {
                    CtrlUnitInfo cuInfo = cuCol.get(i);
                    tempInfo = (BillTemplateInfo)ObjectUtils.createCopy((Object)sourceInfo);
                    tempInfo.setId(null);
                    tempInfo.setCU(cuInfo);
                    tempInfo.setShareStatus(ShareStatu.beDispense);
                    tempInfo.setStatus(TypeStatus.beUse);
                    tempInfo.setBillType(this.getBillTypeInfo(ctx, sourceInfo.getBillType().getName(), cuInfo));
                    BillTemplatePersonInfo billTemplatePersonInfo = new BillTemplatePersonInfo();
                    PersonInfo perInfo = new PersonInfo();
                    perInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                    billTemplatePersonInfo.setPerson(perInfo);
                    billTemplatePersonInfo.setPermList("1");
                    tempInfo.getPerson().clear();
                    tempInfo.getPerson().add(billTemplatePersonInfo);
                    tempInfo.setShareParent(sourceInfo.getId().toString());
                    tempInfo.getRole().clear();
                    tempInfo.getAdmin().clear();
                    tempInfo.getShareCU().clear();
                    tempInfo.setNumber(null);
                    String orgId = cuInfo.getId().toString();
                    try {
                        RuleStatus ruleStatus;
                        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        if (iCodingRuleManager.isExist((IObjectValue)tempInfo, orgId) && (ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)tempInfo, orgId)) != null) {
                            tempInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)tempInfo, orgId));
                        }
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    IObjectPK newId = this.addnew(ctx, (CoreBaseInfo)tempInfo);
                    IDList.add(newId.toString());
                }
                sql = "select FDocEntity from T_CP_BillTemplate WHERE FID='" + sourceInfo.getString("id") + "'";
                Blob blob = null;
                InputStream in = null;
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rows.next()) {
                    blob = rows.getBlob(1);
                    in = blob.getBinaryStream();
                }
                String sqlTemp = "";
                for (int i = 0; i < IDList.size(); ++i) {
                    sqlTemp = i == 0 ? "'" + IDList.get(i) + "'" : sqlTemp + ",'" + IDList.get(i) + "'";
                }
                sql = "update T_CP_BillTemplate SET FDocEntity = ? WHERE FShareParent = ? AND Fid in ( " + sqlTemp + " )";
                PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
                ps.setBinaryStream(1, in, in.available());
                ps.setString(2, sourceInfo.getString("id"));
                ps.execute();
                in.close();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BillTypeInfo getBillTypeInfo(Context ctx, String billTypeName, CtrlUnitInfo cu) {
        BillTypeInfo info = new BillTypeInfo();
        try {
            BillTypeCollection btc = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection("select * where name ='" + billTypeName + "' and cu.id = '" + cu.getId().toString() + "'");
            if (btc.size() > 0) {
                info = btc.get(0);
            } else {
                info.setName(billTypeName);
                info.setCU(cu);
                info.setStatus(TypeStatus.disable);
                BillTypeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return info;
    }

    @Override
    protected void _shareTemplate(Context ctx, IObjectCollection CUSet, BOSUuid billTemplateID) throws BOSException {
        if (CUSet != null && CUSet.size() >= 0 && billTemplateID != null) {
            try {
                String sql = "";
                BillTemplateInfo sourceInfo = this.getBillTemplateInfo(ctx, "select *, billType.* where id ='" + billTemplateID.toString() + "'");
                BillTemplateCollection btCol = this.getBillTemplateCollection(ctx, "select *, billType.* where shareParent ='" + billTemplateID.toString() + "' and shareStatus = '" + "2" + "'");
                BillTemplateInfo tempInfo = null;
                BillTemplateInfo beUpdateTemplateInfo = null;
                CtrlUnitCollection cuCol = (CtrlUnitCollection)CUSet;
                sourceInfo.getShareCU().clear();
                boolean isUpdateTemplate = false;
                if (cuCol.size() > 0) {
                    for (int i = 0; i < cuCol.size(); ++i) {
                        isUpdateTemplate = false;
                        CtrlUnitInfo cuInfo = cuCol.get(i);
                        for (int j = 0; j < btCol.size(); ++j) {
                            if (!cuInfo.getId().toString().equals(btCol.get(j).getCU().getId().toString())) continue;
                            isUpdateTemplate = true;
                            beUpdateTemplateInfo = btCol.get(j);
                        }
                        tempInfo = (BillTemplateInfo)ObjectUtils.createCopy((Object)sourceInfo);
                        if (isUpdateTemplate) {
                            tempInfo.setId(beUpdateTemplateInfo.getId());
                            tempInfo.getPerson().clear();
                            tempInfo.getPerson().addCollection(beUpdateTemplateInfo.getPerson());
                            tempInfo.getAdmin().clear();
                            tempInfo.getAdmin().addCollection(beUpdateTemplateInfo.getAdmin());
                            tempInfo.getRole().clear();
                            tempInfo.getRole().addCollection(beUpdateTemplateInfo.getRole());
                            tempInfo.setCU(cuInfo);
                            if (beUpdateTemplateInfo.getStatus() != TypeStatus.disable) {
                                tempInfo.setStatus(TypeStatus.beUse);
                            }
                            tempInfo.setShareStatus(ShareStatu.beShare);
                            tempInfo.setBillType(beUpdateTemplateInfo.getBillType());
                            tempInfo.setShareParent(sourceInfo.getId().toString());
                            super._save(ctx, (IObjectValue)tempInfo);
                        } else {
                            tempInfo.setId(null);
                            tempInfo.setCU(cuInfo);
                            tempInfo.setShareStatus(ShareStatu.beShare);
                            tempInfo.setStatus(TypeStatus.beUse);
                            tempInfo.setBillType(this.getBillTypeInfo(ctx, sourceInfo.getBillType().getName(), cuInfo));
                            tempInfo.setShareParent(sourceInfo.getId().toString());
                            BillTemplatePersonInfo billTemplatePersonInfo = new BillTemplatePersonInfo();
                            PersonInfo perInfo = new PersonInfo();
                            perInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                            billTemplatePersonInfo.setPerson(perInfo);
                            billTemplatePersonInfo.setPermList("1");
                            tempInfo.getPerson().clear();
                            tempInfo.getPerson().add(billTemplatePersonInfo);
                            this.addnew(ctx, (CoreBaseInfo)tempInfo);
                        }
                        BillTemplateShareCUInfo billTemplateShareCUInfo = new BillTemplateShareCUInfo();
                        billTemplateShareCUInfo.setCu(cuInfo);
                        sourceInfo.getShareCU().add(billTemplateShareCUInfo);
                    }
                } else {
                    sourceInfo.getShareCU().clear();
                }
                super._save(ctx, (IObjectValue)sourceInfo);
                boolean disableTemplate = false;
                BillTemplateInfo beDisableTemplateInfo = null;
                HashSet<String> CUIdSet = new HashSet<String>();
                for (int i = 0; i < cuCol.size(); ++i) {
                    CUIdSet.add(cuCol.get(i).getId().toString());
                }
                for (int j = 0; j < btCol.size(); ++j) {
                    disableTemplate = false;
                    if (!CUIdSet.contains(btCol.get(j).getCU().getId().toString())) {
                        disableTemplate = true;
                        beDisableTemplateInfo = btCol.get(j);
                    }
                    if (!disableTemplate) continue;
                    beDisableTemplateInfo.setStatus(TypeStatus.disable);
                    super._save(ctx, (IObjectValue)beDisableTemplateInfo);
                }
                sql = "select FDocEntity from T_CP_BillTemplate WHERE FID='" + sourceInfo.getString("id") + "'";
                Blob blob = null;
                InputStream in = null;
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rows.next()) {
                    blob = rows.getBlob(1);
                    in = blob.getBinaryStream();
                }
                sql = "update T_CP_BillTemplate SET FDocEntity = ? WHERE FShareParent = ?";
                PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
                ps.setBinaryStream(1, in, in.available());
                ps.setString(2, sourceInfo.getString("id"));
                ps.execute();
                in.close();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

