/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.arcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.arcm.DocDispatchFactory;
import com.kingdee.eas.cp.arcm.DocDispatchInfo;
import com.kingdee.eas.cp.arcm.DocReceiveFactory;
import com.kingdee.eas.cp.arcm.DocReceiveInfo;
import com.kingdee.eas.cp.arcm.DocTypeFactory;
import com.kingdee.eas.cp.arcm.DocTypeInfo;
import com.kingdee.eas.cp.arcm.IDocDispatch;
import com.kingdee.eas.cp.arcm.IDocReceive;
import com.kingdee.eas.cp.arcm.PigeonholeCollection;
import com.kingdee.eas.cp.arcm.PigeonholeFactory;
import com.kingdee.eas.cp.arcm.app.AbstractDocReceiveControllerBean;
import com.kingdee.eas.cp.arcm.app.ArcmAttachmentUtil;
import com.kingdee.eas.cp.arcm.utils.OACommonDataProvider;
import com.kingdee.eas.cp.base.PigeStatusEnum;
import com.kingdee.eas.cp.base.util.FileUtil;
import com.kingdee.eas.cp.dm.ContentTypeEnum;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentImpl;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentParamsInfo;
import com.kingdee.eas.cp.dm.archive.file.ExportFile;
import com.kingdee.eas.cp.dm.archive.util.ArchiveUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.print.MultiDataSourceProviderProxy;
import com.kingdee.eas.framework.print.MultiapprovePrintUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DocReceiveControllerBean
extends AbstractDocReceiveControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.arcm.app.DocReceiveControllerBean");
    private final String ARCM_RESOURCE = "com.kingdee.eas.cp.arcm.LocalString";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model.put("status", (Object)"1");
        IObjectPK pk = super._submit(ctx, model);
        this.saveFile(ctx, model, pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.saveFile(ctx, model, pk);
        return pk;
    }

    private void saveFile(Context ctx, IObjectValue model, IObjectPK pk) {
        String sql = "select FEntity from T_CP_DocExchange where fid = ? ";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        try {
            obj[0] = model.getString("fileName");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            sql = "update T_CP_DocReceive SET FDocEntity = ? WHERE FID = ?";
            PreparedStatement ps = this.getConnection(ctx).prepareStatement(sql);
            logger.info((Object)("Remove DocEntity Size is:" + in.available()));
            ps.setBinaryStream(1, in, in.available());
            ps.setString(2, pk.toString());
            ps.execute();
            in.close();
            sql = "delete T_CP_DocExchange where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _pigeonhole(Context ctx, IObjectValue model) throws BOSException {
        model.put("status", (Object)"2");
        model.remove("docEntity");
        try {
            super._save(ctx, model);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean _pigeonholeToDM(Context ctx, IObjectValue model) throws BOSException {
        DocReceiveInfo docReceiveInfo = (DocReceiveInfo)model;
        ArrayList<String> ids = new ArrayList<String>();
        String billId = model.get("id").toString();
        ids.add(billId);
        MultiDataSourceProviderProxy multiDataSourceProviderProxy = MultiapprovePrintUtility.getMultiQueryDelegate(ids, (Context)ctx);
        OACommonDataProvider data = new OACommonDataProvider(ctx, ids, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.arcm.app.DocReceiveQuery"));
        String docTypeId = docReceiveInfo.getDocType().getId().toString();
        String cuId = null;
        try {
            DocTypeInfo docTypeInfo = DocTypeFactory.getLocalInstance(ctx).getDocTypeInfo((IObjectPK)new ObjectUuidPK(docTypeId));
            cuId = docTypeInfo.getCU().getId().toString();
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        PigeonholeCollection pigeCol = PigeonholeFactory.getLocalInstance(ctx).getPigeonholeCollection("select isAllowRePige,printTemplate,pigePath,categoryPath.id,categoryPath.isArchive,textArchiving where (arcmDocTypeName.id='" + docTypeId + "' or (isOverallSeting=1  and arcmDocType=2)) and cu.id='" + cuId + "' order by isOverallSeting asc");
        if (pigeCol == null || pigeCol.size() < 1) {
            logger.warn((Object)"***********\u6ca1\u6709\u5f52\u6863\u8bbe\u7f6e**********");
            return false;
        }
        if (docReceiveInfo.getPigeStatus().getValue() == 1 && !pigeCol.get(0).isIsAllowRePige()) {
            logger.warn((Object)"******************\u8be5\u516c\u6587\u5df2\u5f52\u6863\uff0c\u4e14\u4e0d\u5141\u8bb8\u91cd\u590d\u5f52\u6863*************");
            return false;
        }
        String templatePath = pigeCol.get(0).getPrintTemplate().split(",")[0];
        String categoryId = pigeCol.get(0).getCategoryPath().getId().toString();
        String textArchiving = pigeCol.get(0).getTextArchiving() == null ? "0" : pigeCol.get(0).getTextArchiving().getValue();
        boolean archiveResult = true;
        archiveResult = "1".equals(textArchiving) ? this.archiveDocAsText(ctx, docReceiveInfo, categoryId, templatePath) : this.archiveDocAsAttachment(ctx, docReceiveInfo, categoryId, templatePath);
        boolean updateStatusResult = true;
        if (archiveResult) {
            updateStatusResult = this.updatePigeonholeStatus(docReceiveInfo, ctx);
        }
        return archiveResult && updateStatusResult;
    }

    private boolean updatePigeonholeStatus(DocReceiveInfo docReceiveInfo, Context ctx) {
        if (1 != docReceiveInfo.getPigeStatus().getValue()) {
            try {
                IDocReceive docDisService = DocReceiveFactory.getLocalInstance(ctx);
                docReceiveInfo.setPigeStatus(PigeStatusEnum.PIGEONHOLED);
                docDisService.save((CoreBaseInfo)docReceiveInfo);
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.error((Object)"update docReceiveInfo Error!");
                return false;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.error((Object)"update docReceiveInfo Error!");
                return false;
            }
        }
        return true;
    }

    private boolean archiveDocAsAttachment(Context ctx, DocReceiveInfo docReceiveInfo, String categoryId, String templatePath) {
        ArrayList<String> ids = new ArrayList<String>();
        String billId = docReceiveInfo.get("id").toString();
        ids.add(billId);
        MultiDataSourceProviderProxy multiDataSourceProviderProxy = MultiapprovePrintUtility.getMultiQueryDelegate(ids, (Context)ctx);
        OACommonDataProvider data = new OACommonDataProvider(ctx, ids, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.arcm.app.DocReceiveQuery"));
        multiDataSourceProviderProxy.put("MainQuery", (BOSQueryDelegate)data);
        if (docReceiveInfo.getPigeStatus().getValue() != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateStr = "(" + sdf.format(new Date()) + ")";
            docReceiveInfo.setName(docReceiveInfo.getName() + dateStr);
        }
        ArchiveDocumentParamsInfo paramsInfo = this.contructParams(docReceiveInfo, categoryId, ContentTypeEnum.PDF);
        try {
            ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
            ExportFile.exportPDF((Context)ctx, (String)templatePath, (MultiDataSourceProviderProxy)multiDataSourceProviderProxy, (OutputStream)bodyStream);
            ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(bodyStream.toByteArray());
            List tempList = ArchiveUtils.getAttach((Context)ctx, (String)paramsInfo.getBizID());
            InputStream[] newFileStreams = new ByteArrayInputStream[((InputStream[])tempList.get(0)).length + 1];
            String[] newFileNames = new String[((String[])tempList.get(1)).length + 1];
            if (tempList != null && tempList.size() >= 2) {
                String docReceiveId = docReceiveInfo.getId().toString();
                String docName = "";
                String sql = "select FName,FDocEntity from T_CP_DocReceive WHERE FID='" + docReceiveId + "'";
                Blob blob = null;
                InputStream docAsAttatch = null;
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rows.next()) {
                    docName = rows.getString(1);
                    blob = rows.getBlob(2);
                    if (null != blob) {
                        docAsAttatch = blob.getBinaryStream();
                    }
                }
                for (int i = 0; i < newFileStreams.length - 1; ++i) {
                    newFileStreams[i] = ((ByteArrayInputStream[])tempList.get(0))[i];
                    newFileNames[i] = ((String[])tempList.get(1))[i];
                }
                newFileStreams[i] = docAsAttatch;
                newFileNames[i] = ResourceBase.getString((String)"com.kingdee.eas.cp.arcm.LocalString", (String)"docBody", (Locale)new Locale("zh")) + "(" + docReceiveInfo.getName() + ").doc";
            }
            ArchiveDocumentImpl arch = new ArchiveDocumentImpl();
            arch.archiveDocument(ctx, paramsInfo, (InputStream)bodyInputStream, newFileStreams, newFileNames);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    private boolean archiveDocAsText(Context ctx, DocReceiveInfo docReceiveInfo, String categoryId, String templatePath) {
        ArrayList<String> ids = new ArrayList<String>();
        String billId = docReceiveInfo.get("id").toString();
        ids.add(billId);
        MultiDataSourceProviderProxy multiDataSourceProviderProxy = MultiapprovePrintUtility.getMultiQueryDelegate(ids, (Context)ctx);
        OACommonDataProvider data = new OACommonDataProvider(ctx, ids, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.arcm.app.DocReceiveQuery"));
        multiDataSourceProviderProxy.put("MainQuery", (BOSQueryDelegate)data);
        if (docReceiveInfo.getPigeStatus().getValue() != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateStr = "(" + sdf.format(new Date()) + ")";
            docReceiveInfo.setName(docReceiveInfo.getName() + dateStr);
        }
        ArchiveDocumentParamsInfo paramsInfo = this.contructParams(docReceiveInfo, categoryId, ContentTypeEnum.WORD);
        try {
            ByteArrayOutputStream exportPDFStream = new ByteArrayOutputStream();
            ExportFile.exportPDF((Context)ctx, (String)templatePath, (MultiDataSourceProviderProxy)multiDataSourceProviderProxy, (OutputStream)exportPDFStream);
            ByteArrayInputStream exportPDFInputStream = new ByteArrayInputStream(exportPDFStream.toByteArray());
            List tempList = ArchiveUtils.getAttach((Context)ctx, (String)paramsInfo.getBizID());
            InputStream[] newFileStreams = new ByteArrayInputStream[((InputStream[])tempList.get(0)).length + 1];
            String[] newFileNames = new String[((String[])tempList.get(1)).length + 1];
            if (tempList != null && tempList.size() >= 2) {
                for (int i = 0; i < newFileStreams.length - 1; ++i) {
                    newFileStreams[i] = ((ByteArrayInputStream[])tempList.get(0))[i];
                    newFileNames[i] = ((String[])tempList.get(1))[i];
                }
                newFileStreams[i] = exportPDFInputStream;
                newFileNames[i] = ResourceBase.getString((String)"com.kingdee.eas.cp.arcm.LocalString", (String)"docPrint", (Locale)new Locale("zh")) + "(" + docReceiveInfo.getName() + ").pdf";
            }
            String docReceiveId = docReceiveInfo.getId().toString();
            String docName = "";
            String sql = "select FName,FDocEntity from T_CP_DocReceive WHERE FID='" + docReceiveId + "'";
            Blob blob = null;
            InputStream docBody = null;
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rows.next()) {
                docName = rows.getString(1);
                blob = rows.getBlob(2);
                if (null != blob) {
                    docBody = blob.getBinaryStream();
                }
            }
            ArchiveDocumentImpl arch = new ArchiveDocumentImpl();
            arch.archiveDocument(ctx, paramsInfo, docBody, newFileStreams, newFileNames);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    private ArchiveDocumentParamsInfo contructParams(DocReceiveInfo model, String categoryId, ContentTypeEnum contentType) {
        if (model == null) {
            return null;
        }
        ArchiveDocumentParamsInfo params = new ArchiveDocumentParamsInfo();
        params.setBizID(model.getId().toString());
        params.setNumber(model.getNumber());
        params.setTitle(model.getName());
        params.setDescription(model.getDescription());
        params.setCreateTime(model.getCreateTime());
        params.setDocNumber(model.getCode());
        params.setMark("guidang");
        params.setModuleName("arcm");
        params.setVersion("test001");
        params.setArchive(true);
        params.setCategoryId(categoryId);
        params.setContentType(contentType);
        return params;
    }

    @Override
    protected void _auditNotPass(Context ctx, IObjectValue model) throws BOSException {
        model.put("status", (Object)"3");
        model.remove("docEntity");
        try {
            super._save(ctx, model);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setDraft(Context ctx, IObjectValue model) throws BOSException {
        model.put("status", (Object)"0");
        model.remove("docEntity");
        try {
            super._save(ctx, model);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _convertToDocDispatch(Context ctx, IObjectValue model) throws BOSException {
        Blob blob = null;
        InputStream in = null;
        DocDispatchInfo newInfo = new DocDispatchInfo();
        try {
            IDocDispatch docDispatch = DocDispatchFactory.getLocalInstance(ctx);
            DocReceiveInfo docReceiveModel = (DocReceiveInfo)model;
            newInfo.put("name", docReceiveModel.getName());
            newInfo.put("proposer", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            newInfo.put("status", "0");
            newInfo.put("fileName", FileUtil.createFileName((BOSObjectType)this.getBOSType()));
            newInfo.setSourceBillId(docReceiveModel.getId().toString());
            newInfo.setCanCopy(true);
            IObjectPK pk = docDispatch.addnew((CoreBaseInfo)newInfo);
            String sql = "select FDocEntity from T_CP_DocReceive WHERE FID='" + model.getString("id") + "'";
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            ArcmAttachmentUtil.delDuplicateAttachment(ctx, newInfo.getId().toString(), docReceiveModel.getId().toString());
            ArcmAttachmentUtil.processUpload(ctx, newInfo, docReceiveModel, in);
            ArcmAttachmentUtil.processAttachment(ctx, docReceiveModel, newInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.info((Object)"Input Stream close Execption");
                }
            }
        }
        return newInfo.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectValue _referenceToDocReceive(Context ctx, IObjectValue model, IObjectValue docDispatchModel) {
        Blob blob = null;
        InputStream in = null;
        DocDispatchInfo newInfo = docDispatchModel != null ? (DocDispatchInfo)docDispatchModel : new DocDispatchInfo();
        try {
            IDocDispatch docDispatch = DocDispatchFactory.getLocalInstance(ctx);
            DocReceiveInfo docReceiveModel = (DocReceiveInfo)model;
            newInfo.put("status", "0");
            newInfo.put("fileName", FileUtil.createFileName((BOSObjectType)this.getBOSType()));
            newInfo.setSourceBillId(docReceiveModel.getId().toString());
            newInfo.setCanCopy(true);
            if (docDispatchModel == null) {
                IObjectPK pk = docDispatch.addnew((CoreBaseInfo)newInfo);
            } else {
                docDispatch.update((IObjectPK)new ObjectUuidPK(newInfo.getId()), (CoreBaseInfo)newInfo);
            }
            String sql = "select FDocEntity from T_CP_DocReceive WHERE FID='" + model.getString("id") + "'";
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArcmAttachmentUtil.delDuplicateAttachment(ctx, newInfo.getId().toString(), docReceiveModel.getId().toString());
            if (rows.next() && (blob = rows.getBlob(1)) != null) {
                in = blob.getBinaryStream();
                ArcmAttachmentUtil.processUpload(ctx, newInfo, docReceiveModel, in);
            }
            ArcmAttachmentUtil.processAttachment(ctx, docReceiveModel, newInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            IObjectValue iObjectValue = null;
            return iObjectValue;
        }
        catch (SQLException e) {
            e.printStackTrace();
            IObjectValue iObjectValue = null;
            return iObjectValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            IObjectValue iObjectValue = null;
            return iObjectValue;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.info((Object)"Input Stream close Execption");
                }
            }
        }
        return newInfo;
    }
}

