/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.arcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.arcm.DocReceiveFactory;
import com.kingdee.eas.cp.arcm.DocReceiveInfo;
import com.kingdee.eas.cp.arcm.IDocReceive;
import com.kingdee.eas.cp.arcm.ISendDocument;
import com.kingdee.eas.cp.arcm.ReceiptCollection;
import com.kingdee.eas.cp.arcm.ReceiptEntryCollection;
import com.kingdee.eas.cp.arcm.ReceiptEntryInfo;
import com.kingdee.eas.cp.arcm.ReceiptFactory;
import com.kingdee.eas.cp.arcm.ReceiptInfo;
import com.kingdee.eas.cp.arcm.SendDocumentFactory;
import com.kingdee.eas.cp.arcm.SendDocumentInfo;
import com.kingdee.eas.cp.arcm.app.AbstractSendDocumentControllerBean;
import com.kingdee.eas.cp.arcm.app.ArcmAttachmentUtil;
import com.kingdee.eas.cp.base.util.FileUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import org.apache.log4j.Logger;

public class SendDocumentControllerBean
extends AbstractSendDocumentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.arcm.app.SendDocumentControllerBean");

    @Override
    protected String _convertToReceive(Context ctx, IObjectValue model, IObjectValue proposer) throws BOSException {
        IDocReceive docReceive = DocReceiveFactory.getLocalInstance(ctx);
        DocReceiveInfo newInfo = new DocReceiveInfo();
        try {
            SendDocumentInfo sendDocumentModel = (SendDocumentInfo)model;
            newInfo.put("name", sendDocumentModel.getName());
            newInfo.put("dispatchUnit", sendDocumentModel.getDispatchUnit());
            if (sendDocumentModel.getDispatchUnit() != null) {
                String oql = "select name where id = '" + sendDocumentModel.getDispatchUnit().getId().toString() + "'";
                String orgName = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(oql).get(0).getName();
                newInfo.setSendUnitName(orgName);
            }
            newInfo.put("receiveNumber", sendDocumentModel.getCode());
            newInfo.put("docSecrecy", sendDocumentModel.getDocSecrecy());
            newInfo.put("docUrgency", sendDocumentModel.getDocUrgency());
            newInfo.put("receiveTime", new Date());
            newInfo.put("proposer", proposer);
            newInfo.put("status", "0");
            newInfo.put("fileName", FileUtil.createFileName((BOSObjectType)this.getBOSType()));
            newInfo.setIsNewConvert(true);
            newInfo.setSourceBillId(sendDocumentModel.getId().toString());
            newInfo.setCanCopy(true);
            IObjectPK pk = docReceive.addnew((CoreBaseInfo)newInfo);
            String sql = "select FDocEntity from T_CP_SendDocument WHERE FID='" + model.getString("id") + "'";
            Blob blob = null;
            InputStream in = null;
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            ArcmAttachmentUtil.delDuplicateAttachment(ctx, newInfo.getId().toString(), sendDocumentModel.getId().toString());
            ArcmAttachmentUtil.processUpload(ctx, newInfo, sendDocumentModel, in);
            ArcmAttachmentUtil.processAttachment(ctx, sendDocumentModel, newInfo);
            return newInfo.getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return newInfo.getId().toString();
        }
    }

    @Override
    protected boolean _hadReceiveStatus(Context ctx, BOSUuid billID) throws BOSException {
        ISendDocument sendDocument = SendDocumentFactory.getLocalInstance(ctx);
        try {
            SendDocumentInfo sendDocumentModel = sendDocument.getSendDocumentInfo((IObjectPK)new ObjectUuidPK(billID));
            sendDocumentModel.put("status", "4");
            sendDocumentModel.remove("docEntity");
            super._save(ctx, (IObjectValue)sendDocumentModel);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    private void processUpload(Context ctx, DocReceiveInfo newInfo, InputStream in) throws EASBizException, BOSException, Exception {
        File file = new File(newInfo.getName() + "_" + newInfo.getReceiveNumber());
        SimpleAttachmentInfo sai = this.getSimpleFile(file, in);
        this.addNewAttachment(ctx, newInfo.getId().toString(), sai);
    }

    private void addNewAttachment(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        String oql;
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        AttachmentCollection coll = iAttachment.getAttachmentCollection(oql = "select id where name = '" + sai.getMainName() + "'");
        if (coll.size() == 0) {
            AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)iAttachment, (String)boID, (SimpleAttachmentInfo)sai);
            this.submitAttachment(attachmentInfo, iAttachment, ctx);
        } else {
            BoAttchAssoInfo baai = new BoAttchAssoInfo();
            baai.setBoID(boID);
            baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
            baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
            baai.setAttachment(coll.get(0));
            BoAttchAssoFactory.getLocalInstance((Context)ctx).addnew(baai);
        }
    }

    private String submitAttachment(AttachmentInfo attachmentInfo, IAttachment iAttachment, Context ctx) throws BOSException, EASBizException {
        IAttachmentFtpFacade iAttachmentFtpFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        if (fileInfo != null && fileInfo.length > AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH) {
            logger.info((Object)" begin mutl part file upload");
            attachmentInfo.setFile(null);
            attchID = iAttachment.addnew(attachmentInfo).toString();
            try {
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(iAttachmentFtpFacade);
                fileUpload.uploadFile(attchID, fileInfo);
            }
            catch (BOSException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        } else {
            logger.info((Object)" begin one part file upload");
            attchID = iAttachment.addnew(attachmentInfo).toString();
        }
        return attchID;
    }

    private SimpleAttachmentInfo getSimpleFile(File file, InputStream in) throws BOSException, EASBizException, Exception {
        try {
            String fullname = file.getName();
            String mainname = StringUtil4File.getMainFileName((String)fullname);
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            byte[] content = SendDocumentControllerBean.getBytes(in);
            SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
            sai.setMainName(mainname);
            sai.setExtName("doc");
            sai.setContent(content);
            sai.setIsShared(false);
            return sai;
        }
        catch (FileNotFoundException fe) {
            throw new AttachmentException(AttachmentException.READFILEERROR);
        }
    }

    private static byte[] getBytes(InputStream in) throws Exception {
        int n;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4000);
        byte[] b = new byte[4000];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    @Override
    protected boolean _sendReceiptInfo(Context ctx, BOSUuid billID, IObjectValue personInfo) throws BOSException {
        ISendDocument sendDocument = SendDocumentFactory.getLocalInstance(ctx);
        try {
            SendDocumentInfo sendDocumentModel = sendDocument.getSendDocumentInfo((IObjectPK)new ObjectUuidPK(billID));
            if (!sendDocumentModel.isSendReceipt() && sendDocumentModel.getStatus() != 4 && sendDocumentModel.getDispatchDocID() != null && !"".equals(sendDocumentModel.getDispatchDocID())) {
                StringBuffer sb = new StringBuffer();
                sb.append("select * , Entry.* , Entry.receiveUnit.id, Entry.receiveUnit.name, Entry.signer.id, Entry.signer.name where dispatchDocID='");
                sb.append(sendDocumentModel.getDispatchDocID());
                sb.append("'");
                ReceiptCollection rc = ReceiptFactory.getLocalInstance(ctx).getReceiptCollection(sb.toString());
                if (rc.size() > 0) {
                    ReceiptInfo receiptInfo = rc.get(0);
                    ReceiptEntryInfo rEntry = null;
                    ReceiptEntryCollection rec = receiptInfo.getEntry();
                    for (int i = 0; rec.size() > 0 && i < rec.size(); ++i) {
                        rEntry = rec.get(i);
                        if (sendDocumentModel.getReceiveUnit() != null && rEntry.getReceiveUnit() != null) {
                            if (!sendDocumentModel.getReceiveUnit().getId().toString().equals(rEntry.getReceiveUnit().getId().toString())) continue;
                            rEntry.setSignDate(new Date());
                            rEntry.setSigner((PersonInfo)personInfo);
                            rEntry.setIsSign(true);
                            i = rec.size();
                            continue;
                        }
                        if (sendDocumentModel.getReceivePerson() == null || rEntry.getSigner() == null || !sendDocumentModel.getReceivePerson().getId().toString().equals(rEntry.getSigner().getId().toString())) continue;
                        rEntry.setSignDate(new Date());
                        rEntry.setSigner((PersonInfo)personInfo);
                        rEntry.setIsSign(true);
                        i = rec.size();
                    }
                    ReceiptFactory.getLocalInstance(ctx).save((CoreBaseInfo)receiptInfo);
                }
                sendDocumentModel.setSendReceipt(true);
                sendDocumentModel.remove("docEntity");
                super._save(ctx, (IObjectValue)sendDocumentModel);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }
}

