/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.app.reverse.agent.AgentBillReverseHandler;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.framework.ICoreBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AgentBillReBack
implements IPaymentDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.AgentBillReBack");

    public void dispose(Context context, BillDisposerAction billDisposer) throws BOSException, EASBizException {
        int i;
        List<String> delSourceBillIdList;
        DisposerActionEnum actionType = billDisposer.getActionType();
        logger.error((Object)("***cpbc*** AgentBillReBack actionType=" + actionType));
        AgentPayBillInfo agentPayBillInfo = (AgentPayBillInfo)billDisposer.getDestBill();
        if (billDisposer == null || billDisposer.getDestBill() == null) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        String srcBillId = agentPayBillInfo.getSourceBillId();
        AgentPayBillEntryCollection payBillEntry = agentPayBillInfo.getEntrys();
        if (payBillEntry != null && payBillEntry.size() > 0) {
            for (int i2 = 0; i2 < payBillEntry.size() && StringUtils.isEmpty((String)(srcBillId = payBillEntry.get(i2).getSourceBillId())); ++i2) {
            }
        }
        if (StringUtils.isEmpty((String)srcBillId)) {
            if (DisposerActionEnum.SUBMIT.equals((Object)actionType) || DisposerActionEnum.PAY.equals((Object)actionType) || DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
                throw new BizCollException(BizCollException.AGENTBILLSOURCEBILLIDNOTNULL);
            }
            return;
        }
        logger.error((Object)("***cpbc*** AgentBillReBack srcBillId=" + srcBillId));
        boolean isPay = false;
        Boolean isCreatePrePaymentBill = BizCollUtil.isCreatePrePaymentBill(context);
        List reverseDelSrcBillIdList = null;
        BizCollBillBaseInfo billInfo = this.getBizCollBillBaseInfo(context, srcBillId);
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(context, BOSUuid.read((String)srcBillId));
        if (!(iCoreBase instanceof IBizCollBillBase)) {
            throw new CreateToException(CreateToException.SOURCEBILLIDERROR);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)iCoreBase;
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            isPay = true;
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "payment", true, isCreatePrePaymentBill);
        } else if (DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
            isPay = false;
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "payment", false, isCreatePrePaymentBill);
        } else if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "Submit", false, isCreatePrePaymentBill);
            delSourceBillIdList = this.getDelSrcBillIdList(billDisposer, agentPayBillInfo);
            if (delSourceBillIdList != null && delSourceBillIdList.size() > 0) {
                reverseDelSrcBillIdList = BizCollUtil.reversePayDeleteSourceBill(context, agentPayBillInfo.getString("id"), delSourceBillIdList);
            }
        } else if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "Save", false, isCreatePrePaymentBill);
            delSourceBillIdList = this.getDelSrcBillIdList(billDisposer, agentPayBillInfo);
            if (delSourceBillIdList != null && delSourceBillIdList.size() > 0) {
                reverseDelSrcBillIdList = BizCollUtil.reversePayDeleteSourceBill(context, agentPayBillInfo.getString("id"), delSourceBillIdList);
            }
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "Delete", false, isCreatePrePaymentBill);
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            isPay = false;
            AgentBillReverseHandler.paymentHandler(context, iBizCollBillBase, billInfo, agentPayBillInfo, "CounterAudit", isPay, isCreatePrePaymentBill);
        }
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        AgentPayBillEntryCollection entries = agentPayBillInfo.getEntrys();
        String sourceBillId = null;
        BizCollBillBaseInfo info = null;
        int size = entries.size();
        for (i = 0; i < size; ++i) {
            sourceBillId = entries.get(i).getSourceBillId();
            if (sourceBillId == null) continue;
            BizCollBillBaseInfo bizCollBillBaseInfo = info = sourceBillId.equals(billInfo.getId().toString()) ? billInfo : null;
            if (sourceBillIdSet.contains(sourceBillId)) continue;
            iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(sourceBillId), info);
            sourceBillIdSet.add(sourceBillId);
        }
        if (reverseDelSrcBillIdList != null && reverseDelSrcBillIdList.size() > 0) {
            size = reverseDelSrcBillIdList.size();
            for (i = 0; i < size; ++i) {
                iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK((String)reverseDelSrcBillIdList.get(i)), null);
            }
        }
        Long endTime = System.currentTimeMillis();
        logger.error((Object)("cpbc AgentBillReBack ngisc_reverse number=" + billInfo.getNumber() + ", agentBillNumber=" + agentPayBillInfo.getNumber() + ",actionType=" + actionType + ",time\uff1a" + (endTime - startTime) + "ms"));
    }

    private BizCollBillBaseInfo getBizCollBillBaseInfo(Context arg0, String billId) throws BOSException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = arg0 == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)arg0);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getSelector());
        return billInfo;
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public List<String> getDelSrcBillIdList(BillDisposerAction billDisposer, AgentPayBillInfo agentPayBillInfo) {
        ArrayList<String> delSrcBillIdList = null;
        try {
            billDisposer.getClass().getMethod("getDeleteEntry", new Class[0]);
            AbstractObjectCollection payBillDelEntry = billDisposer.getDeleteEntry();
            logger.info((Object)("##getDeleteEntry.size =" + (payBillDelEntry == null ? "0" : Integer.valueOf(payBillDelEntry.size()))));
            if (payBillDelEntry != null && payBillDelEntry.size() > 0) {
                HashSet<String> sourceBillIdSet = new HashSet<String>();
                AgentPayBillEntryCollection entries = agentPayBillInfo.getEntrys();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    sourceBillIdSet.add(entries.get(i).getSourceBillId());
                }
                String sourceBillId = null;
                delSrcBillIdList = new ArrayList<String>();
                int size2 = payBillDelEntry.size();
                for (int i = 0; i < size2; ++i) {
                    sourceBillId = payBillDelEntry.getObject(i).getString("sourceBillId");
                    if (StringUtils.isEmpty((String)sourceBillId) || delSrcBillIdList.contains(sourceBillId) || sourceBillIdSet.contains(sourceBillId)) continue;
                    delSrcBillIdList.add(sourceBillId);
                }
            }
        }
        catch (SecurityException e) {
            logger.error((Object)("##getDeleteEntry. " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("##NoSuchMethod getDeleteEntry. " + e.getMessage()));
        }
        return delSrcBillIdList;
    }
}

