/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseCollection;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.SourceSystem;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.fi.ap.IAPBillDisposer;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.arap.BillDisposerAction;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BizAPBillReBack
implements IAPBillDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.BizAPBillReBack");

    public void dispose(Context context, BillDisposerAction billdisposeraction) throws BOSException, EASBizException {
        if (billdisposeraction == null || billdisposeraction.getDestBill() == null) {
            return;
        }
        DisposerActionEnum actionType = billdisposeraction.getActionType();
        OtherBillInfo otherBillInfo = (OtherBillInfo)billdisposeraction.getDestBill();
        OtherBillentryCollection otherBillEntry = otherBillInfo.getEntry();
        ExpenseAccountBillInfo srcObj = null;
        IExpenseAccountBill iservice = null;
        String srcBillId = otherBillInfo.getSourceBillId();
        if (otherBillEntry != null && otherBillEntry.size() > 0) {
            srcBillId = otherBillEntry.get(0).getSourceBillId();
        }
        if (StringUtils.isEmpty((String)srcBillId)) {
            if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
                throw new BizCollException(BizCollException.OTHERBILLSOURCEBILLIDNOTNULL);
            }
            return;
        }
        Long startTime = System.currentTimeMillis();
        iservice = (IExpenseAccountBill)BizCollUtil.getBizInterfaceByBOSUuid(context, BOSUuid.read((String)srcBillId));
        srcObj = (ExpenseAccountBillInfo)iservice.getValue((IObjectPK)new ObjectUuidPK(srcBillId), this.getSelector());
        if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "Submit", false);
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "Delete", false);
        } else if (DisposerActionEnum.AUDIT.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "Audit", false);
        } else if (DisposerActionEnum.VERIFY.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "Settlement", false);
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "CounterAudit", false);
        } else if (DisposerActionEnum.UNVERIFY.equals((Object)actionType)) {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "CounterSettlement", false);
        } else {
            BillReverseHandler.otherBillHandler(context, iservice, srcObj, otherBillInfo, "Save", false);
        }
        Long endTime = System.currentTimeMillis();
        logger.info((Object)("BizAPBillReBack finished number=" + srcObj.getNumber() + ", othernumber=" + otherBillInfo.getNumber() + ",actionType=" + actionType + ",time\uff1a" + (endTime - startTime) + "ms"));
        ArrayList<String> sourceBillIdList = new ArrayList<String>();
        String sourceBillId = null;
        int size = otherBillEntry.size();
        for (int i = 0; i < size; ++i) {
            sourceBillId = otherBillEntry.get(i).getSourceBillId();
            if (StringUtils.isEmpty((String)sourceBillId) || sourceBillIdList.contains(sourceBillId)) continue;
            sourceBillIdList.add(sourceBillId);
        }
        int sourceBillIdSize = sourceBillIdList.size();
        boolean isFromCQ = false;
        if (sourceBillIdSize == 1) {
            if (SourceSystem.CQ.equals((Object)srcObj.getSourceSystem())) {
                iservice.ngisc_reverse((IObjectPK)new ObjectUuidPK((String)sourceBillIdList.get(0)), srcObj);
                isFromCQ = true;
            }
        } else if (sourceBillIdSize > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo queryFilter = new FilterInfo();
            queryFilter.getFilterItems().add(new FilterItemInfo("id", new HashSet(sourceBillIdList), CompareType.INCLUDE));
            view.setFilter(queryFilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("sourceSystem"));
            view.setSelector(sic);
            BizCollBillBaseCollection infoColl = iservice.getBizCollBillBaseCollection(view);
            if (infoColl != null) {
                BizCollBillBaseInfo info = null;
                int size2 = infoColl.size();
                for (int i = 0; i < size2; ++i) {
                    info = infoColl.get(i);
                    if (!SourceSystem.CQ.equals((Object)info.getSourceSystem())) continue;
                    iservice.ngisc_reverse((IObjectPK)new ObjectUuidPK(info.getId()), info);
                    isFromCQ = true;
                }
            }
        }
        if (isFromCQ) {
            logger.info((Object)("BizAPBillReBack ngisc_reverse number=" + srcObj.getNumber() + ", othernumber=" + otherBillInfo.getNumber() + ",actionType=" + actionType + ",time\uff1a" + (endTime - startTime) + "ms"));
        }
    }

    private BizCollBillBaseInfo getBizCollBillBaseInfo(Context arg0, String billId) throws BOSException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = arg0 == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)arg0);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getSelector());
        return billInfo;
    }

    private DailyLoanBillInfo getDailyLoanBillInfo(Context arg0, String billId) throws BOSException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = arg0 == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)arg0);
        DailyLoanBillInfo billInfo = (DailyLoanBillInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getDailyLoanBillSelector());
        return billInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = BizCollUtil.getExpenseAccountBillSic();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("sourceSystem"));
        return sic;
    }

    private SelectorItemCollection getDailyLoanBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("returnAmount"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("isCreatePayBill"));
        sic.add(new SelectorItemInfo("isCreatePrePaymentBill"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.budgetDo"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        return sic;
    }
}

