/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BudgetReturnUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.BudgetReturnUtil");

    public static void updateBudgetDoForReturnBudget(Context ctx, BizCollBillBaseInfo billInfo, boolean approved, boolean isWithTaxBg) throws EASBizException, BOSException {
        IBizCollBillBase iservice = null;
        if (billInfo instanceof OtherExpenseBillInfo) {
            iservice = OtherExpenseBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            iservice = DailyLoanBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            iservice = EvectionLoanBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountBillInfo) {
            iservice = BizAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            iservice = BizAccountOutBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            iservice = TravelAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            iservice = DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof EvectionReqBillInfo) {
            iservice = EvectionReqBillFactory.getLocalInstance(ctx);
        }
        if (iservice != null) {
            BudgetReturnUtil.updateBillBudgetDoForReturnBudget(ctx, iservice, billInfo, approved, isWithTaxBg);
        }
    }

    protected static SelectorItemCollection getUpdateSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.budgetDo"));
        selector.add(new SelectorItemInfo("entries.budgetUsed"));
        return selector;
    }

    protected static void updateBillBudgetDoForReturnBudget(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, boolean approved, boolean isWithTaxBg) throws EASBizException, BOSException {
        CoreBillEntryBaseInfo entryInfo = null;
        AbstractObjectCollection billEntry = (AbstractObjectCollection)billInfo.get("entries");
        int length = billEntry.size();
        for (int i = 0; i < length; ++i) {
            entryInfo = (CoreBillEntryBaseInfo)billEntry.getObject(i);
            if (approved) {
                if (isWithTaxBg) {
                    entryInfo.setBigDecimal("budgetDo", entryInfo.getBigDecimal("amountApproved"));
                    entryInfo.setBigDecimal("budgetUsed", entryInfo.getBigDecimal("amountApproved"));
                    continue;
                }
                if (billInfo instanceof ExpenseAccountBillInfo) {
                    entryInfo.setBigDecimal("budgetDo", entryInfo.getBigDecimal("amountApprovedWithoutTax"));
                    entryInfo.setBigDecimal("budgetUsed", entryInfo.getBigDecimal("amountApprovedWithoutTax"));
                    continue;
                }
                entryInfo.setBigDecimal("budgetDo", entryInfo.getBigDecimal("amountApproved"));
                entryInfo.setBigDecimal("budgetUsed", entryInfo.getBigDecimal("amountApproved"));
                continue;
            }
            entryInfo.setBigDecimal("budgetDo", entryInfo.getBigDecimal("budgetUsed").multiply(new BigDecimal("-1")));
            entryInfo.setBigDecimal("budgetUsed", new BigDecimal("0.00"));
        }
        iservice.updatePartial((CoreBaseInfo)billInfo, BudgetReturnUtil.getUpdateSelector());
    }
}

