/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.reverse.BillReverse;
import com.kingdee.eas.cp.bc.util.ReverseUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class WorkFlowUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.WorkFlowUtils");

    public static void setAbandonState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId.toString()), BizCollUtil.getBudgetSelector());
        if (StateEnum.ALREADYABANDON.equals((Object)baseInfo.getState())) {
            return;
        }
        if (billId.getType().equals((Object)BizCollUtil.dailyloanBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType) || billId.getType().equals((Object)BizCollUtil.evectionReqBosType) || billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) {
            BillReverse reverse = new BillReverse();
            reverse.doReverseAmountBalance(ctx, baseInfo, "returnBudget");
        }
        WorkFlowUtils.setNowState(ctx, billId, StateEnum.ALREADYABANDON, null);
        ReverseUtil.reverseEvectionReqBillState(ctx, billId.toString());
    }

    public static void setAntiAuditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId.toString()), BizCollUtil.getBudgetSelector());
        if (StateEnum.DRAFT.equals((Object)baseInfo.getState())) {
            return;
        }
        if (billId.getType().equals((Object)BizCollUtil.dailyloanBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType) || billId.getType().equals((Object)BizCollUtil.evectionReqBosType) || billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) {
            BillReverse reverse = new BillReverse();
            reverse.doReverseAmountBalance(ctx, baseInfo, "returnBudget");
        }
        WorkFlowUtils.setNowState(ctx, billId, StateEnum.DRAFT, null);
        ReverseUtil.reverseEvectionReqBillState(ctx, billId.toString());
    }

    public static void setDeleteState(Context ctx, BOSUuid billId, BOSUuid sourceBillId) throws BOSException, EASBizException {
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId.toString()), BizCollUtil.getBudgetSelector());
        ReverseUtil.deleteLoanReverseEvectionReqBillState(ctx, billId.toString(), sourceBillId.toString());
    }

    private static void setNowState(Context ctx, BOSUuid billId, StateEnum state, BOSUuid auditorId) throws BOSException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        if (auditorId != null) {
            userId = auditorId.toString();
        }
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=?");
        Boolean isReWriter = (Boolean)ctx.get((Object)"isReWrite");
        if (StateEnum.CHECKING.equals((Object)state) || isReWriter == null && StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            isCheck = true;
            sql.append(", FAuditorID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setInt(++index, state.getValue());
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setDate(++index, new Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }
}

