/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitFilterFacadeFactory;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgCollection;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgFactory;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgInfo;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonCollection;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonFactory;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonInfo;
import com.kingdee.eas.cp.bc.AccountStandardCollection;
import com.kingdee.eas.cp.bc.AccountStandardFactory;
import com.kingdee.eas.cp.bc.AccountStandardInfo;
import com.kingdee.eas.cp.bc.BillOfWFMessageFactory;
import com.kingdee.eas.cp.bc.BizBaseDataException;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.EvectionLoanBillException;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IAccountStandard;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractAccountStandardControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.control.AccountControl;
import com.kingdee.eas.cp.bc.app.control.ControlFactory;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AccountStandardControllerBean
extends AbstractAccountStandardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.AccountStandardControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";
    private static final String WebResource = "com.kingdee.eas.cp.bc.WebCommonUtilResource";
    Map standardMap = null;
    String standardId = null;
    String standardName = null;
    String standardExpenseType = null;
    String standardCurrency = null;
    String standardReimburseLevel = null;
    String standardNumber = null;
    List errorList = null;
    Map infoMap = null;
    List orgErrors = null;
    String deleteAccountIds = null;
    boolean hasAdd = false;
    private static final int MAX_NAME_LENGTH = 255;
    private static final int MAX_NUMBUER_LENGTH = 80;

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        super._update(ctx, pk, model);
    }

    private void checkInfo(Context ctx, IObjectValue model) throws EASBizException {
        AccountStandardInfo info = (AccountStandardInfo)model;
        if (StringUtils.isBlank((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isBlank((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    @Override
    protected List _assignOrg(Context ctx, List accountStandard, List orgs, String queryUUId) throws BOSException, EASBizException {
        if (StringUtils.isNotBlank((String)queryUUId)) {
            orgs.clear();
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.CompanyOrgUnitQuery"));
            List queryKeys = queryExecutor.getQueryKeys(Uuid.read((String)queryUUId));
            int is = queryKeys.size();
            for (int i = 0; i < is; ++i) {
                Object[] tmpObj = (Object[])queryKeys.get(i);
                orgs.add(tmpObj[0]);
            }
            orgs = this.initCompanys(ctx, orgs);
        }
        return this.assignCommonUtil(ctx, accountStandard, orgs, CommonDataWebUtils.companyType, AccountStandardAssignOrgFactory.getLocalInstance(ctx));
    }

    protected List initCompanys(Context ctx, List orgs) throws BOSException {
        ArrayList companyMaps = new ArrayList();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(orgs), CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityViewInfo);
        int is = companys.size();
        for (int i = 0; i < is; ++i) {
            HashMap<String, String> companyMap = new HashMap<String, String>();
            CompanyOrgUnitInfo companyInfo = companys.get(i);
            companyMap.put("id", companyInfo.getId().toString());
            companyMap.put("name", companyInfo.getName());
            companyMaps.add(companyMap);
        }
        return companyMaps;
    }

    @Override
    protected List _assignPerson(Context ctx, Map accountStandard, List person) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(accountStandard);
        return this.assignCommonUtil(ctx, list, person, CommonDataWebUtils.peronType, AccountStandardAssignPersonFactory.getLocalInstance(ctx));
    }

    public List assignCommonUtil(Context ctx, List<Map> accountStandard, List<Map> linkInfos, String linkType, IDataBase iservice) throws BOSException, EASBizException {
        CoreBaseCollection assignOrgCon = new CoreBaseCollection();
        Object info = null;
        AccountStandardInfo accountInfo = null;
        this.errorList = new ArrayList();
        this.deleteAccountIds = "";
        int is = accountStandard.size();
        for (int i = 0; i < is; ++i) {
            this.hasAdd = false;
            this.standardMap = accountStandard.get(i);
            this.standardId = this.standardMap.get("standardId").toString();
            this.standardName = this.standardMap.get("standardName").toString();
            this.standardExpenseType = this.standardMap.get("standardExpenseType").toString();
            this.standardCurrency = this.standardMap.get("standardCurrency").toString();
            this.standardReimburseLevel = this.standardMap.get("standardReimburseLevel").toString();
            this.standardNumber = this.standardMap.get("standardNumber").toString();
            FilterInfo queryFilter = new FilterInfo();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            queryFilter.getFilterItems().add(new FilterItemInfo("" + linkType + ".id", (Object)CommonDataWebUtils.getIds(linkInfos), CompareType.INCLUDE));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.currencyType.id", (Object)this.standardCurrency, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.expenseType.id", (Object)this.standardExpenseType, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.reimburseLV.id", (Object)this.standardReimburseLevel, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.id", (Object)this.standardId, CompareType.NOTEQUALS));
            entityViewInfo.setSelector(CommonDataWebUtils.getAccountSelector(linkType));
            entityViewInfo.setFilter(queryFilter);
            CoreBaseCollection orgcon = iservice.getCollection(entityViewInfo);
            Set set = CommonDataWebUtils.convertSet((AbstractObjectCollection)orgcon);
            int js = linkInfos.size();
            for (int j = 0; j < js; ++j) {
                this.infoMap = new HashMap();
                this.infoMap.put("standardName", this.standardName);
                this.orgErrors = new ArrayList();
                if (set.contains(linkInfos.get(j).get("id").toString())) {
                    this.infoMap.put("standardName", this.standardName);
                    HashMap<String, String> errorMap = new HashMap<String, String>();
                    Map nameMap = (Map)linkInfos.get(j).get("name");
                    Locale locale = ctx.getOriginLocale();
                    String orgName = this.getOrgName(ctx, linkInfos, j);
                    errorMap.put("orgName", orgName);
                    errorMap.put("errorMsg", EASResource.getString((String)WebResource, (String)"EXIST_SAME_ACCOUNTSTANDARD"));
                    this.orgErrors.add(errorMap);
                } else {
                    accountInfo = new AccountStandardInfo();
                    accountInfo.setId(BOSUuid.read((String)this.standardId));
                    accountInfo.setNumber(this.standardNumber);
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    BOSUuid companyId = BOSUuid.read((String)linkInfos.get(j).get("id").toString());
                    company.setId(companyId);
                    accountInfo.setCompany(company);
                    boolean existSameNumebr = false;
                    try {
                        this.checkNumberDup(ctx, accountInfo);
                    }
                    catch (EASBizException e) {
                        existSameNumebr = true;
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        errorMap.put("orgName", (String)linkInfos.get(j).get("name"));
                        errorMap.put("errorMsg", EASResource.getString((String)WebResource, (String)"ACCOUNTSTANDARD_EXIST_SAME_NUMBER"));
                        this.orgErrors.add(errorMap);
                    }
                    if (!existSameNumebr) {
                        this.hasAdd = true;
                        assignOrgCon.add((CoreBaseInfo)this.initAssignInfo(accountInfo, linkInfos.get(j).get("id").toString(), linkType));
                    }
                }
                if (this.orgErrors.size() == 0) continue;
                this.infoMap.put("orgList", this.orgErrors);
                this.errorList.add(this.infoMap);
            }
            if (!this.hasAdd && linkInfos != null && linkInfos.size() != 0) continue;
            this.deleteAccountIds = this.deleteAccountIds + "'" + this.standardId + "',";
        }
        if (this.deleteAccountIds.length() > 0) {
            iservice.delete("where accountStandard.id in(" + this.deleteAccountIds.substring(0, this.deleteAccountIds.length() - 1) + ")");
        }
        if (assignOrgCon.size() != 0) {
            iservice.addnewBatchData(assignOrgCon);
        }
        return this.errorList;
    }

    private String getOrgName(Context ctx, List<Map> linkInfos, int j) {
        Object linkInfoObj = linkInfos.get(j).get("name");
        String orgName = "";
        if (linkInfoObj instanceof Map) {
            Map nameMap = (Map)linkInfos.get(j).get("name");
            Locale locale = ctx.getOriginLocale();
            orgName = locale == LocaleUtils.locale_en_US ? (String)nameMap.get("l1") : (locale == LocaleUtils.locale_zh_CN ? (String)nameMap.get("l2") : (String)nameMap.get("l3"));
        } else {
            orgName = (String)linkInfoObj;
        }
        return orgName;
    }

    public DataBaseInfo initAssignInfo(AccountStandardInfo standardInfo, String linkInfoId, String linkType) {
        if (linkType.equals("company")) {
            AccountStandardAssignOrgInfo info = new AccountStandardAssignOrgInfo();
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)linkInfoId));
            info.setAccountStandard(standardInfo);
            info.setCompany(company);
            return info;
        }
        AccountStandardAssignPersonInfo info = new AccountStandardAssignPersonInfo();
        PersonInfo personinfo = new PersonInfo();
        personinfo.setId(BOSUuid.read((String)linkInfoId));
        info.setAccountStandard(standardInfo);
        info.setPerson(personinfo);
        return info;
    }

    @Override
    protected void _cancelAccountStandardAssign(Context ctx, String type, String accountStandardId, String assignId) throws BOSException, EASBizException {
        Object iservice = null;
        String linkType = null;
        if (type.equals("person")) {
            linkType = "person";
            iservice = AccountStandardAssignPersonFactory.getLocalInstance(ctx);
        } else {
            linkType = "company";
            iservice = AccountStandardAssignOrgFactory.getLocalInstance(ctx);
        }
        iservice.delete("where " + linkType + ".id='" + assignId + "' and accountStandard.id='" + accountStandardId + "'");
    }

    @Override
    protected boolean _deleteAccountStandards(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids != null && ids.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[ids.size()];
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(ids.get(i).toString());
                s.append("'").append(ids.get(i).toString()).append("',");
            }
            s.deleteCharAt(s.length() - 1);
            AccountStandardFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])pks);
        }
        return true;
    }

    @Override
    protected List _enable(Context ctx, List accountStandards, boolean enable) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        if (accountStandards == null || accountStandards.size() == 0) {
            return resultList;
        }
        StringBuffer queryExistSb = new StringBuffer();
        String querySql = "SELECT FID WHERE ";
        String whereSql = "EXPENSETYPE.ID = '%s' AND CURRENCYTYPE.ID = '%s' AND REIMBURSELV.ID = '%s' AND STATE = 1 AND ID != '%s'";
        IAccountStandard accountStInstance = AccountStandardFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        for (Object accountStandard : accountStandards) {
            Map accountStandardMap = (Map)accountStandard;
            String accountStId = accountStandardMap.get("id").toString();
            AccountStandardInfo accountStInfo = new AccountStandardInfo();
            accountStInfo.setId(BOSUuid.read((String)accountStId));
            if (!enable) {
                accountStInfo.setState(EnableStateEnum.DISABLE);
                accountStInstance.updatePartial(accountStInfo, selector);
                continue;
            }
            accountStInfo.setState(EnableStateEnum.ENABLE);
            accountStInstance.updatePartial(accountStInfo, selector);
        }
        return resultList;
    }

    @Override
    protected List _fetchAccountStandard(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("billinfo", billInfo);
        AccountControl accountControl = (AccountControl)ControlFactory.createAccountControl();
        List<Map> checkMap = accountControl.check(ctx, StaffLevelAttriEnum.USERDEFINED, paramMap);
        return checkMap;
    }

    @Override
    protected List _getAccountLimitQueryDataByAdminIds(Context ctx, String adminIds, String date) throws BOSException, EASBizException {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            Map persons = CommonDataWebUtils.getPersonIdsByAdminIds(ctx, adminIds);
            ArrayList<String> personIds = new ArrayList<String>();
            Set keySet = persons.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                personIds.add(it.next().toString());
            }
            Map adminMap = ControlUtil.getAdminOrgUnitsByPersons(ctx, personIds);
            Map stdMap = ControlUtil.getAccountStandards(ctx, personIds, this.getDateByString(date));
            if (stdMap != null && adminMap != null) {
                Set entrySet = stdMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Map data = this.bulidQueryListData(ctx, (Map)entry.getValue(), adminMap, this.getDateByString(date));
                    result.add(data);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Date getDateByString(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private Map bulidQueryListData(Context ctx, Map map, Map adminMap, Date date) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String personId = (String)map.get("personId");
        data.put("personID", personId);
        data.put("personName", (String)map.get("personName"));
        data.put("reimburseLevelID", (String)map.get("levelId"));
        data.put("reimburseLevelName", (String)map.get("levelName"));
        data.put("expenseTypeID", (String)map.get("expenseTypeId"));
        data.put("expenseType", (String)map.get("expenseTypeName"));
        data.put("currencyID", (String)map.get("currencyId"));
        data.put("currencyName", (String)map.get("currencyName"));
        BigDecimal monthLimit = (BigDecimal)map.get("monthLimit");
        data.put("monthLimit", monthLimit);
        Date effectiveDate = (Date)map.get("effectiveDate");
        data.put("effectiveDate", effectiveDate);
        int controMethodVal = (Integer)map.get("controlMethod");
        data.put("controlMethod", ControlMethod.getEnum(controMethodVal).toString());
        data.put("controlVal", controMethodVal);
        Map monthData = ControlUtil.getEffectiveMonth(ctx, effectiveDate, date, ControlMethod.getEnum(controMethodVal));
        BigDecimal limit = monthLimit.multiply(new BigDecimal(monthData.get("month").toString()));
        if (ControlMethod.getEnum(controMethodVal).equals((Object)ControlMethod.total)) {
            data.put("yearLimit", limit);
        }
        BigDecimal totalUsedAmount = ControlUtil.countAccountEntryUsedAmount(ctx, personId, (Date)monthData.get("beginDate"), (Date)monthData.get("endDate"), (String)map.get("expenseTypeId"), (String)map.get("currencyId"));
        BigDecimal totalUsingAmount = ControlUtil.countAccountEntryUsingAmount(ctx, personId, (Date)monthData.get("beginDate"), (Date)monthData.get("endDate"), (String)map.get("expenseTypeId"), (String)map.get("currencyId"));
        BigDecimal totalAmount = totalUsedAmount.add(totalUsingAmount);
        data.put("amountUsed", totalUsedAmount);
        data.put("amountUsing", totalUsingAmount);
        data.put("amountUsable", limit.compareTo(totalAmount) > 0 ? limit.subtract(totalAmount) : new BigDecimal("0.00"));
        data.put("adminOrgUnitName", ((AdminOrgUnitInfo)adminMap.get(personId)).getName());
        return data;
    }

    @Override
    protected List _getAccountLimitQueryDataByUserId(Context ctx, String userID, String date) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userID), selector);
        String personId = userInfo.getPerson().getId().toString();
        String personName = userInfo.getPerson().getName();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Map> listData = new ArrayList<Map>();
        ids.add(personId);
        Map adminMap = ControlUtil.getAdminOrgUnitsByPersons(ctx, ids);
        Map stdMap = ControlUtil.getAccountStandards(ctx, ids, this.getDateByString(date));
        if (stdMap != null && adminMap != null) {
            Set entrySet = stdMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Map data = this.bulidQueryListData(ctx, (Map)entry.getValue(), adminMap, this.getDateByString(date));
                listData.add(data);
            }
        }
        return listData;
    }

    @Override
    protected List _getAssignPersons(Context ctx, String id) throws BOSException, EASBizException {
        ArrayList<PersonInfo> result = new ArrayList<PersonInfo>();
        if (id == null || id.length() < 0) {
            return result;
        }
        AccountStandardAssignPersonCollection con = AccountStandardAssignPersonFactory.getLocalInstance(ctx).getAccountStandardAssignPersonCollection("select person.id,person.number,person.name where accountStandard.id = '" + id + "'");
        Iterator it = con.iterator();
        while (it.hasNext()) {
            AdminOrgUnitInfo adminOrg;
            PersonInfo person = new PersonInfo();
            AccountStandardAssignPersonInfo info = (AccountStandardAssignPersonInfo)it.next();
            person.put("id", (Object)info.getPerson().getId());
            person.put("number", (Object)info.getPerson().getNumber());
            person.put("name", (Object)info.getPerson().getName());
            PositionInfo position = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(info.getPerson().getId());
            if (position != null && position.getName() != null) {
                person.put("Position.name", (Object)position.getName());
            }
            if ((adminOrg = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(info.getPerson().getId())) != null && adminOrg.getName() != null) {
                person.put("AdminOrgUnit.name", (Object)adminOrg.getName());
            }
            result.add(person);
        }
        return result;
    }

    @Override
    protected Map _getFilterInfoData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String ln = company.getLongNumber();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", null, CompareType.IS));
        tempFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE, CompareType.EQUALS));
        tempFilter.setMaskString("#0 or #1");
        fi.mergeFilter(tempFilter, "and");
        FilterInfo tempFilter1 = new FilterInfo();
        tempFilter1.getFilterItems().add(new FilterItemInfo("controlType", (Object)0, CompareType.NOTEQUALS));
        fi.mergeFilter(tempFilter1, "and");
        result.put("expenseTypeFilter", fi.toString());
        return result;
    }

    @Override
    protected List _getGroupFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        Locale local = ctx.getLocale();
        ArrayList resultList = new ArrayList();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, Object> reimburseLevelGroup = new HashMap<String, Object>();
        ArrayList reimburseLevelFilterItems = new ArrayList();
        reimburseLevelGroup.put("field", "reimburseLV.id");
        reimburseLevelGroup.put("dataType", "ObjectValue");
        reimburseLevelGroup.put("title", ResourceBase.getString((String)WebResource, (String)"REIMBURSELEVEL", (Locale)local));
        reimburseLevelGroup.put("mitiSelect", "false");
        reimburseLevelGroup.put("displayCount", 8);
        reimburseLevelGroup.put("unlimited", true);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String[] cuIds = CommonDataWebUtils.getParentCuIds(ctx, companyInfo.getCU().getId().toString());
        HashSet<String> cuIdSet = new HashSet<String>(Arrays.asList(cuIds));
        FilterInfo reimburseFilterInfo = new FilterInfo();
        reimburseFilterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)0));
        reimburseFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        reimburseFilterInfo.getFilterItems().add(new FilterItemInfo("CU.number", cuIdSet, CompareType.INCLUDE));
        EntityViewInfo reimburseEntityViewInfo = new EntityViewInfo();
        reimburseEntityViewInfo.setFilter(reimburseFilterInfo);
        SelectorItemCollection reimburseSelector = new SelectorItemCollection();
        reimburseSelector.add(new SelectorItemInfo("id"));
        reimburseSelector.add(new SelectorItemInfo("name"));
        reimburseEntityViewInfo.setSelector(reimburseSelector);
        CoreBaseCollection reimburses = ReimburseLevelFactory.getLocalInstance(ctx).getCollection(reimburseEntityViewInfo);
        for (int m = 0; m < reimburses.size(); ++m) {
            CoreBaseInfo info = reimburses.get(m);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", info.get("name"));
            filterMap.put("value", info.get("id"));
            filterMap.put("isDefault", false);
            reimburseLevelFilterItems.add(filterMap);
        }
        reimburseLevelGroup.put("filterItems", reimburseLevelFilterItems);
        resultList.add(reimburseLevelGroup);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _initAccountLimitBillQueryData(Context ctx, Map parameterMap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        Calendar ca = Calendar.getInstance();
        int curYear = ca.get(1);
        String year = (String)parameterMap.get("year");
        if (year == null) {
            return null;
        }
        String month = (String)parameterMap.get("month");
        String col = (String)parameterMap.get("col");
        Date beginDate = new Date();
        Date endDate = new Date();
        if (month == null) {
            if (year.equalsIgnoreCase(String.valueOf(curYear))) {
                if (col.equals("curMonthAmount")) {
                    ca.set(5, 1);
                    beginDate = ca.getTime();
                    ca.add(2, 1);
                    ca.add(5, -1);
                    endDate = ca.getTime();
                } else {
                    ca.set(5, 1);
                    ca.add(2, 1);
                    ca.add(5, -1);
                    endDate = ca.getTime();
                    ca.clear();
                    ca.set(1, curYear);
                    beginDate = ca.getTime();
                }
            } else if (col.equals("curMonthAmount")) {
                ca.clear();
                ca.set(1, Integer.valueOf(year));
                ca.set(2, 11);
                beginDate = ca.getTime();
                ca.add(2, 1);
                ca.add(5, -1);
                endDate = ca.getTime();
            } else {
                ca.clear();
                ca.set(1, Integer.valueOf(year));
                beginDate = ca.getTime();
                ca.roll(6, -1);
                endDate = ca.getTime();
            }
        } else {
            ca.clear();
            ca.set(1, Integer.valueOf(year));
            ca.set(2, Integer.valueOf(month));
            beginDate = ca.getTime();
            ca.add(2, 1);
            ca.add(5, -1);
            endDate = ca.getTime();
        }
        String companyId = (String)parameterMap.get("companyId");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP050");
        Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, companyId);
        boolean isCalCurCompany = new Boolean(params.get("CP050").toString());
        String limitId = (String)parameterMap.get("accountLimitId");
        if (limitId == null || beginDate == null || endDate == null) {
            return null;
        }
        String companyProperty = "fappliercompanyid";
        String exCompanyProperty = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getCompanyKey();
        if (exCompanyProperty != null && exCompanyProperty.length() > 0) {
            companyProperty = exCompanyProperty;
        }
        HashSet set = new HashSet();
        StringBuffer sql = new StringBuffer();
        sql.append(" select AA.id id, AA.applierid applierid, AA.bizreqdate bizreqdate, AA.number number, AA.cause cause,       ");
        sql.append(" AA.amount amount, AA.amountapproved amountapproved, AA.amountencashed amountencashed,                      ");
        sql.append(" AA.state state, AA.expensetypeid expensetypeid, AA.currencyid currencyid   \t\t\t\t\t\t\t    ");
        sql.append(" from                                                                                                       ");
        sql.append(" (select                                         \t\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        sql.append(" A.fid id, A.fapplierid applierid, A.fbizreqdate bizreqdate, A.fnumber number, A.fcause cause,              ");
        sql.append(" A.famount amount, A.famountapproved amountapproved, A.famountencashed amountencashed,                      ");
        sql.append(" A.fstate state, B.fexpensetypeid expensetypeid, B.fcurrencyid currencyid\t\t\t\t\t\t\t\t\t");
        sql.append(" from                                                                                                       ");
        sql.append(" t_bc_accountlimit as accountlimit                                                                          ");
        sql.append(" inner join t_bc_bizaccountbill as A                                                                        ");
        sql.append(" \tON accountlimit.fpersonid = A.fapplierid \t\t                                                        ");
        if (isCalCurCompany) {
            sql.append("\tAND accountlimit.fcompanyorgunitid = A." + companyProperty + " \n");
        } else {
            sql.append("\tAND A.fappliercompanyid in \n");
            sql.append("\t(SELECT paramitem.forgunitid FROM T_Bas_paramitem paramitem \n");
            sql.append("WHERE paramitem.fkeyid in \n");
            sql.append("\t(SELECT param.fid FROM T_BAS_Param param \n");
            sql.append("WHERE param.fnumber = 'CP027') \n");
            sql.append("\tAND paramitem.fvalue_l2 = 'true') \n");
        }
        sql.append(" inner join T_BC_BizAccountBillEntry B on A.fid = B.fbillid                                                 ");
        sql.append(" where accountlimit.fcurrencyid = B.fcurrencyid AND accountlimit.fexpensetypeid = B.fexpensetypeid          ");
        sql.append(" and B.fhappentime between ? and ?    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        sql.append(" and (A.FState = 25 or A.FState = 30 or A.FState >= 45)    \t\t\t\t\t\t\t\t\t\t\t\t    ");
        sql.append(" and accountlimit.fid = ? ) as AA                 \t\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        try {
            Object id;
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sql.toString());
            pstmtInsert.setDate(1, new java.sql.Date(beginDate.getTime()));
            pstmtInsert.setDate(2, new java.sql.Date(endDate.getTime()));
            pstmtInsert.setString(3, limitId);
            ResultSet rowSet = pstmtInsert.executeQuery();
            HashSet idSet = new HashSet();
            Iterator ite = idSet.iterator();
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String[] stringArray = new String[]{"id", "applierid", "bizreqdate", "number", "cause", "amount", "amountapproved", "amountencashed", "state", "expensetypeid", "currencyid"};
                int n = stringArray.length;
                for (int i = 0; i < n - 2; ++i) {
                    map.put(stringArray[i], rowSet.getObject(stringArray[i]));
                    if (!stringArray[i].equals("state")) continue;
                    int state = Integer.valueOf(rowSet.getObject("state").toString());
                    map.put("state", (Object)StateEnum.getEnum(state));
                }
                id = (String)rowSet.getObject("id");
                if (id != null) {
                    idSet.add(id);
                }
                set.add(map);
            }
            Map processMap = BillOfWFMessageFactory.getRemoteInstance().getWFCurrentNoteMessage(idSet);
            for (HashMap hashMap : set) {
                id = hashMap.get("id");
                if (id != null) {
                    Object tempMessage = processMap.get(id.toString());
                    hashMap.put("note", tempMessage);
                    continue;
                }
                hashMap.put("note", ResourceBase.getString((String)WebResource, (String)"VIEWTHEFLOW", (Locale)ctx.getOriginLocale()));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        result.put("listData", set);
        return result;
    }

    @Override
    protected Map _initAccountLimitQueryData(Context ctx, String userID) throws BOSException, EASBizException {
        Set companyOrgs;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String adminIds = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userID), selector);
        if (userInfo.getPerson() != null) {
            String personID = userInfo.getPerson().getId().toString();
            result.put("personId", personID);
            List<String> adminIdList = CommonDataWebUtils.getPersonChargeAdmin(ctx, personID);
            if (adminIdList != null && adminIdList.size() > 0) {
                result.put("adminIdList", adminIdList);
            }
            StringBuffer oqlBuffer = new StringBuffer();
            for (String id : adminIdList) {
                oqlBuffer.append("'").append(id.toString()).append("',");
            }
            if (oqlBuffer.length() > 0) {
                oqlBuffer.deleteCharAt(oqlBuffer.lastIndexOf(","));
            }
            adminIds = oqlBuffer.toString();
        }
        if (adminIds != null && adminIds.length() > 0) {
            result.put("adminIds", adminIds);
        }
        if ((companyOrgs = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, userID, OrgRangeType.BIZ_ORG_TYPE, null)) != null && companyOrgs.size() > 0) {
            result.put("orgRanges", companyOrgs);
        }
        return result;
    }

    @Override
    public List getAccountLimitQueryDataByUserId(Context ctx, String userID, String date) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userID), selector);
        String personId = userInfo.getPerson().getId().toString();
        String personName = userInfo.getPerson().getName();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Map> listData = new ArrayList<Map>();
        ids.add(personId);
        Map adminMap = ControlUtil.getAdminOrgUnitsByPersons(ctx, ids);
        Map stdMap = ControlUtil.getAccountStandards(ctx, ids, this.getDateByString(date));
        if (stdMap != null && adminMap != null) {
            Set entrySet = stdMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Map data = this.bulidQueryListData(ctx, (Map)entry.getValue(), adminMap, this.getDateByString(date));
                listData.add(data);
            }
        }
        return listData;
    }

    @Override
    protected Map _initAccountStandardAssign(Context ctx, List accountStandardIds, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("orgFilterIds", CommonDataWebUtils.getEqAndChildCompanyFilter(ctx, companyId));
        HashSet accountSIds = new HashSet(accountStandardIds);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.number"));
        selector.add(new SelectorItemInfo("company.name"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountStandard.id", accountSIds, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountStandardAssignOrgCollection accountStandardAssignOrgCollection = AccountStandardAssignOrgFactory.getLocalInstance(ctx).getAccountStandardAssignOrgCollection(view);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList assignOrgs = new ArrayList();
        HashMap<String, String> org = null;
        int is = accountStandardAssignOrgCollection.size();
        for (int i = 0; i < is; ++i) {
            org = new HashMap<String, String>();
            AccountStandardAssignOrgInfo accountStandardAssignOrgInfo = accountStandardAssignOrgCollection.get(i);
            String company = accountStandardAssignOrgInfo.getCompany().getId().toString();
            if (hashSet.contains(company)) continue;
            hashSet.add(company);
            org.put("id", accountStandardAssignOrgInfo.getCompany().getId().toString());
            org.put("name", accountStandardAssignOrgInfo.getCompany().getName());
            org.put("number", accountStandardAssignOrgInfo.getCompany().getNumber());
            assignOrgs.add(org);
        }
        resultMap.put("assignOrgs", assignOrgs);
        return resultMap;
    }

    @Override
    protected Map _initAccountStandardView(Context ctx, String accountStandardId, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)accountStandardId)) {
            return resultMap;
        }
        FilterInfo queryFilter = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("company.number"));
        queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.id", (Object)accountStandardId));
        entityViewInfo.setFilter(queryFilter);
        entityViewInfo.setSelector(selector);
        ArrayList assignOrgs = new ArrayList();
        AccountStandardAssignOrgCollection assignOrgCon = AccountStandardAssignOrgFactory.getLocalInstance(ctx).getAccountStandardAssignOrgCollection(entityViewInfo);
        int is = assignOrgCon.size();
        for (int i = 0; i < is; ++i) {
            HashMap<String, String> assignOrgMap = new HashMap<String, String>();
            assignOrgMap.put("id", assignOrgCon.get(i).getCompany().getId().toString());
            assignOrgMap.put("name", assignOrgCon.get(i).getCompany().getName().toString());
            assignOrgMap.put("number", assignOrgCon.get(i).getCompany().getNumber());
            assignOrgs.add(assignOrgMap);
        }
        resultMap.put("assignOrgs", assignOrgs);
        resultMap.put("orgFilterIds", CommonDataWebUtils.getEqAndChildCompanyFilter(ctx, companyId));
        return resultMap;
    }

    @Override
    protected boolean _saveAccountStandard(Context ctx, IObjectValue model, List personIds) throws BOSException, EASBizException {
        if (model == null) {
            return false;
        }
        AccountStandardInfo info = (AccountStandardInfo)model;
        if (info.getExpenseType() == null || info.getReimburseLV() == null || info.getCurrencyType() == null || info.getCompany() == null) {
            return false;
        }
        this.checkInfo(ctx, info, personIds);
        AccountStandardFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        AccountStandardAssignPersonFactory.getLocalInstance(ctx).delete("where accountStandard.id = '" + info.getId().toString() + "'");
        if (personIds != null && personIds.size() > 0) {
            CoreBaseCollection con = new CoreBaseCollection();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String personId = it.next().toString();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                AccountStandardAssignPersonInfo assignInfo = new AccountStandardAssignPersonInfo();
                assignInfo.setPerson(person);
                assignInfo.setAccountStandard(info);
                con.add((CoreBaseInfo)assignInfo);
            }
            AccountStandardAssignPersonFactory.getLocalInstance(ctx).saveBatchData(con);
        }
        return true;
    }

    private void checkInfo(Context ctx, AccountStandardInfo info, List personIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String expenseTypeId = info.getExpenseType().getId().toString();
        String currencyId = info.getCurrencyType().getId().toString();
        String lvId = info.getReimburseLV().getId().toString();
        String infoId = info.getId().toString();
        AccountStandardCollection con = AccountStandardFactory.getLocalInstance(ctx).getAccountStandardCollection("select id where expenseType.id = '" + expenseTypeId + "' and currencyType.id = '" + currencyId + "' and reimburseLV = '" + lvId + "' and company.id = '" + company.getId().toString() + "' and state = 1 and id <> '" + infoId + "'");
        if (con.size() > 0) {
            throw new StandardException(StandardException.ACCOUNTSTANDARD_REPEAT);
        }
        if (personIds != null && personIds.size() > 0) {
            StringBuffer string = new StringBuffer();
            StringBuffer oql = new StringBuffer();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                string.append("'").append(id).append("',");
            }
            string.deleteCharAt(string.length() - 1);
            oql.append("select id,person.number,person.name,accountStandard.number where ").append("person.id in (").append(string.toString()).append(") and ").append("accountStandard.expenseType.id = '").append(expenseTypeId).append("' and ").append("accountStandard.currencyType.id = '").append(currencyId).append("' and ").append("accountStandard.state = 1 and accountStandard.id <> '").append(infoId).append("'");
            AccountStandardAssignPersonCollection result = AccountStandardAssignPersonFactory.getLocalInstance(ctx).getAccountStandardAssignPersonCollection(oql.toString());
            if (result.size() > 0) {
                AccountStandardAssignPersonInfo assignInfo = result.get(0);
                String personNumber = assignInfo.getPerson().getNumber();
                String personName = assignInfo.getPerson().getName();
                String person = personName + "(" + personNumber + ")";
                throw new StandardException(StandardException.ACCOUNTSTANDARD_PERSON_REPEAT, new Object[]{person, assignInfo.getAccountStandard().getNumber()});
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseCollection con;
        String id = null;
        String expenseTypeId = null;
        String currencyId = null;
        String lvId = null;
        String companyId = null;
        if (model.get("id") != null) {
            id = model.get("id").toString();
        }
        if (model.get("expenseType") != null) {
            expenseTypeId = ((ExpenseTypeInfo)model.get("expenseType")).getId().toString();
        }
        if (model.get("currencyType") != null) {
            currencyId = ((CurrencyInfo)model.get("currencyType")).getId().toString();
        }
        if (model.get("reimburseLV") != null) {
            lvId = ((ReimburseLevelInfo)model.get("reimburseLV")).getId().toString();
        }
        if (model.get("company") != null) {
            companyId = ((CompanyOrgUnitInfo)model.get("company")).getId().toString();
        }
        if (expenseTypeId == null || currencyId == null || lvId == null || companyId == null) {
            return null;
        }
        String oql = "select id where expenseType.id = '" + expenseTypeId + "' and currencyType.id = '" + currencyId + "' and reimburseLV = '" + lvId + "' and company.id = '" + companyId + "'";
        if (id != null) {
            oql = oql + " and id <> '" + id + "'";
        }
        if ((con = super.getCollection(ctx, oql)) != null && con.size() > 0) {
            throw new StandardException(StandardException.ACCOUNTSTANDARD_REPEAT);
        }
        this.checkModelValidate(ctx, model);
        return super._save(ctx, model);
    }

    protected void checkModelValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountStandardInfo info = (AccountStandardInfo)model;
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
        if (info.getName().trim().length() > 255) {
            throw new BizBaseDataException(BizBaseDataException.NAME_TOO_LONG, new Object[]{255});
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_TOO_LONG);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountStandardInfo accountStandardInfo = (AccountStandardInfo)model;
        String companyId = accountStandardInfo.getCompany().getId().toString();
        String accountNumber = accountStandardInfo.getNumber();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.AccountStandardQuery");
        IQueryExecutor iQueryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        iQueryExecutor.setObjectView(entityViewInfo);
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        int i = 0;
        StringBuffer stringBuffer = new StringBuffer();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        stringBuffer.append("(#").append(i++).append(" ");
        filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
        stringBuffer.append("or #").append(i++).append(") ");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
        stringBuffer.append("and #").append(i++).append(" ");
        BOSUuid accountStandardId = accountStandardInfo.getId();
        if (accountStandardId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)accountStandardId.toString(), CompareType.NOTEQUALS));
            stringBuffer.append("and #").append(i++).append(" ");
        }
        filterInfo.setMaskString(stringBuffer.toString());
        IRowSet rowSet = iQueryExecutor.executeQuery();
        if (rowSet.size() > 0) {
            String number = this._getPropertyAlias(ctx, accountStandardInfo, "number") + " : " + accountStandardInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private boolean existSameNumber(Context ctx, DataBaseInfo dataBaseInfo) {
        boolean exist = false;
        try {
            this.checkNumberDup(ctx, dataBaseInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            exist = true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            exist = true;
        }
        return exist;
    }
}

