/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.WFInstanceVo;
import com.kingdee.eas.cp.bc.app.AbstractBillOfWFMessageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillOfWFMessageControllerBean
extends AbstractBillOfWFMessageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BillOfWFMessageControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    protected Map _getWFCurrentNoteMessage(Context ctx, Set billIds) throws BOSException, EASBizException {
        Map messageMap;
        try {
            messageMap = this.findProcInstList(ctx, billIds);
        }
        catch (SQLException e) {
            messageMap = null;
            e.printStackTrace();
        }
        return messageMap;
    }

    protected Map findProcInstList(Context ctx, Set billId) throws BOSException, SQLException {
        if (billId == null || billId.size() <= 0) {
            return null;
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)this.getQuerySql(billId, ctx));
        if (result == null) {
            return null;
        }
        HashMap messageMap = new HashMap();
        WFInstanceVo vo = null;
        while (result.next()) {
            String bizPackage = BillOfWFMessageControllerBean.formatString(result.getString("FBIZPACKAGE"));
            String bizOperation = BillOfWFMessageControllerBean.formatString(result.getString("FBIZOPERATION"));
            if (bizOperation.equals("afterImageReadyHandler")) {
                this.constructCurrentNode(vo, messageMap, (ResultSet)result);
                continue;
            }
            if (bizPackage.equals("com.kingdee.eas.base.multiapprove.client")) {
                this.constructCurrentNode(vo, messageMap, (ResultSet)result);
                continue;
            }
            if (!bizOperation.equals("ActionSubmit") && !bizOperation.equals("actionSubmit") || !bizPackage.equals("com.kingdee.eas.cp.bc.app")) continue;
            this.constructCurrentNode(vo, messageMap, (ResultSet)result);
        }
        return this.formatMessage(messageMap);
    }

    protected Map formatMessage(Map messageMap) {
        if (messageMap == null) {
            return null;
        }
        HashMap newMessageMap = new HashMap();
        for (WFInstanceVo vo : messageMap.values()) {
            messageMap.put(vo.getBillId(), this.formatHandlerString(vo));
        }
        return messageMap;
    }

    protected String formatHandlerString(WFInstanceVo vo) {
        Object obj;
        StringBuffer tempMessage = new StringBuffer();
        tempMessage.append(vo.getActdefname() == null ? "" : vo.getActdefname());
        tempMessage.append("/");
        Set handlerSet = vo.getHandlerName();
        Iterator ite = handlerSet.iterator();
        if (ite.hasNext() && (obj = ite.next()) != null) {
            tempMessage.append(obj.toString());
        }
        while (ite.hasNext()) {
            obj = ite.next();
            if (obj == null) continue;
            tempMessage.append(",");
            tempMessage.append(obj.toString());
        }
        return tempMessage.toString();
    }

    protected String getQuerySql(Set<String> billId, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct ");
        Locale locale = ctx.getOriginLocale();
        if (locale == LocaleUtils.locale_en_US) {
            sql.append(" ASSIGN.FACTDEFNAME_L1 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L1 AS FPERSONEMPNAME ,");
        }
        if (locale == LocaleUtils.locale_zh_CN) {
            sql.append(" ASSIGN.FACTDEFNAME_L2 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L2 AS FPERSONEMPNAME ,");
        }
        if (locale == LocaleUtils.locale_zh_TW) {
            sql.append(" ASSIGN.FACTDEFNAME_L3 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L3 AS FPERSONEMPNAME ,");
        }
        sql.append(" ASSIGN.FBIZPACKAGE AS FBIZPACKAGE ,");
        sql.append(" ASSIGN.FBIZOPERATION AS FBIZOPERATION ,");
        sql.append(" case when ASSIGN.FBIZOPERATION = 'afterImageReadyHandler' then 1");
        sql.append(" when (ASSIGN.FBIZPACKAGE='com.kingdee.eas.base.multiapprove.client' AND ASSIGN.FBIZOPERATION != 'ConfirmAction' and ASSIGN.FBIZFUNCTION !='ManualDecisionUIFunction' ) then 2");
        sql.append(" when (ASSIGN.FBIZPACKAGE='com.kingdee.eas.base.multiapprove.client') then 3");
        sql.append(" when ((ASSIGN.FBIZOPERATION = 'ActionSubmit' OR ASSIGN.FBIZOPERATION = 'actionSubmit') and ASSIGN.FBIZPACKAGE='com.kingdee.eas.cp.bc.app') then 4");
        sql.append(" end AS W,");
        sql.append(" ASSIGN.FBIZOBJID AS FBIZOBJID ");
        sql.append(" FROM T_WFR_ProcInst AS PROCINST ");
        sql.append(" INNER JOIN T_WFR_Assign AS ASSIGN ON ASSIGN.FPROCINSTID=PROCINST.FPROCINSTID ");
        sql.append(" INNER JOIN T_WFR_Actinst AS ACTINST ON  ASSIGN.FACTINSTID  = ACTINST.FACTINSTID ");
        sql.append(" WHERE PROCINST.FSTATE LIKE 'open%' ");
        sql.append(" AND ACTINST.FINITED = 1 ");
        sql.append(" AND ASSIGN.FBIZOBJID in (").append(this.createFilter(billId)).append(")");
        sql.append(" AND ((ASSIGN.FBIZPACKAGE='com.kingdee.eas.base.multiapprove.client')");
        sql.append(" OR ((ASSIGN.FBIZOPERATION = 'ActionSubmit' OR ASSIGN.FBIZOPERATION = 'actionSubmit') AND (ASSIGN.FBIZPACKAGE='com.kingdee.eas.cp.bc.app'))");
        sql.append(" OR (ASSIGN.FBIZOPERATION = 'afterImageReadyHandler'))");
        sql.append(" ORDER BY W ASC");
        return sql.toString();
    }

    protected void constructCurrentNode(WFInstanceVo vo, Map messageMap, ResultSet result) throws SQLException {
        String bizId = BillOfWFMessageControllerBean.formatString(result.getString("FBIZOBJID"));
        String noteName = BillOfWFMessageControllerBean.formatString(result.getString("FACTDEFNAME"));
        String handler = BillOfWFMessageControllerBean.formatString(result.getString("FPERSONEMPNAME"));
        vo = (WFInstanceVo)messageMap.get(bizId);
        if (vo == null) {
            vo = new WFInstanceVo();
            vo.setBillId(bizId);
            vo.setActdefname(noteName);
            HashSet<String> handlerSet = new HashSet<String>();
            handlerSet.add(handler);
            vo.setHandlerName(handlerSet);
            messageMap.put(bizId, vo);
        } else if (vo.getBillId().equals(bizId) && vo.getActdefname().equals(noteName)) {
            Set handlerSet = vo.getHandlerName();
            handlerSet.add(handler);
        } else if (vo.getBillId().equals(bizId) && !BizCollUtil.objectIsNull(noteName) && !BizCollUtil.objectIsNull(vo.getActdefname()) && vo.getActdefname().contains(EASResource.getString((String)RESBIZCOLL, (String)"Sign")) && noteName.contains(EASResource.getString((String)RESBIZCOLL, (String)"Sign"))) {
            vo.setActdefname(vo.getActdefname() + noteName);
            Set handlerSet = vo.getHandlerName();
            handlerSet.add(handler);
        }
    }

    protected String createFilter(Set<String> billId) {
        StringBuffer filter = new StringBuffer();
        Iterator<String> ite = billId.iterator();
        if (ite.hasNext()) {
            filter.append("'").append((Object)ite.next()).append("'");
        }
        while (ite.hasNext()) {
            filter.append(",").append("'").append((Object)ite.next()).append("'");
        }
        return filter.toString();
    }

    protected static String formatString(Object string) {
        return string == null ? "" : string.toString();
    }

    @Override
    protected boolean _getIsWFAuditNote(Context ctx, String billId) throws BOSException, EASBizException {
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)this.getAuditNoteQuerySql(billId, ctx));
            if (null == result) {
                return false;
            }
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected String getAuditNoteQuerySql(String billId, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct ");
        Locale locale = ctx.getOriginLocale();
        if (locale == LocaleUtils.locale_en_US) {
            sql.append(" ASSIGN.FACTDEFNAME_L1 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L1 AS FPERSONEMPNAME ,");
        }
        if (locale == LocaleUtils.locale_zh_CN) {
            sql.append(" ASSIGN.FACTDEFNAME_L2 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L2 AS FPERSONEMPNAME ,");
        }
        if (locale == LocaleUtils.locale_zh_TW) {
            sql.append(" ASSIGN.FACTDEFNAME_L3 AS FACTDEFNAME ,");
            sql.append(" ASSIGN.FPERSONEMPNAME_L3 AS FPERSONEMPNAME ,");
        }
        sql.append(" ASSIGN.FBIZOBJID AS FBIZOBJID ");
        sql.append(" FROM T_WFR_ProcInst AS PROCINST ");
        sql.append(" INNER JOIN T_WFR_Assign AS ASSIGN ON ASSIGN.FPROCINSTID=PROCINST.FPROCINSTID ");
        sql.append(" WHERE (PROCINST.FPROCDEFTYPE = 'NORMAL' OR PROCINST.FPROCDEFTYPE = 'MICRO') ");
        sql.append(" AND PROCINST.FSTATE LIKE 'open%' ");
        sql.append(" AND ASSIGN.FBIZOBJID = ('" + billId + "')");
        sql.append(" AND ASSIGN.FBIZPACKAGE='com.kingdee.eas.base.multiapprove.client' ");
        return sql.toString();
    }

    @Override
    protected IObjectCollection _checkAssignment(Context ctx, String businessObjId, String packageName, String[] operation, String functionName, String userId, String[] selectors) throws BOSException, EASBizException {
        if (businessObjId == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        if (selectors != null && selectors.length > 0) {
            for (int i = 0; i < selectors.length; ++i) {
                sic.add(new SelectorItemInfo(selectors[i]));
            }
        } else {
            sic.add(new SelectorItemInfo("assignID"));
        }
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)businessObjId));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(WfAssignmentState.ASSIGNED.getValue());
        stateSet.add(WfAssignmentState.ACCEPTED.getValue());
        filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.INCLUDE));
        if (packageName != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizPackage", (Object)packageName));
        }
        if (operation != null && operation.length > 0) {
            if (operation.length == 1) {
                filter.getFilterItems().add(new FilterItemInfo("bizOperation", (Object)operation));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("bizOperation", new HashSet<String>(Arrays.asList(operation)), CompareType.INCLUDE));
            }
        }
        if (functionName != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)functionName));
        }
        if (userId != null) {
            filter.getFilterItems().add(new FilterItemInfo("personUserID", (Object)userId));
        }
        viewInfo.setFilter(filter);
        AssignCollection assignColl = AssignFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return assignColl;
    }
}

