/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitFilterFacadeFactory;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BcParamConstant;
import com.kingdee.eas.cp.bc.BgCtrlBizCollHandler;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizBillUtil;
import com.kingdee.eas.cp.bc.BizCollBillBaseCollection;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.IRePaymentBill;
import com.kingdee.eas.cp.bc.IRePaymentFacade;
import com.kingdee.eas.cp.bc.ImageHandlerCollection;
import com.kingdee.eas.cp.bc.ImageHandlerFactory;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.ProxyReimburseFactory;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.RePaymentFacadeFactory;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.app.AbstractBizCollBillFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.ModelWebUtils;
import com.kingdee.eas.cp.bc.util.InvoiceConfiguration;
import com.kingdee.eas.cp.bc.util.NBgControlCallerUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCollBillFacadeControllerBean
extends AbstractBizCollBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizCollBillFacadeControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";
    private IObjectPK saveRelations;

    @Override
    protected IObjectValue _buildModel(Context ctx, IObjectValue object, IObjectValue expenseTypeInfo) throws BOSException, EASBizException {
        Map params;
        CoreBillEntryBaseInfo entry;
        String applierCompanyId;
        Locale local = ctx.getLocale();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)object;
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        billInfo.setApplier(baseInfo.getApplier());
        billInfo.setBiller(user);
        billInfo.setOrgUnit(baseInfo.getOrgUnit());
        billInfo.setApplierCompany(baseInfo.getApplierCompany());
        billInfo.setTel(baseInfo.getTel());
        CompanyOrgUnitInfo companyInfo = baseInfo.getCompany();
        billInfo.setCompany(companyInfo);
        CostCenterOrgUnitInfo costInfo = (CostCenterOrgUnitInfo)ModelWebUtils.simpleClone((CoreBaseInfo)baseInfo.getCostedDept());
        billInfo.setCostedDept(costInfo);
        CurrencyInfo currency = (CurrencyInfo)ModelWebUtils.simpleClone((CoreBaseInfo)baseInfo.getCurrencyType());
        billInfo.setCurrencyType(currency);
        billInfo.setName("CPBCBILL");
        billInfo.setPosition(baseInfo.getPosition());
        billInfo.setBizReqDate(date);
        billInfo.setBillDate(date);
        billInfo.setBizDate(date);
        BigDecimal zero = BizCollUtil.ZERO;
        billInfo.setAmount(zero);
        billInfo.setAmountApproved(zero);
        billInfo.setState(StateEnum.NEW);
        billInfo.setPrior(PriorEnum.LOW);
        if (baseInfo.getApplierCompany() != null) {
            billInfo.setCU(baseInfo.getApplierCompany().getCU());
        } else {
            billInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        String string = applierCompanyId = billInfo.getApplierCompany() == null ? null : billInfo.getApplierCompany().getId().toString();
        if (billInfo instanceof OtherExpenseBillInfo) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP025");
            paramList.add("CP017");
            paramList.add("CP054");
            paramList.add("CP053");
            Map paramObj = null;
            paramObj = billInfo.getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            Object value = paramObj.get("CP017");
            if (Boolean.valueOf(value.toString()).booleanValue()) {
                billInfo.setAmountControlType(AmountControlTypeEnum.oneTOmore);
            } else {
                billInfo.setAmountControlType(AmountControlTypeEnum.oneTOone);
            }
        } else {
            billInfo.setAmountControlType(AmountControlTypeEnum.oneTOmore);
        }
        boolean CP008 = false;
        boolean CP00803 = false;
        boolean CP_BC_BAPS = false;
        boolean CP_BC_TAPS = false;
        boolean CP_BC_PAPS = false;
        boolean CP_BC_BAOPS = false;
        boolean CP_BC_DLPS = false;
        boolean CP_BC_ELPS = false;
        if (billInfo instanceof ExpenseAccountBillInfo || billInfo instanceof LoanBillInfo) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP008");
            paramList.add("CP00803");
            paramList.add("CP_BC_BAPS");
            paramList.add("CP_BC_TAPS");
            paramList.add("CP_BC_PAPS");
            paramList.add("CP_BC_BAOPS");
            paramList.add("CP_BC_DLPS");
            paramList.add("CP_BC_ELPS");
            Map param = null;
            param = billInfo.getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            CP008 = param.get("CP008") == null ? false : new Boolean(param.get("CP008").toString());
            CP00803 = param.get("CP00803") == null ? false : new Boolean(param.get("CP00803").toString());
            CP_BC_BAPS = param.get("CP_BC_BAPS") == null ? false : new Boolean(param.get("CP_BC_BAPS").toString());
            CP_BC_TAPS = param.get("CP_BC_TAPS") == null ? false : new Boolean(param.get("CP_BC_TAPS").toString());
            CP_BC_PAPS = param.get("CP_BC_PAPS") == null ? false : new Boolean(param.get("CP_BC_PAPS").toString());
            CP_BC_BAOPS = param.get("CP_BC_BAOPS") == null ? false : new Boolean(param.get("CP_BC_BAOPS").toString());
            CP_BC_DLPS = param.get("CP_BC_DLPS") == null ? false : new Boolean(param.get("CP_BC_DLPS").toString());
            boolean bl = CP_BC_ELPS = param.get("CP_BC_ELPS") == null ? false : new Boolean(param.get("CP_BC_ELPS").toString());
        }
        if (billInfo instanceof LoanBillInfo) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, 3);
            ((LoanBillInfo)billInfo).setForeseeDate(calendar.getTime());
        }
        billInfo.put("autoSetApprovedAmount", true);
        billInfo.put("getBudgetByOperationType", true);
        billInfo.put("amountEncashed", zero);
        if (billInfo instanceof OtherExpenseBillInfo) {
            ((OtherExpenseBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"OtherExpenseBill", (Locale)local));
            ((OtherExpenseBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            entry = new OtherExpenseBillEntryInfo();
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(zero);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
            }
            ((OtherExpenseBillInfo)billInfo).getEntries().add((OtherExpenseBillEntryInfo)entry);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            ((DailyLoanBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_DLPS);
            ((DailyLoanBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"DailyLoanBill", (Locale)local));
            ((DailyLoanBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            entry = new DailyLoanBillEntryInfo();
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(zero);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
            }
            ((DailyLoanBillInfo)billInfo).getEntries().add((DailyLoanBillEntryInfo)entry);
        } else if (billInfo instanceof BizAccountBillInfo) {
            ((BizAccountBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_BAPS);
            ((BizAccountBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"bizBill", (Locale)local));
            ((BizAccountBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            entry = new BizAccountBillEntryInfo();
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setAmountOriWithoutTax(zero);
            entry.setAmountWithoutTax(zero);
            entry.setAmountApprovedOriWithoutTax(zero);
            entry.setAmountApprovedWithoutTax(zero);
            entry.setTaxRate(zero);
            entry.setTax(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(zero);
            entry.setInvoiceNum(EASResource.getString((String)RESBIZCOLL, (String)"InvoiceNum", (Locale)local));
            if (billInfo.get("params") != null) {
                params = (Map)billInfo.get("params");
                String currencyId = (String)params.get("currencyId");
                String expenseTypeId = (String)params.get("expenseTypeId");
                BigDecimal amount = null;
                if (params.get("amount") != null) {
                    amount = new BigDecimal(params.get("amount").toString());
                }
                if (currencyId != null && expenseTypeId != null) {
                    billInfo.put("isfromaccountlimit", true);
                    ExpenseTypeInfo expensetype = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select id,number,name,displayName,isStart,controlType,controlMethod,operationType.id,operationType.number,operationType.name,operationType.isEnable where id = '" + expenseTypeId + "'");
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(currencyId, null, applierCompanyId, billInfo.getBizReqDate());
                    CurrencyInfo currencyType = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    entry.setExpenseType(expensetype);
                    entry.setOperationType(expensetype.getOperationType());
                    entry.setCurrencyType(currencyType);
                    entry.setTax(zero);
                    entry.setTaxRate(zero);
                    if (exchangeRate == null) {
                        if (!currencyId.equals(billInfo.getCurrencyType().getId().toString())) {
                            entry.setExchangeRate(zero);
                        }
                    } else {
                        entry.setExchangeRate(exchangeRate.getConvertRate());
                        if (exchangeRate.getExchangeAux() != null) {
                            entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                            entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
                        }
                    }
                    if (amount != null) {
                        amount = amount.setScale(2, 4);
                        entry.setAmountOri(amount);
                        entry.setAmountOriWithoutTax(amount);
                        BigDecimal entryAmount = zero;
                        BigDecimal rate = entry.getExchangeRate();
                        if (rate.compareTo(zero) != 0) {
                            entryAmount = entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE) ? amount.divide(rate, 2, 4) : amount.multiply(entry.getExchangeRate()).setScale(2, 4);
                        }
                        entry.setAmount(entryAmount);
                        entry.setAmountWithoutTax(entryAmount);
                    }
                }
            }
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
                entry.setOperationType(((ExpenseTypeInfo)expenseTypeInfo).getOperationType());
            }
            ((BizAccountBillInfo)billInfo).getEntries().add((BizAccountBillEntryInfo)entry);
        } else if (billInfo instanceof EvectionReqBillInfo) {
            ((EvectionReqBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"EvectionReqBill", (Locale)local));
            entry = new EvectionReqBillEntryInfo();
            String expensenTypeId = (String)billInfo.get("expensetypeid");
            String vehicle = (String)billInfo.get("vehicle");
            String startDate = (String)billInfo.get("startDate");
            String endDate = (String)billInfo.get("endDate");
            String from = (String)billInfo.get("from");
            String to = (String)billInfo.get("to");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (!BizCollUtil.objectIsNull(startDate)) {
                    Date sdate = sdf.parse(startDate);
                    entry.setStartDate(sdate);
                }
                if (!BizCollUtil.objectIsNull(endDate)) {
                    Date edate = sdf.parse(endDate);
                    entry.setEndDate(edate);
                }
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (expensenTypeId != null) {
                ExpenseTypeInfo expenseType = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)expensenTypeId)));
                entry.setExpenseType(expenseType);
            }
            entry.setFrom(from);
            entry.setTo(to);
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setVehicle(VehicleEnum.AIRPLANE);
            if (vehicle != null && !vehicle.equals("null")) {
                entry.setVehicle(VehicleEnum.getEnum(Integer.valueOf(vehicle)));
            }
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(zero);
            entry.setHotelExpense(zero);
            entry.setBussesExpense(zero);
            entry.setOtherExpense(zero);
            entry.setTaxiExpense(zero);
            entry.setEventionSubsidy(zero);
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
            }
            ((EvectionReqBillInfo)billInfo).getEntries().add((EvectionReqBillEntryInfo)entry);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            ((BizAccountOutBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_BAOPS);
            ((BizAccountOutBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"BizAccountOutBill", (Locale)local));
            ((BizAccountOutBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            ((BizAccountOutBillInfo)billInfo).setPayerType(PayerTypeEnum.supplier);
            entry = new BizAccountOutBillEntryInfo();
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setAmountOriWithoutTax(zero);
            entry.setAmountWithoutTax(zero);
            entry.setAmountApprovedOriWithoutTax(zero);
            entry.setAmountApprovedWithoutTax(zero);
            entry.setTaxRate(zero);
            entry.setTax(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(zero);
            entry.setInvoiceNum(EASResource.getString((String)RESBIZCOLL, (String)"InvoiceNum", (Locale)local));
            if (billInfo.get("params") != null) {
                params = (Map)billInfo.get("params");
                String currencyId = (String)params.get("currencyId");
                String expenseTypeId = (String)params.get("expenseTypeId");
                BigDecimal amount = null;
                if (params.get("amount") != null) {
                    amount = new BigDecimal(params.get("amount").toString());
                }
                if (currencyId != null && expenseTypeId != null) {
                    ExpenseTypeInfo expensetype = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select id,number,name,isStart,controlType,controlMethod,operationType.id,operationType.number,operationType.name,operationType.isEnable where id = '" + expenseTypeId + "'");
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(currencyId, null, applierCompanyId, billInfo.getBizReqDate());
                    CurrencyInfo currencyType = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    entry.setExpenseType(expensetype);
                    entry.setOperationType(expensetype.getOperationType());
                    entry.setCurrencyType(currencyType);
                    if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                        entry.setExchangeRate(exchangeRate.getConvertRate());
                    }
                    if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                        entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                        entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
                    }
                    if (amount != null) {
                        entry.setAmountOri(amount.setScale(2));
                        if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            entry.setAmount(amount.divide(entry.getExchangeRate()).setScale(2));
                        } else {
                            entry.setAmount(amount.multiply(entry.getExchangeRate()).setScale(2));
                        }
                    }
                }
            }
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
                entry.setOperationType(((ExpenseTypeInfo)expenseTypeInfo).getOperationType());
            }
            ((BizAccountOutBillInfo)billInfo).getEntries().add((BizAccountOutBillEntryInfo)entry);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            ((DailyPurchaseAccountBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_PAPS);
            ((DailyPurchaseAccountBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"DailyPurchaseAccountBill", (Locale)local));
            ((DailyPurchaseAccountBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            ((DailyPurchaseAccountBillInfo)billInfo).setPayerType(PayerTypeEnum.supplier);
            entry = new DailyPurchaseAccountBillEntryInfo();
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setAmountWithoutTax(zero);
            entry.setAmountOriWithoutTax(zero);
            entry.setAmountApprovedOriWithoutTax(zero);
            entry.setAmountApprovedWithoutTax(zero);
            entry.setTax(zero);
            entry.setTaxRate(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setPrice(zero);
            entry.setPriceWithTax(zero);
            entry.setCount(zero);
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(zero);
            entry.setInvoiceNum(EASResource.getString((String)RESBIZCOLL, (String)"InvoiceNum", (Locale)local));
            if (billInfo.get("params") != null) {
                params = (Map)billInfo.get("params");
                String currencyId = (String)params.get("currencyId");
                String expenseTypeId = (String)params.get("expenseTypeId");
                BigDecimal amount = null;
                if (params.get("amount") != null) {
                    amount = new BigDecimal(params.get("amount").toString());
                }
                if (currencyId != null && expenseTypeId != null) {
                    ExpenseTypeInfo expensetype = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select id,number,name,isStart,controlType,controlMethod,operationType.id,operationType.number,operationType.name,operationType.isEnable where id = '" + expenseTypeId + "'");
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(currencyId, null, applierCompanyId, billInfo.getBizReqDate());
                    CurrencyInfo currencyType = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    entry.setExpenseType(expensetype);
                    entry.setOperationType(expensetype.getOperationType());
                    entry.setCurrencyType(currencyType);
                    if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                        entry.setExchangeRate(exchangeRate.getConvertRate());
                    }
                    if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                        entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                        entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
                    }
                    if (amount != null) {
                        entry.setAmountOri(amount.setScale(2));
                        if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            entry.setAmount(amount.divide(entry.getExchangeRate()).setScale(2));
                        } else {
                            entry.setAmount(amount.multiply(entry.getExchangeRate()).setScale(2));
                        }
                    }
                }
            }
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
                entry.setOperationType(((ExpenseTypeInfo)expenseTypeInfo).getOperationType());
            }
            ((DailyPurchaseAccountBillInfo)billInfo).getEntries().add((DailyPurchaseAccountBillEntryInfo)entry);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            ((EvectionLoanBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_ELPS);
            ((EvectionLoanBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"EvectionLoanBill", (Locale)local));
            ((EvectionLoanBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            entry = new EvectionLoanBillEntryInfo();
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setVehicle(VehicleEnum.AIRPLANE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(zero);
            entry.setHotelExpense(zero);
            entry.setBussesExpense(zero);
            entry.setOtherExpense(zero);
            entry.setTaxiExpense(zero);
            entry.setEventionSubsidy(zero);
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
            }
            ((EvectionLoanBillInfo)billInfo).getEntries().add((EvectionLoanBillEntryInfo)entry);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            ((TravelAccountBillInfo)billInfo).setIsPaySchedule(CP008 && CP00803 && CP_BC_TAPS);
            ((TravelAccountBillInfo)billInfo).setName(ResourceBase.getString((String)RESBIZCOLL, (String)"TravelAccountBill", (Locale)local));
            ((TravelAccountBillInfo)billInfo).setPayMode(this.getDefaultPayMode(ctx));
            entry = new TravelAccountBillEntryInfo();
            entry.setPurpose("");
            entry.setVehicle(VehicleEnum.AIRPLANE);
            entry.setAmount(zero);
            entry.setAmountApproved(zero);
            entry.setAmountOri(zero);
            entry.setAmountApprovedOri(zero);
            entry.setAmountWithoutTax(zero);
            entry.setAmountOriWithoutTax(zero);
            entry.setAmountApprovedOriWithoutTax(zero);
            entry.setAmountApprovedWithoutTax(zero);
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setTaxiExpense(zero);
            entry.setTaxiExpenseWithoutTax(zero);
            entry.setTaxiExpenseTax(zero);
            entry.setTaxiExpenseTaxRate(zero);
            entry.setBussesExpense(zero);
            entry.setBussesExpenseWithoutTax(zero);
            entry.setBussesExpenseTax(zero);
            entry.setBussesExpenseTaxRate(zero);
            entry.setCadFund(zero);
            entry.setHotelExpense(zero);
            entry.setHotelExpenseWithoutTax(zero);
            entry.setOtherExpense(zero);
            entry.setOtherExpenseWithoutTax(zero);
            entry.setOtherExpenseTax(zero);
            entry.setOtherExpenseTaxRate(zero);
            entry.setEventionSubsidy(zero);
            entry.setAllowanceDays(BizCollUtil.ONE);
            entry.setRoomDays(zero);
            entry.setPlaneExpense(zero);
            entry.setCarRentalExpense(zero);
            entry.setTax(zero);
            entry.setTaxRate(zero);
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(zero);
            entry.setInvoiceNum(EASResource.getString((String)RESBIZCOLL, (String)"InvoiceNum", (Locale)local));
            if (billInfo.get("params") != null) {
                params = (Map)billInfo.get("params");
                String currencyId = (String)params.get("currencyId");
                String expenseTypeId = (String)params.get("expenseTypeId");
                BigDecimal amount = null;
                if (params.get("amount") != null) {
                    amount = new BigDecimal(params.get("amount").toString());
                }
                if (currencyId != null && expenseTypeId != null) {
                    ExpenseTypeInfo expensetype = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select id,number,name,isStart,controlType,controlMethod,operationType.id,operationType.number,operationType.name,operationType.isEnable where id = '" + expenseTypeId + "'");
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(currencyId, null, applierCompanyId, billInfo.getBizReqDate());
                    CurrencyInfo currencyType = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    entry.setExpenseType(expensetype);
                    entry.setOperationType(expensetype.getOperationType());
                    entry.setCurrencyType(currencyType);
                    if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                        entry.setExchangeRate(exchangeRate.getConvertRate());
                    }
                    if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                        entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                        entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
                    }
                    if (amount != null) {
                        entry.setAmountOri(amount.setScale(2));
                        if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            entry.setAmount(amount.divide(entry.getExchangeRate()).setScale(2));
                        } else {
                            entry.setAmount(amount.multiply(entry.getExchangeRate()).setScale(2));
                        }
                    }
                }
            }
            if (!BizCollUtil.objectIsNull(expenseTypeInfo)) {
                entry.setExpenseType((ExpenseTypeInfo)expenseTypeInfo);
                entry.setOperationType(((ExpenseTypeInfo)expenseTypeInfo).getOperationType());
            }
            ((TravelAccountBillInfo)billInfo).getEntries().add((TravelAccountBillEntryInfo)entry);
        }
        ModelWebUtils.reduceModel2((CoreBaseInfo)billInfo, "applier", "biller", "orgUnit", "creator", "position");
        if (baseInfo.getApplierCompany() != null) {
            billInfo.getApplierCompany().setCU(baseInfo.getApplierCompany().getCU());
        }
        if (baseInfo.getCompany() != null) {
            billInfo.getCompany().setCU(baseInfo.getCompany().getCU());
        }
        if (baseInfo.getCompany() != null) {
            billInfo.getCompany().setLongNumber(baseInfo.getCompany().getLongNumber());
        }
        if (!(billInfo instanceof OtherExpenseBillInfo) && !(billInfo instanceof EvectionReqBillInfo)) {
            BizBillUtil.initDefaultPersonalBank(ctx, billInfo, null, true);
        }
        return billInfo;
    }

    @Override
    protected Map _initModelDataForViewLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (currentUserInfo.getType() != null && currentUserInfo.getType() != UserType.PERSON) {
            throw new BizCollException(BizCollException.USERTYPEISWRONG);
        }
        HashMap<String, Object> initData = new HashMap<String, Object>();
        try {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP001");
            paramList.add("CP002");
            paramList.add("CP008");
            paramList.add("CP00803");
            paramList.add("CP_BC_BAPS");
            paramList.add("CP_BC_TAPS");
            paramList.add("CP_BC_PAPS");
            paramList.add("CP_BC_BAOPS");
            paramList.add("CP_BC_DLPS");
            paramList.add("CP_BC_ELPS");
            paramList.add("CP010");
            paramList.add("CP011");
            paramList.add("CP018");
            paramList.add("CP019");
            paramList.add("CP025");
            paramList.add("CP023");
            paramList.add("CP017");
            paramList.add("CP020");
            paramList.add("CP027");
            paramList.add("CP028");
            paramList.add("CP029");
            paramList.add("CP030");
            paramList.add("CP031");
            paramList.add("CP032");
            paramList.add("CP033");
            paramList.add("CP036");
            paramList.add("CP037");
            paramList.add("CP039");
            paramList.add("CP03904");
            paramList.add("CP042");
            paramList.add("CP045");
            paramList.add("CP046");
            paramList.add("CP049");
            paramList.add("CP070");
            paramList.add("CP075");
            paramList.add("CP076");
            paramList.add("IsSSC");
            paramList.add("NotCloseEvectionReqBill");
            paramList.add("IsPaperParkIntegration");
            paramList.add("CP050");
            paramList.add("CP051");
            paramList.add("CP05101");
            paramList.add("CP053");
            paramList.add("CP054");
            paramList.add("CP065");
            paramList.add("CP_BC_STATEPRINT");
            String bosTypestr = model.getBOSType().toString();
            Map paramMap = null;
            paramMap = model.get("applierCompany") != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, ((CompanyOrgUnitInfo)model.get("applierCompany")).getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            paramMap.put("CP_BC_ALLSTATES", BcParamConstant.ALLSTATELIST);
            initData.putAll(paramMap);
            if (bosTypestr.equalsIgnoreCase("DE853384")) {
                boolean isPass = false;
                if (paramMap.get("NotCloseEvectionReqBill") == null || !new Boolean(paramMap.get("NotCloseEvectionReqBill").toString()).booleanValue()) {
                    isPass = CommonDataWebUtils.checkBillHasNextBill(ctx, (BizCollBillBaseInfo)model);
                }
                initData.put("ispass", isPass);
            }
            if (bosTypestr.equalsIgnoreCase("8110AAB2") || bosTypestr.equalsIgnoreCase("DE853384") || bosTypestr.equalsIgnoreCase("7AE53B38") || bosTypestr.equalsIgnoreCase("E76173AD")) {
                Boolean isclose = CommonDataWebUtils.checkForBillClose(ctx, model.get("id").toString());
                initData.put("isclose", isclose);
            }
            String personId = currentUserInfo.getPerson().getId().toString();
            initData.put("personId", personId);
            List queryReimbursePersons = ProxyReimburseFactory.getLocalInstance(ctx).queryReimbursePerson(personId);
            initData.put("reimbursePersons", queryReimbursePersons);
            List queryAdminOrg = ProxyReimburseFactory.getLocalInstance(ctx).queryAdminOrgUnit(personId);
            initData.put("adminOrgs", queryAdminOrg);
            PersonInfo applierInfo = (PersonInfo)model.get("applier");
            if (applierInfo != null) {
                List personIds = ProxyReimburseFactory.getLocalInstance(ctx).getPersonIdsByAdminOrg(queryAdminOrg);
                if (personIds.contains(applierInfo.getId().toString()) || queryReimbursePersons.contains(applierInfo.getId().toString())) {
                    initData.put("haveProxy", true);
                } else {
                    initData.put("haveProxy", false);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return initData;
    }

    @Override
    protected Map _initModelDataForEditLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson() == null ? null : user.getPerson().getId().toString();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP010");
        paramList.add("CP011");
        paramList.add("CP018");
        paramList.add("CP019");
        paramList.add("CP020");
        paramList.add("CP027");
        paramList.add("CP028");
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP031");
        paramList.add("CP032");
        paramList.add("CP033");
        paramList.add("CP036");
        paramList.add("CP037");
        paramList.add("CP039");
        paramList.add("CP03904");
        paramList.add("CP044");
        paramList.add("CP045");
        paramList.add("CP046");
        paramList.add("CP049");
        paramList.add("IsSSC");
        paramList.add("IsPaperParkIntegration");
        paramList.add("CP050");
        paramList.add("CP054");
        paramList.add("CP051");
        paramList.add("CP05101");
        paramList.add("CP053");
        paramList.add("CP065");
        paramList.add("CP_BC_STATEPRINT");
        paramList.add("CP085");
        Map paramMap = null;
        paramMap = model.get("applierCompany") != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, ((CompanyOrgUnitInfo)model.get("applierCompany")).getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        String projectIsolateParam = BizBillUtil.getProjectIsolateParam(ctx);
        paramMap.put("Projectlsolate", projectIsolateParam);
        paramMap.put("CP_BC_ALLSTATES", BcParamConstant.ALLSTATELIST);
        initData.putAll(paramMap);
        if (personId != null) {
            initData.put("personId", personId);
        }
        CompanyOrgUnitInfo company = model.get("applierCompany") != null ? (CompanyOrgUnitInfo)model.get("applierCompany") : ContextUtil.getCurrentFIUnit((Context)ctx);
        initData.put("adminOrgUnitIds", CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx, company));
        if (model.get("applier") != null) {
            Map relatedInfoMap = CommonDataWebUtils.getApplierRelatedInfo(ctx, ((IObjectValue)model.get("applier")).get("id").toString());
            initData.putAll(relatedInfoMap);
        }
        Set orgRangeSet = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, user.getId().toString(), String.valueOf(10), null);
        initData.put("orgRangeSet", orgRangeSet);
        Boolean isDelimitUserOrgScope = Boolean.valueOf((String)paramMap.get("CP019"));
        initData.put("companyFilter", CommonDataWebUtils.getCompanyFilter(ctx, orgRangeSet, isDelimitUserOrgScope));
        initData.put("CP054", Boolean.valueOf((String)paramMap.get("CP054")));
        initData.put("CP053", Boolean.valueOf((String)paramMap.get("CP053")));
        return initData;
    }

    @Override
    protected void _abandon(Context ctx, List ids) throws BOSException, EASBizException {
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            BOSUuid uid = BOSUuid.read((String)it.next().toString());
            ObjectUuidPK objpk = new ObjectUuidPK(uid);
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("applierCompany.id"));
            sic.add(new SelectorItemInfo("state"));
            CoreBillBaseInfo info = (CoreBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, sic);
            boolean hasWorkFlow = CommonWebUtilFacadeFactory.getLocalInstance(ctx).hasWorkflow(uid.toString());
            IBizCtrl iBizCtrl = this.getEntityBizInterface(ctx, uid.getType());
            if (info instanceof BizCollBillBaseInfo) {
                if (((BizCollBillBaseInfo)info).getState().getValue() != 25) {
                    throw new BizCollException(BizCollException.CAN_NOT_ABANDON);
                }
                IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)iBizCtrl;
                if (!hasWorkFlow) {
                    ExpenseCommenFacadeFactory.getLocalInstance(ctx).returnBudget(info.getId(), (BizCollBillBaseInfo)info, false);
                    IExpenseAccountFacade iExpenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
                    iExpenseAccountFacade.setAbandonStateWithoutWorkFlow(uid);
                    continue;
                }
                iBizCollBillBase.abandon(uid);
                continue;
            }
            if (!(info instanceof RePaymentBillInfo)) continue;
            if (((RePaymentBillInfo)info).getState().getValue() != 25) {
                throw new BizCollException(BizCollException.CAN_NOT_ABANDON);
            }
            IRePaymentBill iRePaymentBill = (IRePaymentBill)iBizCtrl;
            if (!hasWorkFlow) {
                IRePaymentFacade iRePaymentFacade = RePaymentFacadeFactory.getLocalInstance(ctx);
                iRePaymentFacade.setAbandonState(uid);
                continue;
            }
            iRePaymentBill.abandon(uid);
        }
    }

    private BizCollBillBaseInfo getBizCollBillBaseInfo(Context ctx, String billId) throws BOSException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        return billInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    protected void _close(Context ctx, String id) throws BOSException, EASBizException {
        BOSUuid uid = BOSUuid.read((String)id);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP001");
        paramList.add("CP051");
        Map paramMap = null;
        boolean loanBillUseBg = false;
        boolean reqBillUseBg = false;
        boolean isNeedBudget = false;
        boolean eveReqBillUseBg = false;
        if (uid.getType().toString().equalsIgnoreCase("E76173AD")) {
            OtherExpenseBillInfo billInfo = OtherExpenseBillFactory.getLocalInstance(ctx).getOtherExpenseBillInfo((IObjectPK)new ObjectUuidPK(uid));
            if (billInfo.getApplierCompany() == null) {
                throw new BizCollException(BizCollException.APPLIERCOMPANYNOTNULL);
            }
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
            loanBillUseBg = paramMap.get("CP029") == null ? false : new Boolean(paramMap.get("CP029").toString());
            reqBillUseBg = paramMap.get("CP030") == null ? false : new Boolean(paramMap.get("CP030").toString());
            isNeedBudget = new Boolean(paramMap.get("CP001").toString());
            Boolean isPass = CommonWebUtilFacadeFactory.getLocalInstance(ctx).checkForBillClose(billInfo.getId().toString());
            if (!StateEnum.CHECKED.equals((Object)billInfo.getState()) || !isPass.booleanValue()) throw new BizCollException(BizCollException.OTHEREXPENSEBILLCLOSEERROR);
            if (isNeedBudget && reqBillUseBg) {
                BgCtrlBizCollHandler.setBugdutDoForClose(ctx, billInfo, reqBillUseBg);
                NBgControlCallerUtil.requestBudget(ctx, billInfo.getId());
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("amountBalance"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("lastUpdateUser"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("entries.amountBalance"));
            sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
            sic.add(new SelectorItemInfo("entries.budgetBalance"));
            BizCollUtil.setBillStateReverse(billInfo, StateEnum.CLOSED);
            billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            OtherExpenseBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_close", (BOSObjectType)uid.getType(), (IObjectPK)new ObjectUuidPK(uid), (String)("_close setNowState \u5355\u636e\u5173\u95ed state=" + (Object)((Object)StateEnum.CLOSED) + ",number\uff1a" + billInfo.get("number") + ",billId=" + uid));
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            return;
        } else if (uid.getType().toString().equalsIgnoreCase("8110AAB2") || uid.getType().toString().equalsIgnoreCase("7AE53B38")) {
            LoanBillInfo billInfo = null;
            billInfo = uid.getType().toString().equalsIgnoreCase("8110AAB2") ? DailyLoanBillFactory.getLocalInstance(ctx).getDailyLoanBillInfo((IObjectPK)new ObjectUuidPK(uid)) : EvectionLoanBillFactory.getLocalInstance(ctx).getEvectionLoanBillInfo((IObjectPK)new ObjectUuidPK(uid));
            if (billInfo.getApplierCompany() == null) {
                throw new BizCollException(BizCollException.APPLIERCOMPANYNOTNULL);
            }
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
            loanBillUseBg = paramMap.get("CP029") == null ? false : new Boolean(paramMap.get("CP029").toString());
            reqBillUseBg = paramMap.get("CP030") == null ? false : new Boolean(paramMap.get("CP030").toString());
            isNeedBudget = new Boolean(paramMap.get("CP001").toString());
            Boolean isPass = CommonWebUtilFacadeFactory.getLocalInstance(ctx).checkForBillClose(billInfo.getId().toString());
            if (!isPass.booleanValue()) throw new BizCollException(BizCollException.CLOSEERROR);
            if (billInfo.getLoanState().equals("Y") || billInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT) && billInfo.getAmountBalance().doubleValue() <= 0.0) {
                LoanBillInfo info = billInfo;
                if (isNeedBudget && loanBillUseBg) {
                    BgCtrlBizCollHandler.setBugdutDoForClose(ctx, info, reqBillUseBg);
                    NBgControlCallerUtil.requestBudget(ctx, billInfo.getId());
                }
                IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
                facade.setState(uid, StateEnum.CLOSED);
                billInfo.setAmountBalance(BizCollUtil.ZERO);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("amountBalance"));
                DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
                return;
            } else {
                if (!this.isNotRelaFiAndVoucher(ctx, billInfo.getApplierCompany().getId().toString()) || !billInfo.getState().equals((Object)StateEnum.CHECKED)) throw new BizCollException(BizCollException.CLOSESTATEERROR);
                LoanBillInfo info = billInfo;
                if (isNeedBudget && loanBillUseBg) {
                    BgCtrlBizCollHandler.setBugdutDoForClose(ctx, info, reqBillUseBg);
                    NBgControlCallerUtil.requestBudget(ctx, billInfo.getId());
                }
                IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
                facade.setState(uid, StateEnum.CLOSED);
                if (billInfo.getAmountBalance() != null && billInfo.getAmountBalance().compareTo(BizCollUtil.ZERO) > 0) {
                    billInfo.setReturnAmount(billInfo.getAmountBalance());
                } else {
                    billInfo.setReturnAmount(BizCollUtil.ZERO);
                }
                billInfo.setReturnDate(new Date());
                billInfo.setLoanState("Y");
                billInfo.setAmountBalance(BizCollUtil.ZERO);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("loanState"));
                sic.add(new SelectorItemInfo("returnDate"));
                sic.add(new SelectorItemInfo("returnAmount"));
                sic.add(new SelectorItemInfo("amountBalance"));
                DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
            }
            return;
        } else if (uid.getType().toString().equalsIgnoreCase("DE853384")) {
            EvectionReqBillInfo billInfo = EvectionReqBillFactory.getLocalInstance(ctx).getEvectionReqBillInfo((IObjectPK)new ObjectUuidPK(uid));
            if (billInfo.getApplierCompany() == null) {
                throw new BizCollException(BizCollException.APPLIERCOMPANYNOTNULL);
            }
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
            isNeedBudget = new Boolean(paramMap.get("CP001").toString());
            eveReqBillUseBg = new Boolean(paramMap.get("CP051").toString());
            Boolean isPass = CommonWebUtilFacadeFactory.getLocalInstance(ctx).checkForBillClose(billInfo.getId().toString());
            if (!isPass.booleanValue() || !StateEnum.CHECKED.equals((Object)billInfo.getState())) throw new BizCollException(BizCollException.OTHEREXPENSEBILLCLOSEERROR);
            boolean isBudgetMul = BizCollUtil.checkEveReqBillUseBg(isNeedBudget, eveReqBillUseBg);
            if (isBudgetMul) {
                BgCtrlBizCollHandler.setBugdutDoForClose(ctx, billInfo, isBudgetMul);
                NBgControlCallerUtil.specialBudget(ctx, billInfo.getId());
            }
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            facade.setState(uid, StateEnum.CLOSED);
            billInfo.setAmountBalance(BizCollUtil.ZERO);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("amountBalance"));
            EvectionReqBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
            return;
        } else {
            if (!uid.getType().toString().equalsIgnoreCase("4A44F49F") && !uid.getType().toString().equalsIgnoreCase("C57003BC") && !uid.getType().toString().equalsIgnoreCase("92F938DD") && !uid.getType().toString().equalsIgnoreCase("30BD2798")) return;
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            facade.setState(uid, StateEnum.CLOSED);
        }
    }

    @Override
    protected List _getCollection(Context ctx, String bosType, String view) throws BOSException, EASBizException {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        try {
            IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(new BOSObjectType(bosType), new EntityViewInfo(view));
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result.add((IObjectValue)it.next());
            }
        }
        catch (ParserException e) {
            logger.error((Object)e);
        }
        return result;
    }

    protected SettlementTypeInfo getDefaultPayMode(Context context) {
        SettlementTypeInfo settle = null;
        try {
            ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)context);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
            viewInfo.setFilter(filter);
            SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
            if (collPay != null && collPay.size() > 0) {
                settle = collPay.get(0);
            }
        }
        catch (BOSException e) {
            settle = null;
        }
        return settle;
    }

    private boolean isNotRelaFiAndVoucher(Context context, String companyId) throws EASBizException, BOSException {
        boolean isRelaFi = true;
        boolean isRelaCn = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(context).getParamsForCompany(paramList, companyId);
        isRelaFi = new Boolean(paramMap.get("CP002").toString());
        isRelaCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        return !isRelaFi && !isRelaCn;
    }

    @Override
    protected String _save(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        IObjectPK objectPK = null;
        if (dataObject instanceof CoreBillBaseInfo && dataObject.get("id") != null) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection btpRelationCollection = iBTPManager.getRelationCollection(dataObject.get("id").toString());
            objectPK = iBTPManager.saveRelations((CoreBillBaseInfo)dataObject, btpRelationCollection);
        } else {
            ICoreBase iCoreBase = (ICoreBase)CommonDataWebUtils.getEntityBizInterface(ctx, dataObject.getBOSType());
            objectPK = iCoreBase.save((CoreBaseInfo)dataObject);
        }
        return objectPK.toString();
    }

    @Override
    protected String _submit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        String strNextPartipants;
        Locale local = ctx.getLocale();
        ICoreBase iCoreBase = (ICoreBase)CommonDataWebUtils.getEntityBizInterface(ctx, dataObject.getBOSType());
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String serviceDefId = dataObject.getString("ISERVICE_ServiceID");
        if (!StringUtils.isEmpty((String)serviceDefId)) {
            dataObject.setExtendedProperty("ISERVICE_ServiceID", serviceDefId);
        }
        boolean blnNeedCheckNextPartipants = false;
        if (dataObject.get("blnneedchecknextpartipants") != null) {
            blnNeedCheckNextPartipants = (Boolean)dataObject.get("blnneedchecknextpartipants");
        }
        if ((strNextPartipants = (String)dataObject.get("strnextpartipants")) != null) {
            dataObject.setExtendedProperty("DesignateNextActivityPerformerWhenSubmit", strNextPartipants);
        }
        if (this.shouldCheckNextPartipants(ctx, (CoreBaseInfo)dataObject)) {
            String boId = ((CoreBaseInfo)dataObject).getId() == null ? "" : ((CoreBaseInfo)dataObject).getId().toString();
            try {
                String msg;
                if (blnNeedCheckNextPartipants && !StringUtils.isEmpty((String)(msg = PostParticipantUtil.checkNextParticipants((IObjectValue)((CoreBaseInfo)dataObject), (String)boId, null, null, (Context)ctx)))) {
                    String noNextperformer = ResourceBase.getString((String)RESBIZCOLL, (String)"noNextperformer", (Locale)local);
                    IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
                    AssignmentInfo assignmentInfo = enactmentService.checkAssignmentInfo(((CoreBaseInfo)dataObject).getBOSType().toString(), ctx.getCaller().toString());
                    if (assignmentInfo == null) {
                        EASBizException e = new EASBizException(new NumericExceptionSubItem(null, noNextperformer));
                        throw e;
                    }
                    noNextperformer = noNextperformer + " assignment:<";
                    EASBizException e = new EASBizException(new NumericExceptionSubItem(null, noNextperformer + assignmentInfo.getAssignmentId() + ">"));
                    throw e;
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        IObjectPK objectPK = null;
        if (dataObject instanceof CoreBillBaseInfo && dataObject.get("id") != null) {
            BOTRelationCollection btpRelationCollection = iBTPManager.getRelationCollection(dataObject.get("id").toString());
            objectPK = iBTPManager.submitRelations((CoreBillBaseInfo)dataObject, btpRelationCollection);
        } else {
            objectPK = iCoreBase.submit((CoreBaseInfo)dataObject);
        }
        return objectPK.toString();
    }

    private boolean shouldCheckNextPartipants(Context context, CoreBaseInfo billInfo) throws BOSException, EASBizException {
        Locale local = context.getLocale();
        boolean flag = true;
        try {
            AssignatePersonsInfo assignatePersons;
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
            String procDefId = service.findSubmitProcDef(context.getCaller().toString(), (IObjectValue)billInfo, null, null);
            if (StringUtils.isEmpty((String)procDefId)) {
                flag = false;
            }
            if ((assignatePersons = service.checkPostActivitiesPersonsResult(procDefId, context.getCaller().toString())) != null) {
                String s = billInfo.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
                boolean blnNeedCheckNextPartipants = true;
                if (billInfo.get("blnneedchecknextpartipants") != null) {
                    blnNeedCheckNextPartipants = (Boolean)billInfo.get("blnneedchecknextpartipants");
                }
                if (assignatePersons.isSetNextPersonBeforeSubmit() && s == null && blnNeedCheckNextPartipants) {
                    EASBizException e = new EASBizException(new NumericExceptionSubItem(null, ResourceBase.getString((String)RESBIZCOLL, (String)"submitNoNextPerformer", (Locale)local)));
                    throw e;
                }
            }
        }
        catch (BOSException exception) {
            throw exception;
        }
        catch (EASBizException exception) {
            throw exception;
        }
        catch (Exception e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    protected Map _initDataForListLoad(Context ctx) throws BOSException, EASBizException {
        OrgUnitCollection appliyerComColl;
        AdminOrgUnitInfo adminOrgUnitInfo;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (user.getType() != null && user.getType() != UserType.PERSON) {
            throw new BizCollException(BizCollException.USERTYPEISWRONG);
        }
        String personId = user.getPerson().getId().toString();
        resultMap.put("personId", personId);
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        CompanyOrgUnitInfo extCompany = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getFilterWithCompany(currentCompany);
        resultMap.put("extCompany", extCompany);
        CompanyOrgUnitInfo applierCompany = null;
        if (!(currentCompany != null && currentCompany.isIsBizUnit() || (adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId))) == null || (appliyerComColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminOrgUnitInfo.getId().toString(), 0, 1)) == null || appliyerComColl.size() <= 0)) {
            applierCompany = (CompanyOrgUnitInfo)appliyerComColl.get(0);
            resultMap.put("applierCompany", applierCompany);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP003");
        paramList.add("CP008");
        paramList.add("CP00803");
        paramList.add("CP_BC_BAPS");
        paramList.add("CP_BC_TAPS");
        paramList.add("CP_BC_PAPS");
        paramList.add("CP_BC_BAOPS");
        paramList.add("CP_BC_DLPS");
        paramList.add("CP_BC_ELPS");
        paramList.add("CP018");
        paramList.add("CP021");
        paramList.add("CP02101");
        paramList.add("CP023");
        paramList.add("CP024");
        paramList.add("CP033");
        paramList.add("CP034");
        paramList.add("CP035");
        paramList.add("CP036");
        paramList.add("CP037");
        paramList.add("CP039");
        paramList.add("CP042");
        paramList.add("CP04401");
        paramList.add("CP049");
        paramList.add("IsPaperParkIntegration");
        paramList.add("IsSSC");
        paramList.add("CP050");
        paramList.add("CP051");
        paramList.add("CP05101");
        paramList.add("CP053");
        paramList.add("CP054");
        paramList.add("CP065");
        paramList.add("CP_BC_STATEPRINT");
        paramList.add("CP088");
        paramList.add("CP00802");
        paramList.add("CP00801");
        Map params = null;
        params = applierCompany != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompany.getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        boolean isNeedLoan = Boolean.valueOf((String)params.get("CP001"));
        boolean usedWithFi = Boolean.valueOf((String)params.get("CP002"));
        boolean usedWithCn = Boolean.valueOf((String)params.get("CP008"));
        boolean CP00803 = params.get("CP00803") == null ? false : new Boolean(params.get("CP00803").toString());
        boolean CP_BC_BAPS = params.get("CP_BC_BAPS") == null ? false : new Boolean(params.get("CP_BC_BAPS").toString());
        boolean CP_BC_TAPS = params.get("CP_BC_TAPS") == null ? false : new Boolean(params.get("CP_BC_TAPS").toString());
        boolean CP_BC_PAPS = params.get("CP_BC_PAPS") == null ? false : new Boolean(params.get("CP_BC_PAPS").toString());
        boolean CP_BC_BAOPS = params.get("CP_BC_BAOPS") == null ? false : new Boolean(params.get("CP_BC_BAOPS").toString());
        boolean CP_BC_DLPS = params.get("CP_BC_DLPS") == null ? false : new Boolean(params.get("CP_BC_DLPS").toString());
        boolean CP_BC_ELPS = params.get("CP_BC_ELPS") == null ? false : new Boolean(params.get("CP_BC_ELPS").toString());
        boolean isShowLongName = Boolean.valueOf((String)params.get("CP018"));
        boolean deleteAbandon = Boolean.valueOf((String)params.get("CP023"));
        boolean IsPaperParkIntegration = Boolean.valueOf((String)params.get("IsPaperParkIntegration"));
        boolean isSSC = Boolean.valueOf((String)params.get("IsSSC"));
        boolean accountBillCanVoucher = Boolean.valueOf((String)params.get("CP024"));
        boolean isShowProject = Boolean.valueOf((String)params.get("CP033"));
        boolean usedWithProfitCenterFi = Boolean.valueOf((String)params.get("CP003"));
        boolean enablePayment = Boolean.valueOf((String)params.get("CP034"));
        boolean usedWithAp = Boolean.valueOf((String)params.get("CP042"));
        boolean cp050 = Boolean.valueOf((String)params.get("CP050"));
        boolean isRelaCnVoucher = Boolean.valueOf((String)params.get("CP00802"));
        boolean onlyAlreadyPaymentCanCreateVoucher = params.get("CP00801") == null ? false : new Boolean(params.get("CP00801").toString());
        boolean CP065 = params.get("CP065") == null ? false : new Boolean(params.get("CP065").toString());
        String CP_BC_STATEPRINT = params.get("CP_BC_STATEPRINT") == null ? "" : params.get("CP_BC_STATEPRINT").toString();
        String actorLocation = "default";
        String queryImageOql = "select sscUnit.name where handler.id = '" + personId + "'";
        ImageHandlerCollection imageHandlerCollection = ImageHandlerFactory.getLocalInstance(ctx).getImageHandlerCollection(queryImageOql);
        if (imageHandlerCollection.size() > 0) {
            actorLocation = imageHandlerCollection.get(0).getSscUnit().getName();
        }
        boolean isImageActor = false;
        if ("default".equals(actorLocation)) {
            isImageActor = true;
        }
        resultMap.put("isNeedLoan", isNeedLoan);
        resultMap.put("usedWithFi", usedWithFi);
        resultMap.put("usedWithCn", usedWithCn);
        resultMap.put("CP00803", CP00803);
        resultMap.put("CP_BC_BAPS", CP_BC_BAPS);
        resultMap.put("CP_BC_TAPS", CP_BC_TAPS);
        resultMap.put("CP_BC_PAPS", CP_BC_PAPS);
        resultMap.put("CP_BC_BAOPS", CP_BC_BAOPS);
        resultMap.put("CP_BC_DLPS", CP_BC_DLPS);
        resultMap.put("CP_BC_ELPS", CP_BC_ELPS);
        resultMap.put("isShowLongName", isShowLongName);
        resultMap.put("personId", personId);
        resultMap.put("IsPaperParkIntegration", IsPaperParkIntegration);
        resultMap.put("isSSC", isSSC);
        resultMap.put("deleteAbandon", deleteAbandon);
        resultMap.put("isImageActor", isImageActor);
        resultMap.put("actorlocation", actorLocation);
        resultMap.put("accountBillCanVoucher", accountBillCanVoucher);
        resultMap.put("isShowProject", isShowProject);
        resultMap.put("usedWithProfitCenterFi", usedWithProfitCenterFi);
        resultMap.put("CP021", Boolean.valueOf((String)params.get("CP021")));
        resultMap.put("CP02101", Boolean.valueOf((String)params.get("CP02101")));
        resultMap.put("CP023", Boolean.valueOf((String)params.get("CP023")));
        resultMap.put("CP035", Boolean.valueOf((String)params.get("CP035")));
        resultMap.put("CP036", Boolean.valueOf((String)params.get("CP036")));
        resultMap.put("CP037", Boolean.valueOf((String)params.get("CP037")));
        resultMap.put("CP039", Boolean.valueOf((String)params.get("CP039")));
        resultMap.put("CP04401", Boolean.valueOf((String)params.get("CP04401")));
        resultMap.put("CP049", Boolean.valueOf((String)params.get("CP049")));
        resultMap.put("usedWithAp", usedWithAp);
        resultMap.put("CP054", Boolean.valueOf((String)params.get("CP054")));
        resultMap.put("CP053", Boolean.valueOf((String)params.get("CP053")));
        resultMap.put("CP051", Boolean.valueOf((String)params.get("CP051")));
        resultMap.put("CP05101", Boolean.valueOf((String)params.get("CP05101")));
        resultMap.put("CP050", Boolean.valueOf((String)params.get("CP050")));
        resultMap.put("CP065", CP065);
        resultMap.put("CP_BC_STATEPRINT", CP_BC_STATEPRINT);
        resultMap.put("CP_BC_ALLSTATES", BcParamConstant.ALLSTATELIST);
        resultMap.put("CP088", Boolean.valueOf((String)params.get("CP088")));
        resultMap.put("enablePayment", enablePayment);
        resultMap.put("usedWithCnVoucher", isRelaCnVoucher);
        resultMap.put("onlyAlreadyPaymentCanCreateVoucher", onlyAlreadyPaymentCanCreateVoucher);
        List queryReimbursePersons = ProxyReimburseFactory.getLocalInstance(ctx).queryReimbursePerson(personId);
        resultMap.put("reimbursePersons", queryReimbursePersons);
        List queryAdminOrg = ProxyReimburseFactory.getLocalInstance(ctx).queryAdminOrgUnit(personId);
        resultMap.put("adminOrgs", queryAdminOrg);
        List personIds = ProxyReimburseFactory.getLocalInstance(ctx).getPersonIdsByAdminOrg(queryAdminOrg);
        resultMap.put("personIds", personIds);
        String uipk = (String)ctx.get((Object)"cpbcListUipk");
        if (!StringUtils.isEmpty((String)uipk) && uipk.contains("com.kingdee.eas.cp.bc.EvectionReqBill_new")) {
            ctx.remove((Object)"cpbcListUipk");
            BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
            resultMap.put("appliercompany", baseInfo.getApplierCompany());
            resultMap.put("company", baseInfo.getCompany());
            resultMap.put("costedDept", baseInfo.getCostedDept());
        }
        return resultMap;
    }

    @Override
    protected Map _buildBizEditInitData(Context ctx, IObjectValue model, String loadType) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        if (model instanceof RePaymentBillInfo) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP001");
            paramList.add("CP002");
            paramList.add("CP010");
            paramList.add("CP011");
            paramList.add("CP017");
            paramList.add("CP018");
            paramList.add("CP019");
            paramList.add("CP020");
            paramList.add("CP025");
            paramList.add("CP027");
            paramList.add("CP028");
            paramList.add("CP029");
            paramList.add("CP030");
            paramList.add("CP031");
            paramList.add("CP032");
            paramList.add("CP033");
            paramList.add("CP03401");
            paramList.add("CP035");
            paramList.add("CP036");
            paramList.add("CP037");
            paramList.add("CP039");
            paramList.add("CP03904");
            paramList.add("CP042");
            paramList.add("CP045");
            paramList.add("CP049");
            paramList.add("IsSSC");
            paramList.add("IsPaperParkIntegration");
            paramList.add("CP054");
            paramList.add("CP053");
            paramList.add("CP051");
            paramList.add("CP065");
            paramList.add("CP_BC_STATEPRINT");
            paramList.add("CP072");
            paramList.add("CP085");
            Map paramObj = null;
            paramObj = ((RePaymentBillInfo)model).getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, ((RePaymentBillInfo)model).getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            String projectIsolateParam = BizBillUtil.getProjectIsolateParam(ctx);
            paramObj.put("Projectlsolate", projectIsolateParam);
            paramObj.put("CP_BC_ALLSTATES", BcParamConstant.ALLSTATELIST);
            initData.putAll(paramObj);
        } else {
            boolean paramFlag;
            BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)model;
            Map paramObj = null;
            if ("pageOnLoad".equals(loadType)) {
                String personId;
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                String string = personId = user.getPerson() == null ? null : user.getPerson().getId().toString();
                if (!StringUtils.isEmpty((String)personId)) {
                    initData.put("personId", personId);
                }
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add("CP001");
                paramList.add("CP002");
                paramList.add("CP008");
                paramList.add("CP009");
                paramList.add("CP00803");
                paramList.add("CP_BC_BAPS");
                paramList.add("CP_BC_TAPS");
                paramList.add("CP_BC_PAPS");
                paramList.add("CP_BC_BAOPS");
                paramList.add("CP_BC_DLPS");
                paramList.add("CP_BC_ELPS");
                paramList.add("CP010");
                paramList.add("CP011");
                paramList.add("CP014");
                paramList.add("CP016");
                paramList.add("CP017");
                paramList.add("CP018");
                paramList.add("CP019");
                paramList.add("CP020");
                paramList.add("CP025");
                paramList.add("CP027");
                paramList.add("CP028");
                paramList.add("CP029");
                paramList.add("CP030");
                paramList.add("CP031");
                paramList.add("CP032");
                paramList.add("CP033");
                paramList.add("CP035");
                paramList.add("CP036");
                paramList.add("CP037");
                paramList.add("CP039");
                paramList.add("CP03904");
                paramList.add("CP03905");
                paramList.add("CP03907");
                paramList.add("CP042");
                paramList.add("CP044");
                paramList.add("CP045");
                paramList.add("CP046");
                paramList.add("CP049");
                paramList.add("IsSSC");
                paramList.add("IsPaperParkIntegration");
                paramList.add("CP054");
                paramList.add("CP053");
                paramList.add("CP051");
                paramList.add("CP05101");
                paramList.add("CP052");
                paramList.add("CP05201");
                paramList.add("CP060");
                paramList.add("CP065");
                paramList.add("CP_BC_STATEPRINT");
                paramList.add("CP072");
                paramList.add("CP075");
                paramList.add("CP076");
                paramList.add("CP085");
                paramList.add("CP086");
                paramList.add("CP088");
                paramObj = billInfo.getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
                String projectIsolateParam = BizBillUtil.getProjectIsolateParam(ctx);
                paramObj.put("Projectlsolate", projectIsolateParam);
                paramObj.put("CP_BC_ALLSTATES", BcParamConstant.ALLSTATELIST);
                initData.putAll(paramObj);
                Boolean IsTicket = Boolean.valueOf((String)paramObj.get("CP039"));
                if (IsTicket.booleanValue()) {
                    InvoiceConfiguration invoice = InvoiceConfiguration.getInstance();
                    if (!invoice.isInitialize()) {
                        invoice.init();
                    }
                    initData.put("ticketEnv", invoice.getEnv());
                }
                if (!(billInfo instanceof BizAccountBillInfo || billInfo instanceof TravelAccountBillInfo || billInfo instanceof DailyLoanBillInfo)) {
                    List queryAdminOrg = ProxyReimburseFactory.getLocalInstance(ctx).queryAdminOrgUnit(personId);
                    initData.put("adminOrgs", queryAdminOrg);
                    CompanyOrgUnitInfo company = model.get("applierCompany") != null ? (CompanyOrgUnitInfo)model.get("applierCompany") : ContextUtil.getCurrentFIUnit((Context)ctx);
                    Set idSet = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx, company);
                    initData.put("adminOrgUnitIds", idSet);
                    Boolean isDelimitUserOrgScope = Boolean.valueOf((String)paramObj.get("CP019"));
                    Set orgRangeSet = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, user.getId().toString(), String.valueOf(10), null);
                    initData.put("orgRangeSet", orgRangeSet);
                    initData.put("companyFilter", CommonDataWebUtils.getCompanyFilter(ctx, orgRangeSet, isDelimitUserOrgScope));
                }
            } else if ("modelOnLoad".equals(loadType)) {
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add("CP025");
                paramObj = billInfo.getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            }
            boolean bl = Boolean.valueOf(paramObj == null ? "false" : (String)paramObj.get("CP001")) != false && Boolean.valueOf(paramObj == null ? "false" : (String)paramObj.get("CP010")) != false ? true : (paramFlag = false);
            if (paramFlag) {
                Boolean hasBgViewPermission = this.isHasBgViewPermission(ctx, (UserInfo)ctx.get((Object)"UserInfo"), billInfo);
                initData.put("hasBgViewPermission", hasBgViewPermission);
            }
        }
        return initData;
    }

    public boolean isHasBgViewPermission(Context ctx, UserInfo user, BizCollBillBaseInfo billInfo) {
        try {
            String permissionItem = null;
            CompanyOrgUnitInfo mainOrg = billInfo.getApplierCompany();
            if (billInfo instanceof BizAccountBillInfo) {
                permissionItem = "cp_bc_ExpenseAccount_Budget";
            } else if (billInfo instanceof TravelAccountBillInfo) {
                permissionItem = "cp_bc_TravelAccount_Budget";
            } else if (billInfo instanceof DailyLoanBillInfo) {
                permissionItem = "cp_bc_DailyLoan_Budget";
            } else if (billInfo instanceof EvectionLoanBillInfo) {
                permissionItem = "cp_bc_EvectionLoan_Budget";
            } else if (billInfo instanceof EvectionReqBillInfo) {
                permissionItem = "cp_bc_EvectionReq_Budget";
            } else if (billInfo instanceof OtherExpenseBillInfo) {
                permissionItem = "cp_bc_Expense_Budget";
            } else if (billInfo instanceof BizAccountOutBillInfo) {
                permissionItem = "cp_bc_BizAccountOutBill_Budget";
            } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
                permissionItem = "cp_bc_DailyAccount_Budget";
            }
            if (user == null || user.getId() == null || mainOrg == null || mainOrg.getId() == null || permissionItem == null) {
                return false;
            }
            ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(mainOrg.getId());
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionItem);
        }
        catch (PermissionServiceException e) {
            return false;
        }
        catch (PermItemException e) {
            return false;
        }
        catch (PermissionException e) {
            return false;
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
        return true;
    }

    @Override
    protected Map _billCloseBatch(Context ctx, String[] billIds, String permissionItem) throws BOSException, EASBizException {
        if (billIds == null || billIds.length == 0) {
            return null;
        }
        BOSUuid bosId = BOSUuid.read((String)billIds[0]);
        BOSObjectType bosType = bosId.getType();
        IBizCollBillBase bizCtrl = (IBizCollBillBase)this.getEntityBizInterface(ctx, bosType);
        EntityViewInfo view = new EntityViewInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < billIds.length; ++i) {
            idSet.add(billIds[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setSelector(this.getCloseInfoSic(bosId.toString()));
        view.setFilter(filter);
        BizCollBillBaseCollection billCol = bizCtrl.getBizCollBillBaseCollection(view);
        if (billCol == null || billCol.size() == 0) {
            return null;
        }
        BizCollBillBaseInfo billInfo = null;
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        HashMap<String, IBizCollBillBase> spareMap = new HashMap<String, IBizCollBillBase>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        int successCount = 0;
        spareMap.put("iService", bizCtrl);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        BOSUuid uid = null;
        for (int i = 0; i < billCol.size(); ++i) {
            billInfo = billCol.get(i);
            uid = billInfo.getId();
            try {
                if (!StringUtils.isEmpty((String)permissionItem)) {
                    PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(billInfo.getApplierCompany().getId().toString()), permissionItem);
                }
                BizCollBillFacadeFactory.getLocalInstance(ctx).billClose(uid.toString(), billInfo, spareMap);
                ++successCount;
                continue;
            }
            catch (Exception e) {
                if (billInfo == null) continue;
                errorMsgList.add(billInfo.getNumber() + " " + ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"11_CommonUtilFacadeControllerBean", (Locale)ctx.getOriginLocale()) + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        data.put("successCount", Integer.valueOf(successCount));
        data.put("failCount", Integer.valueOf(idSet.size() - successCount));
        if (errorMsgList.size() > 0) {
            data.put("errorMsgList", errorMsgList);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _billClose(Context ctx, String id, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            throw new BizCollException(BizCollException.CLOSEMETHODUUIDISNULL);
        }
        BOSUuid uid = BOSUuid.read((String)id);
        IBizCollBillBase bizCtrl = null;
        boolean isFromCq = false;
        if (spareMap != null) {
            bizCtrl = (IBizCollBillBase)spareMap.get("iService");
            boolean bl = isFromCq = spareMap.get("isFromCq") != null ? (Boolean)spareMap.get("isFromCq") : false;
        }
        if (bizCtrl == null) {
            bizCtrl = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, uid);
        }
        if (baseInfo == null) {
            baseInfo = bizCtrl.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(uid), this.getCloseInfoSic(id));
        }
        if (baseInfo.getApplierCompany() == null) {
            throw new BizCollException(BizCollException.APPLIERCOMPANYNOTNULL);
        }
        Map paramMap = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP033");
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP051");
        String applierCompayId = baseInfo.getApplierCompany().getId().toString();
        paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, baseInfo.getApplierCompany().getId().toString());
        boolean loanBillUseBg = paramMap.get("CP029") == null ? false : new Boolean(paramMap.get("CP029").toString());
        boolean reqBillUseBg = paramMap.get("CP030") == null ? false : new Boolean(paramMap.get("CP030").toString());
        boolean isNeedBudget = paramMap.get("CP001") == null ? false : new Boolean(paramMap.get("CP001").toString());
        boolean usedWithFi = paramMap.get("CP002") == null ? false : new Boolean(paramMap.get("CP002").toString());
        boolean usedWithCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        boolean eveReqBillUseBg = paramMap.get("CP051") == null ? false : new Boolean(paramMap.get("CP051").toString());
        int state = baseInfo.getState().getValue();
        BigDecimal amountBalance = baseInfo.getAmountBalance() != null ? baseInfo.getAmountBalance() : BigDecimal.ZERO;
        Boolean isPass = true;
        if (!isFromCq) {
            isPass = CommonWebUtilFacadeFactory.getLocalInstance(ctx).checkForBillClose(baseInfo.getId().toString());
        }
        if (baseInfo instanceof OtherExpenseBillInfo) {
            OtherExpenseBillInfo expenseBill = (OtherExpenseBillInfo)baseInfo;
            if (!StateEnum.CHECKED.equals((Object)baseInfo.getState()) || !isPass.booleanValue()) throw new BizCollException(BizCollException.OTHEREXPENSEBILLCLOSEERROR);
            if (isNeedBudget && reqBillUseBg) {
                BgCtrlBizCollHandler.setBugdutDoForClose(ctx, baseInfo, reqBillUseBg);
                NBgControlCallerUtil.requestBudget(ctx, baseInfo.getId());
            }
            this.setCloseInfo(ctx, baseInfo, StateEnum.CLOSED);
            bizCtrl.updatePartial((CoreBaseInfo)baseInfo, this.getCloseSelector(false));
        } else if (baseInfo instanceof LoanBillInfo) {
            LoanBillInfo loanbillInfo = (LoanBillInfo)baseInfo;
            if (!(state == 70 && amountBalance.compareTo(BigDecimal.ZERO) <= 0 || state == 60 && amountBalance.compareTo(BigDecimal.ZERO) == 0)) {
                throw new BizCollException(BizCollException.OTHEREXPENSEBILLCLOSEERROR);
            }
            if (!isPass.booleanValue()) throw new BizCollException(BizCollException.CLOSEERROR);
            if ((loanbillInfo.getLoanState().equals("Y") || loanbillInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT) || loanbillInfo.getState().equals((Object)StateEnum.CHECKED)) && loanbillInfo.getAmountBalance().doubleValue() <= 0.0) {
                if (isNeedBudget && loanBillUseBg) {
                    BgCtrlBizCollHandler.setBugdutDoForClose(ctx, baseInfo, reqBillUseBg);
                    NBgControlCallerUtil.requestBudget(ctx, baseInfo.getId());
                }
                this.setCloseInfo(ctx, baseInfo, StateEnum.CLOSED);
                bizCtrl.updatePartial((CoreBaseInfo)baseInfo, this.getCloseSelector(false));
            } else {
                if (usedWithFi || usedWithCn || !loanbillInfo.getState().equals((Object)StateEnum.CHECKED)) throw new BizCollException(BizCollException.CLOSESTATEERROR);
                if (isNeedBudget && loanBillUseBg) {
                    BgCtrlBizCollHandler.setBugdutDoForClose(ctx, loanbillInfo, reqBillUseBg);
                    NBgControlCallerUtil.requestBudget(ctx, loanbillInfo.getId());
                }
                this.setCloseInfo(ctx, loanbillInfo, StateEnum.CLOSED);
                if (loanbillInfo.getAmountBalance() != null && loanbillInfo.getAmountBalance().compareTo(BizCollUtil.ZERO) > 0) {
                    loanbillInfo.setReturnAmount(baseInfo.getAmountBalance());
                } else {
                    loanbillInfo.setReturnAmount(BizCollUtil.ZERO);
                }
                loanbillInfo.setReturnDate(new Date());
                loanbillInfo.setLoanState("Y");
                bizCtrl.updatePartial((CoreBaseInfo)loanbillInfo, this.getCloseSelector(!usedWithFi && !usedWithCn));
            }
        } else if (baseInfo instanceof EvectionReqBillInfo) {
            if (!isPass.booleanValue() || !StateEnum.CHECKED.equals((Object)baseInfo.getState())) throw new BizCollException(BizCollException.OTHEREXPENSEBILLCLOSEERROR);
            boolean isBudgetMul = BizCollUtil.checkEveReqBillUseBg(isNeedBudget, eveReqBillUseBg);
            if (isBudgetMul) {
                BgCtrlBizCollHandler.setBugdutDoForClose(ctx, baseInfo, isBudgetMul);
                NBgControlCallerUtil.specialBudget(ctx, baseInfo.getId());
            }
            this.setCloseInfo(ctx, baseInfo, StateEnum.CLOSED);
            bizCtrl.updatePartial((CoreBaseInfo)baseInfo, this.getCloseSelector(false));
        } else if (baseInfo instanceof ExpenseAccountBillInfo) {
            ExpenseAccountBillInfo expenseBill = (ExpenseAccountBillInfo)baseInfo;
            BigDecimal amountEncashed = expenseBill.getAmountEncashed();
            BigDecimal amountNotPaid = expenseBill.getAmountNotPaid();
            if (state != 70 && (state != 60 || amountNotPaid == null || amountNotPaid.compareTo(BigDecimal.ZERO) > 0)) {
                throw new BizCollException(BizCollException.EXPENSEBILLCLOSEERROR);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("lastUpdateUser"));
            sic.add(new SelectorItemInfo("state"));
            baseInfo.setState(StateEnum.CLOSED);
            baseInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            baseInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            bizCtrl.updatePartial((CoreBaseInfo)baseInfo, sic);
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_close", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("close \u624b\u5de5\u5173\u95ed  \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber()));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    protected SelectorItemCollection getCloseInfoSic(String id) {
        BOSUuid uid = BOSUuid.read((String)id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        if (!(BizCollUtil.bizAccountBillBosType.equals((Object)uid.getType()) || BizCollUtil.bizAccountOutBillBosType.equals((Object)uid.getType()) || BizCollUtil.travelAccountBillBosType.equals((Object)uid.getType()) || BizCollUtil.dailyPurchaseAccountBillBosType.equals((Object)uid.getType()))) {
            if (BizCollUtil.otherExpenseBosType.equals((Object)uid.getType()) || BizCollUtil.evectionReqBosType.equals((Object)uid.getType())) {
                sic.add(new SelectorItemInfo("entries.amountBalance"));
                sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
                sic.add(new SelectorItemInfo("entries.budgetBalance"));
                sic.add(new SelectorItemInfo("entries.amountApproved"));
            } else {
                sic.add(new SelectorItemInfo("costedDept.id"));
                sic.add(new SelectorItemInfo("costedDept.name"));
                sic.add(new SelectorItemInfo("costedDept.number"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("loanState"));
                sic.add(new SelectorItemInfo("entries.*"));
                sic.add(new SelectorItemInfo("ReqCheckEntries.*"));
            }
        }
        return sic;
    }

    private IBizCtrl getEntityBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            Class[] parameterTypes = new Class[]{Context.class};
            Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
            IBizCtrl iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            return iBiz;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectValue _buildRePayModel(Context ctx, IObjectValue object) throws BOSException, EASBizException {
        Locale local = ctx.getLocale();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
        RePaymentBillInfo info = (RePaymentBillInfo)object;
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        info.setOrgUnit(baseInfo.getOrgUnit());
        CurrencyInfo currency = (CurrencyInfo)ModelWebUtils.simpleClone((CoreBaseInfo)baseInfo.getCurrencyType());
        info.setCurrencyType(currency);
        info.setPosition(baseInfo.getPosition());
        info.setBizReqDate(date);
        info.setBizDate(date);
        info.setState(StateEnum.NEW);
        info.setBizReqDate(DateTimeUtils.truncateDate((Date)baseInfo.getBizReqDate()));
        info.setBiller(user);
        info.setCurrencyType(baseInfo.getCurrencyType());
        info.setPayMode(((DailyLoanBillInfo)baseInfo).getPayMode());
        info.setAmount(BizCollUtil.ZERO);
        info.setApplier(baseInfo.getApplier());
        info.setApplierCompany(baseInfo.getApplierCompany());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setPhone(baseInfo.getTel());
        if (info.getApplierCompany() != null) {
            info.setCU(baseInfo.getApplierCompany().getCU());
        } else {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        ModelWebUtils.reduceModel2((CoreBaseInfo)info, "applier", "biller", "orgUnit", "applierCompany", "creator", "position", "payMode");
        if (baseInfo.getApplierCompany() != null) {
            info.getApplierCompany().setCU(baseInfo.getApplierCompany().getCU());
        }
        CollectionAccountInfo collectionAccount = BizBillUtil.getDefaultCollectionAccount(ctx, null);
        if (info.getPayerName() == null && info.getPayerBank() == null && info.getPayerAccount() == null) {
            info.setPayerAccount(collectionAccount.getBankAccount());
            info.setPayerName(collectionAccount.getPayee());
            info.setPayerBank(collectionAccount.getBebankStr());
            info.setOpenArea(collectionAccount.getOpenArea());
        }
        return info;
    }

    @Override
    protected boolean _isEvaluation(Context ctx, BOSUuid billID) throws BOSException {
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)this.getEntityBizInterface(ctx, billID.getType());
        return iBizCollBillBase.isEvaluation(billID);
    }

    protected void setCloseInfo(Context ctx, BizCollBillBaseInfo info, StateEnum state) {
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setAmountBalance(BizCollUtil.ZERO);
        info.setState(state);
        AbstractObjectCollection con = (AbstractObjectCollection)info.get("entries");
        if (con != null && con.size() > 0) {
            Object entry = null;
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                con.getObject(i).setBigDecimal("amountBalance", BizCollUtil.ZERO);
                con.getObject(i).setBigDecimal("amountBalanceOri", BizCollUtil.ZERO);
                con.getObject(i).setBigDecimal("budgetBalance", BizCollUtil.ZERO);
            }
        }
    }

    protected SelectorItemCollection getCloseSelector(boolean isNotRelaFi) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        sic.add(new SelectorItemInfo("entries.budgetBalance"));
        if (isNotRelaFi) {
            sic.add(new SelectorItemInfo("loanState"));
            sic.add(new SelectorItemInfo("returnDate"));
            sic.add(new SelectorItemInfo("returnAmount"));
        }
        return sic;
    }

    @Override
    protected Map _deleteBatch(Context ctx, String[] ids, String permissionItem) throws BOSException, EASBizException {
        if (ids == null || ids.length < 1) {
            return null;
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        int successCount = 0;
        ObjectStringPK pk = null;
        int idlen = ids.length;
        ICoreBase bizCtrl = BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)ids[0]));
        for (int i = 0; i < idlen; ++i) {
            try {
                pk = new ObjectStringPK(ids[i].toString());
                bizCtrl.delete((IObjectPK)pk);
                ++successCount;
                continue;
            }
            catch (Exception exc) {
                String failreason = ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"11_CommonUtilFacadeControllerBean", (Locale)ctx.getOriginLocale());
                CoreBaseInfo billInfo = null;
                String number = null;
                if (pk != null) {
                    billInfo = bizCtrl.getValue((IObjectPK)pk, BizCollUtil.getDefaultSelector());
                    number = billInfo.getString("number");
                }
                errorMsgList.add(number + failreason + exc.getMessage());
            }
        }
        result.put("successCount", Integer.valueOf(successCount));
        result.put("failCount", Integer.valueOf(idlen - successCount));
        if (errorMsgList.size() > 0) {
            result.put("errorMsgList", errorMsgList);
        }
        return result;
    }
}

