/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BudgetControlCollection;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.BudgetControlInfo;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.app.AbstractBudgetControlControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BudgetControlControllerBean
extends AbstractBudgetControlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BudgetControlControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, (BudgetControlInfo)model);
        super._update(ctx, pk, model);
    }

    private void addNewCheck(Context ctx, BudgetControlInfo tempInfo) throws EASBizException, BOSException {
        if (tempInfo.getYearTime() <= 0) {
            throw new BudgetControlException(BudgetControlException.YEARTIME_NOT_NULL);
        }
        if (tempInfo.getControlObj() == null) {
            throw new BudgetControlException(BudgetControlException.CONTROL_NOT_NULL);
        }
        if (tempInfo.getExpenseSort() == null) {
            throw new BudgetControlException(BudgetControlException.SORTNAME_NOT_NULL);
        }
        this.checkBudgetControlSame_id(ctx, tempInfo);
    }

    private void addNewCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BudgetControlInfo tempInfo = (BudgetControlInfo)model;
        tempInfo.setYearBalance(tempInfo.getSumAccount());
        if (tempInfo.getYearTime() <= 0) {
            throw new BudgetControlException(BudgetControlException.YEARTIME_NOT_NULL);
        }
        if (this.objectIsNull(tempInfo.getControlObj())) {
            throw new BudgetControlException(BudgetControlException.CONTROL_NOT_NULL);
        }
        if (this.objectIsNull(tempInfo.getExpenseSort().getSortName())) {
            throw new BudgetControlException(BudgetControlException.SORTNAME_NOT_NULL);
        }
        this.checkBudgetControlSame(ctx, tempInfo);
    }

    private void checkBudgetControlSame(Context ctx, BudgetControlInfo tempInfo) throws BOSException, EASBizException {
        int year = tempInfo.getYearTime();
        CostCenterOrgUnitInfo costInfo = tempInfo.getControlObj();
        ExpenseSortInfo sortInfo = tempInfo.getExpenseSort();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)costInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)sortInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 ");
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getLocalInstance(ctx).getBudgetControlCollection(ev);
        if (tempCollection.size() >= 1) {
            throw new BudgetControlException(BudgetControlException.SAMEOBJ_IS_EXIT);
        }
    }

    private void checkBudgetControlSame_id(Context ctx, BudgetControlInfo tempInfo) throws BOSException, EASBizException {
        int year = tempInfo.getYearTime();
        CostCenterOrgUnitInfo costInfo = tempInfo.getControlObj();
        ExpenseSortInfo sortInfo = tempInfo.getExpenseSort();
        BOSUuid tempInfoID = tempInfo.getId();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)costInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)sortInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 ");
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getLocalInstance(ctx).getBudgetControlCollection(ev);
        BudgetControlInfo currentInfo = null;
        BOSUuid currentID = null;
        int n = tempCollection.size();
        for (int i = 0; i < n; ++i) {
            currentInfo = tempCollection.get(i);
            currentID = currentInfo.getId();
            if (tempInfoID.equals((Object)currentID)) continue;
            throw new BudgetControlException(BudgetControlException.SAMEOBJ_IS_EXIT);
        }
    }

    protected boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }
}

