/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.CollectionAccountCollection;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.app.AbstractCollectionAccountControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CollectionAccountControllerBean
extends AbstractCollectionAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CollectionAccountControllerBean");

    @Override
    protected void _changeState(Context ctx, List ids, boolean enable) throws BOSException, EASBizException {
        int state = enable ? 1 : 0;
        StringBuffer sql = new StringBuffer();
        StringBuffer idStr = new StringBuffer();
        idStr.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            idStr.append("'").append(ids.get(i).toString()).append("',");
        }
        idStr.deleteCharAt(idStr.length() - 1);
        idStr.append(")");
        sql.append("UPDATE T_BC_COLLECTIONACCOUNT SET CFState = ").append(state).append("  WHERE CFISDEFAULT = 0 AND FID IN ").append(idStr);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IObjectValue _getDefaultCollectionAccount(Context ctx) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select payee, bankAccount, openArea.id, ").append("openArea.name, Bebank.id, Bebank.name, BebankStr where applier.id = '").append(personId).append("' and isDefault = 1");
        CollectionAccountCollection collectionAccountCollection = CollectionAccountFactory.getLocalInstance(ctx).getCollectionAccountCollection(oql.toString());
        if (collectionAccountCollection.size() > 0) {
            CollectionAccountInfo collectionAccount = (CollectionAccountInfo)collectionAccountCollection.getObject(0);
            return collectionAccount;
        }
        return null;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterInfoByShare;
        CollectionAccountInfo collectionAccountInfo = (CollectionAccountInfo)model;
        collectionAccountInfo.setBankAccount(collectionAccountInfo.getBankAccount().trim());
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        String id = null;
        Object idObject = model.get("id");
        if (idObject != null && StringUtils.isNotBlank((String)idObject.toString())) {
            id = idObject.toString();
        }
        if (collectionAccountInfo.getCreator() == null) {
            collectionAccountInfo.setCreator(user);
        }
        if (null != collectionAccountInfo.getApplier() && null != collectionAccountInfo.getPayee()) {
            boolean cp078;
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP078");
            Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            boolean bl = cp078 = paramMap.get("CP078") == null ? true : new Boolean(paramMap.get("CP078").toString());
            if (cp078 && !collectionAccountInfo.getPayee().equals(collectionAccountInfo.getApplier().getName())) {
                collectionAccountInfo.setApplier(null);
            }
        }
        if (StringUtils.isNotBlank((String)collectionAccountInfo.getBankAccount())) {
            String bankAccount = collectionAccountInfo.getBankAccount();
            bankAccount = bankAccount.replaceAll("\\s*", "");
            collectionAccountInfo.setBankAccount(bankAccount);
        }
        collectionAccountInfo.setState(EnableStateEnum.ENABLE);
        FilterInfo filterInfo = this.getFilterInfo(collectionAccountInfo, id);
        boolean ifExist = super._exists(ctx, filterInfo);
        if (ifExist) {
            if (collectionAccountInfo.isIsShare()) {
                throw new BizCollException(BizCollException.BANKACCOUNT_REPEAT);
            }
            throw new BizCollException(BizCollException.BANKACCOUNTREPEAT);
        }
        if (collectionAccountInfo.isIsShare() && (ifExist = super.exists(ctx, filterInfoByShare = this.getFilterInfoByShare(collectionAccountInfo, id)))) {
            throw new BizCollException(BizCollException.BANKACCOUNT_REPEAT);
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        collectionAccountInfo.setCompany(company);
        if (collectionAccountInfo.isIsDefault()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo defaultFilterInfo = new FilterInfo();
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("applier", (Object)collectionAccountInfo.getApplier().getId().toString()));
            defaultFilterInfo.setMaskString("#0 AND #1");
            entityViewInfo.setFilter(defaultFilterInfo);
            CollectionAccountCollection collectionAccountCollection = super.getCollectionAccountCollection(ctx, entityViewInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isDefault"));
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < collectionAccountCollection.size(); ++i) {
                collectionAccountCollection.get(i).setIsDefault(false);
                coreBaseCollection.add((CoreBaseInfo)collectionAccountCollection.get(i));
            }
            super._updateBatchData(ctx, (IObjectCollection)coreBaseCollection);
        }
        return super._submit(ctx, (IObjectValue)collectionAccountInfo);
    }

    @Override
    protected void _saveCollectionAccount(Context ctx, IObjectValue collectionAccount) throws BOSException, EASBizException {
        FilterInfo filterInfoByShare;
        CollectionAccountInfo collectionAccountInfo = (CollectionAccountInfo)collectionAccount;
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String id = null;
        Object idObject = collectionAccount.get("id");
        if (idObject != null && StringUtils.isNotBlank((String)idObject.toString())) {
            id = idObject.toString();
        }
        if (collectionAccountInfo.getCreator() == null) {
            collectionAccountInfo.setCreator(user);
        }
        if (StringUtils.isNotBlank((String)collectionAccountInfo.getBankAccount())) {
            String bankAccount = collectionAccountInfo.getBankAccount();
            bankAccount = bankAccount.replaceAll("\\s*", "");
            collectionAccountInfo.setBankAccount(bankAccount);
        }
        collectionAccountInfo.setState(EnableStateEnum.ENABLE);
        FilterInfo filterInfo = this.getFilterInfo(collectionAccountInfo, id);
        ICollectionAccount collectionAccountFactory = CollectionAccountFactory.getLocalInstance(ctx);
        boolean ifExist = collectionAccountFactory.exists(filterInfo);
        if (ifExist) {
            if (collectionAccountInfo.isIsShare()) {
                throw new BizCollException(BizCollException.BANKACCOUNT_REPEAT);
            }
            throw new BizCollException(BizCollException.BANKACCOUNTREPEAT);
        }
        if (collectionAccountInfo.isIsShare() && (ifExist = collectionAccountFactory.exists(filterInfoByShare = this.getFilterInfoByShare(collectionAccountInfo, id)))) {
            throw new BizCollException(BizCollException.BANKACCOUNT_REPEAT);
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        collectionAccountInfo.setCompany(company);
        if (collectionAccountInfo.isIsDefault()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo defaultFilterInfo = new FilterInfo();
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("applier", (Object)collectionAccountInfo.getApplier().getId().toString()));
            defaultFilterInfo.setMaskString("#0 AND #1");
            entityViewInfo.setFilter(defaultFilterInfo);
            CollectionAccountCollection collectionAccountCollection = collectionAccountFactory.getCollectionAccountCollection(entityViewInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isDefault"));
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < collectionAccountCollection.size(); ++i) {
                collectionAccountCollection.get(i).setIsDefault(false);
                coreBaseCollection.add((CoreBaseInfo)collectionAccountCollection.get(i));
            }
            collectionAccountFactory.updateBatchData(coreBaseCollection);
        }
        collectionAccountFactory.save((CoreBaseInfo)collectionAccountInfo);
    }

    private FilterInfo getFilterInfo(CollectionAccountInfo collectionAccountInfo, String id) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String mask = "#0 and #1";
        filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)collectionAccountInfo.getBankAccount()));
        filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)collectionAccountInfo.getCreator().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("payee", (Object)collectionAccountInfo.getPayee()));
        if (collectionAccountInfo.getApplier() != null && collectionAccountInfo.getApplier().getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("applier.id", (Object)collectionAccountInfo.getApplier().getId().toString()));
            mask = mask + " and (#2 or #3)";
        } else {
            mask = mask + " and #2";
        }
        filterInfo.setMaskString(mask);
        if (id != null) {
            FilterInfo filtertemp = new FilterInfo();
            filtertemp.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            filterInfo.mergeFilter(filtertemp, "and");
        }
        return filterInfo;
    }

    private FilterInfo getFilterInfoByShare(CollectionAccountInfo collectionAccountInfo, String id) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)collectionAccountInfo.getBankAccount(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isShare", (Object)true, CompareType.EQUALS));
        if (id != null) {
            FilterInfo filtertemp = new FilterInfo();
            filtertemp.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            filterInfo.mergeFilter(filtertemp, "and");
        }
        return filterInfo;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)model.getBOSType(), (IObjectPK)pk, (String)("\u6536\u6b3e\u4fe1\u606f\u65b0\u589e " + pk));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)model.getBOSType(), (IObjectPK)pk, (String)("\u6536\u6b3e\u4fe1\u606f\u4fee\u6539" + pk));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    @Override
    protected boolean _isDefault(Context ctx, List ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer idStr = new StringBuffer();
        idStr.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            idStr.append("'").append(ids.get(i).toString()).append("',");
        }
        idStr.deleteCharAt(idStr.length() - 1);
        idStr.append(")");
        sql.append("select CFApplierID,CFISDEFAULT from T_BC_COLLECTIONACCOUNT where FID in ").append(idStr).append(" and CFISDEFAULT = 1");
        int count = 0;
        try {
            Connection conn = EJBFactory.getConnection((Context)ctx);
            PreparedStatement stmt = conn.prepareStatement(sql.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("CFISDEFAULT") != 1) continue;
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count == 1;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)BOSUuid.read((String)pk.toString()).getType(), (IObjectPK)pk, (String)("\u6536\u6b3e\u4fe1\u606f\u5220\u9664 " + pk));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }
}

