/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BillOfWFMessageFactory;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillLoanCheckEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillLoanCheckEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillReqCheckEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillReqCheckEntryInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.IInvoiceTypeEntry;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TicketEntryCollection;
import com.kingdee.eas.cp.bc.TicketEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractCpbcAPIFacadeControllerBean;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CpbcAPIFacadeControllerBean
extends AbstractCpbcAPIFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CpbcAPIFacadeControllerBean");

    @Override
    protected String _InitData(Context ctx, String data) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        BizCollBillBaseInfo baseInfo = null;
        try {
            baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        BizAccountBillInfo billInfo = new BizAccountBillInfo();
        billInfo.setId(this.creatIdByBillType("BizAccountBill"));
        this.buildBillInfo(billInfo, baseInfo, user);
        IInvoiceTypeEntry invoiceService = InvoiceTypeEntryFactory.getLocalInstance(ctx);
        JSONObject retunObject = new JSONObject();
        retunObject.put("costDept", (Object)baseInfo.getCostedDept().getName());
        retunObject.put("bizReqDate", (Object)baseInfo.getBizReqDate().toString());
        logger.error((Object)("#####cpbc API _initData From invoiceInfo data=" + data));
        JSONArray returnDataOut = JSONObject.parseArray((String)data);
        HashMap<String, Map<String, String>> groupMapByInvoiceType = new HashMap<String, Map<String, String>>();
        Map<String, String> valueMapByInvoiceType = new HashMap();
        HashMap<String, Map<String, String>> groupMapByTaxClassNumber = new HashMap<String, Map<String, String>>();
        Map<String, String> valueMapByTaxClassNumber = new HashMap();
        String ticketCode = null;
        BigDecimal amount = new BigDecimal("0.0");
        BigDecimal taxAmount = new BigDecimal("0.0");
        TicketEntryCollection tCollection = new TicketEntryCollection();
        BizAccountBillEntryCollection bizCollection = new BizAccountBillEntryCollection();
        for (int i = 0; i < returnDataOut.size(); ++i) {
            String invoice;
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            String invoiceTypeOut = eJsStrOut.getString("invoiceType");
            String invoiceId = eJsStrOut.getString("id");
            BigDecimal ftotalpricetax = new BigDecimal("0.0");
            if (!BizCollUtil.objectIsNull(eJsStrOut.getString("totalPriceTax"))) {
                ftotalpricetax = new BigDecimal(eJsStrOut.getString("totalPriceTax"));
            }
            BigDecimal ftotaltax = new BigDecimal("0.0");
            if (!BizCollUtil.objectIsNull(eJsStrOut.getString("totalTax"))) {
                ftotaltax = new BigDecimal(eJsStrOut.getString("totalTax"));
            }
            if (!BizCollUtil.objectIsNull(eJsStrOut.getString("invoiceCode"))) {
                ticketCode = eJsStrOut.getString("invoiceCode");
            } else {
                logger.error((Object)"######## cpbcAPI  ticketCode  is null");
            }
            String iTaxClassNumber = null;
            if (!BizCollUtil.objectIsNull(eJsStrOut.getString("spbm"))) {
                iTaxClassNumber = eJsStrOut.getString("spbm");
            } else {
                logger.error((Object)("### cpbcAPI ticketCode =" + ticketCode + " but iTaxClassNumber is null"));
            }
            int count = 1;
            if (InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
                if (groupMapByInvoiceType.containsKey(invoiceTypeOut)) {
                    valueMapByInvoiceType = (Map)groupMapByInvoiceType.get(invoiceTypeOut);
                    amount = (BigDecimal)valueMapByInvoiceType.get("amount");
                    taxAmount = (BigDecimal)valueMapByInvoiceType.get("taxAmount");
                    count = Integer.valueOf(valueMapByInvoiceType.get("count").toString());
                    invoice = valueMapByInvoiceType.get("fid").toString();
                    amount = amount.add(ftotalpricetax);
                    taxAmount = taxAmount.add(ftotaltax);
                    ++count;
                    invoiceId = invoice + "," + invoiceId;
                    valueMapByInvoiceType.put("fid", invoiceId);
                    valueMapByInvoiceType.put("amount", (String)((Object)amount));
                    valueMapByInvoiceType.put("taxAmount", (String)((Object)taxAmount));
                    valueMapByInvoiceType.put("count", (String)((Object)Integer.valueOf(count)));
                    continue;
                }
                valueMapByInvoiceType = new HashMap();
                valueMapByInvoiceType.put("amount", (String)((Object)ftotalpricetax));
                valueMapByInvoiceType.put("taxAmount", (String)((Object)ftotaltax));
                valueMapByInvoiceType.put("count", (String)((Object)Integer.valueOf(1)));
                valueMapByInvoiceType.put("fid", invoiceId);
                groupMapByInvoiceType.put(invoiceTypeOut, valueMapByInvoiceType);
                continue;
            }
            if (groupMapByTaxClassNumber.containsKey(iTaxClassNumber)) {
                valueMapByTaxClassNumber = (Map)groupMapByTaxClassNumber.get(iTaxClassNumber);
                amount = (BigDecimal)valueMapByTaxClassNumber.get("amount");
                taxAmount = (BigDecimal)valueMapByTaxClassNumber.get("taxAmount");
                count = Integer.valueOf(valueMapByTaxClassNumber.get("count").toString());
                invoice = valueMapByTaxClassNumber.get("fid").toString();
                amount = amount.add(ftotalpricetax);
                taxAmount = taxAmount.add(ftotaltax);
                ++count;
                invoiceId = invoice + "," + invoiceId;
                valueMapByTaxClassNumber.put("fClassNumber", iTaxClassNumber);
                valueMapByTaxClassNumber.put("fid", invoiceId);
                valueMapByTaxClassNumber.put("amount", (String)((Object)amount));
                valueMapByTaxClassNumber.put("taxAmount", (String)((Object)taxAmount));
                valueMapByTaxClassNumber.put("count", (String)((Object)Integer.valueOf(count)));
                continue;
            }
            valueMapByTaxClassNumber = new HashMap();
            valueMapByTaxClassNumber.put("amount", (String)((Object)ftotalpricetax));
            valueMapByTaxClassNumber.put("taxAmount", (String)((Object)ftotaltax));
            valueMapByTaxClassNumber.put("count", (String)((Object)Integer.valueOf(1)));
            valueMapByTaxClassNumber.put("fid", invoiceId);
            valueMapByTaxClassNumber.put("fClassNumber", iTaxClassNumber);
            groupMapByTaxClassNumber.put(iTaxClassNumber, valueMapByTaxClassNumber);
        }
        Set keysetByInvoiceType = groupMapByInvoiceType.keySet();
        Iterator itByInvoiceType = keysetByInvoiceType.iterator();
        JSONArray entriesJson_expenseType = new JSONArray();
        HashMap entryLinkInvoice = new HashMap();
        for (int k = 0; k < keysetByInvoiceType.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            BigDecimal eAmount = new BigDecimal(0.0);
            String invoiceif = itByInvoiceType.next().toString();
            Map valuemap = (Map)groupMapByInvoiceType.get(invoiceif);
            if (BizCollUtil.objectIsNull(valuemap)) {
                valuemap = (Map)groupMapByInvoiceType.get(Integer.parseInt(invoiceif));
            }
            entryJson.put("invoiceInfo", (Object)invoiceif);
            entryJson.put("fInvoiceId", valuemap.get("fid"));
            entryJson.put("expenseTypeInfo", (Object)this.getExpensetType(true, invoiceService, baseInfo, invoiceif));
            eAmount = (BigDecimal)valuemap.get("amount");
            entryJson.put("amount", (Object)eAmount);
            entryJson.put("taxAmount", (Object)((BigDecimal)valuemap.get("taxAmount")));
            entryJson.put("count", valuemap.get("count"));
            entriesJson_expenseType.add((Object)entryJson);
        }
        Set keysetByTaxClassNumber = groupMapByTaxClassNumber.keySet();
        Iterator itByTaxClassNumber = keysetByTaxClassNumber.iterator();
        HashMap entryLinkInvoiceByTaxClassNumber = new HashMap();
        for (int k = 0; k < keysetByTaxClassNumber.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            BigDecimal eAmount = new BigDecimal(0.0);
            String invoiceif = itByTaxClassNumber.next().toString();
            String tmpStr = invoiceif.replaceAll("(0){1,}$", "%");
            Map valuemap = (Map)groupMapByTaxClassNumber.get(invoiceif);
            entryJson.put("invoiceInfo", (Object)invoiceif);
            entryJson.put("fInvoiceId", valuemap.get("fid"));
            entryJson.put("expenseTypeInfo", (Object)this.getExpensetType(false, invoiceService, baseInfo, invoiceif));
            eAmount = (BigDecimal)valuemap.get("amount");
            entryJson.put("amount", (Object)eAmount);
            entryJson.put("taxAmount", (Object)((BigDecimal)valuemap.get("taxAmount")));
            entryJson.put("count", valuemap.get("count"));
            entriesJson_expenseType.add((Object)entryJson);
        }
        boolean ticketUsed = false;
        boolean ticketEnterprise = false;
        boolean ticketTaxNumber = false;
        boolean ticketCheckFail = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP03901");
        paramList.add("CP03902");
        paramList.add("CP03903");
        paramList.add("CP03904");
        Map paramMap = new HashMap();
        try {
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, baseInfo.getApplierCompany().getId().toString());
            ticketUsed = new Boolean(paramMap.get("CP03901").toString());
            ticketEnterprise = new Boolean(paramMap.get("CP03902").toString());
            ticketTaxNumber = new Boolean(paramMap.get("CP03903").toString());
            ticketCheckFail = new Boolean(paramMap.get("CP03904").toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        JSONArray tParam = new JSONArray();
        tParam.add((Object)ticketUsed);
        tParam.add((Object)ticketEnterprise);
        tParam.add((Object)ticketTaxNumber);
        tParam.add((Object)ticketCheckFail);
        retunObject.put("tParam", (Object)tParam);
        retunObject.put("data", (Object)entriesJson_expenseType);
        retunObject.put("groupMapByTaxClassNumber", groupMapByTaxClassNumber);
        retunObject.put("groupMapByInvoiceType", groupMapByInvoiceType);
        logger.error((Object)("#####cpbc API _initData To invoiceInfo retunObject=" + retunObject.toJSONString()));
        return retunObject.toJSONString();
    }

    @Override
    protected String _ViewBill(Context ctx, String jsonObject) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        JSONObject jsonStr = JSONObject.parseObject((String)jsonObject);
        JSONObject json = new JSONObject();
        if (!BizCollUtil.objectIsNull(jsonStr.get((Object)"id"))) {
            String billId = jsonStr.get((Object)"id").toString();
            logger.error((Object)("######  cpbcAPI _ViewBill billId =" + billId));
            ObjectUuidPK objpk = new ObjectUuidPK(billId);
            BizAccountBillInfo bizBillInfo = this.createBizInfo(ctx, objpk);
            if (!BizCollUtil.objectIsNull(bizBillInfo) && !BizCollUtil.objectIsNull(bizBillInfo.getId())) {
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                json.put("id", (Object)bizBillInfo.getId().toString());
                json.put("nubmer", (Object)bizBillInfo.getNumber());
                json.put("state", (Object)bizBillInfo.getState().getAlias());
                json.put("userName", (Object)user.getName().toString());
                json.put("costDept", (Object)bizBillInfo.getCostedDept().getName().toString());
                json.put("bizReqDate", (Object)bizBillInfo.getBizReqDate().toString());
                json.put("amount", (Object)bizBillInfo.getAmount());
                json.put("cause", (Object)bizBillInfo.getCause());
                BizAccountBillEntryCollection entries = bizBillInfo.getEntries();
                JSONArray ejsArray = new JSONArray();
                JSONObject expenseTypejson = null;
                for (int j = 0; j < entries.size(); ++j) {
                    BizAccountBillEntryInfo bizEntryInfo = entries.get(j);
                    expenseTypejson = new JSONObject();
                    if (null != bizEntryInfo.getExpenseType() && null != bizEntryInfo.getExpenseType().getName()) {
                        expenseTypejson.put("expenseTypeName", (Object)bizEntryInfo.getExpenseType().getName().toString());
                    }
                    expenseTypejson.put("amount", (Object)bizEntryInfo.getAmount());
                    expenseTypejson.put("entryId", (Object)bizEntryInfo.getId().toString());
                    ejsArray.add((Object)expenseTypejson);
                }
                TicketEntryCollection ticketEntries = bizBillInfo.getTickeEntries();
                BigDecimal ticketAmount = new BigDecimal("0.00");
                for (int j = 0; j < ticketEntries.size(); ++j) {
                    TicketEntryInfo ticketInfo = ticketEntries.get(j);
                    ticketAmount = ticketAmount.add(ticketInfo.getAmout());
                }
                json.put("ticketAmount", (Object)ticketAmount);
                json.put("entriesArray", (Object)ejsArray);
                json.put("workFlows", (Object)this.getWorkFlow(ctx, bizBillInfo.getId().toString()));
            }
        }
        logger.error((Object)("######  cpbcAPI _ViewBill json =" + json.toJSONString()));
        return json.toJSONString();
    }

    private BizAccountBillInfo createBizInfo(Context ctx, ObjectUuidPK objpk) {
        BizAccountBillInfo billInfo = null;
        try {
            billInfo = BizAccountBillFactory.getLocalInstance(ctx).getBizAccountBillInfo((IObjectPK)objpk, this.getSelector());
        }
        catch (EASBizException e) {
            logger.error((Object)("#### cpbcAPI createBizInfo billId=" + objpk.toString()));
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return billInfo;
    }

    private JSONArray getWorkFlow(Context ctx, String id) {
        WfUtil wfUtil = new WfUtil(ctx);
        HashSet<String> setId = new HashSet<String>();
        setId.add(id);
        Map processMap = new HashMap();
        try {
            processMap = BillOfWFMessageFactory.getLocalInstance(ctx).getWFCurrentNoteMessage(setId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Object processMessage = processMap.get(id);
        JSONArray workflowArray = new JSONArray();
        JSONObject jsonWorkFlow = new JSONObject();
        jsonWorkFlow.put("wfId", processMessage);
        workflowArray.add((Object)jsonWorkFlow);
        return workflowArray;
    }

    @Override
    protected String _QueryBill(Context ctx, String jsonObject) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        JSONObject jsonStr = JSONObject.parseObject((String)jsonObject);
        JSONArray jsonArray = jsonStr.getJSONArray("billIds");
        if (BizCollUtil.objectIsNull(jsonArray)) {
            logger.error((Object)"######## cpbcAPI  _QueryBill jsonArray  is null");
            return null;
        }
        JSONObject jsonObjectReturn = new JSONObject();
        JSONArray jsArrayReuturn = new JSONArray();
        BizAccountBillInfo bizBillInfo = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            String billId = jsonArray.get(i).toString();
            logger.error((Object)("######  cpbcAPI _QureyBill billId =" + billId));
            ObjectUuidPK objpk = new ObjectUuidPK(billId);
            bizBillInfo = this.createBizInfo(ctx, objpk);
            JSONObject json = new JSONObject();
            if (BizCollUtil.objectIsNull(bizBillInfo) || BizCollUtil.objectIsNull(bizBillInfo.getId())) continue;
            json.put("id", (Object)bizBillInfo.getId().toString());
            json.put("nubmer", (Object)bizBillInfo.getNumber());
            json.put("state", (Object)bizBillInfo.getState().getAlias());
            json.put("userName", (Object)user.getName().toString());
            json.put("costDept", (Object)bizBillInfo.getCostedDept().getName().toString());
            json.put("bizReqDate", (Object)bizBillInfo.getBizReqDate().toString());
            json.put("amount", (Object)bizBillInfo.getAmount());
            BizAccountBillEntryCollection entries = bizBillInfo.getEntries();
            JSONArray ejsArray = new JSONArray();
            JSONObject expenseTypejson = null;
            for (int j = 0; j < entries.size(); ++j) {
                BizAccountBillEntryInfo bizEntryInfo = entries.get(j);
                expenseTypejson = new JSONObject();
                expenseTypejson.put("amount", (Object)bizEntryInfo.getAmount());
                if (null != bizEntryInfo.getExpenseType() && null != bizEntryInfo.getExpenseType().getName()) {
                    expenseTypejson.put("expenseTypeName", (Object)bizEntryInfo.getExpenseType().getName().toString());
                }
                ejsArray.add((Object)expenseTypejson);
            }
            json.put("entriesArray", (Object)ejsArray);
            jsArrayReuturn.add((Object)json);
        }
        jsonObjectReturn.put("data", (Object)jsArrayReuturn);
        logger.error((Object)("######  cpbcAPI _QureyBill jsonObjectReturn =" + jsonObjectReturn.toJSONString()));
        return jsonObjectReturn.toJSONString();
    }

    @Override
    protected String _FromReqBill(Context ctx, String jsonObject) throws BOSException {
        return this.FromBill(ctx, jsonObject, "otherExpense");
    }

    @Override
    protected String _FromLoanBill(Context ctx, String jsonObject) throws BOSException {
        return this.FromBill(ctx, jsonObject, "dailyLoan");
    }

    private String FromBill(Context ctx, String jsonObject, String sourcebillType) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        HashMap<String, Object> paramMapBack = new HashMap<String, Object>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String companyId = (String)ctx.get((Object)"CurCompanyId");
        paramMapBack.put("applier", user.getPerson().getId());
        paramMapBack.put("companyId", companyId);
        paramMapBack.put("billtype", (Object)BizCollBillTypeEnum.BIZ_ACCOUNT);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceBillType", sourcebillType);
        map.put("billtype", (Object)BizCollBillTypeEnum.BIZ_ACCOUNT);
        map.put("filterValue", paramMapBack);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP014");
        paramList.add("CP042");
        paramList.add("CP052");
        Map paramMap = new HashMap();
        try {
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        paramMapBack.putAll(paramMap);
        List results = CommonUtilFacadeFactory.getLocalInstance(ctx).getSourceBills((String)map.get("sourceBillType"), (Map)map.get("filterValue"));
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < results.size(); ++i) {
            JSONObject toJsonArray = new JSONObject();
            Map resultMap = (Map)results.get(i);
            toJsonArray.put("id", resultMap.get("id"));
            toJsonArray.put("number", resultMap.get("number"));
            toJsonArray.put("bizReqDate", (Object)resultMap.get("bizReqDate").toString());
            toJsonArray.put("hasSourceBill", resultMap.get("hasSourceBill"));
            toJsonArray.put("sourceBillCostCenterName", resultMap.get("sourceBillCostCenterName"));
            toJsonArray.put("amountControlType", resultMap.get("amountControlType"));
            toJsonArray.put("convertMode", resultMap.get("convertMode"));
            toJsonArray.put("cause", resultMap.get("cause"));
            toJsonArray.put("exchangeRate", resultMap.get("exchangeRate"));
            toJsonArray.put("exchangeRatePrecision", resultMap.get("exchangeRatePrecision"));
            toJsonArray.put("currencyTypeName", resultMap.get("currencyTypeName"));
            toJsonArray.put("entryid", (Object)resultMap.get("entryid").toString());
            toJsonArray.put("sourceBillCostCenterId", (Object)resultMap.get("sourceBillCostCenterId").toString());
            toJsonArray.put("sourceBillExpenseTypeId", (Object)resultMap.get("sourceBillExpenseTypeId").toString());
            toJsonArray.put("operationType", resultMap.get("operationType"));
            toJsonArray.put("expenseType", resultMap.get("expenseType"));
            toJsonArray.put("currencyTypeId", (Object)resultMap.get("currencyTypeId").toString());
            toJsonArray.put("billTypeCode", resultMap.get("billTypeCode"));
            toJsonArray.put("amountBalance", resultMap.get("amountBalance"));
            toJsonArray.put("amountBalanceOri", resultMap.get("amountBalanceOri"));
            toJsonArray.put("amountUsed", resultMap.get("amountUsed"));
            toJsonArray.put("checkAmountOri", resultMap.get("amountBalanceOri"));
            toJsonArray.put("checkAmount", resultMap.get("amountBalance"));
            jsonArray.add((Object)toJsonArray);
        }
        JSONObject jsonObjectReturn = new JSONObject();
        jsonObjectReturn.put("fromBills", (Object)jsonArray);
        return jsonObjectReturn.toJSONString();
    }

    protected BOSUuid creatIdByBillType(String billType) {
        BOSUuid id = null;
        if (billType.equals("BizAccountBill")) {
            id = BOSUuid.create((String)"4A44F49F");
        }
        return id;
    }

    protected void createNumberByBillType(Context ctx, String orgType, BizAccountBillInfo billInfo) {
        try {
            ICodingRuleManager iCodingRuleManager;
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            if (billInfo.getCU() != null) {
                billInfo.setCU((CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit));
            }
            if ((iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)billInfo, companyID) && billInfo.getNumber() == null && iCodingRuleManager.isAddView((IObjectValue)billInfo, companyID)) {
                billInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildBillInfo(BizCollBillBaseInfo billInfo, BizCollBillBaseInfo baseInfo, UserInfo user) {
        billInfo.setApplier(baseInfo.getApplier());
        billInfo.setBiller(user);
        billInfo.setOrgUnit(baseInfo.getOrgUnit());
        billInfo.setApplierCompany(baseInfo.getApplierCompany());
        billInfo.setCompany(baseInfo.getCompany());
        billInfo.setCostedDept(baseInfo.getCostedDept());
        billInfo.setCurrencyType(baseInfo.getCurrencyType());
        billInfo.setName("CPBCBILL");
        billInfo.setPosition(baseInfo.getPosition());
        billInfo.setAmount(new BigDecimal("0.00"));
        billInfo.setAmountApproved(new BigDecimal("0.00"));
        billInfo.setPrior(PriorEnum.LOW);
        billInfo.setState(StateEnum.SUBMIT);
        billInfo.put("payMode", baseInfo.get("payMode"));
    }

    private JSONArray getExpensetType(boolean invoicetype, IInvoiceTypeEntry invoiceService, BizCollBillBaseInfo baseInfo, String likeStr) throws BOSException {
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = this.getInvoiceTypeEntryInfo(invoicetype, invoiceService, baseInfo, likeStr);
        JSONArray expenseArray = new JSONArray();
        if (!BizCollUtil.objectIsNull(invoiceTypeEntryInfo)) {
            if (!BizCollUtil.objectIsNull(invoiceTypeEntryInfo.getExpenseType())) {
                JSONObject expense0 = new JSONObject();
                expense0.put("expenseName", (Object)invoiceTypeEntryInfo.getExpenseType().getName());
                expense0.put("expenseId", (Object)invoiceTypeEntryInfo.getExpenseType().getId().toString());
                expenseArray.add((Object)expense0);
            }
        } else {
            JSONObject expense0 = new JSONObject();
            expense0.put("expenseName", (Object)"\u5458\u5de5\u798f\u5229");
            expense0.put("expenseId", (Object)"M8jt/c8rR+64XV9aKNrjUXjkvJQ=");
            expenseArray.add((Object)expense0);
        }
        return expenseArray;
    }

    private ExpenseTypeInfo getExpenseTypeInfo(Context ctx, JSONArray expenseTypeInfos) {
        JSONObject expenseTypeInfo = expenseTypeInfos.getJSONObject(0);
        ExpenseTypeInfo expensetypeInfo = null;
        String id = "M8jt/c8rR+64XV9aKNrjUXjkvJQ=";
        if (expenseTypeInfos.size() > 0) {
            id = expenseTypeInfo.getString("expenseId");
        }
        try {
            expensetypeInfo = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(id), CpbcAPIFacadeControllerBean.getExpenseSelector());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return expensetypeInfo;
    }

    public static SelectorItemCollection getExpenseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("operationType.id"));
        sic.add(new SelectorItemInfo("operationType.number"));
        sic.add(new SelectorItemInfo("operationType.name"));
        return sic;
    }

    private InvoiceTypeEntryInfo getInvoiceTypeEntryInfo(boolean invoicetype, IInvoiceTypeEntry invoiceService, BizCollBillBaseInfo baseInfo, String likeStr) throws BOSException {
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)baseInfo.getCompany().getId().toString()));
        if (invoicetype) {
            filter.getFilterItems().add(new FilterItemInfo("invoiceType", (Object)likeStr));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)likeStr));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = BizCollUtil.getDefaultSelector();
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        viewInfo.setSelector(sic);
        InvoiceTypeEntryCollection invoiceTypeEntryInfos = invoiceService.getInvoiceTypeEntryCollection(viewInfo);
        if (invoiceTypeEntryInfos.size() > 0) {
            invoiceTypeEntryInfo = invoiceTypeEntryInfos.get(0);
        }
        return invoiceTypeEntryInfo;
    }

    @Override
    protected String _SumitBill(Context ctx, String data) throws BOSException {
        JSONObject eJsStrOut;
        int i;
        ContextUtils.loadUserContext((Context)ctx);
        BizCollBillBaseInfo baseInfo = null;
        try {
            baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        BizAccountBillInfo billInfo = new BizAccountBillInfo();
        billInfo.setId(this.creatIdByBillType("BizAccountBill"));
        this.createNumberByBillType(ctx, "Company", billInfo);
        this.buildBillInfo(billInfo, baseInfo, user);
        IInvoiceTypeEntry invoiceService = InvoiceTypeEntryFactory.getLocalInstance(ctx);
        JSONObject retunObject = new JSONObject();
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        billInfo.setBizReqDate(date);
        billInfo.setBillDate(date);
        billInfo.setName(BizCollBillTypeEnum.BIZ_ACCOUNT.toString());
        logger.error((Object)("#####cpbc API  _submitBill From invoiceInfo data=" + data));
        JSONObject fromData = JSONObject.parseObject((String)data);
        JSONArray invoiceData = fromData.getJSONArray("invoiceData");
        JSONObject bizResult = fromData.getJSONObject("easResult");
        JSONArray loanBills = fromData.getJSONArray("loanBills");
        JSONArray reqBills = fromData.getJSONArray("reqBills");
        billInfo.setCause(fromData.getString("expenseCause"));
        retunObject.put("bxd_key", (Object)billInfo.getId().toString());
        retunObject.put("billnumber", (Object)billInfo.getNumber());
        JSONObject groupMapByInvoiceType = bizResult.getJSONObject("groupMapByInvoiceType");
        HashMap valueMapByInvoiceType = new HashMap();
        JSONObject groupMapByTaxClassNumber = bizResult.getJSONObject("groupMapByTaxClassNumber");
        HashMap valueMapByTaxClassNumber = new HashMap();
        String ticketCode = null;
        BigDecimal amount = new BigDecimal("0.0");
        BigDecimal taxAmount = new BigDecimal("0.0");
        TicketEntryCollection tCollection = new TicketEntryCollection();
        BizAccountBillEntryCollection bizCollection = new BizAccountBillEntryCollection();
        ExchangeRateInfo exchangeRate = null;
        try {
            exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(billInfo.getCurrencyType().getId().toString(), null, billInfo.getApplierCompany().getId().toString(), billInfo.getBizReqDate());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        BigDecimal expenseAmount = new BigDecimal("0.0");
        if (!BizCollUtil.objectIsNull(fromData.getString("expenseAmount"))) {
            expenseAmount = new BigDecimal(fromData.getString("expenseAmount"));
        }
        billInfo.setAmount(expenseAmount);
        if (!BizCollUtil.objectIsNull(loanBills)) {
            BigDecimal totalCheckAmountOri = new BigDecimal("0.00");
            if (!BizCollUtil.objectIsNull(fromData.getString("totalCheckAmountOri"))) {
                totalCheckAmountOri = new BigDecimal(fromData.getString("totalCheckAmountOri"));
            }
            billInfo.setAmountEncashed(expenseAmount.subtract(totalCheckAmountOri));
        } else {
            billInfo.setAmountEncashed(expenseAmount);
        }
        Set keysetByInvoiceType = groupMapByInvoiceType.keySet();
        Iterator itByInvoiceType = keysetByInvoiceType.iterator();
        JSONArray entriesJson = new JSONArray();
        HashMap entryLinkInvoice = new HashMap();
        for (int k = 0; k < keysetByInvoiceType.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByInvoiceType.next().toString();
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = new BigDecimal(0.0);
            BigDecimal eTaxAmount = new BigDecimal(0.0);
            Map valuemap = (Map)groupMapByInvoiceType.get(invoiceif);
            if (BizCollUtil.objectIsNull(valuemap)) {
                valuemap = (Map)groupMapByInvoiceType.get(Integer.parseInt(invoiceif));
            }
            BizAccountBillEntryInfo entry = new BizAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)new BOSObjectType("F2062F13"));
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entry.setTicketCode(ticketCode);
            entryJson.put("entryid", (Object)entryBosId.toString());
            entryJson.put("fid", valuemap.get("fid"));
            entriesJson.add((Object)entryJson);
            entryLinkInvoice.putAll(InvoiceUtil.buildInvoiceIdMap(entryBosId.toString(), valuemap.get("fid").toString()));
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            this.buildBizEntryInfo(ctx, entry, baseInfo, bizResult.getJSONArray("data"), valuemap.get("fid").toString());
            eAmount = entry.getAmount();
            eTaxAmount = new BigDecimal(valuemap.get("taxAmount").toString());
            entry.setCurrencyType(billInfo.getCurrencyType());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            if (eAmount != null) {
                eAmount = eAmount.setScale(2, 4);
                entry.setAmountOri(eAmount);
                entry.setAmountApprovedOri(eAmount);
                entry.setAmountOriWithoutTax(eAmount);
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryExRate = entry.getExchangeRate();
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    entryAmount = entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE) ? eAmount.divide(entryExRate, 2, 4) : eAmount.multiply(entryExRate).setScale(2, 4);
                }
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmount);
                entry.setAmountApproved(entryAmount);
            } else {
                entry.setAmount(new BigDecimal("1.00"));
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount);
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
            }
            bizCollection.add(entry);
        }
        Set keysetByTaxClassNumber = groupMapByTaxClassNumber.keySet();
        Iterator itByTaxClassNumber = keysetByTaxClassNumber.iterator();
        HashMap entryLinkInvoiceByTaxClassNumber = new HashMap();
        for (int k = 0; k < keysetByTaxClassNumber.size(); ++k) {
            JSONObject entryJson = new JSONObject();
            String invoiceif = itByTaxClassNumber.next().toString();
            String tmpStr = invoiceif.replaceAll("(0){1,}$", "%");
            String invoiceNumStr = "\u53d1\u7968";
            BigDecimal eAmount = new BigDecimal(0.0);
            BigDecimal eTaxAmount = new BigDecimal(0.0);
            Map valuemap = (Map)groupMapByTaxClassNumber.get(invoiceif);
            BizAccountBillEntryInfo entry = new BizAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            entry.setTicketUrl(entryBosId.toString());
            entry.setTicketCode(ticketCode);
            entryJson.put("entryid", (Object)entryBosId.toString());
            entryJson.put("fid", valuemap.get("fid"));
            entriesJson.add((Object)entryJson);
            entryLinkInvoice.putAll(InvoiceUtil.buildInvoiceIdMap(entryBosId.toString(), valuemap.get("fClassNumber").toString()));
            entry.setCurrencyType(billInfo.getCurrencyType());
            invoiceNumStr = invoiceNumStr + valuemap.get("count") + "\u5f20";
            entry.setInvoiceNum(invoiceNumStr);
            entry.setHappenTime(date);
            this.buildBizEntryInfo(ctx, entry, baseInfo, bizResult.getJSONArray("data"), valuemap.get("fid").toString());
            eAmount = entry.getAmount();
            eTaxAmount = new BigDecimal(valuemap.get("taxAmount").toString());
            if (exchangeRate != null && exchangeRate.getConvertRate() != null) {
                entry.setExchangeRate(exchangeRate.getConvertRate());
            } else {
                entry.setExchangeRate(new BigDecimal("1.0000"));
            }
            if (exchangeRate != null && exchangeRate.getExchangeAux() != null) {
                entry.setConvertMode(exchangeRate.getExchangeAux().getConvertMode());
                entry.setExchangeRatePrecision(exchangeRate.getExchangeAux().getPrecision());
            } else {
                entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                entry.setExchangeRatePrecision(4);
            }
            if (eAmount != null) {
                eAmount.setScale(2, 4);
                entry.setAmountOri(eAmount);
                entry.setAmountApprovedOri(eAmount);
                entry.setAmountOriWithoutTax(eAmount);
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryExRate = entry.getExchangeRate();
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    entryAmount = entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE) ? eAmount.divide(entryExRate, 2, 4) : eAmount.multiply(entryExRate).setScale(2, 4);
                }
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmount);
                entry.setAmountApproved(entryAmount);
            } else {
                entry.setAmount(new BigDecimal("1.00"));
            }
            if (eTaxAmount != null) {
                entry.setTax(eTaxAmount);
                BigDecimal tempDec = entry.getAmountOri().subtract(eTaxAmount);
                entry.setTaxRate(eTaxAmount.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
            }
            bizCollection.add(entry);
        }
        billInfo.getEntries().addCollection(bizCollection);
        for (int i2 = 0; i2 < invoiceData.size(); ++i2) {
            JSONObject eJsStrOut2 = invoiceData.getJSONObject(i2);
            TicketEntryInfo ticketEntry = new TicketEntryInfo();
            this.buildAPITicketEntryInfo(ticketEntry, eJsStrOut2, entryLinkInvoice);
            tCollection.add(ticketEntry);
        }
        billInfo.getTickeEntries().addCollection(tCollection);
        BizAccountBillReqCheckEntryCollection bizReqCols = new BizAccountBillReqCheckEntryCollection();
        BizAccountBillLoanCheckEntryCollection bizLoanCols = new BizAccountBillLoanCheckEntryCollection();
        for (i = 0; reqBills != null && i < reqBills.size(); ++i) {
            eJsStrOut = reqBills.getJSONObject(i);
            BizAccountBillReqCheckEntryInfo bizReqEntryInfo = new BizAccountBillReqCheckEntryInfo();
            bizReqEntryInfo.setSourceBillID(eJsStrOut.getString("id"));
            bizReqEntryInfo.setSourceBillEntryID(eJsStrOut.getString("entryid"));
            bizReqEntryInfo.setSourceBillNumber(eJsStrOut.getString("number"));
            bizReqEntryInfo.setSourceBillDate(eJsStrOut.getDate("bizReqDate"));
            bizReqEntryInfo.setSourceBillCause(eJsStrOut.getString("cause"));
            bizReqEntryInfo.setHasSourceBill(eJsStrOut.getBoolean("hasSourceBill"));
            bizReqEntryInfo.setSourceBillCostCenterName(eJsStrOut.getString("sourceBillCostCenterName"));
            bizReqEntryInfo.setConvertMode(ConvertModeEnum.getEnum((int)eJsStrOut.getIntValue("convertMode")));
            bizReqEntryInfo.setExchangeRate(eJsStrOut.getBigDecimal("exchangeRate"));
            bizReqEntryInfo.setExchangeRatePrecision(eJsStrOut.getIntValue("exchangeRatePrecision"));
            bizReqEntryInfo.setCurrencyType(this.getCurrencyInfo(ctx, eJsStrOut.getString("currencyTypeId")));
            bizReqEntryInfo.setSourceBillAmountUsed(eJsStrOut.getBigDecimal("amountUsed"));
            bizReqEntryInfo.setSourceBillAmountBalance(eJsStrOut.getBigDecimal("amountBalance"));
            bizReqEntryInfo.setSourceBillAmountBalanceOri(eJsStrOut.getBigDecimal("amountBalanceOri"));
            bizReqEntryInfo.setSourceBillCostCenterId(eJsStrOut.getString("sourceBillCostCenterId"));
            bizReqEntryInfo.setSourceBillExpenseTypeId(eJsStrOut.getString("sourceBillExpenseTypeId"));
            bizReqEntryInfo.setSourceBillExpenseType(eJsStrOut.getString("expenseType"));
            bizReqEntryInfo.setSourceBillOperationType(eJsStrOut.getString("operationType"));
            bizReqEntryInfo.setCheckAmountOri(eJsStrOut.getBigDecimal("checkAmountOri"));
            bizReqEntryInfo.setCheckAmount(eJsStrOut.getBigDecimal("checkAmount"));
            billInfo.getReqCheckEntries().add(bizReqEntryInfo);
        }
        for (i = 0; null != loanBills && i < loanBills.size(); ++i) {
            eJsStrOut = loanBills.getJSONObject(i);
            BizAccountBillLoanCheckEntryInfo bizLoanEntryInfo = new BizAccountBillLoanCheckEntryInfo();
            bizLoanEntryInfo.setSourceBillID(eJsStrOut.getString("id"));
            bizLoanEntryInfo.setSourceBillEntryID(eJsStrOut.getString("entryid"));
            bizLoanEntryInfo.setSourceBillNumber(eJsStrOut.getString("number"));
            bizLoanEntryInfo.setSourceBillDate(eJsStrOut.getDate("bizReqDate"));
            bizLoanEntryInfo.setSourceBillCause(eJsStrOut.getString("cause"));
            bizLoanEntryInfo.setHasSourceBill(eJsStrOut.getBoolean("hasSourceBill"));
            bizLoanEntryInfo.setSourceBillCostCenterName(eJsStrOut.getString("sourceBillCostCenterName"));
            bizLoanEntryInfo.setConvertMode(ConvertModeEnum.getEnum((int)eJsStrOut.getIntValue("convertMode")));
            bizLoanEntryInfo.setExchangeRate(eJsStrOut.getBigDecimal("exchangeRate"));
            bizLoanEntryInfo.setExchangeRatePrecision(eJsStrOut.getIntValue("exchangeRatePrecision"));
            bizLoanEntryInfo.setCurrencyType(this.getCurrencyInfo(ctx, eJsStrOut.getString("currencyTypeId")));
            bizLoanEntryInfo.setSourceBillAmountUsed(eJsStrOut.getBigDecimal("amountUsed"));
            bizLoanEntryInfo.setSourceBillAmountBalance(eJsStrOut.getBigDecimal("amountBalance"));
            bizLoanEntryInfo.setSourceBillAmountBalanceOri(eJsStrOut.getBigDecimal("amountBalanceOri"));
            bizLoanEntryInfo.setSourceBillCostCenterId(eJsStrOut.getString("sourceBillCostCenterId"));
            bizLoanEntryInfo.setSourceBillExpenseTypeId(eJsStrOut.getString("sourceBillExpenseTypeId"));
            bizLoanEntryInfo.setSourceBillExpenseType(eJsStrOut.getString("expenseType"));
            bizLoanEntryInfo.setSourceBillOperationType(eJsStrOut.getString("operationType"));
            bizLoanEntryInfo.setCheckAmountOri(eJsStrOut.getBigDecimal("checkAmountOri"));
            bizLoanEntryInfo.setCheckAmount(eJsStrOut.getBigDecimal("checkAmount"));
            billInfo.getLoanCheckEntries().add(bizLoanEntryInfo);
        }
        this.initDefaultCollectionEntry(ctx, billInfo, billInfo.getAmountEncashed());
        try {
            BizAccountBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)billInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"#####cpbc API  _submitBill EASBizException ++++++++++++++++======================");
            e.printStackTrace();
            return null;
        }
        retunObject.put("data", (Object)entriesJson);
        logger.error((Object)("#####cpbc API  _submitBill To invoiceInfo returnObject=" + retunObject.toJSONString()));
        return retunObject.toJSONString();
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String objPK) {
        CurrencyInfo cInfo = null;
        try {
            cInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(objPK));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return cInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("costedDept.id"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseType.number"));
        sic.add(new SelectorItemInfo("tickeEntries.*"));
        sic.add(new SelectorItemInfo("tickeEntries.id"));
        sic.add(new SelectorItemInfo("tickeEntries.amount"));
        return sic;
    }

    private void initDefaultCollectionEntry(Context ctx, ExpenseAccountBillInfo info, BigDecimal amountEncashed) {
        String applierid = info.getApplier().getId().toString();
        String id = info.getId().toString();
        try {
            info.setPayMode(this.getPayMode(ctx));
            ICollectionAccount icollection = null;
            icollection = ctx == null ? CollectionAccountFactory.getRemoteInstance() : CollectionAccountFactory.getLocalInstance(ctx);
            CollectionAccountInfo collectioninfo = icollection.getCollectionAccountInfo("select OpenArea.id,OpenArea.name,OpenArea.number,Bebank.id,Bebank.name,Bebank.number,BebankStr,BankAccount,Payee,SwiftCode where applier.id='" + applierid + "' and isDefault=1");
            if (collectioninfo != null) {
                logger.error((Object)"### runner cpbcAPIAPI initDefaultCollectionEntry collectioninfo is success");
                info.setPayerName(collectioninfo.getPayee());
                info.setPayerAccount(collectioninfo.getBankAccount());
                if (collectioninfo.getBebank() != null) {
                    info.setPayerBankStr(collectioninfo.getBebank());
                }
                info.setPayerBank(collectioninfo.getBebankStr());
                info.setOpenArea(collectioninfo.getOpenArea());
                if (this.isBizAccountBill(id)) {
                    logger.error((Object)("#### runner cpbcAPI  initDefaultCollectionEntry BizAccountBillInfo id = " + id));
                    BizAccountBillAccountEntryInfo entry = null;
                    entry = ((BizAccountBillInfo)info).getCollectionEntries() != null && ((BizAccountBillInfo)info).getCollectionEntries().size() > 0 ? ((BizAccountBillInfo)info).getCollectionEntries().get(0) : new BizAccountBillAccountEntryInfo();
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(this.getPayMode(ctx));
                    entry.setCurrencyType(this.getCurrentType(ctx));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amountEncashed);
                    entry.setAmountOri(amountEncashed);
                    ((BizAccountBillInfo)info).getCollectionEntries().clear();
                    ((BizAccountBillInfo)info).getCollectionEntries().add(entry);
                } else if (this.isTravelAccountBill(id)) {
                    logger.error((Object)("#### runner cpbcAPI  initDefaultCollectionEntry TravelAccountBillInfo id = " + id));
                    TravelAccountBillAccountEntryInfo entry = null;
                    if (((TravelAccountBillInfo)info).getCollectionEntries() != null && ((TravelAccountBillInfo)info).getCollectionEntries().size() > 0) {
                        ((TravelAccountBillInfo)info).getCollectionEntries().get(0);
                        entry = ((TravelAccountBillInfo)info).getCollectionEntries().get(0);
                    } else {
                        entry = new TravelAccountBillAccountEntryInfo();
                    }
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(this.getPayMode(ctx));
                    entry.setCurrencyType(this.getCurrentType(ctx));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amountEncashed);
                    entry.setAmountOri(amountEncashed);
                    ((TravelAccountBillInfo)info).getCollectionEntries().clear();
                    ((TravelAccountBillInfo)info).getCollectionEntries().add(entry);
                }
            } else {
                logger.error((Object)"### runner cpbcAPI  initDefaultCollectionEntry collectioninfo is null");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private SettlementTypeInfo getPayMode(Context ctx) throws BOSException, EASBizException {
        ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(BizCollUtil.getDefaultSelector());
        SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
        SettlementTypeInfo settle = null;
        if (collPay != null && collPay.size() > 0) {
            settle = collPay.get(0);
        }
        return settle;
    }

    public CurrencyInfo getCurrentType(Context ctx) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrency = ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency();
        CurrencyInfo currencyInfo = null;
        if (!BizCollUtil.objectIsNull(baseCurrency)) {
            currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()), BizCollUtil.getDefaultSelector());
        }
        logger.error((Object)("### runner cpbcAPI  currencyInfo =" + currencyInfo));
        return currencyInfo;
    }

    public boolean isTravelAccountBill(String id) {
        boolean isTravelAccountBill = false;
        if (!BizCollUtil.objectIsNull(id) && new TravelAccountBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isTravelAccountBill = true;
        }
        return isTravelAccountBill;
    }

    public boolean isBizAccountBill(String id) {
        boolean isBizAccountBill = false;
        if (!BizCollUtil.objectIsNull(id) && new BizAccountBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isBizAccountBill = true;
        }
        return isBizAccountBill;
    }

    public void buildBizEntryInfo(Context ctx, BizAccountBillEntryInfo entry, BizCollBillBaseInfo baseInfo, JSONArray entries, String fpId) {
        ExpenseTypeInfo expensetypeInfo = null;
        for (int i = 0; i < entries.size(); ++i) {
            JSONObject JSONEntry = entries.getJSONObject(i);
            if (!fpId.equals(JSONEntry.getString("fInvoiceId"))) continue;
            entry.setAmount(JSONEntry.getBigDecimal("amount"));
            expensetypeInfo = this.getExpenseTypeInfo(ctx, JSONEntry.getJSONArray("expenseTypeInfo"));
            entry.setExpenseType(expensetypeInfo);
            entry.setOperationType(expensetypeInfo.getOperationType());
        }
        entry.setPurpose("");
        entry.setAmountApproved(new BigDecimal("0.00"));
        entry.setAmountApprovedOri(new BigDecimal("0.00"));
        entry.setCompany(baseInfo.getCompany());
        entry.setCostCenter(baseInfo.getCostedDept());
        entry.setPayState(EntryStateEnum.UNDONE);
        entry.setReceiveState(EntryStateEnum.UNDONE);
        entry.setBudgetDo(new BigDecimal("0.00"));
    }

    public void buildAPITicketEntryInfo(TicketEntryInfo ticketEntry, JSONObject eJsStrOut, Map entryLinkInvoice) {
        Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
        String invoiceId = null;
        String taxClassNumber = null;
        String invoiceNumber = null;
        BigDecimal ftotalpricetax = new BigDecimal("0.0");
        BigDecimal ftotaltax = new BigDecimal("0.0");
        String ticketCode = null;
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("fphm"))) {
            invoiceNumber = eJsStrOut.getString("fphm");
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("spbm"))) {
            taxClassNumber = eJsStrOut.getString("spbm");
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("id"))) {
            invoiceId = eJsStrOut.getString("id");
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("totalPriceTax"))) {
            ftotalpricetax = new BigDecimal(eJsStrOut.getString("totalPriceTax"));
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("totalTax"))) {
            ftotaltax = new BigDecimal(eJsStrOut.getString("totalTax"));
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.getString("invoiceCode"))) {
            ticketCode = eJsStrOut.getString("invoiceCode");
        }
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
        ticketEntry.setId(entryBosId);
        ticketEntry.setTicketType(InvoiceUtil.getTicketType(invoiceTypeOut.toString()));
        ticketEntry.setTicketCode(ticketCode);
        ticketEntry.setTicketNumber(invoiceNumber);
        ticketEntry.setAmout(ftotalpricetax);
        ticketEntry.setTax(ftotaltax);
        if (!InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
            ticketEntry.setTaxClassNumber(taxClassNumber);
        }
        BigDecimal tempDec = ftotalpricetax.subtract(ftotaltax);
        ticketEntry.setTaxRate(ftotaltax.divide(tempDec, 2, 4).multiply(new BigDecimal(100)));
        BizAccountBillEntryInfo entryInfo = new BizAccountBillEntryInfo();
        if (!BizCollUtil.objectIsNull(entryLinkInvoice.get(invoiceId))) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get(invoiceId).toString()));
        } else if (!BizCollUtil.objectIsNull(eJsStrOut.getString("spbm"))) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get(eJsStrOut.getString("spbm")).toString()));
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    @Override
    protected String _QueryWorkFlowedBill(Context ctx, String jsonObject) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        return null;
    }

    @Override
    protected String _QueryWorkFlowingBill(Context ctx, String jsonObject) throws BOSException {
        ContextUtils.loadUserContext((Context)ctx);
        return null;
    }
}

