/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OtherDealRelateToOrg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CpbcOrgHasReferenced
implements OtherDealRelateToOrg {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CpbcCostOrgHasReferenced");
    private static final String[] EXPENSING_BILLTABLE = new String[]{"T_BC_BIZACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_DAILYLOANBILL", "T_BC_EVECTIONLOANBILL", "T_BC_OTHEREXPENSEBILL", "T_BC_EVECTIONREQBILL"};
    private static final String[] EXPENSING_ENTRYTABLE = new String[]{"T_BC_BIZACCOUNTBILLENTRY", "T_BC_BIZACCOUNTOUTBILLENTRY", "T_BC_DAILYPURCHASEACCONTENTRY", "T_BC_TRAVELACCOUNTBILLENTRY", "T_BC_DAILYLOANBILLENTRY", "T_BC_EVECTIONLOANBILLENTRY", "T_BC_OTHEREXPENSEBILLENTRY", "T_BC_EVECTIONREQBILLENTRY"};
    private static final String[] costBillFields = new String[]{"FCOSTEDDEPTID"};
    private static final String[] costEntryFields = new String[]{"FCOSTCENTERID"};

    public void afterDeal(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        logger.info((Object)("##cpbc afterDeal id=" + model.getId() + ",isCostOrgUnit=" + model.isIsCostOrgUnit()));
        if (model.isIsCostOrgUnit() && model.getPartCostCenter() != null) {
            String id = model.getId().toString();
            StringBuilder sql = new StringBuilder();
            boolean isBizUnit = model.getPartCostCenter().isIsBizUnit();
            if (isBizUnit) {
                logger.info((Object)("##costOrgUnit isBizUnit id=" + model.getId()));
                return;
            }
            sql.append("SELECT FISBIZUNIT FROM T_ORG_COSTCENTER WHERE FID = ? ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{id});
                if (!rs.next()) {
                    return;
                }
                if (rs.getInt("FISBIZUNIT") == 0) {
                    return;
                }
                this.checkIsBizUnit(ctx, id, costBillFields, costEntryFields);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void checkIsBizUnit(Context ctx, String id, String[] billFields, String[] entryFields) throws BOSException, EASBizException, SQLException {
        int entryTableSize;
        int j;
        int jsize;
        StringBuilder sql = new StringBuilder();
        ArrayList<String> idsList = new ArrayList<String>();
        int billTableSize = EXPENSING_BILLTABLE.length;
        if (billTableSize > 0) {
            sql.append("SELECT 1 WHERE EXISTS (");
            for (int i = 0; i < billTableSize; ++i) {
                String billTable = EXPENSING_BILLTABLE[i];
                jsize = billFields.length;
                for (j = 0; j < jsize; ++j) {
                    String billField = billFields[j];
                    sql.append(" SELECT 1 FROM ");
                    sql.append(billTable);
                    sql.append(" WHERE ");
                    sql.append(billField + " = ?");
                    if (i < billTableSize - 1 || j < jsize - 1) {
                        sql.append(" UNION ALL");
                    }
                    idsList.add(id);
                }
            }
        }
        if ((entryTableSize = EXPENSING_ENTRYTABLE.length) > 0) {
            sql.append(" UNION ALL");
            for (int i = 0; i < entryTableSize; ++i) {
                jsize = entryFields.length;
                for (j = 0; j < jsize; ++j) {
                    sql.append(" SELECT 1 FROM " + EXPENSING_ENTRYTABLE[i]);
                    sql.append(" WHERE ");
                    sql.append(entryFields[j] + " = ?");
                    if (i < entryTableSize - 1 || j < jsize - 1) {
                        sql.append(" UNION ALL");
                    }
                    idsList.add(id);
                }
            }
        }
        sql.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idsList.toArray());
            if (rs.next()) {
                throw new BizCollException(BizCollException.COSTORGHASREFERENCEDBYEXPENSEBILL);
            }
            logger.info((Object)("##OrgUnit noReferenced id=" + id));
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

