/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CreateFromObject;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseExpBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.MarketAccountBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractCreateFromFacadeControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CreateFromFacadeControllerBean
extends AbstractCreateFromFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CreateFromFacadeControllerBean");

    @Override
    protected List _getCreateFromCount(Context ctx, String bosType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bosType)) {
            return null;
        }
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        String srcBillBOSType = iBOTMapping.getSourceBillTypeList(bosType);
        if (srcBillBOSType.equals("")) {
            return null;
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        String desName = iBTPManager.getEntityObjectInfoDisplayName(bosType);
        String[] srcBillType = srcBillBOSType.split(",");
        ArrayList<CreateFromObject> list = new ArrayList<CreateFromObject>();
        for (int i = 0; i < srcBillType.length; ++i) {
            CreateFromObject cfObj = new CreateFromObject();
            cfObj.setSrcType(srcBillType[i]);
            cfObj.setDesType(bosType);
            cfObj.setSrcName(iBTPManager.getEntityObjectInfoDisplayName(srcBillType[i]));
            cfObj.setDesName(desName);
            cfObj.setSrcListUI(iBTPManager.getEntityObjectInfoExtendPro(srcBillType[i], "listUI"));
            cfObj.setSrcQueryInfo(iBTPManager.getEntityObjectInfoExtendPro(srcBillType[i], "defaultF7Query"));
            cfObj.setCount(this.executeBillcount(ctx, new BOSObjectType(srcBillType[i]), this.fillFilterInfo(ctx, srcBillType[i])));
            list.add(cfObj);
        }
        return list;
    }

    private FilterInfo fillFilterInfo(Context ctx, String bosType) {
        FilterInfo filter = new FilterInfo();
        boolean index = false;
        if (new DailyLoanBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new EvectionLoanBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new EvectionReqBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new DailyPurchaseExpBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new DailyPurchaseAccountBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new TravelAccountBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new OtherExpenseBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        } else if (new MarketAccountBillInfo().getBOSType().toString().equals(bosType)) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctx.get((Object)"CurCompanyId").toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        if (filter.getFilterItems().size() == 1) {
            filter.setMaskString("#0 or #1 or #2");
        } else {
            filter.setMaskString("(#0 or #1 or #2) and #3");
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeBillcount(Context ctx, BOSObjectType bosType, FilterInfo filterInfo) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ORMappingDAO dao = new ORMappingDAO(bosType, ctx, conn);
            int n = dao.getCount(filterInfo);
            return n;
        }
        catch (SQLException exc) {
            int n = 0;
            return n;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

