/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.ICreditControlSTDAssign;
import com.kingdee.eas.cp.bc.ICreditControlSTDEntry;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.app.AbstractCreditControlSTDControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.creditcontrol.util.CreditControlUtil;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CreditControlSTDControllerBean
extends AbstractCreditControlSTDControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CreditControlSTDControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    protected boolean _enable(Context ctx, List ids, boolean enable) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected List _getAssignPersons(Context ctx, String id) throws BOSException, EASBizException {
        ArrayList<PersonInfo> result = new ArrayList<PersonInfo>();
        if (id == null || id.length() < 0) {
            return result;
        }
        CreditControlSTDEntryCollection con = CreditControlSTDEntryFactory.getLocalInstance(ctx).getCreditControlSTDEntryCollection("select person.id,person.number,person.name where parent.id = '" + id + "'");
        Iterator it = con.iterator();
        while (it.hasNext()) {
            AdminOrgUnitInfo adminOrg;
            PersonInfo person = new PersonInfo();
            CreditControlSTDEntryInfo info = (CreditControlSTDEntryInfo)it.next();
            person.put("id", (Object)info.getPerson().getId());
            person.put("number", (Object)info.getPerson().getNumber());
            person.put("name", (Object)info.getPerson().getName());
            PositionInfo position = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(info.getPerson().getId());
            if (position != null && position.getName() != null) {
                person.put("Position.name", (Object)position.getName());
            }
            if ((adminOrg = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(info.getPerson().getId())) != null && adminOrg.getName() != null) {
                person.put("AdminOrgUnit.name", (Object)adminOrg.getName());
            }
            result.add(person);
        }
        return result;
    }

    @Override
    protected Map _getFilterInfoData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        FilterInfo fi = new FilterInfo();
        List<String> personIds = CommonDataWebUtils.getEqAndChildPerson(ctx);
        HashSet<String> set = new HashSet<String>();
        set.addAll(personIds);
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", set, CompareType.INCLUDE));
        result.put("personFilter", fi.toString());
        return result;
    }

    @Override
    protected List _queryAssignPerson(Context ctx, String creditControlSTDId) throws BOSException, EASBizException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.CreditControlSTDAssignPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlSTDId));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)1));
        filterInfo.setMaskString("#0 AND #1");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList resultList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> personMap = new HashMap<String, String>();
                personMap.put("id", (String)rowSet.getObject("person.id"));
                personMap.put("person.id", (String)rowSet.getObject("person.id"));
                personMap.put("person.name", (String)rowSet.getObject("person.name"));
                personMap.put("person.number", (String)rowSet.getObject("person.number"));
                personMap.put("adminOrgUnit.name", (String)rowSet.getObject("adminOrgUnit.name"));
                resultList.add(personMap);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    protected boolean _save(Context ctx, String model, List personIds) throws BOSException, EASBizException {
        if (model == null) {
            return false;
        }
        CreditControlSTDInfo info = (CreditControlSTDInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)model, CreditControlSTDInfo.class);
        if (info.getReimburseLV() == null || info.getCompany() == null) {
            return false;
        }
        this.checkInfo(ctx, info, personIds);
        CreditControlSTDFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        CreditControlSTDEntryFactory.getLocalInstance(ctx).delete("where parent.id = '" + info.getId().toString() + "'");
        if (personIds != null && personIds.size() > 0) {
            CoreBaseCollection con = new CoreBaseCollection();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String personId = it.next().toString();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                CreditControlSTDEntryInfo assignInfo = new CreditControlSTDEntryInfo();
                assignInfo.setPerson(person);
                assignInfo.setParent(info);
                con.add((CoreBaseInfo)assignInfo);
            }
            CreditControlSTDEntryFactory.getLocalInstance(ctx).saveBatchData(con);
        }
        return true;
    }

    private void checkInfo(Context ctx, CreditControlSTDInfo info, List personIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String lvId = info.getReimburseLV().getId().toString();
        String infoId = info.getId().toString();
        CreditControlSTDCollection con = CreditControlSTDFactory.getLocalInstance(ctx).getCreditControlSTDCollection("select id where reimburseLV = '" + lvId + "' and company.id = '" + company.getId().toString() + "' and id <> '" + infoId + "'");
        if (con.size() > 0) {
            throw new StandardException(StandardException.CREDITSTANDARD_REPEAT);
        }
        if (personIds != null && personIds.size() > 0) {
            StringBuffer string = new StringBuffer();
            StringBuffer oql = new StringBuffer();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                string.append("'").append(id).append("',");
            }
            string.deleteCharAt(string.length() - 1);
            oql.append("select id,person.number,person.name,parent.number where ").append("person.id in (").append(string.toString()).append(") and ").append("parent.reimburseLV.id = '").append(lvId).append("' and ").append("parent.id <> '").append(infoId).append("'");
            CreditControlSTDEntryCollection result = CreditControlSTDEntryFactory.getLocalInstance(ctx).getCreditControlSTDEntryCollection(oql.toString());
            if (result.size() > 0) {
                CreditControlSTDEntryInfo assignInfo = result.get(0);
                String personNumber = assignInfo.getPerson().getNumber();
                String personName = assignInfo.getPerson().getName();
                String person = personName + "(" + personNumber + ")";
                throw new StandardException(StandardException.CREDITSTANDARD_PERSON_REPEAT, new Object[]{person, assignInfo.getParent().getNumber()});
            }
        }
    }

    @Override
    protected void _cancelCreditControlSTDAssign(Context ctx, String type, String creditControlSTDId, String assignId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if ("company".equals(type)) {
            ICreditControlSTDAssign creditControlSTDASSignFactory = CreditControlSTDAssignFactory.getLocalInstance(ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("creditControlSTD", (Object)creditControlSTDId));
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)assignId));
            filterInfo.setMaskString("#0 and #1");
            creditControlSTDASSignFactory.delete(filterInfo);
        } else if ("person".equals(type)) {
            ICreditControlSTDEntry creditControlSTDEntryFactory = CreditControlSTDEntryFactory.getLocalInstance(ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)creditControlSTDId));
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)assignId));
            filterInfo.setMaskString("#0 and #1");
            creditControlSTDEntryFactory.delete(filterInfo);
        }
    }

    @Override
    protected Map _checkCreditControl(Context ctx, String personId, BigDecimal amount, String creditControlSTDId) throws BOSException, EASBizException {
        try {
            Map<String, Object> checkMap = CreditControlUtil.checkPersonCredit(ctx, personId, amount, creditControlSTDId);
            return checkMap;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    protected Map _getCreditControlSTDByPersonIds(Context ctx, List personIds) throws BOSException, EASBizException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        Date date = new Date();
        MultilingualUtil.formatDateTime(date);
        result.put("date", date);
        Iterator it = personIds.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            CreditControlSTDInfo creditInfo = CreditControlUtil.getCreditControlSTDByPerson(ctx, id);
            if (creditInfo == null) continue;
            result.put(id, creditInfo);
        }
        return result;
    }

    @Override
    protected Map _getCreditControlsByreimburseLVOrPerson(Context ctx, String companyId, String reimburseLevelId, String personIds, String billId) throws BOSException, EASBizException {
        CreditControlSTDCollection con;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (companyId != null && reimburseLevelId != null) {
            con = CreditControlSTDFactory.getLocalInstance(ctx).getCreditControlSTDCollection("select id where company.id = '" + companyId + "' and reimburseLV.id = '" + reimburseLevelId + "' and id <> '" + billId + "'");
            result.put("reimburseLevelId", (Object)con);
        }
        if (personIds != null && personIds.length() > 0) {
            con = null;
            CreditControlSTDEntryCollection entryCon = CreditControlSTDEntryFactory.getLocalInstance(ctx).getCreditControlSTDEntryCollection("select parent.id, parent.number, parent.company.id, parent.company.name , person.id, person.name where person in (" + personIds + ") and parent.isAllocPerson = 1 and parent.id <>" + billId + "'");
            if (entryCon != null && entryCon.size() > 0) {
                con = new CreditControlSTDCollection();
            }
            StringBuffer infos = new StringBuffer();
            Iterator it = entryCon.iterator();
            while (it.hasNext()) {
                CreditControlSTDEntryInfo entryInfo = (CreditControlSTDEntryInfo)it.next();
                CreditControlSTDInfo info = entryInfo.getParent();
                PersonInfo person = entryInfo.getPerson();
                CompanyOrgUnitInfo company = info.getCompany();
                infos.append(company.getName()).append(ResourceBase.getString((String)RESBIZCOLL, (String)"createCode", (Locale)ctx.getLocale())).append(info.getNumber()).append(ResourceBase.getString((String)RESBIZCOLL, (String)"CreditControl", (Locale)ctx.getLocale())).append(person.getName()).append(";\n");
            }
            result.put("error", infos.toString());
        }
        return result;
    }

    @Override
    protected Map _getPersonsUsedCredit(Context ctx, String userId) throws BOSException, EASBizException {
        try {
            String adminIds;
            if (userId == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("person.id"));
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
            if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
                Map usedCredit;
                String personId = userInfo.getPerson().getId().toString();
                AdminOrgUnitInfo adminOrg = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
                if (adminOrg != null) {
                    result.put("adminOrgId", adminOrg.getId().toString());
                    usedCredit = CreditControlUtil.getPersonsUsedCredit(ctx, adminOrg.getId().toString());
                    result.put("usedCredit", usedCredit);
                }
                result.put("personId", personId);
                if (result.get("usedCredit") == null) {
                    usedCredit = CreditControlUtil.getPersonUsedCredit(ctx, personId);
                    result.put("usedCredit", usedCredit);
                }
            }
            if ((adminIds = CommonWebUtilFacadeFactory.getLocalInstance(ctx).getSpecialData(userId)) != null) {
                FilterItemInfo filter = new FilterItemInfo("adminOrgUnitId", (Object)adminIds, CompareType.INCLUDE);
                result.put("adminIds", filter.toString());
            }
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    protected Map _initCreditControlSTDAssign(Context ctx, List creditControlStdIds) throws BOSException, EASBizException {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        if (creditControlStdIds == null || creditControlStdIds.size() == 0) {
            return resultMap;
        }
        try {
            Set<String> assignCompanys = this.getCreditControlSTDAssignCompanyIds(ctx, new HashSet<String>(creditControlStdIds));
            resultMap.put("assignCompanys", new ArrayList<String>(assignCompanys));
            resultMap.put("companyFilter", CommonDataWebUtils.getChildCompanyOrg(ctx));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return resultMap;
    }

    private Set<String> getCreditControlSTDAssignCompanyIds(Context ctx, Set<String> creditControlSTDIds) throws BOSException, EASBizException, SQLException {
        if (creditControlSTDIds == null || creditControlSTDIds.size() == 0) {
            return null;
        }
        HashSet<String> creditCSTDAssignCompanyIds = new HashSet<String>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.CreditControlSTDAssignQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("creditControlSTD.id", creditControlSTDIds, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet result = exec.executeQuery();
        while (result.next()) {
            String companyOrgUnitId = (String)result.getObject("companyOrgUnit.id");
            creditCSTDAssignCompanyIds.add(companyOrgUnitId);
        }
        return creditCSTDAssignCompanyIds;
    }

    @Override
    protected Map _initCreditControlSTDView(Context ctx, String creditControlSTDId) throws BOSException, EASBizException {
        HashMap<String, Collection<String>> resultMap = new HashMap<String, Collection<String>>();
        if (StringUtils.isEmpty((String)creditControlSTDId)) {
            return resultMap;
        }
        HashSet<String> personIds = new HashSet<String>();
        ICreditControlSTDEntry creditControlSTDEntryFactory = CreditControlSTDEntryFactory.getLocalInstance(ctx);
        String queryOql = "select person.id where parent.id = '" + creditControlSTDId + "'";
        CreditControlSTDEntryCollection creditControlSTDEntryCollection = creditControlSTDEntryFactory.getCreditControlSTDEntryCollection(queryOql);
        for (int i = 0; i < creditControlSTDEntryCollection.size(); ++i) {
            personIds.add(creditControlSTDEntryCollection.get(i).getPerson().getId().toString());
        }
        List<String> adminIds = CommonDataWebUtils.getChildAdminIds(ctx);
        resultMap.put("adminIds", adminIds);
        resultMap.put("creditCSTDAssignPersonIds", personIds);
        HashSet<String> creditControlSTDIds = new HashSet<String>();
        creditControlSTDIds.add(creditControlSTDId);
        try {
            Set<String> creditControlSTDAssignCompanyIds = this.getCreditControlSTDAssignCompanyIds(ctx, creditControlSTDIds);
            resultMap.put("creditCSTDAssignCompanyIds", new ArrayList<String>(creditControlSTDAssignCompanyIds));
            resultMap.put("orgFilterIds", CommonDataWebUtils.getChildCompanyOrg(ctx));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    @Override
    protected List _saveCreditControlSTDAssign(Context ctx, List creditControlSTDIds, List companyOrgUnits) throws BOSException, EASBizException {
        ArrayList errorList = new ArrayList();
        ICreditControlSTDAssign creditControlSTDAssignFactory = CreditControlSTDAssignFactory.getLocalInstance(ctx);
        Set<String> companyIdList = this.getListMapIds(companyOrgUnits);
        Set<String> creditControlStIds = this.getListMapIds(creditControlSTDIds);
        CoreBaseCollection creditControlSTAssignCollection = new CoreBaseCollection();
        int is = creditControlSTDIds.size();
        for (int i = 0; i < is; ++i) {
            Map creditControlSTD = (Map)creditControlSTDIds.get(i);
            String reimburseLevel = (String)creditControlSTD.get("reimburseLV.id");
            String creditControlSTId = (String)creditControlSTD.get("id");
            String creditControlSTName = (String)creditControlSTD.get("name");
            CreditControlSTDInfo creditControlSTInfo = new CreditControlSTDInfo();
            creditControlSTInfo.setId(BOSUuid.read((String)creditControlSTId));
            FilterInfo queryExistFilter = new FilterInfo();
            queryExistFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", companyIdList, CompareType.INCLUDE));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("creditControlSTD.reimburseLV.id", (Object)reimburseLevel));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("creditControlSTD.id", (Object)creditControlSTId, CompareType.NOTEQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("companyOrgUnit.id"));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(queryExistFilter);
            entityViewInfo.setSelector(selector);
            CoreBaseCollection existAssignCompany = creditControlSTDAssignFactory.getCollection(entityViewInfo);
            Set<String> existCompanyIds = CommonDataWebUtils.getPropIds((AbstractObjectCollection)existAssignCompany, "companyOrgUnit");
            ArrayList<String> errorCompanyList = new ArrayList<String>();
            int js = companyOrgUnits.size();
            for (int j = 0; j < js; ++j) {
                String companyId = ((Map)companyOrgUnits.get(j)).get("id").toString();
                if (existCompanyIds.contains(companyId)) {
                    String companyName = (String)((Map)companyOrgUnits.get(j)).get("name");
                    errorCompanyList.add(companyName);
                } else {
                    CreditControlSTDAssignInfo creditControlSTAssignInfo = new CreditControlSTDAssignInfo();
                    creditControlSTAssignInfo.setCreditControlSTD(creditControlSTInfo);
                    CompanyOrgUnitInfo assignCompany = new CompanyOrgUnitInfo();
                    assignCompany.setId(BOSUuid.read((String)companyId));
                    creditControlSTAssignInfo.setCompanyOrgUnit(assignCompany);
                    creditControlSTAssignCollection.add((CoreBaseInfo)creditControlSTAssignInfo);
                }
                if (errorCompanyList.size() == 0) continue;
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("creditControlStName", creditControlSTName);
                errorMap.put("companyList", errorCompanyList);
                errorList.add(errorMap);
            }
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("creditControlSTD.id", creditControlStIds, CompareType.INCLUDE));
        creditControlSTDAssignFactory.delete(delFilterInfo);
        if (creditControlSTAssignCollection.size() != 0) {
            creditControlSTDAssignFactory.addnewBatchData(creditControlSTAssignCollection);
        }
        return errorList;
    }

    private Set<String> getListMapIds(List<Map<String, Object>> listMap) {
        HashSet<String> resultSet = new HashSet<String>();
        int is = listMap.size();
        for (int i = 0; i < is; ++i) {
            Object idObj = listMap.get(i).get("id");
            if (idObj == null) continue;
            resultSet.add(idObj.toString());
        }
        return resultSet;
    }

    @Override
    protected Map _saveCreditControlSTDAssignPerson(Context ctx, Map creditControlStandard, List persons) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        if (creditControlStandard == null) {
            return resultMap;
        }
        ICreditControlSTDEntry creditControlStEntryFactory = CreditControlSTDEntryFactory.getLocalInstance(ctx);
        Set<String> assignPersonIds = this.getListMapIds(persons);
        String creditControlStandardId = creditControlStandard.get("id").toString();
        FilterInfo queryExistFilter = new FilterInfo();
        queryExistFilter.getFilterItems().add(new FilterItemInfo("person.id", assignPersonIds, CompareType.INCLUDE));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlStandardId, CompareType.NOTEQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.id"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryExistFilter);
        entityViewInfo.setSelector(selector);
        CreditControlSTDEntryCollection creditControlSTDEntryCollection = creditControlStEntryFactory.getCreditControlSTDEntryCollection(entityViewInfo);
        Set<String> existAssignPersonIds = CommonDataWebUtils.getPropIds(creditControlSTDEntryCollection, "person");
        CreditControlSTDInfo creditControlStInfo = new CreditControlSTDInfo();
        creditControlStInfo.setId(BOSUuid.read((String)creditControlStandardId));
        CoreBaseCollection assignPersons = new CoreBaseCollection();
        ArrayList<PersonInfo> savedPersons = new ArrayList<PersonInfo>();
        ArrayList<String> unAssignPersons = new ArrayList<String>();
        int is = persons.size();
        for (int i = 0; i < is; ++i) {
            String personId = ((Map)persons.get(i)).get("id").toString();
            if (existAssignPersonIds.contains(personId)) {
                String personName = (String)((Map)persons.get(i)).get("name");
                unAssignPersons.add(personName);
                continue;
            }
            CreditControlSTDEntryInfo assignPerson = new CreditControlSTDEntryInfo();
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            assignPerson.setPerson(person);
            assignPerson.setParent(creditControlStInfo);
            assignPersons.add((CoreBaseInfo)assignPerson);
            savedPersons.add(person);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlStandardId));
        creditControlStEntryFactory.delete(delFilterInfo);
        if (assignPersons.size() != 0) {
            creditControlStEntryFactory.addnewBatchData(assignPersons);
        }
        resultMap.put("assignPersons", savedPersons);
        resultMap.put("unAssignPersons", unAssignPersons);
        return resultMap;
    }
}

