/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.app.AbstractDailyAccountEditUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DailyAccountEditUIHandler
extends AbstractDailyAccountEditUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.DailyAccountEditUIHandler");

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        EntityViewInfo viewInfo = (EntityViewInfo)request.get("viewInfo");
        SettlementTypeCollection scol = SettlementTypeFactory.getLocalInstance((Context)context).getSettlementTypeCollection(viewInfo);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        DailyPurchaseAccountBillInfo info = new DailyPurchaseAccountBillInfo();
        this.buildNewData(request, response, context, info);
        info.setName(BizCollBillTypeEnum.DAILY_PURCHASE_ACCOUNT.toString());
        info.getEntries().add((DailyPurchaseAccountBillEntryInfo)this.createNewDetailData(request, response, context));
        return info;
    }

    protected IObjectValue createNewDetailData(RequestContext request, ResponseContext response, Context context) {
        DailyPurchaseAccountBillEntryInfo lineInfo = new DailyPurchaseAccountBillEntryInfo();
        try {
            BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(context).forLoanBillCreateNewData();
            lineInfo.setCostCenter(baseInfo.getCostedDept());
            lineInfo.setCompany(baseInfo.getCompany());
            lineInfo.setPayState(EntryStateEnum.UNDONE);
            lineInfo.setReceiveState(EntryStateEnum.UNDONE);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        lineInfo.setPrice(new BigDecimal("0.00"));
        lineInfo.setCount(new BigDecimal("0.00"));
        lineInfo.setAmount(new BigDecimal("0.00"));
        return lineInfo;
    }
}

