/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBgParam;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractDailyLoanBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class DailyLoanBillControllerBean
extends AbstractDailyLoanBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.DailyLoanBillControllerBean");
    private static String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    private void reWriteBillState(Context ctx, BOSUuid id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(id, state);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        DailyLoanBillInfo info = (DailyLoanBillInfo)this.getValue(ctx, pk);
        String orgId = null;
        orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        this.abortWorkingWf(ctx, pk);
        super._delete(ctx, pk);
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            boolean bl = iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
        if (BizCollUtil.objectIsNull(info.getId()) || !BizCollUtil.objectIsNull(info.get("imageNo"))) {
            // empty if block
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (DailyLoanBillInfo)model);
        } else if ("save".equals(action)) {
            this.checkValidate(ctx, (DailyLoanBillInfo)model);
            this.checkSaveEntry((DailyLoanBillInfo)model);
        }
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (DailyLoanBillInfo)model);
        } else if ("save".equals(action)) {
            this.checkValidate(ctx, (DailyLoanBillInfo)model);
            this.checkSaveEntry((DailyLoanBillInfo)model);
        }
    }

    protected void checkSaveEntry(DailyLoanBillInfo info) throws BOSException, EASBizException {
        if (this.objectIsNull(info.getNumber())) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        int size = info.getEntries().size();
        DailyLoanBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (!BizCollUtil.objectIsNull(entryInfo.getParticipants()) && entryInfo.getParticipants().trim().length() > 80) {
                throw new DailyLoanBillException(DailyLoanBillException.PARTICIPANTS_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getComment()) || entryInfo.getComment().trim().length() <= 200) continue;
            throw new DailyLoanBillException(DailyLoanBillException.COMMENT_TOO_LONG);
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DailyLoanBillInfo info = (DailyLoanBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new DailyLoanBillException(DailyLoanBillException.NUMBER_NOT_DUP);
        }
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DailyLoanBillInfo info = (DailyLoanBillInfo)model;
        String sourceId = info.getSourceBillId();
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new DailyLoanBillException(DailyLoanBillException.NAME_TOO_LONG);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new DailyLoanBillException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new DailyLoanBillException(DailyLoanBillException.NUMBER_TOO_LONG);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new DailyLoanBillException(DailyLoanBillException.REQDATE_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getCurrencyType()) && (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.CURRENCYTYPE_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCostedDept()) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.COSTEDDEPT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (BizCollUtil.objectIsNull(info.getApplier()) && (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.APPLIER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getOrgUnit()) && (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCompany()) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.COMPANY_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new DailyLoanBillException(DailyLoanBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new DailyLoanBillException(DailyLoanBillException.BILLDATE_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBiller()) && BizCollUtil.objectIsNull(info.getBiller().getId())) {
            throw new DailyLoanBillException(DailyLoanBillException.BILLER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new DailyLoanBillException(DailyLoanBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new DailyLoanBillException(DailyLoanBillException.ENTRY_NOT_NULL);
        }
        DailyLoanBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (entryInfo.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (sourceId != null && !BizCollUtil.isEvectionReq(sourceId)) {
                if (entryInfo.getAmount() == null) {
                    throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
                }
            } else if (entryInfo.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (!BizCollUtil.bigDecimalObjectLessThan(entryInfo.getAmountApproved(), entryInfo.getAmount())) {
                throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entryInfo.getAmountApproved(), entryInfo.getAmount()});
            }
            if (BizCollUtil.objectIsNull(entryInfo.getComment()) || entryInfo.getComment().trim().length() <= 200) continue;
            throw new DailyLoanBillException(DailyLoanBillException.COMMENT_TOO_LONG);
        }
    }

    protected void checkValidate(Context ctx, DailyLoanBillInfo info) throws EASBizException {
        if (BizCollUtil.objectIsNull(info.getForeseeDate())) {
            Date date = info.getBizReqDate();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            gc.add(2, 3);
            info.setForeseeDate(gc.getTime());
        }
        if ("submit".equals(this.action) && !this.billHasSubmit && !BizCollUtil.objectIsNull(info.getForeseeDate()) && info.getForeseeDate().compareTo(new Date()) <= 0) {
            throw new DailyLoanBillException(DailyLoanBillException.FORESEEDATEMUSTLATER);
        }
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new DailyLoanBillException(DailyLoanBillException.NAME_TOO_LONG);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new DailyLoanBillException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new DailyLoanBillException(DailyLoanBillException.NUMBER_TOO_LONG);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new DailyLoanBillException(DailyLoanBillException.REQDATE_NOT_NULL);
        }
        if (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId())) {
            throw new DailyLoanBillException(DailyLoanBillException.CURRENCYTYPE_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCostedDept()) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.COSTEDDEPT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (BizCollUtil.objectIsNull(info.getApplier()) && (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.APPLIER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getOrgUnit()) && (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCompany()) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new DailyLoanBillException(DailyLoanBillException.COMPANY_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new DailyLoanBillException(DailyLoanBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new DailyLoanBillException(DailyLoanBillException.BILLDATE_NOT_NULL);
        }
        if (info.getBiller() == null || BizCollUtil.objectIsNull(info.getBiller().getId())) {
            throw new DailyLoanBillException(DailyLoanBillException.BILLER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new DailyLoanBillException(DailyLoanBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new DailyLoanBillException(DailyLoanBillException.ENTRY_NOT_NULL);
        }
        DailyLoanBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (!BizCollUtil.objectIsNull(entryInfo.getParticipants()) && entryInfo.getParticipants().trim().length() > 80) {
                throw new DailyLoanBillException(DailyLoanBillException.PARTICIPANTS_TOO_LONG);
            }
            if (!BizCollUtil.objectIsNull(entryInfo.getComment()) && entryInfo.getComment().trim().length() > 200) {
                throw new DailyLoanBillException(DailyLoanBillException.COMMENT_TOO_LONG);
            }
            if (!this.showHeadCompanys.equals("1") && !this.showHeadCompanys.equals("2") || this.fromMbos.booleanValue()) continue;
            if (entryInfo.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entryInfo.getCostCenter() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
        }
        if (this.isRelaAp && !this.fromMbos.booleanValue()) {
            DailyLoanBillAccountEntryInfo collectionInfo = null;
            for (int i = 0; i < info.getCollectionEntries().size(); ++i) {
                collectionInfo = info.getCollectionEntries().get(i);
                if (collectionInfo.getPayMode() != null && ("\u73b0\u91d1".equals(collectionInfo.getPayMode().getName()) || "\u73fe\u91d1".equals(collectionInfo.getPayMode().getName()) || "cash".equalsIgnoreCase(collectionInfo.getPayMode().getName()))) continue;
                if (collectionInfo.getPayerBank() == null && collectionInfo.getPayerBankF7() == null) {
                    throw new ExpAccException(ExpAccException.PAYERBANKNOTNULL);
                }
                if (collectionInfo.getPayerAccount() != null) continue;
                throw new ExpAccException(ExpAccException.PAYERACCOUNTNOTNULL);
            }
        }
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKED);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setNotPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKFAILD);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected BgCtrlParam[] _getBgParam(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return null;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BgCtrlParam[] params = new BgCtrlParam[]{new BgCtrlParam()};
        BgTypeInfo bgTypeInfo = BgTypeFactory.getLocalInstance((Context)ctx).getValueByNumber("ExpenseBudget");
        params[0].setBgTypeId(bgTypeInfo.getId());
        CompanyOrgUnitInfo couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        PeriodInfo perInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)BizCollUtil.covertToSimpleDate(info.getBizReqDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)BizCollUtil.covertToSimpleDate(info.getBizReqDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)couInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            perInfo = periodc.get(0);
        }
        params[0].setPeriodId(perInfo.getId());
        params[0].setBizOrgUnitId(info.getCostedDept().getId());
        params[0].setCurrencyId(info.getCurrencyType().getId());
        params[0].setCompanyId(info.getCompany().getId());
        params[0].setCtrlSystem(SystemEnum.BUSINESS_COLLABORATION);
        params[0].setSrcBillId(info.getId());
        params[0].setSrcBillNumber(info.getNumber());
        params[0].setBizDate(info.getBizReqDate());
        if (info.getSupportedObj() != null && !BizCollUtil.objectIsNull(info.getSupportedObj().getId())) {
            BOSUuid costId = info.getSupportedObj().getId();
            ICostObject iCost = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costInfo = iCost.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            MaterialInfo mat = new MaterialInfo();
            mat.setId(costInfo.getRelatedId());
            params[0].addDimension(BgDimensionEnum.PRODUCT, (IObjectValue)mat);
        }
        params[0].addDimension(BgDimensionEnum.ACCOUNT, (IObjectValue)info.getExpenseType());
        BgCtrlData data = new BgCtrlData();
        data.setDataType(BgDataTypeEnum.Amount);
        data.setValue(info.getAmount());
        params[0].addData(BgElementEnum.AMT, data);
        return params;
    }

    @Override
    protected void _setPaymentState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.ALREADYPAYMENT);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CLOSED);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected boolean _needBgAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (!BizCollUtil.isNeedBudgetControl(ctx, id)) {
            return false;
        }
        ObjectUuidPK objpk = new ObjectUuidPK(id);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo billInfo = (CoreBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        if (billInfo.getSourceBillId() == null || "".equals(billInfo.getSourceBillId())) {
            return true;
        }
        if (BizCollUtil.getBypeByBill(BizCollBillTypeEnum.EVECTION_REQ).equals((Object)BizCollUtil.getBOSType(billInfo.getSourceBillId()))) {
            return true;
        }
        return true;
    }

    @Override
    protected void _reBackBg(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        DailyLoanBgParam dlBgParam = new DailyLoanBgParam();
        BgCtrlParam[] params = dlBgParam.getBgParam(ctx, id);
        IBgControl iBgControl = BgControlFactory.getLocalInstance((Context)ctx);
        iBgControl.bgCancelAudit(params);
    }

    @Override
    protected void _payment(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.reWriteBillState(ctx, id, StateEnum.ISPAYBILL);
    }

    @Override
    protected void _setCheckingState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setState(StateEnum.CHECKING);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.DRAFT);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected List _getCanDeleteIDs(Context ctx, List list) throws BOSException, EASBizException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (BizCollUtil.objectIsNull(list) || list.size() == 0) {
            return returnList;
        }
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DailyLoanBillInfo info;
            String id = (String)list.get(i);
            if (BizCollUtil.objectIsNull(id) || !StateEnum.DRAFT.equals((Object)(info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id))).getState()) && !StateEnum.NEW.equals((Object)info.getState())) continue;
            returnList.add(id);
        }
        return returnList;
    }

    @Override
    protected boolean _isCanModify(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return !BizCollUtil.objectIsNull(id);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid id, StateEnum state) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        DailyLoanBillInfo info = this.getDailyLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(state);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    private void setActionFlag(Context ctx, DailyLoanBillInfo billInfo, String actionFlag) throws BOSException, EASBizException {
        billInfo.setActionFlag(actionFlag);
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    private boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info, String destObjectID) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info, destObjectID)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    private boolean isSrcBillRelPayBill(Context ctx, BizCollBillBaseInfo info) {
        boolean isSrcBillRelPayBill = false;
        try {
            if (BizCollUtil.checkBillHasRePaybill(ctx, info)) {
                isSrcBillRelPayBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSrcBillRelPayBill;
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected void _ngisc_submit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._ngisc_submit(ctx, pk, model);
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_DailyLoan_Update";
    }
}

