/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBgParam;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillException;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractEvectionReqBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvectionReqBillControllerBean
extends AbstractEvectionReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.EvectionReqBillControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EvectionReqBillInfo info = (EvectionReqBillInfo)this.getValue(ctx, pk);
        String orgId = null;
        orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        this.abortWorkingWf(ctx, pk);
        super._delete(ctx, pk);
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            boolean bl = iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (EvectionReqBillInfo)model);
        } else if ("save".equals(action)) {
            if (this.objectIsNull(((EvectionReqBillInfo)model).getNumber())) {
                throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
            }
            this.checkValidate(ctx, (EvectionReqBillInfo)model);
        }
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (EvectionReqBillInfo)model);
        } else if ("save".equals(action)) {
            if (this.objectIsNull(((EvectionReqBillInfo)model).getNumber())) {
                throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
            }
            this.checkValidate(ctx, (EvectionReqBillInfo)model);
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvectionReqBillInfo info = (EvectionReqBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new EvectionReqBillException(EvectionReqBillException.NUMBER_NOT_DUP);
        }
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        EvectionReqBillInfo info = (EvectionReqBillInfo)model;
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new EvectionReqBillException(EvectionReqBillException.NAME_TOO_LONG);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new EvectionReqBillException(EvectionReqBillException.REQDATE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EvectionReqBillException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionReqBillException(EvectionReqBillException.NUMBER_TOO_LONG);
        }
        if (BizCollUtil.objectIsNull(info.getApplier()) && (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.APPLIER_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (BizCollUtil.objectIsNull(info.getOrgUnit()) && (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCompany()) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.COMPANY_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new EvectionReqBillException(EvectionReqBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new EvectionReqBillException(EvectionReqBillException.BILLDATE_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBiller()) && (info.getBiller() == null || BizCollUtil.objectIsNull(info.getBiller().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.BILLER_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCostedDept()) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.COSTEDDEPT_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getCurrencyType()) && (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.CURRENCYTYPE_NOT_NULL);
        }
        if (BizCollUtil.bigDecimalObjectLessThan(info.getIntendingDays(), new BigDecimal("0.0"))) {
            throw new EvectionReqBillException(EvectionReqBillException.INTENDINGDAYS_ILLEGAL);
        }
        if (!this.isEntryAmountZero && BizCollUtil.bigDecimalObjectLessThan(info.getAmount(), new BigDecimal("0.0"))) {
            throw new EvectionReqBillException(EvectionReqBillException.AMOUNT_ILLEGAL);
        }
        if (info.getTotalPeople() < 0) {
            throw new EvectionReqBillException(EvectionReqBillException.TOTALPEOPLE_ILLEGAL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new EvectionReqBillException(EvectionReqBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new EvectionReqBillException(EvectionReqBillException.ENTRY_NOT_NULL);
        }
        EvectionReqBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (BizCollUtil.objectIsNull(entryInfo.getStartDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.STARTDATE_NOT_NULL);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getFrom())) {
                throw new EvectionReqBillException(EvectionReqBillException.FROM_NOT_NULL);
            }
            if (entryInfo.getFrom().trim().length() > 100) {
                throw new EvectionReqBillException(EvectionReqBillException.FROM_TOO_LONG);
            }
            if (entryInfo.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (entryInfo.getAmount() == null) {
                throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
            }
            if (entryInfo.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getEndDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.ENDDATE_NOT_NULL);
            }
            if (entryInfo.getStartDate().after(entryInfo.getEndDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.STARTDATE_NOT_GREATER_ENDDATE);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getTo())) {
                throw new EvectionReqBillException(EvectionReqBillException.TO_NOT_NULL);
            }
            if (entryInfo.getTo().trim().length() > 100) {
                throw new EvectionReqBillException(EvectionReqBillException.TO_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull((Object)entryInfo.getVehicle())) {
                throw new EvectionReqBillException(EvectionReqBillException.VEHICLE_NOT_NULL);
            }
            if (!this.showHeadCompanys.equals("1") && !this.showHeadCompanys.equals("2") || this.fromMbos.booleanValue()) continue;
            if (entryInfo.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
            }
            if (entryInfo.getCompany() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
        }
    }

    protected void checkValidate(Context ctx, EvectionReqBillInfo info) throws EASBizException {
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new EvectionReqBillException(EvectionReqBillException.NAME_TOO_LONG);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new EvectionReqBillException(EvectionReqBillException.REQDATE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EvectionReqBillException(EvectionReqBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionReqBillException(EvectionReqBillException.NUMBER_TOO_LONG);
        }
        if (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId())) {
            throw new EvectionReqBillException(EvectionReqBillException.APPLIER_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId())) {
            throw new EvectionReqBillException(EvectionReqBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new EvectionReqBillException(EvectionReqBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new EvectionReqBillException(EvectionReqBillException.BILLDATE_NOT_NULL);
        }
        if (info.getBiller() == null || BizCollUtil.objectIsNull(info.getBiller().getId())) {
            throw new EvectionReqBillException(EvectionReqBillException.BILLER_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new EvectionReqBillException(EvectionReqBillException.COSTEDDEPT_NOT_NULL);
        }
        if (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId())) {
            throw new EvectionReqBillException(EvectionReqBillException.CURRENCYTYPE_NOT_NULL);
        }
        if (BizCollUtil.bigDecimalObjectLessThan(info.getIntendingDays(), new BigDecimal("0.0"))) {
            throw new EvectionReqBillException(EvectionReqBillException.INTENDINGDAYS_ILLEGAL);
        }
        if (info.getTotalPeople() < 0) {
            throw new EvectionReqBillException(EvectionReqBillException.TOTALPEOPLE_ILLEGAL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new EvectionReqBillException(EvectionReqBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new EvectionReqBillException(EvectionReqBillException.ENTRY_NOT_NULL);
        }
        EvectionReqBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (BizCollUtil.objectIsNull(entryInfo.getStartDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.STARTDATE_NOT_NULL);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getFrom())) {
                throw new EvectionReqBillException(EvectionReqBillException.FROM_NOT_NULL);
            }
            if (entryInfo.getFrom().trim().length() > 80) {
                throw new EvectionReqBillException(EvectionReqBillException.FROM_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getEndDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.ENDDATE_NOT_NULL);
            }
            if (entryInfo.getStartDate().after(entryInfo.getEndDate())) {
                throw new EvectionReqBillException(EvectionReqBillException.STARTDATE_NOT_GREATER_ENDDATE);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getTo())) {
                throw new EvectionReqBillException(EvectionReqBillException.TO_NOT_NULL);
            }
            if (entryInfo.getTo().trim().length() > 80) {
                throw new EvectionReqBillException(EvectionReqBillException.TO_TOO_LONG);
            }
            if (!BizCollUtil.objectIsNull(entryInfo.getPartner()) && entryInfo.getPartner().trim().length() > 80) {
                throw new EvectionReqBillException(EvectionReqBillException.PARTNER_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull((Object)entryInfo.getVehicle())) {
                throw new EvectionReqBillException(EvectionReqBillException.VEHICLE_NOT_NULL);
            }
            if (entryInfo.getCurrencyType() == null) {
                throw new EvectionReqBillException(EvectionReqBillException.CURRENCY_NOT_NULL);
            }
            if (!this.showHeadCompanys.equals("1") && !this.showHeadCompanys.equals("2") || this.fromMbos.booleanValue()) continue;
            if (entryInfo.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entryInfo.getCostCenter() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
        }
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKED);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        if (info.isIsDyncCheck()) {
            EvectionLoanBillFactory.getLocalInstance(ctx).setPassState(info.getLoanBillID().getId());
        }
    }

    @Override
    protected void _setNotPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKFAILD);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        if (info.isIsDyncCheck()) {
            EvectionLoanBillFactory.getLocalInstance(ctx).setNotPassState(info.getLoanBillID().getId());
        }
    }

    @Override
    protected BgCtrlParam[] _getBgParam(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return null;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BgCtrlParam[] params = new BgCtrlParam[]{new BgCtrlParam()};
        BgTypeInfo bgTypeInfo = BgTypeFactory.getLocalInstance((Context)ctx).getValueByNumber("ExpenseBudget");
        params[0].setBgTypeId(bgTypeInfo.getId());
        PeriodInfo perInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizReqDate(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (perInfo != null) {
            params[0].setPeriodId(perInfo.getId());
        }
        params[0].setBizOrgUnitId(info.getCostedDept().getId());
        params[0].setCurrencyId(info.getCurrencyType().getId());
        params[0].setCompanyId(info.getCompany().getId());
        params[0].setCtrlSystem(SystemEnum.BUSINESS_COLLABORATION);
        params[0].setSrcBillId(info.getId());
        params[0].setSrcBillNumber(info.getNumber());
        params[0].setBizDate(info.getBizReqDate());
        if (info.getSupportedObj() != null) {
            BOSUuid costId = info.getSupportedObj().getId();
            ICostObject iCost = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costInfo = iCost.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            MaterialInfo mat = new MaterialInfo();
            mat.setId(costInfo.getRelatedId());
            params[0].addDimension(BgDimensionEnum.PRODUCT, (IObjectValue)mat);
        }
        params[0].addDimension(BgDimensionEnum.ACCOUNT, (IObjectValue)info.getExpenseType());
        BgCtrlData data = new BgCtrlData();
        data.setDataType(BgDataTypeEnum.Amount);
        data.setValue(info.getAmount());
        params[0].addData(BgElementEnum.AMT, data);
        return params;
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CLOSED);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        if (info.isIsDyncCheck()) {
            EvectionLoanBillFactory.getLocalInstance(ctx).setCloseState(info.getLoanBillID().getId());
        }
    }

    @Override
    protected boolean _needBgAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        String sVal;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyId = "";
        if (ctx.get((Object)"CurCompanyId") != null) {
            companyId = ctx.get((Object)"CurCompanyId").toString();
        }
        return !"false".equals(sVal = iParam.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CP001"));
    }

    @Override
    protected void _reBackBg(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        EvectionReqBgParam dlBgParam = new EvectionReqBgParam();
        BgCtrlParam[] params = dlBgParam.getBgParam(ctx, id);
        IBgControl iBgControl = BgControlFactory.getLocalInstance((Context)ctx);
        iBgControl.bgCancelAudit(params);
    }

    @Override
    protected void _setCheckingState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKING);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        if (info.isIsDyncCheck()) {
            EvectionLoanBillFactory.getLocalInstance(ctx).setCheckingState(info.getLoanBillID().getId());
        }
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionReqBillInfo info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.DRAFT);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
        if (info.isIsDyncCheck()) {
            EvectionLoanBillFactory.getLocalInstance(ctx).setDraftState(info.getLoanBillID().getId());
        }
    }

    @Override
    protected List _getCanDeleteIDs(Context ctx, List list) throws BOSException, EASBizException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (BizCollUtil.objectIsNull(list) || list.size() == 0) {
            return returnList;
        }
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            EvectionReqBillInfo info;
            String id = (String)list.get(i);
            if (BizCollUtil.objectIsNull(id) || !StateEnum.DRAFT.equals((Object)(info = this.getEvectionReqBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id))).getState()) && !StateEnum.NEW.equals((Object)info.getState())) continue;
            returnList.add(id);
        }
        return returnList;
    }

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    @Override
    protected boolean _isCanModify(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return !BizCollUtil.objectIsNull(id);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        boolean eveReqUseNewMode;
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        BOTRelationInfo botObj = (BOTRelationInfo)bOTRelationInfo;
        BizCollBillBaseInfo srcObj = (BizCollBillBaseInfo)srcBillVO;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("NotCloseEvectionReqBill");
        paramList.add("CP001");
        paramList.add("CP051");
        paramList.add("CP05101");
        Map paramMap = null;
        paramMap = srcObj.getApplierCompany() != null && srcObj.getApplierCompany().getId() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, srcObj.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        boolean isNeedBudget = new Boolean(paramMap.get("CP001").toString());
        boolean eveReqBillUseBg = new Boolean(paramMap.get("CP051").toString());
        boolean bl = eveReqUseNewMode = paramMap.get("CP05101") == null ? false : new Boolean(paramMap.get("CP05101").toString());
        if (!(BizCollUtil.checkUseEveReqCheckEntries(isNeedBudget, eveReqBillUseBg, eveReqUseNewMode) || paramMap.get("NotCloseEvectionReqBill") != null && new Boolean(paramMap.get("NotCloseEvectionReqBill").toString()).booleanValue())) {
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                if (StateEnum.CHECKED.equals((Object)srcObj.getState())) {
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"23_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()) + srcBillPK.toString()));
                    this.reWriteBillState(ctx, srcBillPK.toString(), StateEnum.CLOSED);
                    ObjectUuidPK pk = new ObjectUuidPK(srcBillPK.toString());
                    IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"EvectionReqBillControllerBean", (BOSObjectType)pk.getObjectType(), (IObjectPK)pk, (String)("close \u51fa\u5dee\u7533\u8bf7\u81ea\u52a8\u5173\u95ed  \u5355\u636eid\uff1a" + pk.toString()));
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"24_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()));
                } else {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"25_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()));
                }
            } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                if (StateEnum.CLOSED.equals((Object)srcObj.getState())) {
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"26_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()) + srcBillPK.toString()));
                    ObjectUuidPK objpk = new ObjectUuidPK(botObj.getDestObjectID());
                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("state"));
                    BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, sic);
                    if (StateEnum.ALREADYABANDON.equals((Object)billInfo.getState()) || StateEnum.DRAFT.equals((Object)billInfo.getState())) {
                        ctx.put((Object)"isReWrite", (Object)new Boolean(true));
                    }
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"27_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()));
                } else {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"28_EvectionReqBillControllerBean", (Locale)ctx.getOriginLocale()));
                }
            }
        }
    }

    @Override
    protected void _ngisc_submit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._ngisc_submit(ctx, pk, model);
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_EvectionReq_Update";
    }
}

