/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractExpenseAccountEditUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class ExpenseAccountEditUIHandler
extends AbstractExpenseAccountEditUIHandler {
    @Override
    public void handleInitUIData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleInitUIData(request, response, context);
    }

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        ExpenseAccountBillInfo info = (ExpenseAccountBillInfo)request.getValue();
        if (info != null && info.getSourceBillId() != null) {
            ObjectUuidPK objpk = new ObjectUuidPK(info.getSourceBillId());
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)context);
            BizCollCoreBillBaseInfo bizCollCoreBillBaseInfo = (BizCollCoreBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, ExpenseAccountEditUIHandler.getAmountControlTypeSelector());
        }
    }

    @Override
    protected void _handleActionShowBg(RequestContext request, ResponseContext response, Context context) throws Exception {
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)request.get("info");
    }

    @Override
    protected void _handleActionCreateToReceiveBill(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCreateToPayBill(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IObjectValue buildNewData(RequestContext request, ResponseContext response, Context context, ExpenseAccountBillInfo info) throws Exception {
        BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(context).forLoanBillCreateNewData();
        info.setOrgUnit(SysContext.getSysContext().getCurrentAdminUnit());
        info.setBizReqDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        info.setBillDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        info.setBiller(user);
        info.setCurrencyType(baseInfo.getCurrencyType());
        info.setPayMode(((DailyLoanBillInfo)baseInfo).getPayMode());
        info.setAmount(new BigDecimal("0.00"));
        info.setPrior(PriorEnum.LOW);
        info.setBudgetAmount(new BigDecimal("0.00"));
        info.setBudgetBalance(new BigDecimal("0.00"));
        info.setAmountApproved(new BigDecimal("0.00"));
        info.setAmountStriked(new BigDecimal("0.00"));
        info.setAmountEncashed(new BigDecimal("0.00"));
        info.setAmountRefunded(new BigDecimal("0.00"));
        info.setState(StateEnum.NEW);
        info.setApplier(baseInfo.getApplier());
        info.setPosition(baseInfo.getPosition());
        info.setOrgUnit(baseInfo.getOrgUnit());
        info.setApplierCompany(baseInfo.getApplierCompany());
        info.setCostedDept(baseInfo.getCostedDept());
        info.setCompany(baseInfo.getCompany());
        return info;
    }

    private static SelectorItemCollection getAmountControlTypeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("amountControlType"));
        return sic;
    }
}

