/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractDailyLoanBillInfo;
import com.kingdee.eas.cp.bc.AbstractEvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.AbstractOtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.AccountAdjustEntryCoreBaseInfo;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountCoreBaseInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseExpBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizAccountBill;
import com.kingdee.eas.cp.bc.IBizAccountOutBill;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IDailyPurchaseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.ITravelAccountBill;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.MarketAccountBillInfo;
import com.kingdee.eas.cp.bc.MarketActivityBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractExpenseAccountFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.app.reverse.BillReverse;
import com.kingdee.eas.cp.bc.util.CommonDataUtil;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.cp.bc.util.ReverseUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpenseAccountFacadeControllerBean
extends AbstractExpenseAccountFacadeControllerBean {
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static String invoiceResource = "com.kingdee.eas.cp.bc.InvoiceResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseAccountFacadeControllerBean");

    @Override
    protected void _bgAudit(Context ctx, IObjectValue billInfo, boolean isAudit) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _unAudit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
    }

    private PeriodInfo getPeriod(Context ctx, ExpenseAccountBillInfo info) throws BOSException, EASBizException {
        PeriodInfo perInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateTimeUtils.truncateDate((Date)info.getBizReqDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateTimeUtils.truncateDate((Date)info.getBizReqDate()), CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            perInfo = periodc.get(0);
        }
        if (perInfo.getId() == null) {
            perInfo = null;
        }
        return perInfo;
    }

    private BgCtrlParam getBgParam(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        return this.getBgParam(ctx, billInfo, null);
    }

    private BgCtrlParam getBgParam(Context ctx, IObjectValue billInfo, BigDecimal amount) throws BOSException, EASBizException {
        ExpenseAccountBillInfo info = (ExpenseAccountBillInfo)billInfo;
        BgCtrlParam param = new BgCtrlParam();
        BgTypeInfo bgTypeInfo = BgTypeFactory.getLocalInstance((Context)ctx).getValueByNumber("ExpenseBudget");
        param.setBgTypeId(bgTypeInfo.getId());
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizReqDate(), (CompanyOrgUnitInfo)info.getCompany());
        if (period != null) {
            param.setPeriodId(period.getId());
        }
        param.setBizOrgUnitId(info.getCostedDept().getId());
        param.setCurrencyId(info.getCurrencyType().getId());
        param.setCompanyId(info.getCompany().getId());
        param.setCtrlSystem(SystemEnum.BUSINESS_COLLABORATION);
        param.setSrcBillId(info.getId());
        param.setSrcBillNumber(info.getNumber());
        param.setBizDate(info.getBizReqDate());
        AccountViewInfo exp = new AccountViewInfo();
        exp.setId(info.getExpenseType().getId());
        param.addDimension(BgDimensionEnum.ACCOUNT, (IObjectValue)exp);
        if (info.getSupportedObj() != null) {
            BOSUuid costId = info.getSupportedObj().getId();
            ICostObject iCost = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costInfo = iCost.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            MaterialInfo mat = new MaterialInfo();
            mat.setId(costInfo.getRelatedId());
            param.addDimension(BgDimensionEnum.PRODUCT, (IObjectValue)mat);
        }
        BgCtrlData data = new BgCtrlData();
        data.setDataType(BgDataTypeEnum.Amount);
        if (amount == null) {
            data.setValue(info.getAmount().subtract(info.getBudgetAmount()));
        } else {
            data.setValue(amount);
        }
        param.addData(BgElementEnum.AMT, data);
        return param;
    }

    @Override
    protected BgCtrlParam[] _getBgParams(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ICoreBase iBill = BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        CoreBaseInfo billInfo = iBill.getValue((IObjectPK)new ObjectUuidPK(billId));
        return new BgCtrlParam[]{this.getBgParam(ctx, (IObjectValue)billInfo)};
    }

    @Override
    protected BgDataCollection _getBgDataCollection(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BgCtrlParam[] result = new BgCtrlParam[]{this.getBgParam(ctx, billInfo)};
        IBgControl bgctrl = BgControlFactory.getLocalInstance((Context)ctx);
        BgDataCollection bgDataColl = bgctrl.bgGetBgDataCollection(result);
        return bgDataColl;
    }

    @Override
    protected void _setPassStateEvent(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        if (billId == null || billId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWBILLIDSHOW);
        }
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = this.getSelector();
        SelectorItemCollection selectorForTm = InvoiceUtil.getSelectorForTm();
        selector.addObjectCollection((IObjectCollection)selectorForTm);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, selector);
        if (this.checkIsSetPassState(ctx, billInfo)) {
            logger.error((Object)("####_setPassStateEvent return \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + "," + (Object)((Object)billInfo.getState())));
            return;
        }
        this.setShareState(ctx, billId, StateEnum.CHECKED, auditorId);
        if (billInfo instanceof ExpenseAccountBillInfo) {
            boolean isMonthlyBalance = false;
            if (billInfo instanceof TravelAccountBillInfo) {
                AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    if (!entries.getObject(i).getBoolean("monthlyBalance")) continue;
                    isMonthlyBalance = true;
                    break;
                }
            }
            if (!isMonthlyBalance) {
                AbstractObjectCollection loanCheckEntries = (AbstractObjectCollection)billInfo.get("loanCheckEntries");
                if (loanCheckEntries == null || loanCheckEntries.size() == 0) {
                    if (billInfo.getAmountApproved().compareTo(billInfo.getBigDecimal("amountEncashed")) != 0) {
                        logger.equals("####_setPassStateEvent amountApproved=" + billInfo.getAmountApproved() + ",amountEncashed=" + billInfo.getBigDecimal("amountEncashed"));
                        throw new BizCollException(BizCollException.AMOUNTENCASHED_MUSTEQ_AMOUNTAPPROVED);
                    }
                } else if (billInfo.getAmountApproved().compareTo(billInfo.getBigDecimal("amountEncashed")) < 0) {
                    logger.equals("####_setPassStateEvent amountEncashed=" + billInfo.getBigDecimal("amountEncashed") + ",amountApproved=" + billInfo.getAmountApproved());
                    throw new BizCollException(BizCollException.AMOUNTENCASHED_NOTGT_AMOUNTAPPROVED);
                }
            }
        }
        boolean reqBillUseBg = false;
        boolean loanBillUseBg = false;
        boolean isTm = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP024");
        paramList.add("CP051");
        paramList.add("CP05101");
        paramList.add("CP039");
        paramList.add("CP070");
        paramList.add("CP029");
        paramList.add("CP030");
        Map paramMap = null;
        boolean isRela = false;
        boolean isRelaFi = false;
        boolean isRelaCn = false;
        boolean eveReqBillUseBg = false;
        paramMap = billInfo.getApplierCompany() != null && billInfo.getApplierCompany().getId() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        isRelaFi = paramMap.get("CP002") == null ? false : new Boolean(paramMap.get("CP002").toString());
        isRelaCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        isRela = isRelaFi || isRelaCn;
        boolean isNeedBudget = new Boolean(paramMap.get("CP001").toString());
        boolean isTicketinVoice = new Boolean(paramMap.get("CP039").toString());
        isTm = new Boolean(paramMap.get("CP070").toString());
        if (isNeedBudget) {
            reqBillUseBg = new Boolean(paramMap.get("CP030").toString());
            loanBillUseBg = new Boolean(paramMap.get("CP029").toString());
            eveReqBillUseBg = new Boolean(paramMap.get("CP051").toString());
            loanBillUseBg = !BizCollUtil.objectIsNull(billInfo.getSourceBillId()) && (BizCollUtil.isEvectionLoanBill(billInfo) || BizCollUtil.isDailyLoanBill(billInfo)) ? reqBillUseBg || loanBillUseBg : new Boolean(paramMap.get("CP029").toString());
        }
        paramMap.put("CP029", loanBillUseBg);
        paramMap.put("CP030", reqBillUseBg);
        if (isTicketinVoice && billInfo instanceof ExpenseAccountBillInfo) {
            if (isTm) {
                BizInvoicePoolUtil.setPassAddIncomeInvoice(ctx, billId);
            }
            paramMap.put("isTicketAndTm", isTm);
            logger.error((Object)"#############################cpbc _setPassStateEvent start ###########################");
            InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, 60, paramMap);
            logger.error((Object)"#############################cpbc _setPassStateEvent end ###########################");
        }
        this.setAmountUsedAndBalance(ctx, billInfo, isRelaCn, reqBillUseBg, loanBillUseBg, paramMap);
        this.setBillPayInfo(ctx, billInfo, isRelaCn);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_setPassStateEvent", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)("_setPassStateEvent \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + ",\u6838\u5b9a\u91d1\u989d=" + billInfo.getAmountApproved() + ",\u4ed8\u73b0\u91d1\u989d=" + billInfo.get("amountEncashed") + ",isRelaCn=" + isRelaCn + ",isRelaFi=" + isRelaFi + ",\u5ba1\u6838\u4eba=" + auditorId + ",isReWriter=" + ctx.get((Object)"isReWrite")));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        if (BizCollUtil.hasCheckEntry(billInfo)) {
            ReverseUtil.checkSourceBillCanClose(ctx, billInfo, true, paramMap);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
    }

    protected boolean checkIsSetPassState(Context ctx, BizCollBillBaseInfo billInfo) {
        if (billInfo.getState() != null && billInfo.getState().getValue() > 60) {
            return true;
        }
        if (StateEnum.CHECKED.equals((Object)billInfo.getState())) {
            BigDecimal amountNotPaid = billInfo.getAmountNotPaid();
            BigDecimal amountPaid = billInfo.getAmountPaid();
            BigDecimal amountBalance = billInfo.getAmountBalance();
            BigDecimal amountEncashed = billInfo.getBigDecimal("amountEncashed");
            if (amountNotPaid != null && amountNotPaid.compareTo(BizCollUtil.ZERO) != 0 || amountPaid != null && amountPaid.compareTo(BizCollUtil.ZERO) != 0 || amountBalance != null && amountBalance.compareTo(BizCollUtil.ZERO) != 0 || billInfo instanceof ExpenseAccountBillInfo && amountEncashed != null && amountEncashed.compareTo(BizCollUtil.ZERO) == 0 || billInfo instanceof LoanBillInfo && billInfo.getAmountApproved() != null && billInfo.getAmountApproved().compareTo(BizCollUtil.ZERO) == 0) {
                return true;
            }
        }
        return false;
    }

    private BigDecimal getBillPayAmount(BizCollBillBaseInfo billInfo) {
        if (billInfo instanceof ExpenseAccountBillInfo) {
            return ((ExpenseAccountBillInfo)billInfo).getAmountEncashed();
        }
        if (billInfo instanceof LoanBillInfo) {
            return ((LoanBillInfo)billInfo).getAmountApproved();
        }
        return null;
    }

    protected void setBillPayInfo(Context ctx, BizCollBillBaseInfo billInfo, boolean isRela) throws BOSException, EASBizException {
        BigDecimal payAmount = this.getBillPayAmount(billInfo);
        if (payAmount != null) {
            BOSObjectType type = billInfo.getId().getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo vo = loader.getEntity(type);
            String table = vo.getTable().getName();
            StringBuffer sql = new StringBuffer();
            Object[] param = new Object[3];
            if (isRela) {
                sql.append("update ");
                sql.append(table);
                sql.append(" set FAmountPaid=?");
                sql.append(" ,FAmountNotPaid=?");
                sql.append(" where FID=?");
                param[0] = BizCollUtil.ZERO;
                param[1] = payAmount;
            } else {
                sql.append("update ");
                sql.append(table);
                sql.append(" set FAmountPaid=?");
                sql.append(" ,FAmountNotPaid=?");
                sql.append(" where FID=?");
                param[0] = payAmount;
                param[1] = BizCollUtil.ZERO;
            }
            param[2] = billInfo.getId().toString();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        }
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getSelector());
        if (billId.getType().equals((Object)BizCollUtil.dailyloanBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType) || billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType)) {
            BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId.toString()), BizCollUtil.getBudgetSelector());
            BillReverse reverse = new BillReverse();
            reverse.doReverseAmountBalance(ctx, baseInfo, "returnBudget");
        }
        if (BizInvoicePoolUtil.getCpbcParams(ctx, billInfo.getId().toString())) {
            BizInvoicePoolUtil.deleteInvoicePool(ctx, billInfo.getId());
        }
        if (InvoiceUtil.getTicketinVoice(ctx, billId.toString())) {
            logger.error((Object)"#############################cpbc  ExpenseAccountFacadeControllerBean setNoPassState  start##############################");
            InvoiceUtil.updateInvoiceStateReturnString(ctx, billId, 1);
            logger.error((Object)"#############################cpbc  ExpenseAccountFacadeControllerBean setNoPassState  end##############################");
        }
        logger.error((Object)"#############################cpbc  ExpenseAccountFacadeControllerBean setNoPassState   CHECKFAILD start ##############################");
        this.setShareState(ctx, billId, StateEnum.CHECKFAILD, auditorId);
        logger.error((Object)"#############################cpbc  ExpenseAccountFacadeControllerBean setNoPassState   CHECKFAILD   end##############################");
        if (billInfo instanceof TravelAccountBillInfo || billInfo instanceof EvectionLoanBillInfo) {
            ReverseUtil.reverseEvectionReqBillState(ctx, billId.toString());
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, StateEnum.CHECKING, auditorId);
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getSelector());
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, StateEnum state) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, state, null);
    }

    private void billClose(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue billInfo = iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        if (billInfo instanceof ExpenseAccountBillInfo) {
            ExpenseAccountBillInfo bill = (ExpenseAccountBillInfo)billInfo;
            IExpenseAccountFacade facade = null;
            facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            List idList = facade.getSrcBillFromBotpRelation(billId.toString());
            Iterator ite = idList.iterator();
            LoanBillInfo loanInfo = null;
            while (ite.hasNext()) {
                SelectorItemCollection sic;
                String srcBillId = (String)ite.next();
                if (!BizCollUtil.isLoanBill(srcBillId) || !AmountControlTypeEnum.oneTOone.equals((Object)((LoanBillInfo)(billInfo = (iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx)).getValue((objpk = new ObjectUuidPK(srcBillId)).getObjectType(), (IObjectPK)objpk))).getAmountControlType()) && (((LoanBillInfo)billInfo).getAmountUsed() == null || ((LoanBillInfo)billInfo).getAmountBalance().doubleValue() != 0.0)) continue;
                if (billInfo instanceof DailyLoanBillInfo) {
                    loanInfo = (DailyLoanBillInfo)billInfo;
                    loanInfo.setLoanState("Y");
                    loanInfo.setReturnAmount(loanInfo.getAmountApproved().subtract(bill.getAmountApproved()));
                    loanInfo.setReturnDate(new Date());
                    loanInfo.setAmountUsed(bill.getAmountApproved());
                    loanInfo.setAmountBalance(loanInfo.getAmountApproved().subtract(bill.getAmountApproved()));
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("loanState"));
                    sic.add(new SelectorItemInfo("returnDate"));
                    if (AmountControlTypeEnum.oneTOone.equals((Object)((LoanBillInfo)billInfo).getAmountControlType())) {
                        sic.add(new SelectorItemInfo("returnAmount"));
                        sic.add(new SelectorItemInfo("amountUsed"));
                        sic.add(new SelectorItemInfo("amountBalance"));
                    }
                    DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)loanInfo, sic);
                    continue;
                }
                if (!(billInfo instanceof EvectionLoanBillInfo)) continue;
                loanInfo = (EvectionLoanBillInfo)billInfo;
                loanInfo.setLoanState("Y");
                loanInfo.setReturnAmount(loanInfo.getAmountApproved().subtract(bill.getAmountApproved()));
                loanInfo.setReturnDate(new Date());
                loanInfo.setAmountUsed(bill.getAmountApproved());
                loanInfo.setAmountBalance(loanInfo.getAmountApproved().subtract(bill.getAmountApproved()));
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("loanState"));
                sic.add(new SelectorItemInfo("returnDate"));
                if (AmountControlTypeEnum.oneTOone.equals((Object)((LoanBillInfo)billInfo).getAmountControlType())) {
                    sic.add(new SelectorItemInfo("returnAmount"));
                    sic.add(new SelectorItemInfo("amountUsed"));
                    sic.add(new SelectorItemInfo("amountBalance"));
                }
                EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)loanInfo, sic);
            }
        } else if (billInfo instanceof LoanBillInfo && AmountControlTypeEnum.oneTOone.equals((Object)((LoanBillInfo)billInfo).getAmountControlType()) && ((LoanBillInfo)billInfo).getSourceBillId() != null) {
            objpk = new ObjectUuidPK(((LoanBillInfo)billInfo).getSourceBillId());
            iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            BizCollBillBaseInfo reqInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
            reqInfo.setAmountUsed(((LoanBillInfo)billInfo).getAmountApproved());
            reqInfo.setAmountBalance(reqInfo.getAmountApproved().subtract(((LoanBillInfo)billInfo).getAmountApproved()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("amountUsed"));
            sic.add(new SelectorItemInfo("amountBalance"));
            if (reqInfo instanceof OtherExpenseBillInfo) {
                OtherExpenseBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)reqInfo, sic);
            }
        }
    }

    private void setNowState(Context ctx, BOSUuid billId, StateEnum state, BOSUuid auditorId) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        if (auditorId != null) {
            userId = auditorId.toString();
        }
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=?");
        String nowTime = this.getTime().toString();
        Boolean isReWriter = (Boolean)ctx.get((Object)"isReWrite");
        if (StateEnum.CHECKING.equals((Object)state) || isReWriter == null && StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            isCheck = true;
            sql.append(", FAuditorID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setInt(++index, state.getValue());
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"setNowState", (BOSObjectType)type, (IObjectPK)new ObjectUuidPK(billId), (String)("setNowState\u8bbe\u7f6e\u5355\u636e\u72b6\u6001 state=" + (Object)((Object)state) + ",billId=" + billId + ",auditorId=" + auditorId));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    private void setAmountUsedAndBalance(Context ctx, BizCollBillBaseInfo billInfo, boolean isRela, boolean reqBillUseBg, boolean loanBillUseBg, Map paramMap) throws BOSException, EASBizException {
        BigDecimal amountCopy;
        CoreBillEntryBaseInfo entryInfo;
        BizCollBillBaseInfo info;
        int entryParLength = 4;
        String sql = null;
        Object[] param = new Object[1];
        boolean billIsRequstBg = true;
        if (billInfo instanceof OtherExpenseBillInfo) {
            if (reqBillUseBg) {
                entryParLength = 5;
                billIsRequstBg = ReverseUtil.checkBillIsRequstBg(ctx, billInfo);
            }
            info = (OtherExpenseBillInfo)billInfo;
            entryInfo = null;
            for (int i = 0; i < ((AbstractOtherExpenseBillInfo)info).getEntries().size(); ++i) {
                entryInfo = ((AbstractOtherExpenseBillInfo)info).getEntries().get(i);
                amountCopy = null;
                param = new Object[entryParLength];
                amountCopy = new BigDecimal("0.00");
                param[0] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApprovedOri());
                param[2] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApproved());
                param[1] = amountCopy;
                sql = "update t_bc_OtherExpenseBillentry set famountused=?,famountbalance=?,famountbalanceOri=?";
                if (reqBillUseBg) {
                    sql = sql + ",FbudgetBalance=?";
                    param[3] = amountCopy;
                    if (!billIsRequstBg) {
                        param[3] = BizCollUtil.ZERO;
                    }
                    param[4] = entryInfo.getId().toString();
                } else {
                    param[3] = entryInfo.getId().toString();
                }
                sql = sql + " where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            BigDecimal amountCopy2 = null;
            param = new Object[3];
            amountCopy2 = new BigDecimal("0.00");
            param[0] = amountCopy2;
            amountCopy2 = this.amountNotNull(info.getAmountApproved());
            param[1] = amountCopy2;
            param[2] = info.getId().toString();
            sql = "update t_bc_OtherExpenseBill set famountused=?,famountbalance=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            if (reqBillUseBg || loanBillUseBg) {
                entryParLength = 5;
                billIsRequstBg = ReverseUtil.checkBillIsRequstBg(ctx, billInfo);
            }
            info = (DailyLoanBillInfo)billInfo;
            entryInfo = null;
            for (int i = 0; i < ((AbstractDailyLoanBillInfo)info).getEntries().size(); ++i) {
                entryInfo = ((AbstractDailyLoanBillInfo)info).getEntries().get(i);
                amountCopy = null;
                param = new Object[entryParLength];
                amountCopy = new BigDecimal("0.00");
                param[0] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApprovedOri());
                param[2] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApproved());
                param[1] = amountCopy;
                sql = "update t_bc_dailyloanbillentry set famountused=?,famountbalance=?,famountbalanceOri=?";
                if (loanBillUseBg || reqBillUseBg) {
                    sql = sql + ",FbudgetBalance=?";
                    if (!loanBillUseBg && reqBillUseBg) {
                        if (entryInfo.getSourceAmountBalance() != null && entryInfo.getSourceAmountBalance().compareTo(BizCollUtil.ZERO) > 0) {
                            if (this.amountNotNull(entryInfo.getAmountApproved()).compareTo(entryInfo.getSourceAmountBalance()) > 0) {
                                amountCopy = entryInfo.getSourceAmountBalance().setScale(2, 4);
                            }
                        } else {
                            amountCopy = new BigDecimal("0.00");
                        }
                    }
                    param[3] = amountCopy;
                    if (!billIsRequstBg) {
                        param[3] = BizCollUtil.ZERO;
                    }
                    param[4] = entryInfo.getId().toString();
                } else {
                    param[3] = entryInfo.getId().toString();
                }
                sql = sql + " where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            if (!isRela) {
                BigDecimal amountCopy3 = null;
                param = new Object[3];
                amountCopy3 = new BigDecimal("0.00");
                param[0] = amountCopy3;
                amountCopy3 = this.amountNotNull(info.getAmountApproved());
                param[1] = amountCopy3;
                param[2] = info.getId().toString();
                sql = "update t_bc_dailyloanbill set famountused=?,famountbalance=? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            if (loanBillUseBg) {
                entryParLength = 5;
                billIsRequstBg = ReverseUtil.checkBillIsRequstBg(ctx, billInfo);
            }
            info = (EvectionLoanBillInfo)billInfo;
            entryInfo = null;
            for (int i = 0; i < ((AbstractEvectionLoanBillInfo)info).getEntries().size(); ++i) {
                entryInfo = ((AbstractEvectionLoanBillInfo)info).getEntries().get(i);
                amountCopy = null;
                param = new Object[entryParLength];
                amountCopy = new BigDecimal("0.00");
                param[0] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApprovedOri());
                param[2] = amountCopy;
                amountCopy = this.amountNotNull(entryInfo.getAmountApproved());
                param[1] = amountCopy;
                sql = "update t_bc_evectionloanbillentry set famountused=?,famountbalance=?,famountbalanceOri=?";
                if (loanBillUseBg) {
                    sql = sql + ",FbudgetBalance=?";
                    param[3] = amountCopy;
                    if (!billIsRequstBg) {
                        param[3] = BizCollUtil.ZERO;
                    }
                    param[4] = entryInfo.getId().toString();
                } else {
                    param[3] = entryInfo.getId().toString();
                }
                sql = sql + " where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            if (!isRela) {
                BigDecimal amountCopy4 = null;
                param = new Object[3];
                amountCopy4 = new BigDecimal("0.00");
                param[0] = amountCopy4;
                amountCopy4 = this.amountNotNull(info.getAmountApproved());
                param[1] = amountCopy4;
                param[2] = info.getId().toString();
                sql = "update t_bc_evectionloanbill set famountused=?,famountbalance=? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
        }
        if (billInfo instanceof EvectionReqBillInfo) {
            boolean isNeedBudget = paramMap.get("CP001") == null ? false : new Boolean(paramMap.get("CP001").toString());
            boolean eveReqBillUseBg = paramMap.get("CP051") == null ? false : new Boolean(paramMap.get("CP051").toString());
            boolean eveReqUseNewMode = paramMap.get("CP05101") == null ? false : new Boolean(paramMap.get("CP05101").toString());
            boolean isBudgetMul = BizCollUtil.checkUseEveReqCheckEntries(isNeedBudget, eveReqBillUseBg, eveReqUseNewMode);
            boolean isEveReqUseBg = BizCollUtil.checkEveReqBillUseBg(isNeedBudget, eveReqBillUseBg);
            if (isEveReqUseBg) {
                entryParLength = 5;
                billIsRequstBg = ReverseUtil.checkBillIsRequstBg(ctx, billInfo);
            }
            EvectionReqBillInfo info2 = (EvectionReqBillInfo)billInfo;
            EvectionReqBillEntryInfo entryInfo2 = null;
            for (int i = 0; i < info2.getEntries().size(); ++i) {
                entryInfo2 = info2.getEntries().get(i);
                BigDecimal amountCopy5 = null;
                param = new Object[entryParLength];
                amountCopy5 = new BigDecimal("0.00");
                param[0] = amountCopy5;
                if (isBudgetMul) {
                    amountCopy5 = this.amountNotNull(entryInfo2.getAmountApprovedOri());
                    param[2] = amountCopy5;
                    amountCopy5 = this.amountNotNull(entryInfo2.getAmountApproved());
                    param[1] = amountCopy5;
                } else {
                    amountCopy5 = this.amountNotNull(entryInfo2.getAmountOri());
                    param[2] = amountCopy5;
                    amountCopy5 = this.amountNotNull(entryInfo2.getAmount());
                    param[1] = amountCopy5;
                }
                sql = "update t_bc_EvectionReqBillentry set famountused=?,famountbalance=?,famountbalanceOri=?";
                if (isEveReqUseBg) {
                    sql = sql + ",FbudgetBalance=?";
                    param[3] = amountCopy5;
                    if (!billIsRequstBg) {
                        param[3] = BizCollUtil.ZERO;
                    }
                    param[4] = entryInfo2.getId().toString();
                } else {
                    param[3] = entryInfo2.getId().toString();
                }
                sql = sql + " where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
            }
            BigDecimal amountCopy6 = null;
            param = new Object[3];
            amountCopy6 = new BigDecimal("0.00");
            param[0] = amountCopy6;
            amountCopy6 = isBudgetMul ? this.amountNotNull(info2.getAmountApproved()) : this.amountNotNull(info2.getAmount());
            param[1] = amountCopy6;
            param[2] = info2.getId().toString();
            sql = "update t_bc_EvectionReqBill set famountused=?,famountbalance=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
        }
        if (billInfo instanceof LoanBillInfo || billInfo instanceof OtherExpenseBillInfo || billInfo instanceof EvectionReqBillInfo) {
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"setAmountUsedAndBalance", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)("setAmountUsedAndBalance \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + ",isRelaCn=" + isRela + ",sql=" + sql + ",param=" + Arrays.asList(param)));
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        }
    }

    private BigDecimal amountNotNull(BigDecimal value) {
        return value == null ? BizCollUtil.ZERO : value;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("sourceSystem"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("biller.id"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("costedDept.id"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("supportedObj.number"));
        sic.add(new SelectorItemInfo("supportedObj.name"));
        sic.add(new SelectorItemInfo("supportedObj.id"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("budgetAmount"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("ReqCheckEntries.*"));
        sic.add(new SelectorItemInfo("LoanCheckEntries.*"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        return sic;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected boolean _needBgAudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BigDecimal amount;
        if (!BizCollUtil.isNeedBudgetControl(ctx, billId)) {
            return false;
        }
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ExpenseAccountBillInfo billInfo = (ExpenseAccountBillInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        if (billInfo.getSourceBillId() == null || "".equals(billInfo.getSourceBillId())) {
            return true;
        }
        if (BizCollUtil.getBypeByBill(BizCollBillTypeEnum.EVECTION_REQ).equals((Object)BizCollUtil.getBOSType(billInfo.getSourceBillId()))) {
            return true;
        }
        BigDecimal bigDecimal = amount = billInfo.getAmount() == null ? this.ZERO : billInfo.getAmount();
        return billInfo.getBudgetAmount() == null || billInfo.getBudgetAmount().compareTo(this.ZERO) <= 0 || billInfo.getBudgetAmount().compareTo(amount) < 0;
    }

    @Override
    protected void _setPayState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.ALREADYPAYMENT);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.CLOSED);
    }

    @Override
    protected void _reBackBg(Context ctx, BOSUuid billId, boolean bgState) throws BOSException, EASBizException {
        BigDecimal amountApproved;
        BigDecimal budget;
        if (!BizCollUtil.isNeedBudgetControl(ctx, billId)) {
            return;
        }
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ExpenseAccountBillInfo billInfo = (ExpenseAccountBillInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        StateEnum state = billInfo.getState();
        BigDecimal amount = billInfo.getAmount() == null ? this.ZERO : billInfo.getAmount();
        BigDecimal bigDecimal = budget = billInfo.getBudgetAmount() == null ? this.ZERO : billInfo.getBudgetAmount();
        if (StateEnum.CHECKFAILD.equals((Object)state) && bgState) {
            this.backBgControl(ctx, billInfo, amount.subtract(budget));
            return;
        }
        if (!StateEnum.CHECKED.equals((Object)state)) {
            return;
        }
        BigDecimal budgetAmount = billInfo.getBudgetAmount() == null ? this.ZERO : billInfo.getBudgetAmount();
        BigDecimal bigDecimal2 = amountApproved = billInfo.getAmountApproved() == null ? this.ZERO : billInfo.getAmountApproved();
        if (bgState) {
            this.backBgControl(ctx, billInfo, amount.add(amountApproved.negate()));
        } else if (budgetAmount.compareTo(this.ZERO) != 0) {
            this.backBgControl(ctx, billInfo, budgetAmount.add(amountApproved.negate()));
        }
    }

    private void backBgControl(Context ctx, ExpenseAccountBillInfo billInfo, BigDecimal amount) throws EASBizException, BOSException {
        BgCtrlParam[] params = new BgCtrlParam[]{this.getBgParam(ctx, (IObjectValue)billInfo, amount)};
        IBgControl bgctrl = null;
        bgctrl = BgControlFactory.getLocalInstance((Context)ctx);
        Object result = null;
        bgctrl.bgCancelAudit(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeBillcount(Context ctx, BOSObjectType bosType, FilterInfo filterInfo) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ORMappingDAO dao = new ORMappingDAO(bosType, ctx, conn);
            int n = dao.getCount(filterInfo);
            return n;
        }
        catch (SQLException exc) {
            int n = 0;
            return n;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private int executeBillcount(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws BOSException {
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo vo = loader.getEntity(bosType);
            Class<?> tempClass = Class.forName(vo.getBusinessInterface());
            String methodName = "get" + vo.getName() + "Collection";
            Method getCollection = tempClass.getMethod(methodName, EntityViewInfo.class);
            tempClass = Class.forName(vo.getBusinessImplFactory());
            Method getLocalInstance = tempClass.getMethod("getLocalInstance", Context.class);
            AbstractObjectCollection col = (AbstractObjectCollection)getCollection.invoke(getLocalInstance.invoke(null, ctx), viewInfo);
            if (col != null) {
                return col.size();
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return 0;
    }

    private String parseLongNumber(String longNumber) {
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        if (numbers.length != 0) {
            return numbers[numbers.length - 1];
        }
        return null;
    }

    private Integer countBill(Context ctx, BOSObjectType bosType, Map paramMap) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterInfo tempFilterAp = new FilterInfo();
        FilterInfo tempFilter = new FilterInfo();
        FilterItemCollection ficAp = tempFilterAp.getFilterItems();
        BOSObjectType descBosType = (BOSObjectType)paramMap.get("descBosType");
        boolean isNeedBudget = paramMap.get("CP001") == null ? false : new Boolean(paramMap.get("CP001").toString());
        boolean isNeedRelaFi = paramMap.get("CP002") == null ? false : new Boolean(paramMap.get("CP002").toString());
        boolean isLoantoVoucher = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        boolean isDepartmentCtrl = paramMap.get("CP014") == null ? false : new Boolean(paramMap.get("CP014").toString());
        boolean isNeedRelaAp = paramMap.get("CP042") == null ? false : new Boolean(paramMap.get("CP042").toString());
        boolean eveReqBillUseBg = paramMap.get("CP051") == null ? false : new Boolean(paramMap.get("CP051").toString());
        boolean eveReqUseNewMode = paramMap.get("CP05101") == null ? false : new Boolean(paramMap.get("CP05101").toString());
        boolean isJoinBudgetMul = BizCollUtil.checkUseEveReqCheckEntries(isNeedBudget, eveReqBillUseBg, eveReqUseNewMode);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personId = user.getPerson().getId().toString();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        paramMap.put("applier", personId);
        FilterInfo personAndOrgfilter = CommonDataUtil.getPersonAndOrgFilter(ctx, paramMap, user.getId().toString(), personId, companyId);
        filter.mergeFilter(personAndOrgfilter, "and");
        if (!isDepartmentCtrl) {
            boolean isNeedCompanyFilter;
            boolean bl = isNeedCompanyFilter = paramMap.get("CP052") == null ? false : new Boolean(paramMap.get("CP052").toString());
            if (isNeedCompanyFilter) {
                FilterInfo tempFilter2 = new FilterInfo();
                tempFilter2.getFilterItems().add(new FilterItemInfo("applierCompany.id", (Object)companyId, CompareType.EQUALS));
                filter.mergeFilter(tempFilter2, "and");
            }
        }
        if (!BizCollUtil.evectionReqBosType.equals((Object)bosType) || isJoinBudgetMul) {
            tempFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            filter.mergeFilter(tempFilter, "and");
            tempFilter = new FilterInfo();
        }
        if (BizCollUtil.dailyloanBosType.equals((Object)bosType)) {
            if (isNeedRelaAp && (BizCollUtil.bizAccountBillBosType.equals((Object)descBosType) || BizCollUtil.travelAccountBillBosType.equals((Object)descBosType))) {
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill is null"));
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill", (Object)false));
                tempFilterAp.setMaskString("#0 or #1");
            } else if (!isNeedRelaAp) {
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill is null"));
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill", (Object)false));
                tempFilterAp.setMaskString("#0 or #1");
            }
        }
        if (BizCollUtil.isLoanBill(bosType)) {
            filter.mergeFilter(CommonDataUtil.getOnRePayFilter(), "and");
            if (isLoantoVoucher) {
                tempFilter.getFilterItems().add(new FilterItemInfo("loanState", (Object)"N"));
                tempFilter.getFilterItems().add(new FilterItemInfo("state", (Object)70));
            } else if (isNeedRelaFi) {
                tempFilter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
                tempFilter.getFilterItems().add(new FilterItemInfo("amountNotPaid", (Object)0));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
            }
            filter.mergeFilter(tempFilter, "and");
            tempFilter = new FilterInfo();
        } else {
            tempFilter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(60), CompareType.EQUALS));
        }
        filter.mergeFilter(tempFilter, "and");
        filter.mergeFilter(tempFilterAp, "and");
        IDynamicObject iDynamicObject = null;
        iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        IObjectPK[] idArray = iDynamicObject.getPKList(bosType, filter, sorter);
        Set<String> idSet = new HashSet<String>();
        for (int i = 0; i < idArray.length; ++i) {
            idSet.add(idArray[i].toString());
        }
        try {
            if (BizCollUtil.evectionReqBosType.equals((Object)bosType)) {
                idSet = BizCollUtil.getForBillIdSet(ctx, idSet);
            }
            if (BizCollUtil.isLoanBill(bosType)) {
                idSet = CommonUtilFacadeFactory.getLocalInstance(ctx).getCheckDestBillDoneForBillIdSet(idSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (idSet.size() > 0) {
            tempFilter = new FilterInfo();
            tempFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.mergeFilter(tempFilter, "and");
            return new Integer(this.executeBillcount(ctx, bosType, filter));
        }
        return new Integer(0);
    }

    private FilterInfo getDataPermissionRule(Context ctx, BOSObjectType bosType) throws BOSException, EASBizException, ParserException {
        FilterInfo ruleFilter = null;
        FilterInfo tempFilter = null;
        String rule = null;
        DataPermissionService dataPermissionService = new DataPermissionService(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectType", (Object)bosType.toString(), CompareType.EQUALS));
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("orgRelation"));
        viewInfo.setFilter(filter);
        PermItemCollection permCol = PermItemFactory.getLocalInstance((Context)ctx).getPermItemCollection(viewInfo);
        PermItemInfo permItemInfo = null;
        int size = permCol.size();
        for (int i = 0; i < size; ++i) {
            permItemInfo = permCol.get(i);
            rule = dataPermissionService.getPermissionRule(ctx.getCaller(), PermissionUtil.getPermissionOrgPK((Context)ctx, (OrgType)permItemInfo.getOrgRelation(), null, null), permItemInfo.getName());
            if (rule == null) continue;
            tempFilter = new EntityViewInfo(rule).getFilter();
            if (ruleFilter == null) {
                ruleFilter = tempFilter;
                continue;
            }
            ruleFilter.mergeFilter(tempFilter, "and");
        }
        return ruleFilter;
    }

    private Integer getCountByBill(Context ctx, BizCollBillTypeEnum type, Map paramMap, ArrayList result) throws BOSException {
        if (type == null) {
            return new Integer(0);
        }
        BOSObjectType bosType = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        switch (type.getValue()) {
            case 30: {
                DailyLoanBillInfo info = new DailyLoanBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 20: {
                EvectionLoanBillInfo info = new EvectionLoanBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 10: {
                EvectionReqBillInfo info = new EvectionReqBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 50: {
                MarketActivityBillInfo info = new MarketActivityBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 70: {
                OtherExpenseBillInfo info = new OtherExpenseBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 60: {
                DailyPurchaseExpBillInfo info = new DailyPurchaseExpBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 100: {
                DailyPurchaseAccountBillInfo info = new DailyPurchaseAccountBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 110: {
                TravelAccountBillInfo info = new TravelAccountBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 90: {
                BizAccountBillInfo info = new BizAccountBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 40: {
                BizAccountOutBillInfo info = new BizAccountOutBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
            case 80: {
                MarketAccountBillInfo info = new MarketAccountBillInfo();
                bosType = info.getBOSType();
                if (!result.contains(bosType.toString())) {
                    return new Integer(0);
                }
                return this.countBill(ctx, bosType, paramMap);
            }
        }
        return new Integer(0);
    }

    @Override
    protected Map _getCreateBillCount(Context ctx, BizCollBillTypeEnum[] billTypes) throws BOSException {
        HashMap<BizCollBillTypeEnum, Integer> countMap = new HashMap<BizCollBillTypeEnum, Integer>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP014");
        paramList.add("CP042");
        paramList.add("CP051");
        Map paramMap = null;
        try {
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        BizCollBillTypeEnum billType = null;
        Integer count = null;
        String descBosType = paramMap.get("descBosType") == null ? "" : paramMap.get("descBosType").toString();
        ArrayList result = this.getSrcBosTypeList(ctx, descBosType);
        if (result.size() == 0) {
            return countMap;
        }
        for (int i = 0; i < billTypes.length; ++i) {
            billType = billTypes[i];
            count = this.getCountByBill(ctx, billType, paramMap, result);
            if (count <= 0) continue;
            countMap.put(billType, count);
        }
        return countMap;
    }

    @Override
    protected Map _getCreateBillCount(Context ctx, BizCollBillTypeEnum[] billTypes, Map paramMap) throws BOSException, EASBizException {
        HashMap<BizCollBillTypeEnum, Integer> countMap = new HashMap<BizCollBillTypeEnum, Integer>();
        HashMap subParamMap = new HashMap();
        subParamMap.put("CP002", paramMap.get("CP002"));
        subParamMap.put("CP014", paramMap.get("CP014"));
        BizCollBillTypeEnum billType = null;
        Integer count = null;
        String descBosType = paramMap.get("descBosType") == null ? "" : paramMap.get("descBosType").toString();
        ArrayList result = this.getSrcBosTypeList(ctx, descBosType);
        if (result.size() == 0) {
            return countMap;
        }
        for (int i = 0; i < billTypes.length; ++i) {
            billType = billTypes[i];
            count = this.getCountByBill(ctx, billType, paramMap, result);
            if (count <= 0) continue;
            countMap.put(billType, count);
        }
        return countMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoPayment(Context ctx, BOSUuid billId) throws BOSException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            ORMappingDAO dao = new ORMappingDAO(iBOTRelation.getType(), ctx, cn);
            boolean bl = dao.exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected void payment(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (!this.isDoPayment(ctx, billId)) {
            return;
        }
        this.setNowState(ctx, billId, StateEnum.ALREADYPAYMENT, null);
    }

    @Override
    protected void _afterPayment(Context ctx, List billList) throws BOSException, EASBizException {
        Iterator ite = billList.iterator();
        while (ite.hasNext()) {
            this.payment(ctx, BOSUuid.read((String)ite.next().toString()));
        }
    }

    private boolean isDoVoucher(Context ctx, BOSUuid billId) throws BOSException {
        return true;
    }

    protected void voucher(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (!this.isDoVoucher(ctx, billId)) {
            return;
        }
        this.setNowState(ctx, billId, StateEnum.CLOSED, null);
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue billInfo = iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk);
        if (billInfo instanceof BizAccountBillInfo) {
            BizAccountBillInfo bizAccountBillInfo = (BizAccountBillInfo)billInfo;
            bizAccountBillInfo.setFiVouchered(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IBizAccountBill iBizAccountBill = null;
            iBizAccountBill = BizAccountBillFactory.getLocalInstance(ctx);
            iBizAccountBill.updatePartial((CoreBaseInfo)bizAccountBillInfo, sic);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            BizAccountOutBillInfo bizAccountOutBillInfo = (BizAccountOutBillInfo)billInfo;
            bizAccountOutBillInfo.setFiVouchered(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IBizAccountOutBill iBizAccountOutBill = null;
            iBizAccountOutBill = BizAccountOutBillFactory.getLocalInstance(ctx);
            iBizAccountOutBill.updatePartial((CoreBaseInfo)bizAccountOutBillInfo, sic);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            TravelAccountBillInfo travelAccountBillInfo = (TravelAccountBillInfo)billInfo;
            travelAccountBillInfo.setFiVouchered(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            ITravelAccountBill iTravelAccountBill = null;
            iTravelAccountBill = TravelAccountBillFactory.getLocalInstance(ctx);
            iTravelAccountBill.updatePartial((CoreBaseInfo)travelAccountBillInfo, sic);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            DailyPurchaseAccountBillInfo dailyPurchaseAccountBillInfo = (DailyPurchaseAccountBillInfo)billInfo;
            dailyPurchaseAccountBillInfo.setFiVouchered(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IDailyPurchaseAccountBill iDailyPurchaseAccountBill = null;
            iDailyPurchaseAccountBill = DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
            iDailyPurchaseAccountBill.updatePartial((CoreBaseInfo)dailyPurchaseAccountBillInfo, sic);
        }
    }

    @Override
    protected void _afterVoucher(Context ctx, List billList) throws BOSException, EASBizException {
        Iterator ite = billList.iterator();
        while (ite.hasNext()) {
            this.voucher(ctx, BOSUuid.read((String)ite.next().toString()));
        }
    }

    @Override
    protected List _getSrcBillFromBotpRelation(Context ctx, String destId) throws BOSException, EASBizException {
        ArrayList<String> destObjIdList = new ArrayList<String>();
        String sqlToGetDestObjId = "SELECT distinct FSRCOBJECTID FROM T_BOT_RELATION WHERE FDESTOBJECTID=?";
        IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjId, (Object[])new Object[]{destId});
        try {
            while (rsToGetDestObjId.next()) {
                destObjIdList.add(rsToGetDestObjId.getString("FSRCOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return destObjIdList;
    }

    @Override
    protected boolean _isNeedRelaFi(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isFi = BizCollUtil.isNeedRelaFi(ctx, billId);
        return isFi;
    }

    @Override
    protected boolean _isNeedBudgetControl(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isBudg = BizCollUtil.isNeedBudgetControl(ctx, billId);
        return isBudg;
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.SUBMIT);
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), null);
    }

    @Override
    protected void _setAbandonState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isPaperParkIntegration;
        boolean isTm;
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BizCollBillBaseInfo billInfo = null;
        if (billId.getType().equals((Object)BizCollUtil.dailyloanBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType) || billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType)) {
            billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(billId.getType(), (IObjectPK)objpk, BizCollUtil.getBudgetSelector());
            BillReverse reverse = new BillReverse();
            reverse.doReverseAmountBalance(ctx, billInfo, "returnBudget");
        }
        if (billInfo == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("applierCompany.id"));
            billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(billId.getType(), (IObjectPK)objpk, sic);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        paramList.add("CP070");
        paramList.add("IsPaperParkIntegration");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
        boolean isTicketInoice = paramMap.get("CP039") == null ? false : new Boolean(paramMap.get("CP039").toString());
        boolean bl = isTm = paramMap.get("CP070") == null ? false : new Boolean(paramMap.get("CP070").toString());
        if (billInfo instanceof ExpenseAccountBillInfo) {
            if (isTicketInoice && isTm) {
                BizInvoicePoolUtil.deleteInvoicePool(ctx, billInfo.getId());
            }
            if (isTicketInoice) {
                logger.error((Object)("####cpbc _setAbandonState updateInvoice start billid=" + billId));
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billId, 1);
                logger.error((Object)("####cpbc _setAbandonState updateInvoice end billid=" + billId));
            }
        }
        this._setState(ctx, billId, StateEnum.ALREADYABANDON);
        logger.error((Object)("####cpbc _setAbandonState ALREADYABANDON end billid=" + billId));
        if (billInfo instanceof TravelAccountBillInfo || billInfo instanceof EvectionLoanBillInfo) {
            ReverseUtil.reverseEvectionReqBillState(ctx, billId.toString());
        }
        boolean bl2 = isPaperParkIntegration = paramMap.get("IsPaperParkIntegration") == null ? false : new Boolean(paramMap.get("IsPaperParkIntegration").toString());
        if (isPaperParkIntegration) {
            BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteImage4Buss(billId.toString(), true, false, false);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
    }

    protected ArrayList getSrcBosTypeList(Context ctx, String descBosType) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(descBosType)) {
            return result;
        }
        HashMap map = new HashMap();
        try {
            String sqlToGetTargetBillTypeList = "SELECT FSRCENTITYNAME FROM T_BOT_MAPPING MAPPING INNER JOIN T_BOT_EXTMAPPING EM ON MAPPING.FEXTMAPPINGID=EM.FID WHERE (MAPPING.FUIDisable=0 OR MAPPING.FUIDisable IS NULL)  AND MAPPING.FDESTENTITYNAME=? AND MAPPING.FDEFINESYS=? AND EM.FISEFFECTED=? AND EM.FTRANSMODE<>? ORDER BY MAPPING.FAlias_" + ctx.getLocale().toString() + " schinese_pinyin ASC";
            IRowSet rsToGetSrcBillTypeList = DbUtil.executeQuery((Context)ctx, (String)sqlToGetTargetBillTypeList, (Object[])new Object[]{descBosType, new Integer(20), Boolean.TRUE, new Integer(20)});
            while (rsToGetSrcBillTypeList.next()) {
                String destEntityName = rsToGetSrcBillTypeList.getString("FSRCENTITYNAME");
                if (map.containsKey(destEntityName)) continue;
                result.add(destEntityName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void setShareState(Context ctx, BOSUuid billId, StateEnum state, BOSUuid auditorId) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        if (auditorId != null) {
            if (new UserInfo().getBOSType().equals((Object)auditorId.getType())) {
                userId = auditorId.toString();
            } else {
                logger.info((Object)("##setShareState error auditorId=" + auditorId));
            }
        }
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=?");
        String nowTime = this.getTime().toString();
        Boolean isReWriter = (Boolean)ctx.get((Object)"isReWrite");
        if (StateEnum.CHECKING.equals((Object)state) || isReWriter == null && StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            isCheck = true;
            sql.append(", FAuditorID=?");
            sql.append(", FHandlerID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setInt(++index, state.getValue());
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setString(++index, userId);
                stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"setShareState", (BOSObjectType)type, (IObjectPK)new ObjectUuidPK(billId), (String)("setShareState\u8bbe\u7f6e\u5355\u636e\u72b6\u6001 state=" + (Object)((Object)state) + ",billId=" + billId + ",auditorId=" + auditorId));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    @Override
    protected void _setAbandonStateWithoutWorkFlow(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this._setAbandonState(ctx, id);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isTm;
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        BizCollBillBaseInfo baseInfo = null;
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        if ((billId.getType().equals((Object)BizCollUtil.dailyloanBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType) || billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType)) && (baseInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(billId.getType(), (IObjectPK)objpk, BizCollUtil.getBudgetSelector())).getState().getValue() >= 25) {
            BillReverse reverse = new BillReverse();
            reverse.doReverseAmountBalance(ctx, baseInfo, "returnBudget");
        }
        if (baseInfo == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("applierCompany.id"));
            baseInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(billId.getType(), (IObjectPK)objpk, sic);
        }
        if (billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType) || billId.getType().equals((Object)BizCollUtil.evectionloanBosType)) {
            ReverseUtil.reverseEvectionReqBillState(ctx, billId.toString());
        }
        this.setShareState(ctx, billId, StateEnum.DRAFT, null);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        paramList.add("CP070");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, baseInfo.getApplierCompany().getId().toString());
        boolean isTicketInoice = paramMap.get("CP039") == null ? false : new Boolean(paramMap.get("CP039").toString());
        boolean bl = isTm = paramMap.get("CP070") == null ? false : new Boolean(paramMap.get("CP070").toString());
        if (baseInfo instanceof ExpenseAccountBillInfo) {
            if (isTicketInoice && isTm) {
                BizInvoicePoolUtil.deleteInvoicePool(ctx, baseInfo.getId());
            }
            if (isTicketInoice) {
                logger.error((Object)("####cpbc _setAbandonState updateInvoice start billid=" + billId));
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billId, 1);
                logger.error((Object)("####cpbc _setAbandonState updateInvoice end billid=" + billId));
            }
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), baseInfo);
    }

    @Override
    protected void _setAuditInfoNull(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(table);
        sql.append(" set FAuditorID=? ,");
        sql.append(" FAuditDate=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setString(++index, "");
            stmt.setDate(++index, null);
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _setChenckingDisAudit(Context ctx, BOSUuid billId, String disAuditOption) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(table);
        sql.append(" set FdisAuditOption=? ,FdisAuditPersonID=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setString(++index, disAuditOption);
            stmt.setString(++index, userId);
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _setDisAuditState(Context ctx, BOSUuid billId, StateEnum state, String disAuditOption) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=? ,FdisAuditOption=? ,FdisAuditPersonID=?");
        String nowTime = this.getTime().toString();
        Boolean isReWriter = (Boolean)ctx.get((Object)"isReWrite");
        if (StateEnum.CHECKING.equals((Object)state) || isReWriter == null && StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            isCheck = true;
            sql.append(", FAuditorID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setInt(++index, state.getValue());
            stmt.setString(++index, disAuditOption);
            stmt.setString(++index, userId);
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new java.sql.Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _setAdjustPass(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        if (billId == null || billId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWBILLIDSHOW);
        }
        if (auditorId == null || auditorId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWAUDITORIDSHOW);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("adjustState"));
        selector.add(new SelectorItemInfo("collectionEntries.id"));
        ExpenseAccountFacadeControllerBean.setCollectionSelector(selector);
        selector.add(new SelectorItemInfo("acAdjustEntries.*"));
        IBizCollBillBase bizInterface = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        BizCollBillBaseInfo billInfo = bizInterface.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        int billState = billInfo.getState().getValue();
        if (billState < 60) {
            throw new BizCollException(BizCollException.ADJUST_BILLSTATE);
        }
        AbstractObjectCollection acAdjustEntries = (AbstractObjectCollection)billInfo.get("acAdjustEntries");
        HashMap<String, AccountAdjustEntryCoreBaseInfo> temMap = new HashMap<String, AccountAdjustEntryCoreBaseInfo>();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(auditorId));
        for (AccountAdjustEntryCoreBaseInfo adEntryInfo : acAdjustEntries) {
            String collectionID = adEntryInfo.getCollectionID();
            if (adEntryInfo.getAdjustState() == AdjustStateEnum.CHECKED) continue;
            adEntryInfo.setAdjustState(AdjustStateEnum.CHECKED);
            adEntryInfo.setLastAuditor(userInfo);
            adEntryInfo.setLastAuditTime(this.getTime());
            temMap.put(collectionID, adEntryInfo);
        }
        AbstractObjectCollection acCollection = (AbstractObjectCollection)billInfo.get("collectionEntries");
        for (CollectionAccountCoreBaseInfo acInfo : acCollection) {
            AccountAdjustEntryCoreBaseInfo adEntryInfo;
            String ID = acInfo.getId().toString();
            adEntryInfo = (AccountAdjustEntryCoreBaseInfo)temMap.get(ID);
            if (adEntryInfo == null) continue;
            acInfo.setPayMode(adEntryInfo.getPayModeAdjust());
            acInfo.setPayerName(adEntryInfo.getPayerNameAdjust());
            acInfo.setPayerBank(adEntryInfo.getPayerBankAdjust());
            acInfo.setPayerBankF7(adEntryInfo.getPayerBankF7Adjust());
            acInfo.setOpenArea(adEntryInfo.getOpenAreaAdjust());
            acInfo.setPayerAccount(adEntryInfo.getPayerAccountAdjust());
            acInfo.put("payerNumber", adEntryInfo.getPayerNumberAdjust());
            acInfo.put("payerType", (Object)adEntryInfo.getPayerTypeAdjust());
            acInfo.put("payerId", adEntryInfo.getPayerIdAdjust());
        }
        billInfo.put("adjustState", (Object)AdjustStateEnum.CHECKED);
        selector.clear();
        ExpenseAccountFacadeControllerBean.setCollectionSelector(selector);
        selector.add(new SelectorItemInfo("adjustState"));
        selector.add(new SelectorItemInfo("acAdjustEntries.adjustState"));
        selector.add(new SelectorItemInfo("acAdjustEntries.lastAuditor"));
        selector.add(new SelectorItemInfo("acAdjustEntries.lastAuditTime"));
        bizInterface.updatePartial((CoreBaseInfo)billInfo, selector);
    }

    @Override
    protected void _setAdjustChecking(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        if (billId == null || billId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWBILLIDSHOW);
        }
        if (auditorId == null || auditorId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWAUDITORIDSHOW);
        }
        this.setAdjustState(ctx, auditorId, billId, AdjustStateEnum.CHECKING);
    }

    @Override
    protected void _setAdjustEdit(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        if (billId == null || billId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWBILLIDSHOW);
        }
        if (auditorId == null || auditorId.equals((Object)"")) {
            throw new BizCollException(BizCollException.WORKFLOWAUDITORIDSHOW);
        }
        this.setAdjustState(ctx, auditorId, billId, AdjustStateEnum.EDIT);
    }

    public void setAdjustState(Context ctx, BOSUuid auditorId, BOSUuid billId, AdjustStateEnum state) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("adjustState"));
        selector.add(new SelectorItemInfo("acAdjustEntries.adjustState"));
        IBizCollBillBase bizInterface = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        BizCollBillBaseInfo billInfo = bizInterface.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        int billState = billInfo.getState().getValue();
        if (billState < 60) {
            throw new BizCollException(BizCollException.ADJUST_BILLSTATE);
        }
        billInfo.put("adjustState", (Object)state);
        AbstractObjectCollection acAdjustEntries = (AbstractObjectCollection)billInfo.get("acAdjustEntries");
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(auditorId));
        for (AccountAdjustEntryCoreBaseInfo acEntryInfo : acAdjustEntries) {
            acEntryInfo.setAdjustState(state);
            acEntryInfo.setLastAuditTime(this.getTime());
            acEntryInfo.setLastAuditor(userInfo);
        }
        selector.clear();
        selector.add(new SelectorItemInfo("adjustState"));
        selector.add(new SelectorItemInfo("acAdjustEntries.adjustState"));
        selector.add(new SelectorItemInfo("acAdjustEntries.lastAuditor"));
        selector.add(new SelectorItemInfo("acAdjustEntries.lastAuditTime"));
        bizInterface.updatePartial((CoreBaseInfo)billInfo, selector);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"setAdjustState", (BOSObjectType)billId.getType(), (IObjectPK)new ObjectUuidPK(billId), (String)("setAdjustState\u8bbe\u7f6e\u6536\u6b3e\u5206\u5f55\u72b6\u6001 state=" + (Object)((Object)state) + ",billId=" + billId + ",auditorId=" + auditorId));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    @Override
    protected void _disAuditAdjust(Context ctx, BOSUuid billId, BOSUuid disAuditorId, String opinion) throws BOSException, EASBizException {
        if (opinion != null && opinion.length() > 600) {
            throw new BizCollException(BizCollException.DISAUDITOPTION_TOO_LG);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("adjustState"));
        selector.add(new SelectorItemInfo("collectionEntries.id"));
        ExpenseAccountFacadeControllerBean.setCollectionSelector(selector);
        selector.add(new SelectorItemInfo("acAdjustEntries.*"));
        IBizCollBillBase bizInterface = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        BizCollBillBaseInfo billInfo = bizInterface.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        AbstractObjectCollection acAdjustEntries = (AbstractObjectCollection)billInfo.get("acAdjustEntries");
        HashMap<String, AccountAdjustEntryCoreBaseInfo> temMap = new HashMap<String, AccountAdjustEntryCoreBaseInfo>();
        if (acAdjustEntries.size() == 0) {
            throw new BizCollException(BizCollException.ADJUST_HASNO_ENTRIES);
        }
        for (AccountAdjustEntryCoreBaseInfo adEntryInfo : acAdjustEntries) {
            String collectionID = adEntryInfo.getCollectionID();
            if (adEntryInfo.getAdjustState() != AdjustStateEnum.CHECKED) {
                throw new BizCollException(BizCollException.ADJUST_ANTI_AUDIT);
            }
            adEntryInfo.setAdjustState(AdjustStateEnum.EDIT);
            temMap.put(collectionID, adEntryInfo);
        }
        HashSet keySet = new HashSet(temMap.keySet());
        boolean collectionsHasDestBill = CommonUtilFacadeFactory.getLocalInstance(ctx).collectionsHasDestBill(billId.toString(), keySet);
        if (collectionsHasDestBill) {
            throw new BizCollException(BizCollException.ADJUST_ANTI_HASDEST);
        }
        AbstractObjectCollection acCollection = (AbstractObjectCollection)billInfo.get("collectionEntries");
        for (CollectionAccountCoreBaseInfo acInfo : acCollection) {
            AccountAdjustEntryCoreBaseInfo adEntryInfo;
            String ID = acInfo.getId().toString();
            adEntryInfo = (AccountAdjustEntryCoreBaseInfo)temMap.get(ID);
            if (adEntryInfo == null) continue;
            acInfo.setPayMode(adEntryInfo.getPayMode());
            acInfo.setPayerName(adEntryInfo.getPayerName());
            acInfo.setPayerBank(adEntryInfo.getPayerBank());
            acInfo.setPayerBankF7(adEntryInfo.getPayerBankF7());
            acInfo.setOpenArea(adEntryInfo.getOpenArea());
            acInfo.setPayerAccount(adEntryInfo.getPayerAccount());
            acInfo.put("payerNumber", adEntryInfo.getPayerNumber());
            acInfo.put("payerType", (Object)adEntryInfo.getPayerType());
            acInfo.put("payerId", adEntryInfo.getPayerId());
        }
        billInfo.put("disAuditAdjustPerson", disAuditorId);
        billInfo.put("disAuditAdjustOption", opinion);
        billInfo.put("adjustState", (Object)AdjustStateEnum.EDIT);
        selector.clear();
        selector.add(new SelectorItemInfo("disAuditAdjustPerson"));
        selector.add(new SelectorItemInfo("disAuditAdjustOption"));
        selector.add(new SelectorItemInfo("adjustState"));
        ExpenseAccountFacadeControllerBean.setCollectionSelector(selector);
        selector.add(new SelectorItemInfo("acAdjustEntries.adjustState"));
        bizInterface.updatePartial((CoreBaseInfo)billInfo, selector);
    }

    public static void setCollectionSelector(SelectorItemCollection selector) {
        selector.add(new SelectorItemInfo("collectionEntries.payMode"));
        selector.add(new SelectorItemInfo("collectionEntries.payerName"));
        selector.add(new SelectorItemInfo("collectionEntries.payerBank"));
        selector.add(new SelectorItemInfo("collectionEntries.payerBankF7"));
        selector.add(new SelectorItemInfo("collectionEntries.openArea"));
        selector.add(new SelectorItemInfo("collectionEntries.payerAccount"));
        selector.add(new SelectorItemInfo("collectionEntries.payerType"));
        selector.add(new SelectorItemInfo("collectionEntries.payerId"));
        selector.add(new SelectorItemInfo("collectionEntries.payerNumber"));
    }
}

