/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractExpenseReqBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public abstract class ExpenseReqBillControllerBean
extends AbstractExpenseReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseReqBillControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        ExpenseReqBillInfo info = (ExpenseReqBillInfo)model;
        if ("submit".equals(action)) {
            this.checkValidate(ctx, info);
        } else if ("save".equals(action) && BizCollUtil.objectIsNull(info.getNumber())) {
            throw new ExpenseReqException(ExpenseReqException.NULL_NUMBER_EXCEPTION);
        }
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        ExpenseReqBillInfo info = (ExpenseReqBillInfo)model;
        if ("submit".equals(action)) {
            this.checkValidate(ctx, info);
        } else if ("save".equals(action) && BizCollUtil.objectIsNull(info.getNumber())) {
            throw new ExpenseReqException(ExpenseReqException.NULL_NUMBER_EXCEPTION);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseInfo obj = this.getValue(ctx, pk);
        if (obj == null) {
            throw new ExpenseReqException(ExpenseReqException.DELETE_ERROR_OCCURED);
        }
        ExpenseReqBillInfo info = (ExpenseReqBillInfo)obj;
        StateEnum state = info.getState();
        if (!(StateEnum.NEW.equals((Object)state) || StateEnum.DRAFT.equals((Object)state) || StateEnum.CANCELED.equals((Object)state) || StateEnum.SUBMIT.equals((Object)state) || StateEnum.ALREADYABANDON.equals((Object)state))) {
            throw new ExpenseReqException(ExpenseReqException.CAN_NOT_DELETE_EXCEPTION);
        }
        this.abortWorkingWf(ctx, pk);
        super._delete(ctx, pk);
        this.recycleRuleNumber(ctx, info);
    }

    private void recycleRuleNumber(Context ctx, CoreBillBaseInfo info) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ExpenseReqBillInfo billInfo = (ExpenseReqBillInfo)info;
        String orgId = null;
        orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        if (orgId != null && iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
    }

    private String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        IOrgUnitCommon iCom = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = iCom.getRootCompany();
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    private boolean isNeedBudgetControl(Context ctx) throws BOSException, EASBizException {
        String sVal;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyId = "";
        if (ctx.get((Object)"CurCompanyId") != null) {
            companyId = ctx.get((Object)"CurCompanyId").toString();
        }
        return !"false".equals(sVal = iParam.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CP001"));
    }

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    public void _reverseSave(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._reverseSave(ctx, pk, (IObjectValue)model);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
    }

    @Override
    protected String _getBudgetConrolParamNumber(Context ctx) throws BOSException {
        return null;
    }

    protected void checkValidate(Context ctx, ExpenseReqBillInfo info) throws EASBizException {
        if (BizCollUtil.objectIsNull(info.getNumber())) {
            throw new ExpenseReqException(ExpenseReqException.NULL_NUMBER_EXCEPTION);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && info.getCostedDept() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COSTDEPT_EXCEPTION);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && info.getCompany() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COMAPNY_EXCEPTION);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        if (info.getTel() != null && info.getTel().length() > 50) {
            throw new ExpAccException(ExpAccException.TEL_TOO_LONG);
        }
        this.checkEntry(ctx, info);
    }

    protected void checkEntry(Context ctx, ExpenseReqBillInfo info) throws EASBizException {
    }
}

