/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.ExpenseSortCollection;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.app.AbstractExpenseSortControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ExpenseSortControllerBean
extends AbstractExpenseSortControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseSortControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNameSame(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNameSame(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            super._delete(ctx, pk);
        }
        catch (DataAccessException ee) {
            throw new VoucherTempException(VoucherTempException.EXPENSETYPE_NOW_USING);
        }
    }

    private void checkSame(Context ctx, ExpenseSortInfo info) throws BOSException, EASBizException {
        String tempSortName = info.getSortName().trim();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        ExpenseSortCollection tempColl = this.getExpenseSortCollection(ctx, ev);
        ExpenseSortInfo tempInfo = null;
        int n = tempColl.size();
        for (int i = 0; i < n; ++i) {
            tempInfo = tempColl.get(i);
            if (!tempInfo.getSortName().equals(tempSortName)) continue;
            throw new ExpSortException(ExpSortException.SORTNAME_REPEAT);
        }
    }

    private void checkNameSame(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseSortInfo info = (ExpenseSortInfo)model;
        String tempSortName = info.getSortName();
        StringBuffer mark = new StringBuffer();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sortName", (Object)tempSortName, CompareType.EQUALS));
        mark.append(" (#0 or #1) and #2");
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            mark.append(" and #3 ");
        }
        filter.setMaskString(mark.toString());
        ev.setFilter(filter);
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, info, "sortName") + info.getSortName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private void checkNumberSame(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseSortInfo info = (ExpenseSortInfo)model;
        String tempSortName = info.getSortName();
        StringBuffer mark = new StringBuffer();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)tempSortName, CompareType.EQUALS));
        mark.append(" (#0 or #1) and #2");
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.EQUALS));
            mark.append(" and #3 ");
        }
        filter.setMaskString(mark.toString());
        ev.setFilter(filter);
        if (super._exists(ctx, filter)) {
            throw new ExpSortException(ExpSortException.SORTNUMBER_REPEAT);
        }
    }

    private void checkInfo(Context ctx, IObjectValue model) throws ExpSortException {
        ExpenseSortInfo info = (ExpenseSortInfo)model;
        if (this.objectIsNull(info.getSortName()) || info.getSortName().trim().equals("")) {
            throw new ExpSortException(ExpSortException.SORTNAME_NOT_NULL);
        }
        if (this.objectIsNull(info.getNumber()) || info.getNumber().trim().equals("")) {
            throw new ExpSortException(ExpSortException.SORTNUMBER_NOT_NULL);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNameSame(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        super._update(ctx, pk, model);
    }
}

