/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.SysMenuItemCollection;
import com.kingdee.eas.base.uiframe.SysMenuItemFactory;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.app.AbstractExpenseTypeControllerBean;
import com.kingdee.eas.cp.bc.util.BCReferenceDAO;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpenseTypeControllerBean
extends AbstractExpenseTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseTypeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)model;
        this.setName(info);
        this.checkInfo(ctx, (IObjectValue)info);
        this.prepareInfo(ctx, (IObjectValue)info);
        IObjectPK ok = super._addnew(ctx, (IObjectValue)info);
        this.checkNameSame(ctx, model);
        return ok;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)model;
        this.setName(info);
        this.checkInfo(ctx, model);
        this.prepareInfo(ctx, model);
        super._addnew(ctx, pk, model);
        this.checkNameSame(ctx, model);
    }

    protected boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExpenseTypeInfo info = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo(pk);
        Object[] params = new String[]{info.getNumber()};
        CompanyOrgUnitInfo unitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!ContextUtil.getCurrentFIUnit((Context)ctx).getId().equals((Object)unitInfo.getId())) {
            throw new OperationException(OperationException.EXPTYPE_CANNOT_DELETE_NOT_CURRENTCOMPANY, params);
        }
        try {
            super._delete(ctx, pk);
        }
        catch (DataAccessException ee) {
            throw new VoucherTempException(VoucherTempException.EXPENSETYPE_NOW_USING, params);
        }
    }

    private void checkNameSame(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)model;
        String tempSortName = info.getNumber().trim();
        StringBuffer mark = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)tempSortName, CompareType.EQUALS));
        mark.append(" #0");
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            mark.append(" and #1 ");
        }
        filter.setMaskString(mark.toString());
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)info, "number") + info.getNumber();
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{info.getNumber()});
        }
    }

    private void checkInfo(Context ctx, IObjectValue model) throws ExpSortException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)model;
        if (this.objectIsNull(info.getNumber()) || info.getNumber().trim().equals("")) {
            throw new ExpSortException(ExpSortException.TYPENUMBER_NOT_NULL);
        }
        if (this.objectIsNull(info.getTypeName()) || info.getTypeName().trim().equals("")) {
            throw new ExpSortException(ExpSortException.TYPENAME_NOT_NULL);
        }
    }

    private void prepareInfo(Context ctx, IObjectValue model) {
        ExpenseTypeInfo expenseType = (ExpenseTypeInfo)model;
        OperationTypeInfo operationType = expenseType.getOperationType();
        expenseType.setOperationId(operationType.getId());
        expenseType.setOperationName(operationType.getName(ctx.getOriginLocale()));
        expenseType.setOperationNumber(operationType.getNumber());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)model;
        ExpenseTypeInfo oldInfo = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select number,operationType.id,parent.id where id='" + info.getId() + "'");
        if (!oldInfo.getNumber().equals(info.getNumber())) {
            if (BCReferenceDAO.isReferenced(ctx, info.getId())) {
                throw new BizCollException(BizCollException.USEDEXPENSETYPECANNOTCHANGENUMBER);
            }
        } else {
            if (oldInfo.getParent() != null && info.getParent() != null && !oldInfo.getParent().getId().equals((Object)info.getParent().getId()) || oldInfo.getParent() == null && info.getParent() != null) {
                throw new BizCollException(BizCollException.NUMBERNOTMODIFIEDCANNOTCHANGETYPE);
            }
            if (!oldInfo.getOperationType().getId().equals((Object)info.getOperationType().getId()) && BCReferenceDAO.isReferenced(ctx, info.getId())) {
                throw new BizCollException(BizCollException.USEDEXPENSETYPECANNOTCHANGEOPERATIONTYPE);
            }
        }
        this.setName(info);
        this.checkInfo(ctx, (IObjectValue)info);
        this.checkNameSame(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)info);
        this.prepareInfo(ctx, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void setName(ExpenseTypeInfo info) {
        info.setName(info.getTypeName(locale_L1), locale_L1);
        info.setName(info.getTypeName(locale_L2), locale_L2);
        info.setName(info.getTypeName(locale_L3), locale_L3);
    }

    @Override
    protected void _setUsable(Context ctx, List ids, boolean enable) throws BOSException, EASBizException {
        if (ids == null) {
            return;
        }
        String id = null;
        IExpenseType expenseType = ExpenseTypeFactory.getLocalInstance(ctx);
        ExpenseTypeInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        TreeBaseCollection coll = null;
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            id = (String)ids.get(i);
            info = expenseType.getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(id));
            Object[] params = new String[]{info.getNumber()};
            CompanyOrgUnitInfo unitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!ContextUtil.getCurrentFIUnit((Context)ctx).getId().equals((Object)unitInfo.getId())) {
                throw new OperationException(OperationException.OPRTTYPE_CANNOT_SETUSABEL_NOT_CURRENTCOMPANY, params);
            }
            if (!info.isIsLeaf() && (coll = this.getAllChildren(ctx, info)) != null && coll.size() > 0) {
                ExpenseTypeInfo childInfo = null;
                for (int index = 0; index < coll.size(); ++index) {
                    childInfo = (ExpenseTypeInfo)coll.getObject(index);
                    childInfo.setIsStart(enable);
                    childInfo.setLastUpdateTime(timestamp);
                    childInfo.setLastUpdateUser(userInfo);
                    expenseType.updatePartial((CoreBaseInfo)childInfo, sic);
                }
            }
            info.setIsStart(enable);
            info.setLastUpdateTime(timestamp);
            info.setLastUpdateUser(userInfo);
            expenseType.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected boolean _releaseWebService(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return false;
        }
        ExpenseTypeEntryCollection typeEntryCols = this.getExpenseTypeCollection(ctx, ids);
        if (typeEntryCols != null && typeEntryCols.size() > 0) {
            HashMap<String, SysMenuItemInfo> billMenuMap = new HashMap<String, SysMenuItemInfo>(8);
            HashMap<String, String> maxMenuNumberMap = new HashMap<String, String>(8);
            Iterator ite = typeEntryCols.iterator();
            int i = 0;
            while (ite.hasNext()) {
                ExpenseTypeEntryInfo tempEntryInfo = (ExpenseTypeEntryInfo)ite.next();
                SysMenuItemInfo tempMenuInfo = new SysMenuItemInfo();
                String parentId = tempEntryInfo.getBillType().getWebPathId();
                StringBuffer uiClassName = new StringBuffer();
                uiClassName.append(tempEntryInfo.getBillType().getDefaultWebPath());
                uiClassName.append(tempEntryInfo.getBillType().getWebUI());
                uiClassName.append("&").append("expenseType=").append(tempEntryInfo.getExpenseType().getId());
                String tempUiClassName = uiClassName.toString();
                SysMenuItemInfo tempParentMenuInfo = (SysMenuItemInfo)billMenuMap.get(parentId);
                if (tempParentMenuInfo == null) {
                    tempParentMenuInfo = this.getSysMenuItemInfo(ctx, parentId);
                    billMenuMap.put(parentId, tempParentMenuInfo);
                    maxMenuNumberMap.put(parentId, this.getMaxMenuNumber(ctx, parentId));
                } else {
                    billMenuMap.put(parentId, tempParentMenuInfo);
                    maxMenuNumberMap.put(parentId, this.getMaxMenuNumber(ctx, parentId));
                }
                String tempMaxMenuNumber = (String)maxMenuNumberMap.get(parentId);
                if (tempMaxMenuNumber == null) {
                    tempMaxMenuNumber = this.getMaxMenuNumber(ctx, parentId);
                    maxMenuNumberMap.put(parentId, tempMaxMenuNumber);
                }
                if (!BizCollUtil.objectIsNull(tempParentMenuInfo)) continue;
                tempMenuInfo.setParent(tempParentMenuInfo);
                String tempNumber = this.concructMenuNumber(i, tempMaxMenuNumber);
                tempMenuInfo.setNumber(tempNumber);
                if (tempParentMenuInfo != null && tempNumber != null) {
                    tempMenuInfo.setLongNumber(tempParentMenuInfo.getLongNumber() + "!" + tempNumber);
                }
                this.setSysMenuItemInfo(tempEntryInfo, tempMenuInfo);
                if (this.isExitUiClassName(ctx, parentId, tempUiClassName)) continue;
                SysMenuItemFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)tempMenuInfo);
            }
        }
        return true;
    }

    private String concructMenuNumber(int i, String maxMenuNumber) {
        String number;
        String mark = "BZ";
        if (maxMenuNumber != null && maxMenuNumber.indexOf(mark) >= 0) {
            String tempNumber = maxMenuNumber.substring(maxMenuNumber.indexOf(mark) + 2);
            int index = Integer.valueOf(tempNumber);
            number = maxMenuNumber.substring(0, maxMenuNumber.indexOf(mark) + 2) + String.valueOf(++index);
        } else {
            number = maxMenuNumber + mark + String.valueOf(i);
        }
        return number;
    }

    private String getMaxMenuNumber(Context ctx, String parentId) throws BOSException, EASBizException {
        SysMenuItemInfo parentMenu;
        String number = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        if (!BizCollUtil.objectIsNull(parentId) && (parentMenu = SysMenuItemFactory.getLocalInstance((Context)ctx).getSysMenuItemInfo((IObjectPK)new ObjectUuidPK(parentId), selector)) != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentMenu.getLongNumber() + "%"), CompareType.LIKE));
            ev.setFilter(filter);
            ev.setSelector(selector);
            SorterItemInfo sortInfo = new SorterItemInfo("number");
            sortInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(sortInfo);
            SysMenuItemCollection cols = SysMenuItemFactory.getLocalInstance((Context)ctx).getSysMenuItemCollection(ev);
            if (cols != null && cols.size() > 0) {
                SysMenuItemInfo sysMenuItemInfo = cols.get(0);
                number = sysMenuItemInfo.getNumber();
            }
        }
        return number;
    }

    private boolean isExitUiClassName(Context ctx, String parentId, String uiClassName) throws BOSException, EASBizException {
        String tempUiClassName = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("uiClassName"));
        if (parentId == null) {
            return true;
        }
        SysMenuItemInfo parentMenu = SysMenuItemFactory.getLocalInstance((Context)ctx).getSysMenuItemInfo((IObjectPK)new ObjectUuidPK(parentId), selector);
        if (parentMenu != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentMenu.getLongNumber() + "%"), CompareType.LIKE));
            ev.setFilter(filter);
            ev.setSelector(selector);
            SysMenuItemCollection cols = SysMenuItemFactory.getLocalInstance((Context)ctx).getSysMenuItemCollection(ev);
            if (cols != null && cols.size() > 0) {
                for (int i = 0; i < cols.size(); ++i) {
                    SysMenuItemInfo sysMenuItemInfo = cols.get(i);
                    tempUiClassName = sysMenuItemInfo.getUiClassName();
                    if (null == uiClassName || !uiClassName.equals(tempUiClassName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private ExpenseTypeEntryCollection getExpenseTypeCollection(Context ctx, List ids) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("expenseType", (Object)this.getIdsFilter(ids), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("isSupportWeb", (Object)Boolean.TRUE));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("expenseType.id"));
        selector.add(new SelectorItemInfo("expenseType.name"));
        selector.add(new SelectorItemInfo("billType.*"));
        return ExpenseTypeEntryFactory.getLocalInstance(ctx).getExpenseTypeEntryCollection(ev);
    }

    private SysMenuItemInfo getSysMenuItemInfo(Context ctx, String id) throws EASBizException, BOSException {
        if (BizCollUtil.objectIsNull(id)) {
            return null;
        }
        return SysMenuItemFactory.getLocalInstance((Context)ctx).getSysMenuItemInfo((IObjectPK)new ObjectUuidPK(id));
    }

    private void setSysMenuItemInfo(ExpenseTypeEntryInfo entryInfo, SysMenuItemInfo menuItemInfo) {
        menuItemInfo.setName(entryInfo.getBillType().getName() + "(" + entryInfo.getExpenseType().getName() + ")");
        menuItemInfo.setName(entryInfo.getBillType().getName(LocaleUtils.locale_L2) + "(" + entryInfo.getExpenseType().getName(LocaleUtils.locale_L2) + ")", LocaleUtils.locale_L3);
        menuItemInfo.setOrder("255");
        menuItemInfo.setLevel(4);
        menuItemInfo.setIsLeaf(true);
        menuItemInfo.setVisible(true);
        menuItemInfo.setEnabled(true);
        menuItemInfo.setIsReport(false);
        menuItemInfo.setMenutype(BizTypeEnum.webmenu);
        if (entryInfo.getBillType() != null && entryInfo.getBillType().getFunction() != null) {
            PermItemInfo itemInfo = new PermItemInfo();
            itemInfo.setId(BOSUuid.read((String)entryInfo.getBillType().getFunction()));
            menuItemInfo.setFunction(itemInfo);
        }
        StringBuffer uiClassName = new StringBuffer();
        uiClassName.append(entryInfo.getBillType().getDefaultWebPath());
        uiClassName.append(entryInfo.getBillType().getWebUI());
        uiClassName.append("&").append("expenseType=").append(entryInfo.getExpenseType().getId());
        menuItemInfo.setUiClassName(uiClassName.toString());
    }

    private String getIdsFilter(List ids) {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        StringBuffer filterString = new StringBuffer();
        Iterator ite = ids.iterator();
        while (ite.hasNext()) {
            filterString.append("'").append((String)ite.next()).append("',");
        }
        filterString.deleteCharAt(filterString.length() - 1);
        return filterString.toString();
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BizReference ref = null;
        try {
            ref = BCReferenceDAO.getReference(ctx, BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)ref, (Throwable)e);
        }
        if (ref != null) {
            logger.error((Object)("####cpbc--ExpenseTypeControllerBean--isReferenced:" + ref.getClass() + "," + ref.getRefEntityName() + "," + ref.getRefFieldName() + "," + ref.getRefFieldName() + "," + ref.getRefTableName()));
            throw new ObjectReferedException((Object)ref);
        }
    }

    @Override
    protected IObjectCollection _getTopExpenseType(Context ctx, String personId, int num) throws BOSException, EASBizException {
        String expenseTypeIdsStr;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        Set operationIds = this.getOperationIdSet(ctx, company.getId().toString(), null, null, null);
        String operationIdsStr = StringUtils.arrayToString((Object[])operationIds.toArray(), (String)"','");
        HashSet<String> expenseTypeIds = new HashSet<String>();
        String sql1 = " select top %s entry.fexpensetypeid,count(entry.fexpensetypeid) c from (  select b.fexpensetypeid from t_bc_bizaccountbill a left join t_bc_bizaccountbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where a.fapplierid='%s' and e.fisstart = 1  and e.foperationtypeid in ('" + operationIdsStr + "')  union all   select b.fexpensetypeid  from t_bc_dailypurchaseaccountbill a left join t_bc_dailypurchaseaccontentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where  a.fapplierid='%s' and e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "')  union all  select b.fexpensetypeid  from t_bc_bizaccountoutbill a left join t_bc_bizaccountoutbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where  a.fapplierid='%s' and e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "')  union all  select b.fexpensetypeid  from t_bc_travelaccountbill a left join t_bc_travelaccountbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where  a.fapplierid='%s' and e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "') ) entry group by entry.fexpensetypeid order by c desc";
        IRowSet result1 = DbUtil.executeQuery((Context)ctx, (String)String.format(sql1, num, personId, personId, personId, personId));
        if (result1 != null && result1.size() > 0) {
            try {
                while (result1.next() && result1.getString("fexpensetypeid") != null) {
                    expenseTypeIds.add(result1.getString("fexpensetypeid").toString());
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (expenseTypeIds.size() < num) {
            expenseTypeIdsStr = StringUtils.arrayToString((Object[])expenseTypeIds.toArray(), (String)"','");
            String sql2 = " select top %s entry.fexpensetypeid,count(entry.fexpensetypeid) c from (  select b.fexpensetypeid from t_bc_bizaccountbill a left join t_bc_bizaccountbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "') and e.fid not in ('" + expenseTypeIdsStr + "') union all   select b.fexpensetypeid  from t_bc_dailypurchaseaccountbill a left join t_bc_dailypurchaseaccontentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "') and e.fid not in ('" + expenseTypeIdsStr + "') union all  select b.fexpensetypeid  from t_bc_bizaccountoutbill a left join t_bc_bizaccountoutbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "') and e.fid not in ('" + expenseTypeIdsStr + "') union all  select b.fexpensetypeid  from t_bc_travelaccountbill a left join t_bc_travelaccountbillentry b on a.fid = b.fbillid left join t_bc_expensetype e on b.fexpensetypeid = e.fid  right join t_bc_expensetypeentry ee on e.fid = ee.fparentid  where e.fisstart = 1 and e.foperationtypeid in ('" + operationIdsStr + "') and e.fid not in ('" + expenseTypeIdsStr + "')) entry group by entry.fexpensetypeid order by c desc";
            IRowSet result2 = DbUtil.executeQuery((Context)ctx, (String)String.format(sql2, num - expenseTypeIds.size()));
            if (result2 != null && result2.size() > 0) {
                try {
                    while (result2.next() && result2.getString("fexpensetypeid") != null) {
                        expenseTypeIds.add(result2.getString("fexpensetypeid").toString());
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        if (expenseTypeIds.size() < num) {
            expenseTypeIdsStr = StringUtils.arrayToString((Object[])expenseTypeIds.toArray(), (String)"','");
            String sql3 = " select top %s fid  from t_bc_expensetype where foperationtypeid in ('" + operationIdsStr + "') and fid not in ('" + expenseTypeIdsStr + "')  order by fnumber asc";
            IRowSet result3 = DbUtil.executeQuery((Context)ctx, (String)String.format(sql3, num - expenseTypeIds.size()));
            if (result3 != null && result3.size() > 0) {
                try {
                    while (result3.next() && result3.getString("fid") != null) {
                        expenseTypeIds.add(result3.getString("fid").toString());
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", expenseTypeIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection setor = new SelectorItemCollection();
        setor.add(new SelectorItemInfo("id"));
        setor.add(new SelectorItemInfo("name"));
        setor.add(new SelectorItemInfo("number"));
        setor.add(new SelectorItemInfo("imageUrl"));
        setor.add(new SelectorItemInfo("operationType.id"));
        setor.add(new SelectorItemInfo("operationType.name"));
        setor.add(new SelectorItemInfo("operationType.number"));
        entityViewInfo.setSelector(setor);
        CoreBaseCollection operationTypes = ExpenseTypeFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
        return operationTypes;
    }

    protected Set getOperationIdSet(Context ctx, String companyId, String billType, String costCenterId, String personId) throws EASBizException, BOSException {
        return BizBaseDataWebFacadeFactory.getLocalInstance(ctx).getOperationIdsByCompany(companyId, null, null);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int index;
        ExpenseTypeInfo expenseTypeInfo = (ExpenseTypeInfo)model;
        String number = expenseTypeInfo.getNumber();
        String id = expenseTypeInfo.getId().toString();
        String operationTypeInfoId = null;
        if (expenseTypeInfo.getOperationType() != null) {
            operationTypeInfoId = expenseTypeInfo.getOperationType().getId().toString();
        }
        if ((index = number.lastIndexOf(".")) >= 0) {
            String _pNumber = number.substring(0, number.lastIndexOf("."));
            ExpenseTypeInfo expTypeInfo = null;
            if (_pNumber != null && operationTypeInfoId != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)_pNumber, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)operationTypeInfoId, CompareType.EQUALS));
                evi.setFilter(filterInfo);
                ExpenseTypeCollection colls = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(evi);
                if (colls != null && colls.size() > 0) {
                    expTypeInfo = colls.get(0);
                    if (expTypeInfo.getId() != null && expTypeInfo.getId().toString().equals(id)) {
                        throw new OperationException(OperationException.EXPTYPE_PARENT_NOT_EXIST, new String[]{_pNumber});
                    }
                } else {
                    throw new OperationException(OperationException.EXPTYPE_PARENT_NOT_EXIST, new String[]{_pNumber});
                }
            }
        }
        return super._save(ctx, model);
    }
}

