/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizBillUtil;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizOutTicketEntryCollection;
import com.kingdee.eas.cp.bc.BizOutTicketEntryFactory;
import com.kingdee.eas.cp.bc.BizOutTicketEntryInfo;
import com.kingdee.eas.cp.bc.CollectionAccountCoreBaseInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IInvoiceFacade;
import com.kingdee.eas.cp.bc.IInvoiceType;
import com.kingdee.eas.cp.bc.InvoiceException;
import com.kingdee.eas.cp.bc.InvoiceFacadeFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.cp.bc.InvoiceTypeFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeInfo;
import com.kingdee.eas.cp.bc.PurTicketEntryCollection;
import com.kingdee.eas.cp.bc.PurTicketEntryFactory;
import com.kingdee.eas.cp.bc.PurTicketEntryInfo;
import com.kingdee.eas.cp.bc.SourceSystem;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TicketBaseEntryInfo;
import com.kingdee.eas.cp.bc.TicketEntryCollection;
import com.kingdee.eas.cp.bc.TicketEntryFactory;
import com.kingdee.eas.cp.bc.TicketEntryInfo;
import com.kingdee.eas.cp.bc.TraTicketEntryCollection;
import com.kingdee.eas.cp.bc.TraTicketEntryFactory;
import com.kingdee.eas.cp.bc.TraTicketEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.VATInvoiceBizOutEntryCollection;
import com.kingdee.eas.cp.bc.VATInvoiceBizOutEntryInfo;
import com.kingdee.eas.cp.bc.VATInvoiceEntryCollection;
import com.kingdee.eas.cp.bc.VATInvoiceEntryInfo;
import com.kingdee.eas.cp.bc.VATInvoicePurEntryCollection;
import com.kingdee.eas.cp.bc.VATInvoicePurEntryInfo;
import com.kingdee.eas.cp.bc.VATInvoiceTraEntryCollection;
import com.kingdee.eas.cp.bc.VATInvoiceTraEntryInfo;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.app.AbstractInvoiceFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.cp.bc.util.InvoiceUtilCustom;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseCollection;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InvoiceFacadeControllerBean
extends AbstractInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.InvoiceFacadeControllerBean");
    public boolean firstAccount = false;
    public boolean firstEntry = false;
    public boolean moreEntry = false;
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.InvoiceResource";
    private static final String INVOICE_NUM_STR = "\u5f20";
    private static final String INVOICE_STR = "\u53d1\u7968";

    @Override
    protected void _updateState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizInvoicePoolUtil.getCpbcParams(ctx, id.toString())) {
            BizInvoicePoolUtil.deleteInvoicePool(ctx, id);
        }
        if (InvoiceUtil.getTicketinVoice(ctx, id.toString())) {
            logger.error((Object)"#############################cpbc  InvoiceFacadeControllerBean _updateState  start##############################");
            InvoiceUtil.updateInvoiceNewState(ctx, id);
            logger.error((Object)"#############################cpbc  InvoiceFacadeControllerBean _updateState  end##############################");
        }
    }

    @Override
    protected void _invoiceCustom(Context ctx, Map spareMap) throws BOSException, EASBizException {
        this.firstAccount = false;
        this.firstEntry = false;
        this.moreEntry = false;
    }

    @Override
    protected Map _buildBillEntryAndTicketEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        this._invoiceCustom(ctx, spareMap);
        HashMap<String, Map> billEntryAndTicketCollectionMap = new HashMap<String, Map>();
        Map paramMap = InvoiceUtil.getInvoiceParamMap(ctx, baseInfo);
        spareMap.put("paramMap", paramMap);
        Map buildBillEntry = this._buildBillEntry(ctx, invoiceData, baseInfo, spareMap);
        Map entryLinkInvoice = (Map)buildBillEntry.get("entryLinkInvoice");
        Map buildTicketEntry = this._buildTicketEntry(ctx, entryLinkInvoice, invoiceData, baseInfo, spareMap);
        Map _buildVATInvoiceEntry = this._buildVATInvoiceEntry(ctx, invoiceData, baseInfo, spareMap);
        billEntryAndTicketCollectionMap.put("entryCollection", buildBillEntry);
        billEntryAndTicketCollectionMap.put("ticketCollection", buildTicketEntry);
        billEntryAndTicketCollectionMap.put("vatCollection", _buildVATInvoiceEntry);
        return billEntryAndTicketCollectionMap;
    }

    @Override
    protected Map _buildBillEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        Map billEntryCollectionMap = null;
        JSONArray ticketData = JSONObject.parseArray((String)invoiceData);
        if (this.firstEntry) {
            billEntryCollectionMap = InvoiceUtilCustom.buildEntryByFirstEntry(ctx, invoiceData, baseInfo, spareMap);
        } else if (this.moreEntry) {
            billEntryCollectionMap = InvoiceUtilCustom.buildEntryByMoreEntry(ctx, invoiceData, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountBillInfo) {
            Map groupMap = this.invoiceCloudGroupByBiz(ticketData, spareMap);
            billEntryCollectionMap = this.invoiceCloudBuildEntryByBiz(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            Map groupMap = this.invoiceCloudGroupByBizOut(ticketData, spareMap);
            billEntryCollectionMap = this.invoiceCloudBuildEntryByBizOut(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            Map groupMap = this.invoiceCloudGroupByPur(ticketData, spareMap);
            billEntryCollectionMap = this.invoiceCloudBuildEntryByPur(ctx, groupMap, baseInfo, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            Map groupMap = this.invoiceCloudGroupByTra(ticketData, spareMap);
            billEntryCollectionMap = this.invoiceCloudBuildEntryByTra(ctx, groupMap, baseInfo, spareMap);
        }
        return billEntryCollectionMap;
    }

    @Override
    protected Map _buildTicketEntry(Context ctx, Map entryLinkInvoice, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        Map ticketEntryCollectionMap = null;
        JSONArray ticketData = JSONObject.parseArray((String)invoiceData);
        spareMap.put("baseInfo", baseInfo);
        HashMap cacheInvoiceTypeMap = new HashMap();
        spareMap.put("cacheInvoiceTypeMap", cacheInvoiceTypeMap);
        if (baseInfo instanceof BizAccountBillInfo) {
            ticketEntryCollectionMap = this.invoiceCloudBuildTicketEntryByBiz(ctx, ticketData, entryLinkInvoice, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            ticketEntryCollectionMap = this.invoiceCloudBuildTicketEntryByBizOut(ctx, ticketData, entryLinkInvoice, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            ticketEntryCollectionMap = this.invoiceCloudBuildTicketEntryByPur(ctx, ticketData, entryLinkInvoice, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            ticketEntryCollectionMap = this.invoiceCloudBuildTicketEntryByTra(ctx, ticketData, entryLinkInvoice, spareMap);
        }
        spareMap.remove("baseInfo");
        spareMap.remove("cacheInvoiceTypeInfo");
        return ticketEntryCollectionMap;
    }

    @Override
    protected Map _buildAccountEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        this._invoiceCustom(ctx, spareMap);
        Map accountEntryCollectionMap = null;
        JSONArray ticketData = JSONObject.parseArray((String)invoiceData);
        if (this.firstAccount) {
            accountEntryCollectionMap = InvoiceUtilCustom.buildAccountEntryByFirstEntry(ctx, invoiceData, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountBillInfo) {
            accountEntryCollectionMap = this.invoiceCloudBuildAccountEntryByBiz(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            accountEntryCollectionMap = this.invoiceCloudBuildAccountEntryByBizOut(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            accountEntryCollectionMap = this.invoiceCloudBuildAccountEntryByPur(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            accountEntryCollectionMap = this.invoiceCloudBuildAccountEntryByTra(ctx, ticketData, baseInfo, spareMap);
        }
        return accountEntryCollectionMap;
    }

    @Override
    protected Map _buildChangeInvoiceAndEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        Map changeInvoiceAndEntryMap = null;
        JSONArray ticketData = JSONObject.parseArray((String)invoiceData);
        Map paramMap = InvoiceUtil.getInvoiceParamMap(ctx, baseInfo);
        spareMap.put("paramMap", paramMap);
        HashMap cacheInvoiceTypeMap = new HashMap();
        spareMap.put("cacheInvoiceTypeMap", cacheInvoiceTypeMap);
        if (baseInfo instanceof BizAccountBillInfo) {
            changeInvoiceAndEntryMap = this.invoiceCloudChangeInvoiceEntryByBiz(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            changeInvoiceAndEntryMap = this.invoiceCloudChangeInvoiceEntryByBizOut(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            changeInvoiceAndEntryMap = this.invoiceCloudChangeInvoiceEntryByPur(ctx, ticketData, baseInfo, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            changeInvoiceAndEntryMap = this.invoiceCloudChangeInvoiceEntryByTra(ctx, ticketData, baseInfo, spareMap);
        }
        spareMap.remove("cacheInvoiceTypeInfo");
        return changeInvoiceAndEntryMap;
    }

    @Override
    protected Map _buildVATInvoiceEntry(Context ctx, String invoiceData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        Map vatEntryCollectionMap = null;
        List vatInvoiceEntryList = (List)spareMap.get("VATInvoiceEntryList");
        spareMap.remove("VATInvoiceEntryList");
        if (baseInfo instanceof BizAccountBillInfo) {
            vatEntryCollectionMap = this.invoiceCloudBuildVatEntryByBiz(ctx, vatInvoiceEntryList, spareMap);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            vatEntryCollectionMap = this.invoiceCloudBuildVatEntryByBizOut(ctx, vatInvoiceEntryList, spareMap);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            vatEntryCollectionMap = this.invoiceCloudBuildVatEntryByPur(ctx, vatInvoiceEntryList, spareMap);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            vatEntryCollectionMap = this.invoiceCloudBuildVatEntryByTra(ctx, vatInvoiceEntryList, spareMap);
        }
        return vatEntryCollectionMap;
    }

    @Override
    protected String _getViewInvoiceUrl(Context ctx, String billId, Set serialNoSet, Map spareMap) throws BOSException, EASBizException {
        String url = "";
        String random = Double.toString(Math.random());
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)billId));
        BizCollBillBaseInfo baseInfo = iBizCollBillBase.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
        if (SourceSystem.CQ.equals((Object)baseInfo.getSourceSystem())) {
            url = InvoiceUtil.getCqShowInvoiceUrl(ctx, baseInfo, random, spareMap);
            return url;
        }
        spareMap.put("random", random);
        JSONObject retunObject = InvoiceUtil.getUserkeyJson(ctx, baseInfo, spareMap);
        spareMap.remove("random");
        retunObject.put("invoiceSerialNos", (Object)StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        spareMap.remove("SerialNoSet");
        logger.info((Object)("###########start _getViewInvoiceUrl retunObject=" + retunObject));
        String userKey = InvoiceUtil.showInvoiceSigniture(ctx, retunObject);
        logger.info((Object)("###########end _getViewInvoiceUrl userKey=" + userKey));
        JSONObject userKeyData = JSONObject.parseObject((String)userKey);
        if (!userKeyData.isEmpty() && "0000".equals(userKeyData.getString("errcode")) && StringUtils.isNotEmpty((CharSequence)userKeyData.getJSONObject("data").getString("userKey"))) {
            url = retunObject.get((Object)"url") + "/m4-web/fpzs/expense/invoice/list?userKey=" + userKeyData.getJSONObject("data").get((Object)"userKey");
        }
        return url;
    }

    @Override
    protected String _getViewInvoiceUrl(Context ctx, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        String random = Double.toString(Math.random());
        String url = "";
        if (SourceSystem.CQ.equals((Object)baseInfo.getSourceSystem())) {
            url = InvoiceUtil.getCqShowInvoiceUrl(ctx, baseInfo, random, spareMap);
            return url;
        }
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>();
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
        if (ticketEntries != null && ticketEntries.size() > 0) {
            for (CoreBillEntryBaseInfo ticket : ticketEntries) {
                serialNoSet.add(ticket.get("serialNo").toString());
            }
        }
        spareMap.put("random", random);
        JSONObject retunObject = InvoiceUtil.getUserkeyJson(ctx, baseInfo, spareMap);
        spareMap.remove("random");
        retunObject.put("invoiceSerialNos", (Object)StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        spareMap.remove("SerialNoSet");
        logger.info((Object)("###########start ShowCloudInvoiceTokenHandler retunObject=" + retunObject));
        String userKey = InvoiceUtil.showInvoiceSigniture(ctx, retunObject);
        logger.info((Object)("###########end ShowCloudInvoiceTokenHandler userKey=" + userKey));
        JSONObject userKeyData = JSONObject.parseObject((String)userKey);
        if (!userKeyData.isEmpty() && "0000".equals(userKeyData.getString("errcode")) && StringUtils.isNotEmpty((CharSequence)userKeyData.getJSONObject("data").getString("userKey"))) {
            url = retunObject.get((Object)"url") + "/m4-web/fpzs/expense/invoice/list?userKey=" + userKeyData.getJSONObject("data").get((Object)"userKey");
        }
        return url;
    }

    public Map invoiceCloudGroupByBiz(JSONArray invoiceDataArray, Map spareMap) throws EASBizException, BOSException {
        LinkedHashMap groupMap = new LinkedHashMap();
        spareMap.put("groupMap", groupMap);
        spareMap.put("billType", "biz");
        this.buildGroupMap(invoiceDataArray, spareMap);
        spareMap.remove("groupMap");
        spareMap.remove("billType");
        return groupMap;
    }

    public Map invoiceCloudGroupByBizOut(JSONArray invoiceDataArray, Map spareMap) throws EASBizException, BOSException {
        LinkedHashMap groupMap = new LinkedHashMap();
        spareMap.put("groupMap", groupMap);
        spareMap.put("billType", "bizOut");
        this.buildGroupMap(invoiceDataArray, spareMap);
        spareMap.remove("groupMap");
        spareMap.remove("billType");
        return groupMap;
    }

    public Map invoiceCloudGroupByPur(JSONArray invoiceDataArray, Map spareMap) throws EASBizException, BOSException {
        LinkedHashMap groupMap = new LinkedHashMap();
        spareMap.put("groupMap", groupMap);
        spareMap.put("billType", "pur");
        this.buildGroupMap(invoiceDataArray, spareMap);
        spareMap.remove("groupMap");
        spareMap.remove("billType");
        return groupMap;
    }

    public Map invoiceCloudGroupByTra(JSONArray invoiceDataArray, Map spareMap) throws EASBizException, BOSException {
        LinkedHashMap groupMap = new LinkedHashMap();
        spareMap.put("groupMap", groupMap);
        spareMap.put("billType", "tra");
        this.buildGroupMap(invoiceDataArray, spareMap);
        spareMap.remove("groupMap");
        spareMap.remove("billType");
        return groupMap;
    }

    private void buildGroupMap(JSONArray invoiceDataArray, Map spareMap) throws EASBizException, BOSException {
        for (int i = 0; i < invoiceDataArray.size(); ++i) {
            JSONObject invoiceData = invoiceDataArray.getJSONObject(i);
            JSONArray items = invoiceData.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                this.groupVATInvoice(invoiceData, items, spareMap);
                continue;
            }
            this.groupNoVATInvoice(invoiceData, spareMap);
        }
    }

    private void groupVATInvoice(JSONObject invoiceDataHead, JSONArray invoiceDataItems, Map spareMap) throws EASBizException, BOSException {
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isMergeInvoice = (Boolean)paramMap.get("isMergeInvoice");
        for (int j = 0; j < invoiceDataItems.size(); ++j) {
            JSONObject itemData = invoiceDataItems.getJSONObject(j);
            HashMap groupMap = (HashMap)spareMap.get("groupMap");
            String billType = (String)spareMap.get("billType");
            String serialNo = invoiceDataHead.getString("serialNo");
            String invoiceType2 = invoiceDataHead.getString("invoiceType");
            String invoiceNumber = invoiceDataHead.getString("invoiceNo");
            String costType = invoiceDataHead.getString("costType");
            HashMap valueMap = new HashMap();
            HashMap<String, Object> vatEntryInfoMap = new HashMap<String, Object>();
            Map<String, Map> VATEntryInfoCollection = new HashMap();
            HashSet<String> serialNoSet = new HashSet<String>();
            ArrayList<String> invoiceNumberList = new ArrayList<String>();
            BigDecimal taxRate = itemData.getBigDecimal("taxRate");
            taxRate = taxRate.setScale(2, 4);
            BigDecimal amount = itemData.getBigDecimal("detailAmount");
            BigDecimal taxAmount = itemData.getBigDecimal("taxAmount");
            String taxClassNumber = itemData.getString("goodsCode");
            BigDecimal num = itemData.getBigDecimal("num");
            String goodsName = itemData.getString("goodsName");
            String mapkey = invoiceType2 + taxClassNumber + taxRate;
            String VATKey = invoiceType2 + taxClassNumber + taxRate + serialNo;
            if ("tra".equals(billType)) {
                mapkey = mapkey + costType;
                VATKey = VATKey + costType;
            }
            if (!isMergeInvoice.booleanValue()) {
                UUID uuid = UUID.randomUUID();
                mapkey = mapkey + uuid.toString();
                VATKey = VATKey + uuid.toString();
            }
            if (isMergeInvoice.booleanValue() && groupMap.containsKey(mapkey)) {
                valueMap = (HashMap)groupMap.get(mapkey);
                BigDecimal amountMap = (BigDecimal)valueMap.get("totalAmountWithoutTax");
                BigDecimal taxAmountMap = (BigDecimal)valueMap.get("totalTaxAmount");
                BigDecimal numMap = (BigDecimal)valueMap.get("num");
                HashSet fids = (HashSet)valueMap.get("serialNo");
                ArrayList invoiceNumbers = (ArrayList)valueMap.get("invoiceNumber");
                if ("-".equals(invoiceNumber) || !invoiceNumbers.contains(invoiceNumber)) {
                    invoiceNumbers.add(invoiceNumber);
                }
                VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
                if (VATEntryInfoCollection.containsKey(VATKey)) {
                    BigDecimal entryMTRAmountOri = BizCollUtil.ZERO;
                    BigDecimal entryMTRTaxAmount = BizCollUtil.ZERO;
                    BigDecimal entryMTRNum = BizCollUtil.ZERO;
                    Map VATEMap = (Map)VATEntryInfoCollection.get(VATKey);
                    entryMTRAmountOri = amount.add(taxAmount).add((BigDecimal)VATEMap.get("amountOri"));
                    entryMTRTaxAmount = taxAmount.add((BigDecimal)VATEMap.get("tax"));
                    entryMTRNum = num.add((BigDecimal)VATEMap.get("num"));
                    VATEMap.put("amountOri", entryMTRAmountOri);
                    VATEMap.put("tax", entryMTRTaxAmount);
                    VATEMap.put("num", entryMTRNum);
                    VATEntryInfoCollection.put(VATKey, VATEMap);
                } else {
                    vatEntryInfoMap.put("amountOri", amount.add(taxAmount));
                    vatEntryInfoMap.put("tax", taxAmount);
                    vatEntryInfoMap.put("taxRate", taxRate);
                    vatEntryInfoMap.put("serialNo", serialNo);
                    vatEntryInfoMap.put("invoiceNumber", invoiceNumber);
                    vatEntryInfoMap.put("num", num);
                    if ("tra".equals(billType)) {
                        this.buildTraValueMapAndVatMap(invoiceDataHead, null, vatEntryInfoMap, spareMap);
                    }
                    VATEntryInfoCollection.put(VATKey, vatEntryInfoMap);
                }
                amount = amount.add(amountMap);
                taxAmount = taxAmount.add(taxAmountMap);
                num = num.add(numMap);
                fids.add(serialNo);
                valueMap.put("serialNo", fids);
                valueMap.put("invoiceNumber", invoiceNumbers);
                valueMap.put("totalAmountWithoutTax", amount);
                valueMap.put("totalTaxAmount", taxAmount);
                valueMap.put("invoiceType", invoiceType2);
                valueMap.put("taxClassNumber", taxClassNumber);
                valueMap.put("num", num);
                valueMap.put("VATEntryInfoCollection", VATEntryInfoCollection);
                continue;
            }
            serialNoSet.add(serialNo);
            invoiceNumberList.add(invoiceNumber);
            valueMap.put("totalAmountWithoutTax", amount);
            valueMap.put("totalTaxAmount", taxAmount);
            valueMap.put("serialNo", serialNoSet);
            valueMap.put("taxRate", taxRate);
            valueMap.put("invoiceType", invoiceType2);
            valueMap.put("taxClassNumber", taxClassNumber);
            valueMap.put("invoiceNumber", invoiceNumberList);
            valueMap.put("num", num);
            valueMap.put("goodsName", goodsName);
            vatEntryInfoMap.put("amountOri", amount.add(taxAmount));
            vatEntryInfoMap.put("tax", taxAmount);
            vatEntryInfoMap.put("taxRate", taxRate);
            vatEntryInfoMap.put("serialNo", serialNo);
            vatEntryInfoMap.put("invoiceType", invoiceType2);
            vatEntryInfoMap.put("taxClassNumber", taxClassNumber);
            vatEntryInfoMap.put("invoiceNumber", invoiceNumber);
            vatEntryInfoMap.put("num", num);
            if ("tra".equals(billType)) {
                this.buildTraValueMapAndVatMap(invoiceDataHead, valueMap, vatEntryInfoMap, spareMap);
            }
            VATEntryInfoCollection.put(VATKey, vatEntryInfoMap);
            valueMap.put("VATEntryInfoCollection", VATEntryInfoCollection);
            groupMap.put(mapkey, valueMap);
        }
    }

    private void groupNoVATInvoice(JSONObject invoiceDataHead, Map spareMap) throws EASBizException, BOSException {
        HashMap groupMap = (HashMap)spareMap.get("groupMap");
        String billType = (String)spareMap.get("billType");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isMergeInvoice = (Boolean)paramMap.get("isMergeInvoice");
        HashMap valueMap = new HashMap();
        HashSet<String> serialNoSet = new HashSet<String>();
        ArrayList<String> invoiceNumberList = new ArrayList<String>();
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        String invoiceType2 = invoiceDataHead.getString("invoiceType");
        String serialNo = invoiceDataHead.getString("serialNo");
        String invoiceNumber = invoiceDataHead.getString("invoiceNo");
        String costType = invoiceDataHead.getString("costType");
        BigDecimal taxRate = invoiceDataHead.getBigDecimal("taxRate");
        taxRate = taxRate.setScale(2, 4);
        if (StringUtils.isNotEmpty((CharSequence)invoiceDataHead.getString("amount"))) {
            amount = invoiceDataHead.getBigDecimal("amount");
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceDataHead.getString("taxAmount"))) {
            taxAmount = invoiceDataHead.getBigDecimal("taxAmount");
        }
        BigDecimal num = invoiceDataHead.getBigDecimal("num");
        String mapkey = invoiceType2 + taxRate;
        String VATKey = "";
        if ("tra".equals(billType)) {
            mapkey = mapkey + costType;
            VATKey = invoiceType2 + taxRate + serialNo + costType;
        }
        if (!isMergeInvoice.booleanValue()) {
            UUID uuid = UUID.randomUUID();
            mapkey = mapkey + uuid.toString();
            VATKey = VATKey + uuid.toString();
        }
        if (isMergeInvoice.booleanValue() && groupMap.containsKey(mapkey)) {
            valueMap = (HashMap)groupMap.get(mapkey);
            BigDecimal amountMap = (BigDecimal)valueMap.get("totalAmountWithoutTax");
            BigDecimal taxAmountMap = (BigDecimal)valueMap.get("totalTaxAmount");
            BigDecimal numMap = (BigDecimal)valueMap.get("num");
            HashSet fids = (HashSet)valueMap.get("serialNo");
            ArrayList invoiceNumbers = (ArrayList)valueMap.get("invoiceNumber");
            if ("tra".equals(billType)) {
                Map VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
                if (VATEntryInfoCollection.containsKey(VATKey)) {
                    BigDecimal entryMTRAmountOri = BizCollUtil.ZERO;
                    BigDecimal entryMTRTaxAmount = BizCollUtil.ZERO;
                    BigDecimal entryMTRNum = BizCollUtil.ZERO;
                    Map VATEMap = (Map)VATEntryInfoCollection.get(VATKey);
                    entryMTRAmountOri = amount.add(taxAmount).add((BigDecimal)VATEMap.get("amount"));
                    entryMTRTaxAmount = taxAmount.add((BigDecimal)VATEMap.get("tax"));
                    entryMTRNum = num.add((BigDecimal)VATEMap.get("num"));
                    VATEMap.put("amountOri", entryMTRAmountOri);
                    VATEMap.put("tax", entryMTRTaxAmount);
                    VATEMap.put("num", entryMTRNum);
                    VATEntryInfoCollection.put(VATKey, VATEMap);
                } else {
                    HashMap<String, Object> vatEntryInfoMap = new HashMap<String, Object>();
                    vatEntryInfoMap.put("amountOri", amount.add(taxAmount));
                    vatEntryInfoMap.put("tax", taxAmount);
                    vatEntryInfoMap.put("taxRate", taxRate);
                    vatEntryInfoMap.put("serialNo", serialNo);
                    vatEntryInfoMap.put("invoiceType", invoiceType2);
                    vatEntryInfoMap.put("taxClassNumber", null);
                    vatEntryInfoMap.put("invoiceNumber", invoiceNumber);
                    vatEntryInfoMap.put("num", num);
                    vatEntryInfoMap.put("costType", costType);
                    if ("tra".equals(billType)) {
                        this.buildTraValueMapAndVatMap(invoiceDataHead, valueMap, vatEntryInfoMap, spareMap);
                    }
                    VATEntryInfoCollection.put(VATKey, vatEntryInfoMap);
                }
                valueMap.put("VATEntryInfoCollection", VATEntryInfoCollection);
            }
            amount = amount.add(amountMap);
            taxAmount = taxAmount.add(taxAmountMap);
            num = num.add(numMap);
            fids.add(serialNo);
            if ("-".equals(invoiceNumber) || !invoiceNumbers.contains(invoiceNumber)) {
                invoiceNumbers.add(invoiceNumber);
            }
            valueMap.put("serialNo", fids);
            valueMap.put("invoiceNumber", invoiceNumbers);
            valueMap.put("totalAmountWithoutTax", amount);
            valueMap.put("totalTaxAmount", taxAmount);
            valueMap.put("num", num);
        } else {
            serialNoSet.add(serialNo);
            invoiceNumberList.add(invoiceNumber);
            valueMap.put("totalAmountWithoutTax", amount);
            valueMap.put("totalTaxAmount", taxAmount);
            valueMap.put("serialNo", serialNoSet);
            valueMap.put("taxRate", taxRate);
            valueMap.put("invoiceType", invoiceType2);
            valueMap.put("taxClassNumber", null);
            valueMap.put("invoiceNumber", invoiceNumberList);
            valueMap.put("num", num);
            if ("tra".equals(billType)) {
                HashMap VATEntryInfoCollection = new HashMap();
                HashMap<String, Object> vatEntryInfoMap = new HashMap<String, Object>();
                vatEntryInfoMap.put("amountOri", amount.add(taxAmount));
                vatEntryInfoMap.put("tax", taxAmount);
                vatEntryInfoMap.put("taxRate", taxRate);
                vatEntryInfoMap.put("serialNo", serialNo);
                vatEntryInfoMap.put("invoiceType", invoiceType2);
                vatEntryInfoMap.put("taxClassNumber", null);
                vatEntryInfoMap.put("invoiceNumber", invoiceNumber);
                vatEntryInfoMap.put("costType", costType);
                this.buildTraValueMapAndVatMap(invoiceDataHead, valueMap, vatEntryInfoMap, spareMap);
                VATEntryInfoCollection.put(VATKey, vatEntryInfoMap);
                valueMap.put("VATEntryInfoCollection", VATEntryInfoCollection);
            }
            groupMap.put(mapkey, valueMap);
        }
    }

    private void buildTraValueMapAndVatMap(JSONObject invoiceDataHead, Map<String, Object> valueMap, Map vatEntryInfoMap, Map spareMap) {
        String costType = invoiceDataHead.getString("costType");
        String invoiceType2 = invoiceDataHead.getString("invoiceType");
        if (valueMap != null) {
            BigDecimal insurancePremium;
            BigDecimal insuranceMap;
            valueMap.put("costType", costType);
            valueMap.put("invoiceDate", invoiceDataHead.getString("invoiceDate"));
            valueMap.put("stationGetOn", invoiceDataHead.getString("stationGetOn"));
            valueMap.put("stationGetOff", invoiceDataHead.getString("stationGetOff"));
            if ("10".equals(invoiceType2)) {
                valueMap.put("stationGetOn", invoiceDataHead.getString("placeOfDeparture"));
                valueMap.put("stationGetOff", invoiceDataHead.getString("destination"));
                if (valueMap.get("cadFund") != null) {
                    BigDecimal cadFundMap = (BigDecimal)valueMap.get("cadFund");
                    BigDecimal cadFund = invoiceDataHead.getBigDecimal("airportConstructionFee");
                    cadFund = cadFund.add(cadFundMap);
                    valueMap.put("cadFund", cadFund);
                } else {
                    valueMap.put("cadFund", invoiceDataHead.getBigDecimal("airportConstructionFee"));
                }
                if (valueMap.get("insurancePremium") != null) {
                    insuranceMap = (BigDecimal)valueMap.get("insurancePremium");
                    insurancePremium = invoiceDataHead.getBigDecimal("insurancePremium");
                    insurancePremium = insurancePremium.add(insuranceMap);
                    valueMap.put("insurancePremium", insurancePremium);
                } else {
                    valueMap.put("insurancePremium", invoiceDataHead.getBigDecimal("insurancePremium"));
                }
            }
            if ("16".equals(invoiceType2) || "20".equals(invoiceType2)) {
                if (valueMap.get("insurancePremium") != null) {
                    insuranceMap = (BigDecimal)valueMap.get("insurancePremium");
                    insurancePremium = invoiceDataHead.getBigDecimal("insurancePremium");
                    insurancePremium = insurancePremium.add(insuranceMap);
                    valueMap.put("insurancePremium", insurancePremium);
                } else {
                    valueMap.put("insurancePremium", invoiceDataHead.getBigDecimal("insurancePremium"));
                }
            }
        }
        if (vatEntryInfoMap != null) {
            vatEntryInfoMap.put("costType", costType);
            vatEntryInfoMap.put("cadFund", invoiceDataHead.getBigDecimal("airportConstructionFee"));
            vatEntryInfoMap.put("insurancePremium", invoiceDataHead.getBigDecimal("insurancePremium"));
        }
    }

    public Map invoiceCloudBuildEntryByBiz(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        BizAccountBillEntryCollection bizCollection = new BizAccountBillEntryCollection();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        ArrayList<Map> VATInvoiceEntryList = new ArrayList<Map>();
        entryLinkInvoice.put("firstEntry", null);
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        StringBuilder logbd = new StringBuilder("##\u5355\u5934\u5bfc\u7968 number=" + baseInfo.getNumber() + ",CP03910=" + isUseDeduction);
        if (groupMap.size() > 0) {
            logbd.append(",\u5206\u5f55id,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        for (Map.Entry mapEntry : groupMap.entrySet()) {
            Map valueMap = (Map)mapEntry.getValue();
            Map VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
            Set fids = (Set)valueMap.get("serialNo");
            String serialNoStr = StringUtils.join((Object[])fids.toArray(), (String)",");
            ArrayList invoiceNo = (ArrayList)valueMap.get("invoiceNumber");
            String invoiceNoStr = StringUtils.join((Object[])invoiceNo.toArray(), (String)",");
            String taxClassNumber = (String)valueMap.get("taxClassNumber");
            String invoiceType2 = (String)valueMap.get("invoiceType");
            String cacheKey = invoiceType2 + taxClassNumber;
            if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
            } else {
                invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
            }
            boolean isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
            BigDecimal amountWithoutTax = (BigDecimal)valueMap.get("totalAmountWithoutTax");
            totalTaxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            taxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            if (isUseDeduction.booleanValue() && !isDeduction) {
                taxAmount = BizCollUtil.ZERO;
            }
            BigDecimal taxRate = (BigDecimal)valueMap.get("taxRate");
            BizAccountBillEntryInfo entry = new BizAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            logbd.append(";" + entryBosId + "," + taxClassNumber + "," + isDeduction + "," + taxAmount);
            entry.setEntrySerialNo(serialNoStr);
            entry.setEntryTicNumber(invoiceNoStr);
            entry.setTicketUrl(entryBosId.toString());
            if (VATEntryInfoCollection != null) {
                for (Map.Entry vatMapEntry : VATEntryInfoCollection.entrySet()) {
                    Map VATEntryInfoMap = (Map)vatMapEntry.getValue();
                    if (isUseDeduction.booleanValue() && !isDeduction) {
                        VATEntryInfoMap.put("tax", BizCollUtil.ZERO);
                    }
                    VATEntryInfoMap.put("serialNolinkEntryId", entryBosId.toString());
                    VATInvoiceEntryList.add(VATEntryInfoMap);
                }
            }
            entryLinkInvoice.put(entryBosId.toString(), serialNoStr);
            entry.setCurrencyType(baseInfo.getCurrencyType());
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            if (amountWithoutTax != null) {
                BigDecimal entryAmountOri = amountWithoutTax.add(totalTaxAmount).setScale(2, 4);
                BigDecimal entryAmountOriWithoutTax = entryAmountOri.subtract(taxAmount).setScale(2, 4);
                BigDecimal entryExRate = entry.getExchangeRate();
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
                    } else {
                        entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
                    }
                }
                entry.setAmountOri(entryAmountOri);
                entry.setAmountOriWithoutTax(entryAmountOriWithoutTax);
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmountWithoutTax);
            }
            entry.setTax(taxAmount);
            taxRate = taxAmount.compareTo(BizCollUtil.ZERO) == 0 ? BizCollUtil.ZERO : taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
            entry.setTaxRate(taxRate);
            logbd.append("," + taxRate);
            int invoiceNum = fids.size();
            entry.setInvoiceNum(ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + invoiceNum + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
            Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
            entry.setHappenTime(date);
            InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
            bizCollection.add(entry);
        }
        logger.info((Object)logbd);
        HashMap<String, Object> bizCollectionMap = new HashMap<String, Object>();
        bizCollectionMap.put("bizCollection", (Object)bizCollection);
        bizCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        spareMap.put("VATInvoiceEntryList", VATInvoiceEntryList);
        return bizCollectionMap;
    }

    public Map invoiceCloudBuildEntryByBizOut(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        BizAccountOutBillEntryCollection bizOutCollection = new BizAccountOutBillEntryCollection();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        ArrayList<Map> VATInvoiceEntryList = new ArrayList<Map>();
        entryLinkInvoice.put("firstEntry", null);
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        StringBuilder logbd = new StringBuilder("##\u5355\u5934\u5bfc\u7968 number=" + baseInfo.getNumber() + ";CP03910=" + isUseDeduction);
        if (groupMap.size() > 0) {
            logbd.append(",\u5206\u5f55id,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        for (Map.Entry mapEntry : groupMap.entrySet()) {
            Map valueMap = (Map)mapEntry.getValue();
            Map VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
            Set fids = (Set)valueMap.get("serialNo");
            String serialNoStr = StringUtils.join((Object[])fids.toArray(), (String)",");
            ArrayList invoiceNo = (ArrayList)valueMap.get("invoiceNumber");
            String invoiceNoStr = StringUtils.join((Object[])invoiceNo.toArray(), (String)",");
            String taxClassNumber = (String)valueMap.get("taxClassNumber");
            String invoiceType2 = (String)valueMap.get("invoiceType");
            String cacheKey = invoiceType2 + taxClassNumber;
            if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
            } else {
                invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
            }
            boolean isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
            BigDecimal amountWithoutTax = (BigDecimal)valueMap.get("totalAmountWithoutTax");
            totalTaxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            taxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            if (isUseDeduction.booleanValue() && !isDeduction) {
                taxAmount = BizCollUtil.ZERO;
            }
            BigDecimal taxRate = (BigDecimal)valueMap.get("taxRate");
            BizAccountOutBillEntryInfo entry = new BizAccountOutBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            logbd.append(";" + entryBosId + "," + taxClassNumber + "," + isDeduction + "," + taxAmount);
            entry.setId(entryBosId);
            entry.setEntrySerialNo(serialNoStr);
            entry.setEntryTicNumber(invoiceNoStr);
            entry.setTicketUrl(entryBosId.toString());
            if (VATEntryInfoCollection != null) {
                for (Map.Entry vatMapEntry : VATEntryInfoCollection.entrySet()) {
                    Map VATEntryInfoMap = (Map)vatMapEntry.getValue();
                    if (isUseDeduction.booleanValue() && !isDeduction) {
                        VATEntryInfoMap.put("tax", BizCollUtil.ZERO);
                    }
                    VATEntryInfoMap.put("serialNolinkEntryId", entryBosId.toString());
                    VATInvoiceEntryList.add(VATEntryInfoMap);
                }
            }
            entryLinkInvoice.put(entryBosId.toString(), serialNoStr);
            entry.setCurrencyType(baseInfo.getCurrencyType());
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            if (amountWithoutTax != null) {
                BigDecimal entryAmountOri = amountWithoutTax.add(totalTaxAmount).setScale(2, 4);
                BigDecimal entryAmountOriWithoutTax = entryAmountOri.subtract(taxAmount).setScale(2, 4);
                BigDecimal entryExRate = entry.getExchangeRate();
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
                    } else {
                        entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
                    }
                }
                entry.setAmountOri(entryAmountOri);
                entry.setAmountOriWithoutTax(entryAmountOriWithoutTax);
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmountWithoutTax);
            }
            entry.setTax(taxAmount);
            taxRate = taxAmount.compareTo(BizCollUtil.ZERO) == 0 ? BizCollUtil.ZERO : taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
            logbd.append("," + taxRate);
            entry.setTaxRate(taxRate);
            int invoiceNum = fids.size();
            entry.setInvoiceNum(ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + invoiceNum + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
            Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
            entry.setHappenTime(date);
            InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
            bizOutCollection.add(entry);
        }
        logger.info((Object)logbd);
        HashMap<String, Object> bizOutCollectionMap = new HashMap<String, Object>();
        bizOutCollectionMap.put("bizOutCollection", (Object)bizOutCollection);
        bizOutCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        spareMap.put("VATInvoiceEntryList", VATInvoiceEntryList);
        return bizOutCollectionMap;
    }

    public Map invoiceCloudBuildEntryByPur(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        DailyPurchaseAccountBillEntryCollection purCollection = new DailyPurchaseAccountBillEntryCollection();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        ArrayList<Map> VATInvoiceEntryList = new ArrayList<Map>();
        entryLinkInvoice.put("firstEntry", null);
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        StringBuilder logbd = new StringBuilder("##\u5355\u5934\u5bfc\u7968 number=" + baseInfo.getNumber() + ";CP03910=" + isUseDeduction);
        if (groupMap.size() > 0) {
            logbd.append(",\u5206\u5f55id,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        for (Map.Entry mapEntry : groupMap.entrySet()) {
            Map valueMap = (Map)mapEntry.getValue();
            Map VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
            Set fids = (Set)valueMap.get("serialNo");
            String serialNoStr = StringUtils.join((Object[])fids.toArray(), (String)",");
            ArrayList invoiceNo = (ArrayList)valueMap.get("invoiceNumber");
            String invoiceNoStr = StringUtils.join((Object[])invoiceNo.toArray(), (String)",");
            String taxClassNumber = (String)valueMap.get("taxClassNumber");
            String invoiceType2 = (String)valueMap.get("invoiceType");
            String cacheKey = invoiceType2 + taxClassNumber;
            if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
            } else {
                invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
            }
            boolean isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
            BigDecimal amountWithoutTax = (BigDecimal)valueMap.get("totalAmountWithoutTax");
            totalTaxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            taxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            if (isUseDeduction.booleanValue() && !isDeduction) {
                taxAmount = BizCollUtil.ZERO;
            }
            BigDecimal taxRate = (BigDecimal)valueMap.get("taxRate");
            BigDecimal count = (BigDecimal)valueMap.get("num");
            String goodsName = (String)valueMap.get("goodsName");
            DailyPurchaseAccountBillEntryInfo entry = new DailyPurchaseAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            logbd.append(";" + entryBosId + "," + taxClassNumber + "," + isDeduction + "," + taxAmount);
            entry.setEntrySerialNo(serialNoStr);
            entry.setEntryTicNumber(invoiceNoStr);
            entry.setTicketUrl(entryBosId.toString());
            if (VATEntryInfoCollection != null) {
                for (Map.Entry vatMapEntry : VATEntryInfoCollection.entrySet()) {
                    Map VATEntryInfoMap = (Map)vatMapEntry.getValue();
                    VATEntryInfoMap.put("serialNolinkEntryId", entryBosId.toString());
                    if (isUseDeduction.booleanValue() && !isDeduction) {
                        VATEntryInfoMap.put("tax", BizCollUtil.ZERO);
                    }
                    VATInvoiceEntryList.add(VATEntryInfoMap);
                }
            }
            entryLinkInvoice.put(entryBosId.toString(), serialNoStr);
            entry.setCurrencyType(baseInfo.getCurrencyType());
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            if (amountWithoutTax != null) {
                BigDecimal entryAmountOri = amountWithoutTax.add(totalTaxAmount).setScale(2, 4);
                BigDecimal entryAmountOriWithoutTax = entryAmountOri.subtract(taxAmount).setScale(2, 4);
                BigDecimal entryExRate = entry.getExchangeRate();
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
                    } else {
                        entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
                    }
                }
                entry.setAmountOri(entryAmountOri);
                entry.setAmountOriWithoutTax(entryAmountOriWithoutTax);
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmountWithoutTax);
            }
            entry.setTax(taxAmount);
            entry.setName(goodsName);
            taxRate = taxAmount.compareTo(BizCollUtil.ZERO) == 0 ? BizCollUtil.ZERO : taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
            entry.setTaxRate(taxRate);
            logbd.append("," + taxRate);
            InvoiceUtil.buildPurEntryPriceAndCountForBill(entry, count);
            int invoiceNum = fids.size();
            entry.setInvoiceNum(ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + invoiceNum + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
            Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
            entry.setHappenTime(date);
            InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
            purCollection.add(entry);
        }
        logger.info((Object)logbd);
        HashMap<String, Object> purCollectionMap = new HashMap<String, Object>();
        purCollectionMap.put("purCollection", (Object)purCollection);
        purCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        spareMap.put("VATInvoiceEntryList", VATInvoiceEntryList);
        return purCollectionMap;
    }

    public Map invoiceCloudBuildEntryByTra(Context ctx, Map groupMap, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        TravelAccountBillEntryCollection traBizCollection = new TravelAccountBillEntryCollection();
        HashMap<String, String> entryLinkInvoice = new HashMap<String, String>();
        ArrayList<Map> VATInvoiceEntryList = new ArrayList<Map>();
        entryLinkInvoice.put("firstEntry", null);
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        StringBuilder logbd = new StringBuilder("##\u5355\u5934\u5bfc\u7968 number=" + baseInfo.getNumber() + ";CP03910=" + isUseDeduction);
        if (groupMap.size() > 0) {
            logbd.append(",\u5206\u5f55id,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        for (Map.Entry mapEntry : groupMap.entrySet()) {
            Map valueMap = (Map)mapEntry.getValue();
            Map VATEntryInfoCollection = (Map)valueMap.get("VATEntryInfoCollection");
            Set fids = (Set)valueMap.get("serialNo");
            String serialNoStr = StringUtils.join((Object[])fids.toArray(), (String)",");
            ArrayList invoiceNo = (ArrayList)valueMap.get("invoiceNumber");
            String invoiceNoStr = StringUtils.join((Object[])invoiceNo.toArray(), (String)",");
            String taxClassNumber = (String)valueMap.get("taxClassNumber");
            String invoiceType2 = (String)valueMap.get("invoiceType");
            String cacheKey = invoiceType2 + taxClassNumber;
            if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
            } else {
                invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
            }
            boolean isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
            BigDecimal amountWithoutTax = (BigDecimal)valueMap.get("totalAmountWithoutTax");
            totalTaxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            taxAmount = (BigDecimal)valueMap.get("totalTaxAmount");
            if (isUseDeduction.booleanValue() && !isDeduction) {
                taxAmount = BizCollUtil.ZERO;
            }
            BigDecimal taxRate = (BigDecimal)valueMap.get("taxRate");
            String costType = (String)valueMap.get("costType");
            String invoiceDate = (String)valueMap.get("invoiceDate");
            String stationGetOn = (String)valueMap.get("stationGetOn");
            String stationGetOff = (String)valueMap.get("stationGetOff");
            TravelAccountBillEntryInfo entry = new TravelAccountBillEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)entry.getBOSType());
            entry.setId(entryBosId);
            logbd.append(";" + entryBosId + "," + taxClassNumber + "," + isDeduction + "," + taxAmount);
            entry.setTicketUrl(entryBosId.toString());
            entry.setEntrySerialNo(serialNoStr);
            entry.setEntryTicNumber(invoiceNoStr);
            if (VATEntryInfoCollection != null) {
                for (Map.Entry vatMapEntry : VATEntryInfoCollection.entrySet()) {
                    Map VATEntryInfoMap = (Map)vatMapEntry.getValue();
                    VATEntryInfoMap.put("serialNolinkEntryId", entryBosId.toString());
                    if (isUseDeduction.booleanValue() && !isDeduction) {
                        VATEntryInfoMap.put("tax", BizCollUtil.ZERO);
                    }
                    VATInvoiceEntryList.add(VATEntryInfoMap);
                }
            }
            entryLinkInvoice.put(entryBosId.toString(), serialNoStr);
            if (StringUtils.isNotEmpty((CharSequence)invoiceDate)) {
                try {
                    entry.setEndDate(sdf.parse(invoiceDate));
                    entry.setStartDate(sdf.parse(invoiceDate));
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            entry.setFrom(stationGetOn);
            entry.setTo(stationGetOff);
            VehicleEnum vehicleEnum = VehicleEnum.OTHER;
            if ("8".equals(invoiceType2) || "16".equals(invoiceType2)) {
                vehicleEnum = VehicleEnum.BUSSES;
            } else if ("9".equals(invoiceType2)) {
                vehicleEnum = VehicleEnum.TRAIN;
            } else if ("10".equals(invoiceType2)) {
                vehicleEnum = VehicleEnum.AIRPLANE;
            } else if ("20".equals(invoiceType2)) {
                vehicleEnum = VehicleEnum.SHIP;
            }
            entry.setVehicle(vehicleEnum);
            entry.setCostCenter(baseInfo.getCostedDept());
            entry.setCompany(baseInfo.getCompany());
            entry.setTaxiExpense(BizCollUtil.ZERO);
            entry.setTaxiExpenseWithoutTax(BizCollUtil.ZERO);
            entry.setTaxiExpenseTax(BizCollUtil.ZERO);
            entry.setTaxiExpenseTaxRate(BizCollUtil.ZERO);
            entry.setBussesExpense(BizCollUtil.ZERO);
            entry.setBussesExpenseWithoutTax(BizCollUtil.ZERO);
            entry.setBussesExpenseTax(BizCollUtil.ZERO);
            entry.setBussesExpenseTaxRate(BizCollUtil.ZERO);
            entry.setHotelExpense(BizCollUtil.ZERO);
            entry.setHotelExpenseWithoutTax(BizCollUtil.ZERO);
            entry.setTaxRate(BizCollUtil.ZERO);
            entry.setTax(BizCollUtil.ZERO);
            entry.setOtherExpense(BizCollUtil.ZERO);
            entry.setOtherExpenseWithoutTax(BizCollUtil.ZERO);
            entry.setOtherExpenseTax(BizCollUtil.ZERO);
            entry.setOtherExpenseTaxRate(BizCollUtil.ZERO);
            entry.setCadFund(BizCollUtil.ZERO);
            BigDecimal entryAmountOri = amountWithoutTax.add(totalTaxAmount).setScale(2, 4);
            BigDecimal entryAmountOriWithoutTax = entryAmountOri.subtract(taxAmount).setScale(2, 4);
            taxAmount = taxAmount.setScale(2, 4);
            taxRate = taxAmount.compareTo(BizCollUtil.ZERO) == 0 ? BizCollUtil.ZERO : taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
            logbd.append("," + taxRate);
            if ("city".equals(costType)) {
                entry.setTaxiExpense(entryAmountOri);
                entry.setTaxiExpenseTax(taxAmount);
                entry.setTaxiExpenseWithoutTax(entryAmountOriWithoutTax);
                entry.setTaxiExpenseTaxRate(taxRate);
            } else if ("suburb".equals(costType)) {
                if (valueMap.get("cadFund") != null) {
                    entryAmountOri = entryAmountOri.subtract((BigDecimal)valueMap.get("cadFund"));
                    entryAmountOriWithoutTax = entryAmountOriWithoutTax.subtract((BigDecimal)valueMap.get("cadFund"));
                }
                entry.setBussesExpense(entryAmountOri);
                entry.setBussesExpenseTax(taxAmount);
                entry.setBussesExpenseWithoutTax(entryAmountOriWithoutTax);
                entry.setBussesExpenseTaxRate(taxRate);
                if (valueMap.get("cadFund") != null) {
                    BigDecimal cadFundMap = (BigDecimal)valueMap.get("cadFund");
                    entryAmountOri = entryAmountOri.add(cadFundMap);
                    entry.setBussesExpense(entryAmountOri);
                    entry.setCadFund(cadFundMap.setScale(2, 4));
                    entryAmountOriWithoutTax = entryAmountOriWithoutTax.add((BigDecimal)valueMap.get("cadFund"));
                }
                if (valueMap.get("insurancePremium") != null) {
                    BigDecimal insurancePremium = (BigDecimal)valueMap.get("insurancePremium");
                    entry.setOtherExpense(insurancePremium.setScale(2, 4));
                    entry.setOtherExpenseWithoutTax(insurancePremium.setScale(2, 4));
                    entryAmountOri = entryAmountOri.add(insurancePremium);
                    entryAmountOriWithoutTax = entryAmountOriWithoutTax.add(insurancePremium);
                }
            } else if ("hotel".equals(costType)) {
                entry.setHotelExpense(entryAmountOri);
                entry.setTax(taxAmount);
                entry.setHotelExpenseWithoutTax(entryAmountOriWithoutTax);
                entry.setTaxRate(taxRate);
            } else if ("other".equals(costType)) {
                entry.setOtherExpense(entryAmountOri);
                entry.setOtherExpenseTax(taxAmount);
                entry.setOtherExpenseWithoutTax(entryAmountOriWithoutTax);
                entry.setOtherExpenseTaxRate(taxRate);
            }
            int invoiceNum = fids.size();
            entry.setInvoiceNum(ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + invoiceNum + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
            entry.setCurrencyType(baseInfo.getCurrencyType());
            entry.setCurrencyType(baseInfo.getCurrencyType());
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            if (amountWithoutTax != null) {
                BigDecimal entryExRate = entry.getExchangeRate();
                BigDecimal entryAmount = BizCollUtil.ZERO;
                BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
                if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                    if (entry.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
                    } else {
                        entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                        entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
                    }
                }
                entry.setAmountOri(entryAmountOri);
                entry.setAmountOriWithoutTax(entryAmountOriWithoutTax);
                entry.setAmount(entryAmount);
                entry.setAmountWithoutTax(entryAmountWithoutTax);
            }
            InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
            traBizCollection.add(entry);
        }
        logger.info((Object)logbd);
        HashMap<String, Object> traCollectionMap = new HashMap<String, Object>();
        traCollectionMap.put("traBizCollection", (Object)traBizCollection);
        traCollectionMap.put("entryLinkInvoice", entryLinkInvoice);
        spareMap.put("VATInvoiceEntryList", VATInvoiceEntryList);
        return traCollectionMap;
    }

    public Map invoiceCloudBuildTicketEntryByBiz(Context ctx, JSONArray ticketDataArray, Map entryLinkInvoice, Map spareMap) throws BOSException, EASBizException {
        TicketEntryCollection bizTicketCollection = new TicketEntryCollection();
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)spareMap.get("baseInfo");
        for (int i = 0; i < ticketDataArray.size(); ++i) {
            JSONObject ticketData = ticketDataArray.getJSONObject(i);
            TicketEntryInfo ticketEntry = new TicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
            ticketEntry.setId(entryBosId);
            InvoiceUtil.buildExpenseTicketEntryInfo(ctx, ticketEntry, ticketData, entryLinkInvoice, baseInfo, spareMap);
            bizTicketCollection.add(ticketEntry);
        }
        HashMap<String, TicketEntryCollection> bizTicketCollectionMap = new HashMap<String, TicketEntryCollection>();
        bizTicketCollectionMap.put("bizTicketCollection", bizTicketCollection);
        return bizTicketCollectionMap;
    }

    public Map invoiceCloudBuildTicketEntryByBizOut(Context ctx, JSONArray ticketDataArray, Map entryLinkInvoice, Map spareMap) throws BOSException, EASBizException {
        BizOutTicketEntryCollection bizOutTicketCollection = new BizOutTicketEntryCollection();
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)spareMap.get("baseInfo");
        for (int i = 0; i < ticketDataArray.size(); ++i) {
            JSONObject ticketData = ticketDataArray.getJSONObject(i);
            BizOutTicketEntryInfo ticketEntry = new BizOutTicketEntryInfo();
            InvoiceUtil.buildExpenseTicketEntryInfo(ctx, ticketEntry, ticketData, entryLinkInvoice, baseInfo, spareMap);
            bizOutTicketCollection.add(ticketEntry);
        }
        HashMap<String, BizOutTicketEntryCollection> bizOutTicketCollectionMap = new HashMap<String, BizOutTicketEntryCollection>();
        bizOutTicketCollectionMap.put("bizOutTicketCollection", bizOutTicketCollection);
        return bizOutTicketCollectionMap;
    }

    public Map invoiceCloudBuildTicketEntryByPur(Context ctx, JSONArray ticketDataArray, Map entryLinkInvoice, Map spareMap) throws BOSException, EASBizException {
        PurTicketEntryCollection purTicketCollection = new PurTicketEntryCollection();
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)spareMap.get("baseInfo");
        for (int i = 0; i < ticketDataArray.size(); ++i) {
            JSONObject ticketData = ticketDataArray.getJSONObject(i);
            PurTicketEntryInfo ticketEntry = new PurTicketEntryInfo();
            InvoiceUtil.buildExpenseTicketEntryInfo(ctx, ticketEntry, ticketData, entryLinkInvoice, baseInfo, spareMap);
            purTicketCollection.add(ticketEntry);
        }
        HashMap<String, PurTicketEntryCollection> purTicketCollectionMap = new HashMap<String, PurTicketEntryCollection>();
        purTicketCollectionMap.put("purTicketCollection", purTicketCollection);
        return purTicketCollectionMap;
    }

    public Map invoiceCloudBuildTicketEntryByTra(Context ctx, JSONArray ticketDataArray, Map entryLinkInvoice, Map spareMap) throws BOSException, EASBizException {
        TraTicketEntryCollection traTicketCollection = new TraTicketEntryCollection();
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)spareMap.get("baseInfo");
        for (int i = 0; i < ticketDataArray.size(); ++i) {
            JSONObject ticketData = ticketDataArray.getJSONObject(i);
            TraTicketEntryInfo traEntry = new TraTicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)traEntry.getBOSType());
            traEntry.setId(entryBosId);
            InvoiceUtil.buildExpenseTicketEntryInfo(ctx, traEntry, ticketData, entryLinkInvoice, baseInfo, spareMap);
            traTicketCollection.add(traEntry);
        }
        HashMap<String, TraTicketEntryCollection> traTicketCollectionMap = new HashMap<String, TraTicketEntryCollection>();
        traTicketCollectionMap.put("traTicketCollection", traTicketCollection);
        return traTicketCollectionMap;
    }

    public Map invoiceCloudBuildAccountEntryByBiz(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException {
        return null;
    }

    public Map invoiceCloudBuildAccountEntryByBizOut(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        Map map = this.invoiceCloudBuildAccountEntry(ctx, ticketData, baseInfo, spareMap);
        return map;
    }

    public Map invoiceCloudBuildAccountEntryByPur(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        Map map = this.invoiceCloudBuildAccountEntry(ctx, ticketData, baseInfo, spareMap);
        return map;
    }

    public Map invoiceCloudBuildAccountEntryByTra(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        return null;
    }

    public Map invoiceCloudBuildAccountEntry(Context ctx, JSONArray ticketData, BizCollBillBaseInfo baseInfo, Map spareMap) {
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseInvoiceAcc = paramMap == null ? true : (Boolean)paramMap.get("isUseInvoiceAcc");
        paramMap.remove("isUseInvoiceAcc");
        if (!isUseInvoiceAcc.booleanValue()) {
            return null;
        }
        HashMap<String, CoreBillEntryBaseCollection> resultMap = new HashMap<String, CoreBillEntryBaseCollection>();
        CoreBillEntryBaseCollection addAccountCollection = new CoreBillEntryBaseCollection();
        CoreBillEntryBaseCollection updateAccountCollection = new CoreBillEntryBaseCollection();
        AbstractObjectCollection collectionEntries = (AbstractObjectCollection)baseInfo.get("collectionEntries");
        CollectionAccountCoreBaseInfo buildAccountEntry = null;
        if (baseInfo instanceof BizAccountOutBillInfo) {
            buildAccountEntry = new BizAccountOutBillAccountEntryInfo();
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            buildAccountEntry = new DailyPurchaseAccountBillAccountEntryInfo();
        } else if (baseInfo instanceof BizAccountBillInfo) {
            buildAccountEntry = new BizAccountBillAccountEntryInfo();
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            buildAccountEntry = new TravelAccountBillAccountEntryInfo();
        } else if (collectionEntries != null && collectionEntries.size() > 0) {
            buildAccountEntry = (CollectionAccountCoreBaseInfo)collectionEntries.getObject(0);
            buildAccountEntry.clear();
        } else {
            return resultMap;
        }
        if (collectionEntries != null && collectionEntries.size() > 0) {
            buildAccountEntry.put("payMode", collectionEntries.getObject(0).get("payMode"));
        }
        buildAccountEntry.setCurrencyType(baseInfo.getCurrencyType());
        buildAccountEntry.setExchangeRate(new BigDecimal("1.0000"));
        buildAccountEntry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        buildAccountEntry.setExchangeRatePrecision(4);
        ArrayList<String> payerList = new ArrayList<String>();
        HashMap<String, CollectionAccountCoreBaseInfo> accountMap = new HashMap<String, CollectionAccountCoreBaseInfo>();
        JSONObject jsonObject = null;
        String payerName = "";
        String payerAccount = "";
        String currencyTypeId = "";
        String payerType = "";
        String samekey = "";
        CollectionAccountCoreBaseInfo newAccountEntry = null;
        CollectionAccountCoreBaseInfo accountInfo = null;
        int size = ticketData.size();
        for (int i = 0; i < size; ++i) {
            jsonObject = ticketData.getJSONObject(i);
            payerName = jsonObject.getString("salerName");
            if (StringUtils.isEmpty((CharSequence)payerName)) continue;
            newAccountEntry = (CollectionAccountCoreBaseInfo)buildAccountEntry.clone();
            if (ticketData.size() > 0) {
                InvoiceUtil.buildPurAndBizOutBillAccountEntryInfo(newAccountEntry, jsonObject);
            }
            payerAccount = newAccountEntry.getPayerAccount();
            samekey = payerName + payerAccount;
            if (accountMap.containsKey(samekey)) {
                accountInfo = (CollectionAccountCoreBaseInfo)accountMap.get(samekey);
                accountInfo.put("amountOri", accountInfo.getBigDecimal("amountOri").add(newAccountEntry.getAmountOri()));
                accountInfo.put("amount", accountInfo.getBigDecimal("amount").add(newAccountEntry.getAmount()));
                continue;
            }
            accountMap.put(samekey, newAccountEntry);
            payerList.add(payerName);
            addAccountCollection.addObject((IObjectValue)newAccountEntry);
        }
        if (addAccountCollection.size() > 0) {
            BizBillUtil.getDefaultSupplier(ctx, baseInfo, addAccountCollection, payerList);
            if (collectionEntries != null && collectionEntries.size() > 0) {
                HashMap<String, CollectionAccountCoreBaseInfo> addAccountCollMap = new HashMap<String, CollectionAccountCoreBaseInfo>();
                for (int i = addAccountCollection.size() - 1; i >= 0; --i) {
                    accountInfo = (CollectionAccountCoreBaseInfo)addAccountCollection.get(i);
                    payerName = accountInfo.getString("payerName");
                    payerAccount = accountInfo.getString("payerAccount") != null ? accountInfo.getString("payerAccount") : "";
                    currencyTypeId = accountInfo.getObjectValue("currencyType") != null ? accountInfo.getObjectValue("currencyType").getString("id") : "";
                    payerType = accountInfo.getString("payerType");
                    samekey = payerName + payerAccount + currencyTypeId + payerType;
                    addAccountCollMap.put(samekey, accountInfo);
                }
                CollectionAccountCoreBaseInfo billAccountInfo = null;
                int size2 = collectionEntries.size();
                for (int i = 0; i < size2; ++i) {
                    billAccountInfo = (CollectionAccountCoreBaseInfo)collectionEntries.getObject(i);
                    payerName = billAccountInfo.getPayerName() != null ? billAccountInfo.getPayerName() : "";
                    payerAccount = billAccountInfo.getPayerAccount() != null ? billAccountInfo.getPayerAccount() : "";
                    currencyTypeId = billAccountInfo.getCurrencyType() != null ? billAccountInfo.getCurrencyType().getId().toString() : "";
                    payerType = billAccountInfo.get("payerType") != null ? String.valueOf(billAccountInfo.get("payerType")) : "";
                    samekey = payerName + payerAccount + currencyTypeId + payerType;
                    accountInfo = (CollectionAccountCoreBaseInfo)addAccountCollMap.get(samekey);
                    if (accountInfo == null) continue;
                    billAccountInfo.setAmountOri(billAccountInfo.getAmountOri().add(accountInfo.getBigDecimal("amountOri")));
                    billAccountInfo.setAmount(billAccountInfo.getAmount().add(accountInfo.getBigDecimal("amount")));
                    addAccountCollection.removeObject((IObjectValue)accountInfo);
                    updateAccountCollection.addObject((IObjectValue)billAccountInfo);
                    addAccountCollMap.remove(samekey);
                }
            }
        }
        resultMap.put("addAccountCollection", addAccountCollection);
        resultMap.put("updateAccountCollection", updateAccountCollection);
        return resultMap;
    }

    public Map invoiceCloudChangeInvoiceEntryByBiz(Context ctx, JSONArray ticketDataArr, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        TicketEntryCollection bizTicketEntries = new TicketEntryCollection();
        String entryId = (String)spareMap.get("entryId");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        spareMap.remove("entryId");
        StringBuilder logbd = new StringBuilder("##\u5206\u5f55\u5bfc\u7968 number=" + baseInfo.getNumber() + ",CP03910=" + isUseDeduction + ",\u5206\u5f55id" + entryId);
        if (ticketDataArr.size() > 0) {
            logbd.append(",\u53d1\u7968\u53f7\u7801,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        BizAccountBillEntryCollection entries = (BizAccountBillEntryCollection)((Object)baseInfo.get("entries"));
        BizAccountBillEntryInfo entryInfo = (BizAccountBillEntryInfo)entries.getObject(BOSUuid.read((String)entryId));
        entries.clear();
        entries.addObject((IObjectValue)entryInfo);
        BigDecimal totalAmountWithoutTax = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        HashSet<BigDecimal> taxRateSet = new HashSet<BigDecimal>(10);
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        ArrayList<String> enTicNumberList = new ArrayList<String>(20);
        Map<String, Object> entryLinkSerialNo = InvoiceUtil.getEntryLinkSerialNo(baseInfo, entryId, spareMap);
        HashSet linkSer = (HashSet)entryLinkSerialNo.get("entryLinkSerialNo");
        serialNoSet.addAll(linkSer);
        String entryTicNumber = entryInfo.getString("entryTicNumber");
        if (entryTicNumber != null) {
            String[] items = entryTicNumber.split(",");
            enTicNumberList.addAll(Lists.newArrayList(Arrays.asList(items)));
        }
        int iSize = ticketDataArr.size();
        for (int i = 0; i < iSize; ++i) {
            TicketEntryInfo ticketEntry = new TicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
            ticketEntry.setId(entryBosId);
            InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
            boolean isDeduction = false;
            BigDecimal teAmount = BizCollUtil.ZERO;
            BigDecimal teTaxAmount = BizCollUtil.ZERO;
            BigDecimal teDeductionTax = BizCollUtil.ZERO;
            Boolean teDeduction = false;
            String teTaxClassNumber = "";
            JSONObject invoiceData = ticketDataArr.getJSONObject(i);
            String serialNo = invoiceData.getString("serialNo");
            serialNoSet.add(serialNo);
            String invoiceNumber = invoiceData.getString("invoiceNo");
            String invoiceType2 = invoiceData.getString("invoiceType");
            String invoiceCode = invoiceData.getString("invoiceCode");
            Date invoiceDate = invoiceData.getDate("invoiceDate");
            String checkStatus = invoiceData.getString("checkStatus");
            String salerName = invoiceData.getString("salerName");
            String taxClassNumber = "";
            if (StringUtils.isNotEmpty((CharSequence)invoiceNumber) && invoiceNumber.indexOf("-") == -1 && !enTicNumberList.contains(invoiceNumber)) {
                enTicNumberList.add(invoiceNumber);
            } else {
                enTicNumberList.add("-");
            }
            ticketEntry.setTicketTypeId(InvoiceUtil.getInvoiceTypeInfo(ctx, baseInfo, spareMap, invoiceType2));
            ticketEntry.setTicketCode(invoiceCode);
            ticketEntry.setTicketNumber(invoiceNumber);
            ticketEntry.setBillingDate(invoiceDate);
            ticketEntry.setSalerName(salerName);
            ticketEntry.setSerialNo(serialNo);
            ticketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
            ticketEntry.setIsElectronicInvoice(invoiceData.getBoolean("isElectronicInvoice"));
            JSONArray items = invoiceData.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsObject = items.getJSONObject(j);
                    BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                    BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                    taxClassNumber = jsObject.getString("goodsCode");
                    BigDecimal taxRate = jsObject.getBigDecimal("taxRate");
                    taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                    taxRateSet.add(taxRate);
                    itemTaxRateSet.add(taxRate);
                    totalAmountWithoutTax = totalAmountWithoutTax.add(detailAmount);
                    totalTaxAmount = totalTaxAmount.add(detailTaxAmount);
                    String cacheKey = invoiceType2 + taxClassNumber;
                    if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                        invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                    } else {
                        invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                        invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                    }
                    boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                    if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                        taxAmount = taxAmount.add(detailTaxAmount);
                    }
                    logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + detailTaxAmount + "," + taxRate);
                    if (isDeduction) {
                        teDeduction = isDeduction;
                        teTaxClassNumber = taxClassNumber;
                        teDeductionTax = teDeductionTax.add(detailTaxAmount);
                    }
                    teAmount = teAmount.add(detailAmount);
                    teTaxAmount = teTaxAmount.add(detailTaxAmount);
                }
                if (itemTaxRateSet.size() > 1) {
                    ticketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
                } else {
                    BigDecimal taxR = (BigDecimal)itemTaxRateSet.iterator().next();
                    ticketEntry.setTaxRate(taxR);
                }
            } else {
                BigDecimal taxRate = invoiceData.getBigDecimal("taxRate");
                taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                taxRateSet.add(taxRate);
                ticketEntry.setTaxRate(taxRate);
                BigDecimal ammount = BizCollUtil.ZERO;
                BigDecimal taaxAmount = BizCollUtil.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("amount"))) {
                    ammount = invoiceData.getBigDecimal("amount");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("taxAmount"))) {
                    taaxAmount = invoiceData.getBigDecimal("taxAmount");
                }
                totalAmountWithoutTax = totalAmountWithoutTax.add(ammount);
                totalTaxAmount = totalTaxAmount.add(taaxAmount);
                String cacheKey = invoiceType2 + taxClassNumber;
                if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                    invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                } else {
                    invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                    invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                }
                boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                    taxAmount = taxAmount.add(taaxAmount);
                }
                logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + taaxAmount + "," + taxRate);
                teAmount = teAmount.add(ammount);
                teTaxAmount = teTaxAmount.add(taaxAmount);
                if (isDeduction) {
                    teDeduction = isDeduction;
                    teDeductionTax = taaxAmount;
                }
            }
            ticketEntry.setAmout(teAmount.add(teTaxAmount));
            ticketEntry.setTax(teTaxAmount);
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
                if (StringUtils.isNotEmpty((CharSequence)teTaxClassNumber)) {
                    ticketEntry.setTaxClassNumber(teTaxClassNumber);
                } else {
                    ticketEntry.setTaxClassNumber(taxClassNumber);
                }
            }
            ticketEntry.setIsDeduction(teDeduction);
            if (ticketEntry.isIsDeduction()) {
                ticketEntry.setDeductionTax(teDeductionTax);
            } else {
                ticketEntry.setDeductionTax(BizCollUtil.ZERO);
            }
            bizTicketEntries.add(ticketEntry);
        }
        BigDecimal totalAmount = totalAmountWithoutTax.add(totalTaxAmount).setScale(2, 4);
        totalAmountWithoutTax = totalAmount.subtract(taxAmount);
        BigDecimal entryAmountOri = BizCollUtil.ZERO;
        BigDecimal entryAmountOriWithoutTax = BizCollUtil.ZERO;
        BigDecimal entryTax = BizCollUtil.ZERO;
        if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo()) && linkSer.size() > 0) {
            AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
            String serialNo = null;
            CoreBillEntryBaseInfo ticket = null;
            Iterator ticketEnIterator = ticketEntries.iterator();
            BigDecimal ticEnAmount = BizCollUtil.ZERO;
            BigDecimal ticEnTax = BizCollUtil.ZERO;
            BigDecimal ticEnAmountWithoutTax = BizCollUtil.ZERO;
            while (ticketEnIterator.hasNext()) {
                ticket = (CoreBillEntryBaseInfo)ticketEnIterator.next();
                serialNo = (String)ticket.get("serialNo");
                if (!linkSer.contains(serialNo)) continue;
                BigDecimal amout = ticket.getBigDecimal("amout");
                BigDecimal tax = ticket.getBigDecimal("tax");
                BigDecimal taxRate = ticket.getBigDecimal("taxRate").setScale(2, 4);
                BigDecimal amountWithoutTax = amout.subtract(tax);
                ticEnAmount = ticEnAmount.add(amout);
                ticEnAmountWithoutTax = ticEnAmountWithoutTax.add(amountWithoutTax);
                ticEnTax = ticEnTax.add(tax);
                taxRateSet.add(taxRate);
            }
            entryAmountOri = ticEnAmount.add(totalAmount);
            entryAmountOriWithoutTax = ticEnAmountWithoutTax.add(totalAmountWithoutTax);
            entryTax = ticEnTax.add(taxAmount);
        } else if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo())) {
            entryAmountOri = totalAmount;
            entryAmountOriWithoutTax = totalAmountWithoutTax;
            entryTax = taxAmount;
        } else {
            entryAmountOri = entryInfo.getAmountOri().add(totalAmount);
            entryAmountOriWithoutTax = entryInfo.getAmountOriWithoutTax().add(totalAmountWithoutTax);
            entryTax = entryInfo.getTax().add(taxAmount);
            BigDecimal taxRate = entryInfo.getTaxRate().setScale(2, 4);
            taxRateSet.add(taxRate);
        }
        BigDecimal entryExRate = entryInfo.getExchangeRate();
        BigDecimal entryAmount = BizCollUtil.ZERO;
        BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
        if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
            if (entryInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
            } else {
                entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
            }
        }
        entryInfo.setAmountOri(entryAmountOri);
        entryInfo.setAmountOriWithoutTax(entryAmountOriWithoutTax);
        entryInfo.setAmount(entryAmount);
        entryInfo.setAmountWithoutTax(entryAmountWithoutTax);
        entryInfo.setTax(entryTax);
        if (taxRateSet.size() == 1) {
            BigDecimal taxR = (BigDecimal)taxRateSet.iterator().next();
            entryInfo.setBigDecimal("taxRate", taxR);
        }
        if (entryTax.compareTo(BizCollUtil.ZERO) == 0 || taxRateSet.size() > 1) {
            entryInfo.setBigDecimal("taxRate", BizCollUtil.ZERO);
        }
        logbd.append(",\u603b\u7a0e\u989d=" + entryTax);
        logbd.append(",\u603b\u7a0e\u7387=" + entryInfo.get("taxRate"));
        entryInfo.setTicketUrl(entryInfo.getId().toString());
        entryInfo.setString("entryTicNumber", StringUtils.join((Object[])enTicNumberList.toArray(), (String)","));
        entryInfo.setString("invoiceNum", ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + serialNoSet.size() + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
        entryInfo.setString("entrySerialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        logger.info((Object)logbd);
        HashMap<String, TicketEntryCollection> changeInvoiceAndEntryMap = new HashMap<String, TicketEntryCollection>();
        changeInvoiceAndEntryMap.put("bizInvoiceAndEntry", bizTicketEntries);
        return changeInvoiceAndEntryMap;
    }

    public Map invoiceCloudChangeInvoiceEntryByBizOut(Context ctx, JSONArray ticketDataArr, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        BizOutTicketEntryCollection bizOutTicketEntries = new BizOutTicketEntryCollection();
        String entryId = (String)spareMap.get("entryId");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        spareMap.remove("entryId");
        StringBuilder logbd = new StringBuilder("##\u5206\u5f55\u5bfc\u7968 number=" + baseInfo.getNumber() + ",CP03910=" + isUseDeduction + ",\u5206\u5f55id" + entryId);
        if (ticketDataArr.size() > 0) {
            logbd.append(",\u53d1\u7968\u53f7\u7801,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        BizAccountOutBillEntryCollection entries = (BizAccountOutBillEntryCollection)((Object)baseInfo.get("entries"));
        BizAccountOutBillEntryInfo entryInfo = (BizAccountOutBillEntryInfo)entries.getObject(BOSUuid.read((String)entryId));
        entries.clear();
        entries.addObject((IObjectValue)entryInfo);
        BigDecimal totalAmountWithoutTax = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        HashSet<BigDecimal> taxRateSet = new HashSet<BigDecimal>(10);
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        ArrayList<String> enTicNumberList = new ArrayList<String>(20);
        Map<String, Object> entryLinkSerialNo = InvoiceUtil.getEntryLinkSerialNo(baseInfo, entryId, spareMap);
        HashSet linkSer = (HashSet)entryLinkSerialNo.get("entryLinkSerialNo");
        serialNoSet.addAll(linkSer);
        String entryTicNumber = entryInfo.getString("entryTicNumber");
        if (entryTicNumber != null) {
            String[] items = entryTicNumber.split(",");
            enTicNumberList.addAll(Lists.newArrayList(Arrays.asList(items)));
        }
        int iSize = ticketDataArr.size();
        for (int i = 0; i < iSize; ++i) {
            BizOutTicketEntryInfo ticketEntry = new BizOutTicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
            ticketEntry.setId(entryBosId);
            InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
            boolean isDeduction = false;
            BigDecimal teAmount = BizCollUtil.ZERO;
            BigDecimal teTaxAmount = BizCollUtil.ZERO;
            BigDecimal teDeductionTax = BizCollUtil.ZERO;
            Boolean teDeduction = false;
            String teTaxClassNumber = "";
            JSONObject invoiceData = ticketDataArr.getJSONObject(i);
            String serialNo = invoiceData.getString("serialNo");
            serialNoSet.add(serialNo);
            String invoiceNumber = invoiceData.getString("invoiceNo");
            String invoiceType2 = invoiceData.getString("invoiceType");
            String invoiceCode = invoiceData.getString("invoiceCode");
            Date invoiceDate = invoiceData.getDate("invoiceDate");
            String checkStatus = invoiceData.getString("checkStatus");
            String salerName = invoiceData.getString("salerName");
            String taxClassNumber = "";
            if (StringUtils.isNotEmpty((CharSequence)invoiceNumber) && invoiceNumber.indexOf("-") == -1 && !enTicNumberList.contains(invoiceNumber)) {
                enTicNumberList.add(invoiceNumber);
            } else {
                enTicNumberList.add("-");
            }
            ticketEntry.setTicketTypeId(InvoiceUtil.getInvoiceTypeInfo(ctx, baseInfo, spareMap, invoiceType2));
            ticketEntry.setTicketCode(invoiceCode);
            ticketEntry.setTicketNumber(invoiceNumber);
            ticketEntry.setBillingDate(invoiceDate);
            ticketEntry.setSalerName(salerName);
            ticketEntry.setSerialNo(serialNo);
            ticketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
            ticketEntry.setIsElectronicInvoice(invoiceData.getBoolean("isElectronicInvoice"));
            JSONArray items = invoiceData.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsObject = items.getJSONObject(j);
                    BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                    BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                    taxClassNumber = jsObject.getString("goodsCode");
                    BigDecimal taxRate = jsObject.getBigDecimal("taxRate");
                    taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                    taxRateSet.add(taxRate);
                    itemTaxRateSet.add(taxRate);
                    totalAmountWithoutTax = totalAmountWithoutTax.add(detailAmount);
                    totalTaxAmount = totalTaxAmount.add(detailTaxAmount);
                    String cacheKey = invoiceType2 + taxClassNumber;
                    if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                        invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                    } else {
                        invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                        invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                    }
                    boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                    if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                        taxAmount = taxAmount.add(detailTaxAmount);
                    }
                    logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + detailTaxAmount + "," + taxRate);
                    if (isDeduction) {
                        teDeduction = isDeduction;
                        teTaxClassNumber = taxClassNumber;
                        teDeductionTax = teDeductionTax.add(detailTaxAmount);
                    }
                    teAmount = teAmount.add(detailAmount);
                    teTaxAmount = teTaxAmount.add(detailTaxAmount);
                }
                if (itemTaxRateSet.size() > 1) {
                    ticketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
                } else {
                    BigDecimal taxR = (BigDecimal)itemTaxRateSet.iterator().next();
                    ticketEntry.setTaxRate(taxR);
                }
            } else {
                BigDecimal taxRate = invoiceData.getBigDecimal("taxRate");
                taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                taxRateSet.add(taxRate);
                ticketEntry.setTaxRate(taxRate);
                BigDecimal ammount = BizCollUtil.ZERO;
                BigDecimal taaxAmount = BizCollUtil.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("amount"))) {
                    ammount = invoiceData.getBigDecimal("amount");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("taxAmount"))) {
                    taaxAmount = invoiceData.getBigDecimal("taxAmount");
                }
                totalAmountWithoutTax = totalAmountWithoutTax.add(ammount);
                totalTaxAmount = totalTaxAmount.add(taaxAmount);
                String cacheKey = invoiceType2 + taxClassNumber;
                if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                    invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                } else {
                    invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                    invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                }
                boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                    taxAmount = taxAmount.add(taaxAmount);
                }
                logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + taaxAmount + "," + taxRate);
                teAmount = teAmount.add(ammount);
                teTaxAmount = teTaxAmount.add(taaxAmount);
                if (isDeduction) {
                    teDeduction = isDeduction;
                    teDeductionTax = taaxAmount;
                }
            }
            ticketEntry.setAmout(teAmount.add(teTaxAmount));
            ticketEntry.setTax(teTaxAmount);
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
                if (StringUtils.isNotEmpty((CharSequence)teTaxClassNumber)) {
                    ticketEntry.setTaxClassNumber(teTaxClassNumber);
                } else {
                    ticketEntry.setTaxClassNumber(taxClassNumber);
                }
            }
            ticketEntry.setIsDeduction(teDeduction);
            if (ticketEntry.isIsDeduction()) {
                ticketEntry.setDeductionTax(teDeductionTax);
            } else {
                ticketEntry.setDeductionTax(BizCollUtil.ZERO);
            }
            bizOutTicketEntries.add(ticketEntry);
        }
        BigDecimal totalAmount = totalAmountWithoutTax.add(totalTaxAmount).setScale(2, 4);
        totalAmountWithoutTax = totalAmount.subtract(taxAmount);
        BigDecimal entryAmountOri = BizCollUtil.ZERO;
        BigDecimal entryAmountOriWithoutTax = BizCollUtil.ZERO;
        BigDecimal entryTax = BizCollUtil.ZERO;
        if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo()) && linkSer.size() > 0) {
            AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
            String serialNo = null;
            CoreBillEntryBaseInfo ticket = null;
            Iterator ticketEnIterator = ticketEntries.iterator();
            BigDecimal ticEnAmount = BizCollUtil.ZERO;
            BigDecimal ticEnTax = BizCollUtil.ZERO;
            BigDecimal ticEnAmountWithoutTax = BizCollUtil.ZERO;
            while (ticketEnIterator.hasNext()) {
                ticket = (CoreBillEntryBaseInfo)ticketEnIterator.next();
                serialNo = (String)ticket.get("serialNo");
                if (!linkSer.contains(serialNo)) continue;
                BigDecimal amout = ticket.getBigDecimal("amout");
                BigDecimal tax = ticket.getBigDecimal("tax");
                BigDecimal taxRate = ticket.getBigDecimal("taxRate").setScale(2, 4);
                BigDecimal amountWithoutTax = amout.subtract(tax);
                ticEnAmount = ticEnAmount.add(amout);
                ticEnAmountWithoutTax = ticEnAmountWithoutTax.add(amountWithoutTax);
                ticEnTax = ticEnTax.add(tax);
                taxRateSet.add(taxRate);
            }
            entryAmountOri = ticEnAmount.add(totalAmount);
            entryAmountOriWithoutTax = ticEnAmountWithoutTax.add(totalAmountWithoutTax);
            entryTax = ticEnTax.add(taxAmount);
        } else if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo())) {
            entryAmountOri = totalAmount;
            entryAmountOriWithoutTax = totalAmountWithoutTax;
            entryTax = taxAmount;
        } else {
            entryAmountOri = entryInfo.getAmountOri().add(totalAmount);
            entryAmountOriWithoutTax = entryInfo.getAmountOriWithoutTax().add(totalAmountWithoutTax);
            entryTax = entryInfo.getTax().add(taxAmount);
            BigDecimal taxRate = entryInfo.getTaxRate().setScale(2, 4);
            taxRateSet.add(taxRate);
        }
        BigDecimal entryExRate = entryInfo.getExchangeRate();
        BigDecimal entryAmount = BizCollUtil.ZERO;
        BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
        if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
            if (entryInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
            } else {
                entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
            }
        }
        entryInfo.setAmountOri(entryAmountOri);
        entryInfo.setAmountOriWithoutTax(entryAmountOriWithoutTax);
        entryInfo.setAmount(entryAmount);
        entryInfo.setAmountWithoutTax(entryAmountWithoutTax);
        entryInfo.setTax(entryTax);
        if (taxRateSet.size() == 1) {
            BigDecimal taxR = (BigDecimal)taxRateSet.iterator().next();
            entryInfo.setBigDecimal("taxRate", taxR);
        }
        if (entryTax.compareTo(BizCollUtil.ZERO) == 0 || taxRateSet.size() > 1) {
            entryInfo.setBigDecimal("taxRate", BizCollUtil.ZERO);
        }
        logbd.append(",\u603b\u7a0e\u989d=" + entryTax);
        logbd.append(",\u603b\u7a0e\u7387=" + entryInfo.get("taxRate"));
        entryInfo.setTicketUrl(entryInfo.getId().toString());
        entryInfo.setString("entryTicNumber", StringUtils.join((Object[])enTicNumberList.toArray(), (String)","));
        entryInfo.setString("invoiceNum", ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + serialNoSet.size() + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
        entryInfo.setString("entrySerialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        logger.info((Object)logbd);
        HashMap<String, BizOutTicketEntryCollection> changeInvoiceAndEntryMap = new HashMap<String, BizOutTicketEntryCollection>();
        changeInvoiceAndEntryMap.put("bizOutInvoiceAndEntry", bizOutTicketEntries);
        return changeInvoiceAndEntryMap;
    }

    public Map invoiceCloudChangeInvoiceEntryByPur(Context ctx, JSONArray ticketDataArr, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        PurTicketEntryCollection purTicketEntries = new PurTicketEntryCollection();
        String entryId = (String)spareMap.get("entryId");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        spareMap.remove("entryId");
        StringBuilder logbd = new StringBuilder("##\u5206\u5f55\u5bfc\u7968 number=" + baseInfo.getNumber() + ",CP03910=" + isUseDeduction + ",\u5206\u5f55id" + entryId);
        if (ticketDataArr.size() > 0) {
            logbd.append(",\u53d1\u7968\u53f7\u7801,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d,\u7a0e\u7387\u4e3a\uff1a");
        }
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        DailyPurchaseAccountBillEntryCollection entries = (DailyPurchaseAccountBillEntryCollection)((Object)baseInfo.get("entries"));
        DailyPurchaseAccountBillEntryInfo entryInfo = (DailyPurchaseAccountBillEntryInfo)entries.getObject(BOSUuid.read((String)entryId));
        entries.clear();
        entries.addObject((IObjectValue)entryInfo);
        BigDecimal totalAmountWithoutTax = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        BigDecimal count = InvoiceUtil.AmountNotNull(entryInfo.getCount());
        HashSet<BigDecimal> taxRateSet = new HashSet<BigDecimal>(10);
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        ArrayList<String> enTicNumberList = new ArrayList<String>(20);
        Map<String, Object> entryLinkSerialNo = InvoiceUtil.getEntryLinkSerialNo(baseInfo, entryId, spareMap);
        HashSet linkSer = (HashSet)entryLinkSerialNo.get("entryLinkSerialNo");
        serialNoSet.addAll(linkSer);
        String entryTicNumber = entryInfo.getString("entryTicNumber");
        if (entryTicNumber != null) {
            String[] items = entryTicNumber.split(",");
            enTicNumberList.addAll(Lists.newArrayList(Arrays.asList(items)));
        }
        int iSize = ticketDataArr.size();
        for (int i = 0; i < iSize; ++i) {
            PurTicketEntryInfo purTicketEntry = new PurTicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)purTicketEntry.getBOSType());
            purTicketEntry.setId(entryBosId);
            InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)purTicketEntry, entryInfo);
            boolean isDeduction = false;
            BigDecimal teAmount = BizCollUtil.ZERO;
            BigDecimal teTaxAmount = BizCollUtil.ZERO;
            BigDecimal teDeductionTax = BizCollUtil.ZERO;
            Boolean teDeduction = false;
            String teTaxClassNumber = "";
            JSONObject invoiceData = ticketDataArr.getJSONObject(i);
            String serialNo = invoiceData.getString("serialNo");
            serialNoSet.add(serialNo);
            String invoiceNumber = invoiceData.getString("invoiceNo");
            String invoiceType2 = invoiceData.getString("invoiceType");
            String invoiceCode = invoiceData.getString("invoiceCode");
            Date invoiceDate = invoiceData.getDate("invoiceDate");
            String checkStatus = invoiceData.getString("checkStatus");
            String salerName = invoiceData.getString("salerName");
            String taxClassNumber = "";
            if (StringUtils.isNotEmpty((CharSequence)invoiceNumber) && invoiceNumber.indexOf("-") == -1 && !enTicNumberList.contains(invoiceNumber)) {
                enTicNumberList.add(invoiceNumber);
            } else {
                enTicNumberList.add("-");
            }
            purTicketEntry.setTicketTypeId(InvoiceUtil.getInvoiceTypeInfo(ctx, baseInfo, spareMap, invoiceType2));
            purTicketEntry.setTicketCode(invoiceCode);
            purTicketEntry.setTicketNumber(invoiceNumber);
            purTicketEntry.setBillingDate(invoiceDate);
            purTicketEntry.setSalerName(salerName);
            purTicketEntry.setSerialNo(serialNo);
            purTicketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
            purTicketEntry.setIsElectronicInvoice(invoiceData.getBoolean("isElectronicInvoice"));
            JSONArray items = invoiceData.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsObject = items.getJSONObject(j);
                    BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                    BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                    BigDecimal numItems = jsObject.getBigDecimal("num") == null ? BizCollUtil.ZERO : jsObject.getBigDecimal("num");
                    taxClassNumber = jsObject.getString("goodsCode");
                    count = count.add(numItems);
                    BigDecimal taxRate = jsObject.getBigDecimal("taxRate");
                    taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                    taxRateSet.add(taxRate);
                    itemTaxRateSet.add(taxRate);
                    totalAmountWithoutTax = totalAmountWithoutTax.add(detailAmount);
                    totalTaxAmount = totalTaxAmount.add(detailTaxAmount);
                    String cacheKey = invoiceType2 + taxClassNumber;
                    if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                        invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                    } else {
                        invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                        invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                    }
                    boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                    if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                        taxAmount = taxAmount.add(detailTaxAmount);
                    }
                    logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + detailTaxAmount + "," + taxRate);
                    if (isDeduction) {
                        teDeduction = isDeduction;
                        teTaxClassNumber = taxClassNumber;
                        teDeductionTax = teDeductionTax.add(detailTaxAmount);
                    }
                    teAmount = teAmount.add(detailAmount);
                    teTaxAmount = teTaxAmount.add(detailTaxAmount);
                }
                if (itemTaxRateSet.size() > 1) {
                    purTicketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
                } else {
                    BigDecimal taxR = (BigDecimal)itemTaxRateSet.iterator().next();
                    purTicketEntry.setTaxRate(taxR);
                }
            } else {
                BigDecimal num = invoiceData.getBigDecimal("num") == null ? BizCollUtil.ZERO : invoiceData.getBigDecimal("num");
                count = count.add(num);
                BigDecimal taxRate = invoiceData.getBigDecimal("taxRate");
                taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                taxRateSet.add(taxRate);
                purTicketEntry.setTaxRate(taxRate);
                BigDecimal ammount = BizCollUtil.ZERO;
                BigDecimal taaxAmount = BizCollUtil.ZERO;
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("amount"))) {
                    ammount = invoiceData.getBigDecimal("amount");
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceData.getString("taxAmount"))) {
                    taaxAmount = invoiceData.getBigDecimal("taxAmount");
                }
                totalAmountWithoutTax = totalAmountWithoutTax.add(ammount);
                totalTaxAmount = totalTaxAmount.add(taaxAmount);
                String cacheKey = invoiceType2 + taxClassNumber;
                if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                    invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                } else {
                    invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                    invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                }
                boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                    taxAmount = taxAmount.add(taaxAmount);
                }
                logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + taaxAmount + "," + taxRate);
                teAmount = teAmount.add(ammount);
                teTaxAmount = teTaxAmount.add(taaxAmount);
                if (isDeduction) {
                    teDeduction = isDeduction;
                    teDeductionTax = taaxAmount;
                }
            }
            purTicketEntry.setAmout(teAmount.add(teTaxAmount));
            purTicketEntry.setTax(teTaxAmount);
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
                if (StringUtils.isNotEmpty((CharSequence)teTaxClassNumber)) {
                    purTicketEntry.setTaxClassNumber(teTaxClassNumber);
                } else {
                    purTicketEntry.setTaxClassNumber(taxClassNumber);
                }
            }
            purTicketEntry.setIsDeduction(teDeduction);
            if (purTicketEntry.isIsDeduction()) {
                purTicketEntry.setDeductionTax(teDeductionTax);
            } else {
                purTicketEntry.setDeductionTax(BizCollUtil.ZERO);
            }
            purTicketEntries.add(purTicketEntry);
        }
        BigDecimal totalAmount = totalAmountWithoutTax.add(totalTaxAmount).setScale(2, 4);
        totalAmountWithoutTax = totalAmount.subtract(taxAmount);
        BigDecimal entryAmountOri = BizCollUtil.ZERO;
        BigDecimal entryAmountOriWithoutTax = BizCollUtil.ZERO;
        BigDecimal entryTax = BizCollUtil.ZERO;
        if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo()) && linkSer.size() > 0) {
            AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
            String serialNo = null;
            CoreBillEntryBaseInfo ticket2 = null;
            BigDecimal ticEnAmount = BizCollUtil.ZERO;
            BigDecimal ticEnTax = BizCollUtil.ZERO;
            BigDecimal ticEnAmountWithoutTax = BizCollUtil.ZERO;
            for (CoreBillEntryBaseInfo ticket2 : ticketEntries) {
                serialNo = (String)ticket2.get("serialNo");
                if (!linkSer.contains(serialNo)) continue;
                BigDecimal amout = ticket2.getBigDecimal("amout");
                BigDecimal tax = ticket2.getBigDecimal("tax");
                BigDecimal taxRate = ticket2.getBigDecimal("taxRate").setScale(2, 4);
                BigDecimal amountWithoutTax = amout.subtract(tax);
                ticEnAmount = ticEnAmount.add(amout);
                ticEnAmountWithoutTax = ticEnAmountWithoutTax.add(amountWithoutTax);
                ticEnTax = ticEnTax.add(tax);
                taxRateSet.add(taxRate);
            }
            entryAmountOri = ticEnAmount.add(totalAmount);
            entryAmountOriWithoutTax = ticEnAmountWithoutTax.add(totalAmountWithoutTax);
            entryTax = ticEnTax.add(taxAmount);
        } else if (StringUtils.isBlank((CharSequence)entryInfo.getEntrySerialNo())) {
            entryAmountOri = totalAmount;
            entryAmountOriWithoutTax = totalAmountWithoutTax;
            entryTax = taxAmount;
        } else {
            entryAmountOri = entryInfo.getAmountOri().add(totalAmount);
            entryAmountOriWithoutTax = entryInfo.getAmountOriWithoutTax().add(totalAmountWithoutTax);
            entryTax = entryInfo.getTax().add(taxAmount);
            BigDecimal taxRate = entryInfo.getTaxRate().setScale(2, 4);
            taxRateSet.add(taxRate);
        }
        BigDecimal entryExRate = entryInfo.getExchangeRate();
        BigDecimal entryAmount = BizCollUtil.ZERO;
        BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
        if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
            if (entryInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
            } else {
                entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
            }
        }
        entryInfo.setAmountOri(entryAmountOri);
        entryInfo.setAmountOriWithoutTax(entryAmountOriWithoutTax);
        entryInfo.setAmount(entryAmount);
        entryInfo.setAmountWithoutTax(entryAmountWithoutTax);
        entryInfo.setTax(entryTax);
        if (taxRateSet.size() == 1) {
            BigDecimal taxR = (BigDecimal)taxRateSet.iterator().next();
            entryInfo.setBigDecimal("taxRate", taxR);
        }
        if (entryTax.compareTo(BizCollUtil.ZERO) == 0 || taxRateSet.size() > 1) {
            entryInfo.setBigDecimal("taxRate", BizCollUtil.ZERO);
        }
        logbd.append(",\u603b\u7a0e\u989d=" + entryTax);
        logbd.append(",\u603b\u7a0e\u7387=" + entryInfo.get("taxRate"));
        InvoiceUtil.buildPurEntryPriceAndCount(entryInfo, count);
        entryInfo.setTicketUrl(entryInfo.getId().toString());
        entryInfo.setString("entryTicNumber", StringUtils.join((Object[])enTicNumberList.toArray(), (String)","));
        entryInfo.setString("invoiceNum", ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + serialNoSet.size() + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
        entryInfo.setString("entrySerialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        logger.info((Object)logbd);
        HashMap<String, PurTicketEntryCollection> changeInvoiceAndEntryMap = new HashMap<String, PurTicketEntryCollection>();
        changeInvoiceAndEntryMap.put("purInvoiceAndEntry", purTicketEntries);
        return changeInvoiceAndEntryMap;
    }

    public Map invoiceCloudChangeInvoiceEntryByTra(Context ctx, JSONArray ticketDataArr, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        TraTicketEntryCollection traTicketEntries = new TraTicketEntryCollection();
        VATInvoiceTraEntryCollection traVatCollection = new VATInvoiceTraEntryCollection();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String entryId = (String)spareMap.get("entryId");
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        spareMap.remove("entryId");
        StringBuilder logbd = new StringBuilder("##\u5206\u5f55\u5bfc\u7968 number=" + baseInfo.getNumber() + ",CP03910=" + isUseDeduction + ",\u5206\u5f55id" + entryId);
        if (ticketDataArr.size() > 0) {
            logbd.append(",\u53d1\u7968\u53f7\u7801,\u7a0e\u6536\u7f16\u7801,\u662f\u5426\u62b5\u6263,\u7a0e\u989d\u4e3a\uff1a");
        }
        HashMap<String, InvoiceTypeEntryInfo> invoiceTypeEntryCacheMap = new HashMap<String, InvoiceTypeEntryInfo>();
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        TravelAccountBillEntryCollection entries = (TravelAccountBillEntryCollection)((Object)baseInfo.get("entries"));
        TravelAccountBillEntryInfo entryInfo = entries.get(BOSUuid.read((String)entryId));
        entries.clear();
        entries.addObject((IObjectValue)entryInfo);
        BigDecimal totalAmountWithoutTax = BizCollUtil.ZERO;
        BigDecimal totalTaxAmount = BizCollUtil.ZERO;
        BigDecimal totalDeTaxAmount = BizCollUtil.ZERO;
        BigDecimal totalInsurancePremium = BizCollUtil.ZERO;
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        ArrayList<String> enTicNumberList = new ArrayList<String>(20);
        HashMap<String, Map<String, BigDecimal>> costTypeAmount = new HashMap<String, Map<String, BigDecimal>>(20);
        List<String> vatList = this.getVatList(baseInfo);
        Map<String, Object> entryLinkSerialNo = InvoiceUtil.getEntryLinkSerialNo(baseInfo, entryId, spareMap);
        HashSet linkSer = (HashSet)entryLinkSerialNo.get("entryLinkSerialNo");
        serialNoSet.addAll(linkSer);
        String entryTicNumber = entryInfo.getString("entryTicNumber");
        if (entryTicNumber != null) {
            String[] items = entryTicNumber.split(",");
            enTicNumberList.addAll(Lists.newArrayList(Arrays.asList(items)));
        }
        int iSize = ticketDataArr.size();
        for (int i = 0; i < iSize; ++i) {
            Map<String, BigDecimal> amountMap;
            TraTicketEntryInfo ticketEntry = new TraTicketEntryInfo();
            BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
            ticketEntry.setId(entryBosId);
            InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
            boolean isDeduction = false;
            BigDecimal teAmount = BizCollUtil.ZERO;
            BigDecimal teTaxAmount = BizCollUtil.ZERO;
            BigDecimal teDeductionTax = BizCollUtil.ZERO;
            Boolean teDeduction = false;
            String teTaxClassNumber = "";
            BigDecimal ammount = BizCollUtil.ZERO;
            BigDecimal taaxAmount = BizCollUtil.ZERO;
            BigDecimal taxAmount = BizCollUtil.ZERO;
            HashSet<BigDecimal> taxRateSet = new HashSet<BigDecimal>(10);
            JSONObject invoiceData = ticketDataArr.getJSONObject(i);
            String serialNo = invoiceData.getString("serialNo");
            serialNoSet.add(serialNo);
            String invoiceNumber = invoiceData.getString("invoiceNo");
            String invoiceType2 = invoiceData.getString("invoiceType");
            String invoiceCode = invoiceData.getString("invoiceCode");
            Date invoiceDate = invoiceData.getDate("invoiceDate");
            String checkStatus = invoiceData.getString("checkStatus");
            String salerName = invoiceData.getString("salerName");
            String costType = invoiceData.getString("costType");
            String passengerName = InvoiceUtil.nullToK(invoiceData.getString("passengerName"));
            String seatGrade = InvoiceUtil.nullToK(invoiceData.getString("seatGrade"));
            String placeOfDeparture = InvoiceUtil.nullToK(invoiceData.getString("stationGetOn"));
            String destination = InvoiceUtil.nullToK(invoiceData.getString("stationGetOff"));
            if ("10".equals(invoiceType2)) {
                seatGrade = InvoiceUtil.nullToK(invoiceData.getString("seatGradeName"));
                placeOfDeparture = InvoiceUtil.nullToK(invoiceData.getString("placeOfDeparture"));
                destination = InvoiceUtil.nullToK(invoiceData.getString("destination"));
            }
            BigDecimal cadFund = InvoiceUtil.AmountNotNull(invoiceData.getBigDecimal("airportConstructionFee"));
            BigDecimal insurancePremium = InvoiceUtil.AmountNotNull(invoiceData.getBigDecimal("insurancePremium"));
            totalInsurancePremium = totalInsurancePremium.add(insurancePremium);
            String taxClassNumber = "";
            if (StringUtils.isNotEmpty((CharSequence)invoiceNumber) && invoiceNumber.indexOf("-") == -1 && !enTicNumberList.contains(invoiceNumber)) {
                enTicNumberList.add(invoiceNumber);
            } else {
                enTicNumberList.add("-");
            }
            if (StringUtils.isEmpty((CharSequence)entryInfo.getFrom())) {
                entryInfo.setFrom(placeOfDeparture);
            }
            if (StringUtils.isEmpty((CharSequence)entryInfo.getTo())) {
                entryInfo.setTo(destination);
            }
            try {
                if (entryInfo.getStartDate() == null && StringUtils.isNotEmpty((CharSequence)invoiceData.getString("invoiceDate"))) {
                    entryInfo.setStartDate(sdf.parse(invoiceData.getString("invoiceDate")));
                }
                if (entryInfo.getEndDate() == null && StringUtils.isNotEmpty((CharSequence)invoiceData.getString("invoiceDate"))) {
                    entryInfo.setEndDate(sdf.parse(invoiceData.getString("invoiceDate")));
                }
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ticketEntry.setTicketTypeId(InvoiceUtil.getInvoiceTypeInfo(ctx, baseInfo, spareMap, invoiceType2));
            ticketEntry.setTicketCode(invoiceCode);
            ticketEntry.setTicketNumber(invoiceNumber);
            ticketEntry.setBillingDate(invoiceDate);
            ticketEntry.setSalerName(salerName);
            ticketEntry.setSerialNo(serialNo);
            ticketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
            ticketEntry.setPassengerName(passengerName);
            ticketEntry.setSeatClass(seatGrade);
            ticketEntry.setPlaceOfDeparture(placeOfDeparture);
            ticketEntry.setDestination(destination);
            ticketEntry.setIsElectronicInvoice(invoiceData.getBoolean("isElectronicInvoice"));
            ticketEntry.setInsurancePremium(insurancePremium);
            JSONArray items = invoiceData.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsObject = items.getJSONObject(j);
                    BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                    BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                    taxClassNumber = jsObject.getString("goodsCode");
                    BigDecimal taxRate = jsObject.getBigDecimal("taxRate");
                    taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                    itemTaxRateSet.add(taxRate);
                    ammount = ammount.add(detailAmount);
                    totalAmountWithoutTax = totalAmountWithoutTax.add(detailAmount);
                    totalTaxAmount = totalTaxAmount.add(detailTaxAmount);
                    taaxAmount = taaxAmount.add(detailTaxAmount);
                    String cacheKey = invoiceType2 + taxClassNumber;
                    if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                        invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                    } else {
                        invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                        invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                    }
                    boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                    if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                        taxAmount = taxAmount.add(detailTaxAmount);
                    }
                    logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + detailTaxAmount + "," + taxRate);
                    totalDeTaxAmount = totalDeTaxAmount.add(taxAmount);
                    if (isDeduction) {
                        teDeduction = isDeduction;
                        teTaxClassNumber = taxClassNumber;
                        teDeductionTax = teDeductionTax.add(detailTaxAmount);
                    }
                    teAmount = teAmount.add(detailAmount);
                    teTaxAmount = teTaxAmount.add(detailTaxAmount);
                }
                if (itemTaxRateSet.size() > 1) {
                    ticketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
                    taxRateSet.add(BizCollUtil.ZERO);
                } else {
                    BigDecimal taxR = (BigDecimal)itemTaxRateSet.iterator().next();
                    ticketEntry.setTaxRate(taxR);
                    taxRateSet.add(taxR);
                }
            } else {
                BigDecimal taxRate = invoiceData.getBigDecimal("taxRate");
                taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
                taxRateSet.add(taxRate);
                ticketEntry.setTaxRate(taxRate);
                ammount = invoiceData.getBigDecimal("amount") == null ? BizCollUtil.ZERO : invoiceData.getBigDecimal("amount");
                taaxAmount = invoiceData.getBigDecimal("taxAmount") == null ? BizCollUtil.ZERO : invoiceData.getBigDecimal("taxAmount");
                totalAmountWithoutTax = totalAmountWithoutTax.add(ammount);
                totalTaxAmount = totalTaxAmount.add(taaxAmount);
                String cacheKey = invoiceType2 + taxClassNumber;
                if (invoiceTypeEntryCacheMap.get(cacheKey) != null) {
                    invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)invoiceTypeEntryCacheMap.get(cacheKey);
                } else {
                    invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, invoiceType2, taxClassNumber, spareMap);
                    invoiceTypeEntryCacheMap.put(cacheKey, invoiceTypeEntryInfo);
                }
                boolean bl = isDeduction = invoiceTypeEntryInfo != null ? invoiceTypeEntryInfo.isIsDeduction() : false;
                if (!isUseDeduction.booleanValue() || isUseDeduction.booleanValue() && isDeduction) {
                    taxAmount = taxAmount.add(taaxAmount);
                }
                logbd.append(";" + (StringUtils.isNotEmpty((CharSequence)invoiceNumber) ? invoiceNumber : serialNo) + "," + taxClassNumber + "," + isDeduction + "," + taaxAmount + "," + taxRate);
                totalDeTaxAmount = totalDeTaxAmount.add(taxAmount);
                teAmount = teAmount.add(ammount);
                teTaxAmount = teTaxAmount.add(taaxAmount);
                if (isDeduction) {
                    teDeduction = isDeduction;
                    teDeductionTax = taaxAmount;
                }
            }
            if (costTypeAmount.containsKey(costType)) {
                amountMap = (Map)costTypeAmount.get(costType);
                BigDecimal amountWithOutTax = (BigDecimal)amountMap.get("amountWithOutTax");
                BigDecimal amTax = (BigDecimal)amountMap.get("tax");
                BigDecimal amTaxAmount = (BigDecimal)amountMap.get("taxAmount");
                HashSet amTaxRateSet = (HashSet)amountMap.get("taxRate");
                BigDecimal amCadFund = InvoiceUtil.AmountNotNull(amountMap.get("cadFund"));
                BigDecimal amInsurancePremium = InvoiceUtil.AmountNotNull(amountMap.get("insurancePremium"));
                amountWithOutTax = amountWithOutTax.add(ammount);
                amTax = amTax.add(taaxAmount);
                amTaxRateSet.addAll(taxRateSet);
                amCadFund = amCadFund.add(cadFund);
                amTaxAmount = amTaxAmount.add(taxAmount);
                amInsurancePremium = amInsurancePremium.add(insurancePremium);
                amountMap.put("amountWithOutTax", amountWithOutTax);
                amountMap.put("tax", amTax);
                amountMap.put("taxAmount", amTaxAmount);
                amountMap.put("taxRate", (BigDecimal)((Object)amTaxRateSet));
                amountMap.put("cadFund", amCadFund);
                amountMap.put("insurancePremium", amInsurancePremium);
            } else {
                amountMap = new HashMap();
                amountMap.put("amountWithOutTax", ammount);
                amountMap.put("tax", taaxAmount);
                amountMap.put("taxAmount", taxAmount);
                amountMap.put("taxRate", (BigDecimal)((Object)taxRateSet));
                amountMap.put("cadFund", cadFund);
                amountMap.put("insurancePremium", insurancePremium);
                costTypeAmount.put(costType, amountMap);
            }
            ticketEntry.setAmout(teAmount.add(teTaxAmount));
            ticketEntry.setTax(teTaxAmount);
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
                if (StringUtils.isNotEmpty((CharSequence)teTaxClassNumber)) {
                    ticketEntry.setTaxClassNumber(teTaxClassNumber);
                } else {
                    ticketEntry.setTaxClassNumber(taxClassNumber);
                }
            }
            ticketEntry.setIsDeduction(teDeduction);
            if (ticketEntry.isIsDeduction()) {
                ticketEntry.setDeductionTax(teDeductionTax);
            } else {
                ticketEntry.setDeductionTax(BizCollUtil.ZERO);
            }
            traTicketEntries.add(ticketEntry);
            VATInvoiceTraEntryInfo vatInfo = new VATInvoiceTraEntryInfo();
            BOSUuid vatBosId = BOSUuid.create((BOSObjectType)vatInfo.getBOSType());
            vatInfo.setId(vatBosId);
            vatInfo.setCostType(costType);
            vatInfo.setSerialNo(serialNo);
            vatInfo.setAmout(ammount.add(taaxAmount));
            if (!isUseDeduction.booleanValue()) {
                vatInfo.setTax(taaxAmount);
            } else if (teDeduction.booleanValue()) {
                vatInfo.setTax(teDeductionTax);
            } else {
                vatInfo.setTax(BizCollUtil.ZERO);
            }
            vatInfo.put("bizEntryBill", entryInfo.getId().toString());
            vatInfo.put("ticketEntryBill", ticketEntry.getId().toString());
            vatInfo.setTicketTypeId(InvoiceUtil.getTicketTypeId(ctx, invoiceType2));
            vatInfo.setTaxClassNumber(taxClassNumber);
            vatInfo.setTicketNumber(invoiceNumber);
            vatInfo.setCadFund(cadFund);
            vatInfo.setInsurancePremium(insurancePremium);
            traVatCollection.add(vatInfo);
        }
        BigDecimal taxiExpenseTax = InvoiceUtil.AmountNotNull(entryInfo, "taxiExpenseTax");
        BigDecimal taxiExpenseWithoutTax = InvoiceUtil.AmountNotNull(entryInfo, "taxiExpenseWithoutTax");
        BigDecimal taxiExpenseTaxRate = InvoiceUtil.AmountNotNull(entryInfo, "taxiExpenseTaxRate");
        BigDecimal bussesExpenseTax = InvoiceUtil.AmountNotNull(entryInfo, "bussesExpenseTax");
        BigDecimal bussesExpenseWithoutTax = InvoiceUtil.AmountNotNull(entryInfo, "bussesExpenseWithoutTax");
        BigDecimal bussesExpenseTaxRate = InvoiceUtil.AmountNotNull(entryInfo, "bussesExpenseTaxRate");
        BigDecimal bussesCadFund = InvoiceUtil.AmountNotNull(entryInfo, "cadFund");
        BigDecimal hotelExpenseTax = InvoiceUtil.AmountNotNull(entryInfo, "tax");
        BigDecimal hotelExpenseWithoutTax = InvoiceUtil.AmountNotNull(entryInfo, "hotelExpenseWithoutTax");
        BigDecimal hotelExpenseTaxRate = InvoiceUtil.AmountNotNull(entryInfo, "taxRate");
        BigDecimal otherExpenseTax = InvoiceUtil.AmountNotNull(entryInfo, "otherExpenseTax");
        BigDecimal otherExpenseWithoutTax = InvoiceUtil.AmountNotNull(entryInfo, "otherExpenseWithoutTax");
        BigDecimal otherExpenseTaxRate = InvoiceUtil.AmountNotNull(entryInfo, "otherExpenseTaxRate");
        for (Map.Entry next : costTypeAmount.entrySet()) {
            String costType = (String)next.getKey();
            Map amountMap = (Map)next.getValue();
            BigDecimal amountWithOutTax = (BigDecimal)amountMap.get("amountWithOutTax");
            BigDecimal tax = (BigDecimal)amountMap.get("tax");
            BigDecimal taxDeAmount = (BigDecimal)amountMap.get("taxAmount");
            BigDecimal cadFund = InvoiceUtil.AmountNotNull(amountMap.get("cadFund"));
            Set taxRateSet = (Set)amountMap.get("taxRate");
            BigDecimal taxRate = BizCollUtil.ZERO;
            BigDecimal totalAmTax = BizCollUtil.ZERO;
            BigDecimal totalAmWithOutTax = BizCollUtil.ZERO;
            BigDecimal currentTotalAm = BizCollUtil.ZERO;
            if (taxRateSet.size() == 1) {
                BigDecimal taxR;
                taxRate = taxR = (BigDecimal)taxRateSet.iterator().next();
            }
            if ("city".equals(costType)) {
                currentTotalAm = amountWithOutTax.add(tax);
                totalAmTax = tax.add(taxiExpenseTax);
                totalAmWithOutTax = amountWithOutTax.add(taxiExpenseWithoutTax);
                entryInfo.setTaxiExpense(totalAmWithOutTax.add(totalAmTax));
                entryInfo.setTaxiExpenseTax(taxDeAmount.add(taxiExpenseTax));
                entryInfo.setTaxiExpenseWithoutTax(currentTotalAm.subtract(taxDeAmount).add(taxiExpenseWithoutTax));
                if (vatList.size() > 0 && vatList.contains(entryId + costType) && taxiExpenseTaxRate.compareTo(taxRate) != 0) {
                    entryInfo.setTaxiExpenseTaxRate(BizCollUtil.ZERO);
                } else {
                    entryInfo.setTaxiExpenseTaxRate(taxRate);
                }
                logbd.append(",taxTaxi=" + entryInfo.getTaxiExpenseTax());
                logbd.append(",taxRateTaxi=" + entryInfo.getTaxiExpenseTaxRate());
            } else if ("suburb".equals(costType)) {
                currentTotalAm = amountWithOutTax.add(tax);
                totalAmTax = tax.add(bussesExpenseTax);
                totalAmWithOutTax = amountWithOutTax.add(bussesExpenseWithoutTax).add(bussesCadFund);
                entryInfo.setBussesExpense(totalAmWithOutTax.add(totalAmTax));
                entryInfo.setBussesExpenseTax(taxDeAmount.add(bussesExpenseTax));
                entryInfo.setBussesExpenseWithoutTax(currentTotalAm.subtract(taxDeAmount).subtract(cadFund).add(bussesExpenseWithoutTax));
                if (vatList.size() > 0 && vatList.contains(entryId + costType) && bussesExpenseTaxRate.compareTo(taxRate) != 0) {
                    entryInfo.setBussesExpenseTaxRate(BizCollUtil.ZERO);
                } else {
                    entryInfo.setBussesExpenseTaxRate(taxRate);
                }
                entryInfo.setCadFund(cadFund.add(bussesCadFund));
                logbd.append(",taxTaxiBusses=" + entryInfo.getBussesExpenseTax());
                logbd.append(",taxRateTaxiBusses=" + entryInfo.getBussesExpenseTaxRate());
            } else if ("hotel".equals(costType)) {
                currentTotalAm = amountWithOutTax.add(tax);
                totalAmTax = tax.add(hotelExpenseTax);
                totalAmWithOutTax = amountWithOutTax.add(hotelExpenseWithoutTax);
                entryInfo.setHotelExpense(totalAmWithOutTax.add(totalAmTax));
                entryInfo.setTax(taxDeAmount.add(hotelExpenseTax));
                entryInfo.setHotelExpenseWithoutTax(currentTotalAm.subtract(taxDeAmount).add(hotelExpenseWithoutTax));
                if (vatList.size() > 0 && vatList.contains(entryId + costType) && hotelExpenseTaxRate.compareTo(taxRate) != 0) {
                    entryInfo.setTaxRate(BizCollUtil.ZERO);
                } else {
                    entryInfo.setTaxRate(taxRate);
                }
                logbd.append(",tax=" + entryInfo.getTax());
                logbd.append(",taxRate=" + entryInfo.getTaxRate());
            } else if ("other".equals(costType)) {
                currentTotalAm = amountWithOutTax.add(tax);
                totalAmTax = tax.add(otherExpenseTax);
                totalAmWithOutTax = amountWithOutTax.add(otherExpenseWithoutTax);
                entryInfo.setOtherExpense(totalAmWithOutTax.add(totalAmTax));
                entryInfo.setOtherExpenseTax(taxDeAmount.add(otherExpenseTax));
                entryInfo.setOtherExpenseWithoutTax(currentTotalAm.subtract(taxDeAmount).add(otherExpenseWithoutTax));
                if (vatList.size() > 0 && vatList.contains(entryId + costType) && otherExpenseTaxRate.compareTo(taxRate) != 0) {
                    entryInfo.setOtherExpenseTaxRate(BizCollUtil.ZERO);
                } else {
                    entryInfo.setOtherExpenseTaxRate(taxRate);
                }
                logbd.append(",taxOther=" + entryInfo.getOtherExpenseTax());
                logbd.append(",taxRateOther=" + entryInfo.getOtherExpenseTaxRate());
            }
            if (BizCollUtil.ZERO.compareTo(InvoiceUtil.AmountNotNull(amountMap.get("insurancePremium"))) == 0) continue;
            entryInfo.setOtherExpense(entryInfo.getOtherExpense().add((BigDecimal)amountMap.get("insurancePremium")));
            entryInfo.setOtherExpenseWithoutTax(entryInfo.getOtherExpenseWithoutTax().add((BigDecimal)amountMap.get("insurancePremium")));
            totalAmountWithoutTax = totalAmountWithoutTax.add((BigDecimal)amountMap.get("insurancePremium"));
        }
        BigDecimal totalAmount = totalAmountWithoutTax.add(totalTaxAmount).setScale(2, 4);
        totalAmountWithoutTax = totalAmount.subtract(totalDeTaxAmount);
        BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo, "amountOri").add(totalAmount).add(totalInsurancePremium);
        BigDecimal entryAmountOriWithoutTax = InvoiceUtil.AmountNotNull(entryInfo, "amountOriWithoutTax").add(totalAmountWithoutTax).add(totalInsurancePremium);
        BigDecimal entryExRate = entryInfo.getExchangeRate();
        BigDecimal entryAmount = BizCollUtil.ZERO;
        BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
        if (BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
            if (entryInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
            } else {
                entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
            }
        }
        entryInfo.setAmountOri(entryAmountOri);
        entryInfo.setAmountOriWithoutTax(entryAmountOriWithoutTax);
        entryInfo.setAmount(entryAmount);
        entryInfo.setAmountWithoutTax(entryAmountWithoutTax);
        entryInfo.setTicketUrl(entryInfo.getId().toString());
        entryInfo.setString("entryTicNumber", StringUtils.join((Object[])enTicNumberList.toArray(), (String)","));
        entryInfo.setString("invoiceNum", ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_STR", (Locale)ctx.getLocale()) + serialNoSet.size() + ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)ctx.getLocale()));
        entryInfo.setString("entrySerialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        logger.info((Object)logbd);
        HashMap<String, AbstractObjectCollection> changeInvoiceAndEntryMap = new HashMap<String, AbstractObjectCollection>();
        changeInvoiceAndEntryMap.put("traInvoiceAndEntry", traTicketEntries);
        changeInvoiceAndEntryMap.put("vatCollection", traVatCollection);
        return changeInvoiceAndEntryMap;
    }

    private List<String> getVatList(BizCollBillBaseInfo baseInfo) {
        VATInvoiceTraEntryCollection vatInvoiceEntries = (VATInvoiceTraEntryCollection)((Object)baseInfo.get("vatInvoiceEntries"));
        VATInvoiceTraEntryInfo vatEntry = null;
        ArrayList<String> vatList = new ArrayList<String>();
        Iterator it = vatInvoiceEntries.iterator();
        while (it.hasNext()) {
            vatEntry = (VATInvoiceTraEntryInfo)it.next();
            vatList.add(vatEntry.getString("bizEntryBill") + vatEntry.getString("costType"));
        }
        return vatList;
    }

    public Map invoiceCloudBuildVatEntryByBiz(Context ctx, List vatInvoiceEntryList, Map spareMap) throws EASBizException, BOSException {
        VATInvoiceEntryCollection vatCollection = new VATInvoiceEntryCollection();
        int size = vatInvoiceEntryList.size();
        for (int i = 0; i < size; ++i) {
            Map vatEntryInfoMap = (Map)vatInvoiceEntryList.get(i);
            VATInvoiceEntryInfo vatInfo = new VATInvoiceEntryInfo();
            BOSUuid vatBosId = BOSUuid.create((BOSObjectType)vatInfo.getBOSType());
            vatInfo.setId(vatBosId);
            this.buildVatInfo(vatEntryInfoMap, vatInfo);
            vatCollection.add(vatInfo);
        }
        HashMap<String, VATInvoiceEntryCollection> vatCollectionMap = new HashMap<String, VATInvoiceEntryCollection>();
        vatCollectionMap.put("vatCollection", vatCollection);
        return vatCollectionMap;
    }

    public Map invoiceCloudBuildVatEntryByBizOut(Context ctx, List vatInvoiceEntryList, Map spareMap) throws EASBizException, BOSException {
        VATInvoiceBizOutEntryCollection vatCollection = new VATInvoiceBizOutEntryCollection();
        int size = vatInvoiceEntryList.size();
        for (int i = 0; i < size; ++i) {
            Map vatEntryInfoMap = (Map)vatInvoiceEntryList.get(i);
            VATInvoiceBizOutEntryInfo vatInfo = new VATInvoiceBizOutEntryInfo();
            BOSUuid vatBosId = BOSUuid.create((BOSObjectType)vatInfo.getBOSType());
            vatInfo.setId(vatBosId);
            this.buildVatInfo(vatEntryInfoMap, vatInfo);
            vatCollection.add(vatInfo);
        }
        HashMap<String, VATInvoiceBizOutEntryCollection> vatCollectionMap = new HashMap<String, VATInvoiceBizOutEntryCollection>();
        vatCollectionMap.put("vatCollection", vatCollection);
        return vatCollectionMap;
    }

    public Map invoiceCloudBuildVatEntryByPur(Context ctx, List vatInvoiceEntryList, Map spareMap) throws EASBizException, BOSException {
        VATInvoicePurEntryCollection vatCollection = new VATInvoicePurEntryCollection();
        int size = vatInvoiceEntryList.size();
        for (int i = 0; i < size; ++i) {
            Map vatEntryInfoMap = (Map)vatInvoiceEntryList.get(i);
            VATInvoicePurEntryInfo vatInfo = new VATInvoicePurEntryInfo();
            BOSUuid vatBosId = BOSUuid.create((BOSObjectType)vatInfo.getBOSType());
            vatInfo.setId(vatBosId);
            vatInfo.setNum((BigDecimal)vatEntryInfoMap.get("num"));
            this.buildVatInfo(vatEntryInfoMap, vatInfo);
            vatCollection.add(vatInfo);
        }
        HashMap<String, VATInvoicePurEntryCollection> vatCollectionMap = new HashMap<String, VATInvoicePurEntryCollection>();
        vatCollectionMap.put("vatCollection", vatCollection);
        return vatCollectionMap;
    }

    public Map invoiceCloudBuildVatEntryByTra(Context ctx, List vatInvoiceEntryList, Map spareMap) throws EASBizException, BOSException {
        VATInvoiceTraEntryCollection vatCollection = new VATInvoiceTraEntryCollection();
        int size = vatInvoiceEntryList.size();
        for (int i = 0; i < size; ++i) {
            Map vatEntryInfoMap = (Map)vatInvoiceEntryList.get(i);
            VATInvoiceTraEntryInfo vatInfo = new VATInvoiceTraEntryInfo();
            BOSUuid vatBosId = BOSUuid.create((BOSObjectType)vatInfo.getBOSType());
            vatInfo.setId(vatBosId);
            String costType = (String)vatEntryInfoMap.get("costType");
            vatInfo.setCostType(costType);
            vatInfo.setCadFund((BigDecimal)vatEntryInfoMap.get("cadFund"));
            vatInfo.setInsurancePremium((BigDecimal)vatEntryInfoMap.get("insurancePremium"));
            this.buildVatInfo(vatEntryInfoMap, vatInfo);
            vatCollection.add(vatInfo);
        }
        HashMap<String, VATInvoiceTraEntryCollection> vatCollectionMap = new HashMap<String, VATInvoiceTraEntryCollection>();
        vatCollectionMap.put("vatCollection", vatCollection);
        return vatCollectionMap;
    }

    private void buildVatInfo(Map vatEntryInfoMap, TicketBaseEntryInfo vatInfo) throws BOSException {
        String serialNo = (String)vatEntryInfoMap.get("serialNo");
        String serialNolinkEntryId = (String)vatEntryInfoMap.get("serialNolinkEntryId");
        String serialNolinkTicketEntryId = (String)vatEntryInfoMap.get("serialNolinkTicketEntryId");
        String invoiceType2 = (String)vatEntryInfoMap.get("invoiceType");
        String taxClassNumber = (String)vatEntryInfoMap.get("taxClassNumber");
        String invoiceNumber = (String)vatEntryInfoMap.get("invoiceNumber");
        BigDecimal amountOri = (BigDecimal)vatEntryInfoMap.get("amountOri");
        BigDecimal tax = (BigDecimal)vatEntryInfoMap.get("tax");
        BigDecimal taxRate = (BigDecimal)vatEntryInfoMap.get("taxRate");
        taxRate = taxRate.multiply(InvoiceUtil.ONE_HUNDRED).setScale(2, 4);
        vatInfo.setSerialNo(serialNo);
        vatInfo.setAmout(amountOri);
        vatInfo.setTax(tax);
        vatInfo.setTaxRate(taxRate);
        vatInfo.put("bizEntryBill", serialNolinkEntryId);
        vatInfo.put("ticketEntryBill", serialNolinkTicketEntryId);
        vatInfo.setTicketTypeId(InvoiceUtil.getTicketTypeId(invoiceType2));
        vatInfo.setTaxClassNumber(taxClassNumber);
        vatInfo.setTicketNumber(invoiceNumber);
    }

    @Override
    protected void _rebackTicketRelationAndState(Context ctx, BizCollBillBaseInfo info, BizCollBillBaseInfo infoOld, Map paramMap) throws BOSException, EASBizException {
        if (paramMap == null) {
            return;
        }
        String action = paramMap.get("action") == null ? "" : paramMap.get("action").toString();
        boolean billHasSubmit = paramMap.get("billHasSubmit") == null ? false : (Boolean)paramMap.get("billHasSubmit");
        Map params = (Map)paramMap.get("params");
        try {
            StringBuilder logStr = new StringBuilder();
            logStr.append("##cp.bc " + action + " rebackTicketRelationAndState start ");
            if (infoOld == null) {
                logStr.append(",infoOld=null");
            }
            logger.info((Object)logStr);
            if ("submit".equals(action)) {
                if (infoOld != null) {
                    if (billHasSubmit) {
                        InvoiceUtil.saveTicketAndUpdateTicketState(ctx, infoOld, params, action);
                    } else {
                        InvoiceUtil.updateInvoiceStateReturnString(ctx, info, 1, null);
                        InvoiceUtil.saveTicketRelation(ctx, infoOld, params, action);
                    }
                } else if (info != null) {
                    InvoiceUtil.updateInvoiceStateReturnString(ctx, info, 1, null);
                    AbstractObjectCollection ticketEntries = (AbstractObjectCollection)info.get("tickeEntries");
                    if (ticketEntries != null && ticketEntries.size() > 0) {
                        infoOld = (BizCollBillBaseInfo)info.clone();
                        ((AbstractObjectCollection)infoOld.get("tickeEntries")).clear();
                        InvoiceUtil.saveTicketRelation(ctx, infoOld, params, action);
                    }
                }
            } else if ("save".equals(action)) {
                AbstractObjectCollection ticketEntries;
                if (infoOld != null) {
                    InvoiceUtil.saveTicketRelation(ctx, infoOld, params, action);
                } else if (info != null && (ticketEntries = (AbstractObjectCollection)info.get("tickeEntries")) != null && ticketEntries.size() > 0) {
                    infoOld = (BizCollBillBaseInfo)info.clone();
                    ((AbstractObjectCollection)infoOld.get("tickeEntries")).clear();
                    InvoiceUtil.saveTicketRelation(ctx, infoOld, params, action);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("##cp.bc rebackTicketRelationAndState error." + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)"##cp.bc rebackTicketRelationAndState end");
    }

    @Override
    protected Map _repairTicketEntries(Context ctx, String billId) throws BOSException, EASBizException {
        Locale local = SysContext.getSysContext().getOriginLocale();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> detailMsg = new ArrayList<String>();
        int successCount = 0;
        int failCount = 0;
        String zhang = ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)local);
        if (StringUtils.isBlank((CharSequence)billId)) {
            String resultMsg = ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRSUCCESS", (Locale)local) + successCount + zhang + "," + ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRFAIL", (Locale)local) + failCount + zhang + "!";
            resultMap.put("resultMsg", resultMsg);
            resultMap.put("detailMsg", "");
            logger.error((Object)"###cpbc repairTicket fail! \u83b7\u53d6\u5355\u636eid\u4e3a\u7a7a");
            return resultMap;
        }
        logger.error((Object)"##### cpbc repairTicketEntries start");
        AbstractObjectCollection billCol = this.getBaseInfoCollections(ctx, billId);
        if (billCol.size() == 0) {
            logger.info((Object)"##cpbc repairTicketEntries no query bill !");
        }
        IInvoiceFacade invoiceFacade = InvoiceFacadeFactory.getLocalInstance(ctx);
        HashMap<String, Map> companyParamMap = new HashMap<String, Map>();
        Map map = null;
        String billNumber = null;
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            try {
                String applierCompanyId;
                BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)billCol.getObject(i);
                billNumber = baseInfo.getNumber();
                String string = applierCompanyId = baseInfo.getApplierCompany() != null ? baseInfo.getApplierCompany().getId().toString() : null;
                if (companyParamMap.containsKey(applierCompanyId)) {
                    map = (Map)companyParamMap.get(applierCompanyId);
                } else {
                    ArrayList<String> paramList = new ArrayList<String>();
                    paramList.add("CP03901");
                    paramList.add("CP03907");
                    map = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompanyId);
                    companyParamMap.put(applierCompanyId, map);
                }
                invoiceFacade.repairTicketEntriesDeal(baseInfo, map);
                ++successCount;
                continue;
            }
            catch (Exception e) {
                ++failCount;
                detailMsg.add(ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIROCCUREXCEPTION", (Locale)local, (Object[])new Object[]{billNumber}) + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        String resultMsg = ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRSUCCESS", (Locale)local) + successCount + zhang + "," + ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRFAIL", (Locale)local) + failCount + zhang + "!";
        resultMap.put("detailMsg", detailMsg);
        resultMap.put("resultMsg", resultMsg);
        return resultMap;
    }

    @Override
    protected void _repairTicketEntriesDeal(Context ctx, BizCollBillBaseInfo baseInfo, Map paramMap) throws BOSException, EASBizException {
        if (!(baseInfo instanceof ExpenseAccountBillInfo)) {
            throw new InvoiceException(InvoiceException.NOEXPENSEBILL);
        }
        ArrayList<String> serialNoArray = new ArrayList<String>();
        AbstractObjectCollection entries = (AbstractObjectCollection)baseInfo.get("entries");
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
        String entrySerialNo = null;
        int esize = entries.size();
        for (int k = 0; k < esize; ++k) {
            entrySerialNo = entries.getObject(k).getString("entrySerialNo");
            if (StringUtils.isBlank((CharSequence)entrySerialNo)) continue;
            serialNoArray.addAll(Arrays.asList(entrySerialNo.split(",")));
        }
        if (serialNoArray.size() == 0) {
            throw new InvoiceException(InvoiceException.NORELATEINVOICE);
        }
        LinkedHashSet serialNoSet = new LinkedHashSet(serialNoArray);
        if (ticketEntries.size() > 0) {
            String serialNo = null;
            int tsize = ticketEntries.size();
            for (int k = 0; k < tsize; ++k) {
                serialNo = ticketEntries.getObject(k).getString("serialNo");
                if (!serialNoSet.contains(serialNo)) continue;
                serialNoSet.remove(serialNo);
            }
        }
        if (serialNoSet.size() == 0) {
            throw new InvoiceException(InvoiceException.INVOICENORMAL);
        }
        HashMap<String, Object> spareMap = new HashMap<String, Object>();
        spareMap.put("serialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        JSONObject invoiceDetailDataJson = InvoiceUtil.getInvoiceDetailDataJson(ctx, baseInfo, spareMap);
        JSONArray invoiceDetailData = InvoiceUtil.getInvoiceDetailData(ctx, invoiceDetailDataJson, spareMap);
        if (invoiceDetailData == null) {
            throw new InvoiceException(InvoiceException.GETDETAILDATAFAIL);
        }
        JSONArray invoiceData = new JSONArray();
        int isize = invoiceDetailData.size();
        for (int k = 0; k < isize; ++k) {
            JSONObject invoice = invoiceDetailData.getJSONObject(k);
            JSONObject convertToBaseInvoiceData = InvoiceUtil.convertToBaseInvoiceData(invoice, null);
            invoiceData.add((Object)convertToBaseInvoiceData);
        }
        JSONArray ticketDataArray = JSONObject.parseArray((String)invoiceData.toString());
        this.repairTkEntries(ctx, baseInfo, ticketDataArray, baseInfo.getId().toString());
        this._repairTicketRelation(ctx, baseInfo, paramMap);
    }

    @Override
    protected Map _repairTicketRelationBatch(Context ctx, String billId) throws BOSException, EASBizException {
        Locale local = SysContext.getSysContext().getOriginLocale();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String zhang = ResourceBase.getString((String)RESBIZCOLL, (String)"INVOICE_NUM_STR", (Locale)local);
        if (StringUtils.isBlank((CharSequence)billId)) {
            String resultMsg = ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRSUCCESS", (Locale)local) + 0 + zhang + "," + ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRFAIL", (Locale)local) + 0 + zhang + "!";
            resultMap.put("resultMsg", resultMsg);
            resultMap.put("detailMsg", "");
            logger.info((Object)"###cpbc repairTicketRelation fail! \u83b7\u53d6\u5355\u636eid\u4e3a\u7a7a");
            return resultMap;
        }
        logger.error((Object)"##### cpbc repairTicketRelation start");
        AbstractObjectCollection billCol = this.getBaseInfoCollections(ctx, billId);
        if (billCol.size() == 0) {
            logger.info((Object)"##cpbc repairTicketRelation no query bill !");
        }
        IInvoiceFacade invoiceFacade = InvoiceFacadeFactory.getLocalInstance(ctx);
        HashMap<String, Map> companyParamMap = new HashMap<String, Map>();
        ArrayList<String> detailMsg = new ArrayList<String>();
        int successCount = 0;
        int failCount = 0;
        String billNumber = null;
        Map map = null;
        AbstractObjectCollection ticketEntries = null;
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            try {
                String applierCompanyId;
                BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)billCol.getObject(i);
                ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
                billNumber = baseInfo.getNumber();
                if (ticketEntries != null && ticketEntries.size() == 0) {
                    throw new InvoiceException(InvoiceException.REPAIRNOTTICKET);
                }
                String string = applierCompanyId = baseInfo.getApplierCompany() != null ? baseInfo.getApplierCompany().getId().toString() : null;
                if (companyParamMap.containsKey(applierCompanyId)) {
                    map = (Map)companyParamMap.get(applierCompanyId);
                } else {
                    ArrayList<String> paramList = new ArrayList<String>();
                    paramList.add("CP03901");
                    paramList.add("CP03907");
                    map = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompanyId);
                    companyParamMap.put(applierCompanyId, map);
                }
                invoiceFacade.repairTicketRelation(baseInfo, map);
                ++successCount;
                continue;
            }
            catch (InvoiceException e) {
                ++failCount;
                detailMsg.add(ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIROCCUREXCEPTION", (Locale)local, (Object[])new Object[]{billNumber}) + e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
        String resultMsg = ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRSUCCESS", (Locale)local) + successCount + zhang + "," + ResourceBase.getString((String)RESBIZCOLL, (String)"REPAIRFAIL", (Locale)local) + failCount + zhang + "!";
        resultMap.put("detailMsg", detailMsg);
        resultMap.put("resultMsg", resultMsg);
        return resultMap;
    }

    @Override
    protected void _repairTicketRelation(Context ctx, BizCollBillBaseInfo baseInfo, Map paramMap) throws BOSException, EASBizException {
        if (!(baseInfo instanceof ExpenseAccountBillInfo)) {
            throw new InvoiceException(InvoiceException.NOEXPENSEBILL);
        }
        String errCode = InvoiceUtil.saveTicketRelation(ctx, baseInfo, paramMap, "submit");
        if ("0000".equals(errCode)) {
            StateEnum state = baseInfo.getState();
            if (StateEnum.SUBMIT.equals((Object)state) || StateEnum.CHECKING.equals((Object)state)) {
                InvoiceUtil.updateInvoiceStateReturnString(ctx, baseInfo, 30, paramMap);
            }
            if (state != null && state.getValue() >= 60) {
                InvoiceUtil.updateInvoiceStateReturnString(ctx, baseInfo, 60, paramMap);
            }
        }
    }

    private AbstractObjectCollection getBaseInfoCollections(Context ctx, String billId2) throws EASBizException, BOSException {
        String[] ids = billId2.split(",");
        HashMap idsMap = new HashMap();
        Set idSet = null;
        for (String billId2 : ids) {
            if (StringUtils.isEmpty((CharSequence)billId2)) continue;
            BOSObjectType objectType = new ObjectUuidPK(billId2).getObjectType();
            if (idsMap.containsKey(objectType)) {
                ((Set)idsMap.get(objectType)).add(billId2);
                continue;
            }
            idSet = new HashSet<String>();
            idSet.add(billId2);
            idsMap.put(objectType, idSet);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorItemCollection());
        Object objectCollection = null;
        ArrayList queryList = new ArrayList();
        CoreBaseCollection billCol = null;
        Iterator iterator = idsMap.entrySet().iterator();
        ICoreBase bizCtrl = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            idSet = (Set)entry.getValue();
            BOSUuid bosId = BOSUuid.read((String)((String)idSet.iterator().next()));
            bizCtrl = BizCollUtil.getBizInterfaceByBOSUuid(ctx, bosId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            if (billCol == null) {
                billCol = bizCtrl.getCollection(view);
                continue;
            }
            billCol.addObjectCollection((IObjectCollection)bizCtrl.getCollection(view));
        }
        return billCol;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("billTypeCode"));
        sic.add(new SelectorItemInfo("sourceSystem"));
        sic.add(new SelectorItemInfo("biller.id"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.longNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.entrySerialNo"));
        sic.add(new SelectorItemInfo("entries.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("tickeEntries.id"));
        sic.add(new SelectorItemInfo("tickeEntries.serialNo"));
        sic.add(new SelectorItemInfo("tickeEntries.bizEntryBill"));
        return sic;
    }

    protected void repairTkEntries(Context ctx, BizCollBillBaseInfo baseInfo, JSONArray ticketDataArray, String billId) throws BOSException, EASBizException {
        CoreBaseCollection ticketCollection = new CoreBaseCollection();
        AbstractObjectCollection entries = (AbstractObjectCollection)baseInfo.get("entries");
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
        TicketBaseEntryInfo ticketEntry = null;
        for (int i = 0; i < ticketDataArray.size(); ++i) {
            JSONObject invoiceDataJson = ticketDataArray.getJSONObject(i);
            ticketEntry = new TicketEntryInfo();
            if (baseInfo instanceof BizAccountOutBillInfo) {
                ticketEntry = new BizOutTicketEntryInfo();
            } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
                ticketEntry = new PurTicketEntryInfo();
            } else if (baseInfo instanceof TravelAccountBillInfo) {
                ticketEntry = new TraTicketEntryInfo();
            }
            ticketEntry.put("bill", billId);
            BigDecimal amountWithoutTax = BizCollUtil.ZERO;
            BigDecimal taxAmount = BizCollUtil.ZERO;
            boolean isDeduction = false;
            String taxClassNumber = "";
            boolean enIsDeduction = false;
            String enTaxClassNumber = "";
            BigDecimal enDeductionTax = BizCollUtil.ZERO;
            HashMap<String, String> ticketDataMap = new HashMap<String, String>(){
                {
                    this.put("invoiceCode", "ticketCode");
                    this.put("invoiceNo", "ticketNumber");
                    this.put("serialNo", "serialNo");
                    this.put("invoiceDate", "billingDate");
                    this.put("checkStatus", "checkStates");
                    this.put("salerName", "salerName");
                }
            };
            for (Map.Entry entry : ticketDataMap.entrySet()) {
                String easEntryKey = (String)entry.getValue();
                String invoiceCloudKey = (String)entry.getKey();
                ticketEntry.put(easEntryKey, invoiceDataJson.get((Object)invoiceCloudKey));
            }
            String serialNo = invoiceDataJson.getString("serialNo");
            String invoiceType2 = invoiceDataJson.getString("invoiceType");
            ticketEntry.setTicketTypeId(InvoiceUtil.getTicketTypeId(ctx, invoiceType2));
            JSONArray items = invoiceDataJson.getJSONArray("items");
            if (items != null && !"".equals(items) && items.size() > 0) {
                HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsObject = items.getJSONObject(j);
                    BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                    BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                    taxClassNumber = jsObject.getString("goodsCode");
                    BigDecimal taxRate = jsObject.getBigDecimal("taxRate") == null ? BizCollUtil.ZERO : jsObject.getBigDecimal("taxRate");
                    itemTaxRateSet.add(taxRate);
                    taxAmount = taxAmount.add(detailTaxAmount);
                    amountWithoutTax = amountWithoutTax.add(detailAmount);
                    isDeduction = InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, taxClassNumber, invoiceType2, baseInfo, null);
                    if (!isDeduction) continue;
                    enIsDeduction = isDeduction;
                    enTaxClassNumber = taxClassNumber;
                    enDeductionTax = enDeductionTax.add(detailTaxAmount);
                }
                if (itemTaxRateSet.size() > 1) {
                    ticketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
                } else {
                    for (BigDecimal taxR : itemTaxRateSet) {
                        ticketEntry.setTaxRate(taxR.setScale(2, 4).multiply(new BigDecimal(100)));
                    }
                }
            } else {
                BigDecimal taxRate = invoiceDataJson.getBigDecimal("taxRate");
                taxRate = taxRate == null ? BizCollUtil.ZERO : taxRate;
                ticketEntry.setTaxRate(taxRate.setScale(2, 4).multiply(new BigDecimal(100)));
                BigDecimal ammount = invoiceDataJson.getBigDecimal("amount");
                ammount = ammount == null ? BizCollUtil.ZERO : ammount;
                BigDecimal taaxAmount = invoiceDataJson.getBigDecimal("taxAmount");
                taaxAmount = taaxAmount == null ? BizCollUtil.ZERO : taaxAmount;
                amountWithoutTax = amountWithoutTax.add(ammount);
                taxAmount = taxAmount.add(taaxAmount);
                isDeduction = InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, taxClassNumber, invoiceType2, baseInfo, null);
                if (isDeduction) {
                    enIsDeduction = isDeduction;
                    enDeductionTax = taaxAmount;
                }
            }
            if (ticketEntry instanceof TraTicketEntryInfo) {
                String passengerName = InvoiceUtil.nullToK(invoiceDataJson.getString("passengerName"));
                String seatGrade = InvoiceUtil.nullToK(invoiceDataJson.getString("seatGrade"));
                String placeOfDeparture = InvoiceUtil.nullToK(invoiceDataJson.getString("stationGetOn"));
                String destination = InvoiceUtil.nullToK(invoiceDataJson.getString("stationGetOff"));
                if ("10".equals(invoiceDataJson.getString("invoiceType"))) {
                    seatGrade = InvoiceUtil.nullToK(invoiceDataJson.getString("seatGradeName"));
                    placeOfDeparture = InvoiceUtil.nullToK(invoiceDataJson.getString("placeOfDeparture"));
                    destination = InvoiceUtil.nullToK(invoiceDataJson.getString("destination"));
                }
                ((TraTicketEntryInfo)ticketEntry).setPassengerName(passengerName);
                ((TraTicketEntryInfo)ticketEntry).setSeatClass(seatGrade);
                ((TraTicketEntryInfo)ticketEntry).setPlaceOfDeparture(placeOfDeparture);
                ((TraTicketEntryInfo)ticketEntry).setDestination(destination);
            }
            ticketEntry.setAmout(amountWithoutTax.add(taxAmount));
            ticketEntry.setTax(taxAmount);
            if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
                if (StringUtils.isNotEmpty((CharSequence)enTaxClassNumber)) {
                    ticketEntry.setTaxClassNumber(enTaxClassNumber);
                } else {
                    ticketEntry.setTaxClassNumber(taxClassNumber);
                }
            }
            ticketEntry.setIsDeduction(enIsDeduction);
            if (ticketEntry.isIsDeduction()) {
                ticketEntry.setDeductionTax(enDeductionTax);
            } else {
                ticketEntry.setDeductionTax(BizCollUtil.ZERO);
            }
            CoreBillEntryBaseInfo entryInfo = null;
            if (ticketEntry instanceof TicketEntryInfo) {
                entryInfo = new BizAccountBillEntryInfo();
            } else if (ticketEntry instanceof BizOutTicketEntryInfo) {
                entryInfo = new BizAccountOutBillEntryInfo();
            } else if (ticketEntry instanceof PurTicketEntryInfo) {
                entryInfo = new DailyPurchaseAccountBillEntryInfo();
            } else if (ticketEntry instanceof TraTicketEntryInfo) {
                entryInfo = new TravelAccountBillEntryInfo();
            } else {
                logger.error((Object)"repairTicketEntries fail! ticketEntry is not in(TicketEntryInfo,BizOutTicketEntryInfo,PurTicketEntryInfo,TraTicketEntryInfo)");
                return;
            }
            CoreBillEntryBaseInfo entry = null;
            int size = entries.size();
            for (int j = 0; j < size; ++j) {
                entry = (CoreBillEntryBaseInfo)entries.getObject(j);
                if (!StringUtils.isNotEmpty((CharSequence)entry.getString("entrySerialNo")) || !Arrays.asList(entry.getString("entrySerialNo").split(",")).contains(serialNo)) continue;
                entryInfo.setId(entry.getBOSUuid("id"));
                InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
                break;
            }
            ticketCollection.add((CoreBaseInfo)ticketEntry);
            ticketEntries.addObject((IObjectValue)ticketEntry);
        }
        if (baseInfo instanceof BizAccountBillInfo) {
            TicketEntryFactory.getLocalInstance(ctx).addnew(ticketCollection);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            BizOutTicketEntryFactory.getLocalInstance(ctx).addnew(ticketCollection);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            PurTicketEntryFactory.getLocalInstance(ctx).addnew(ticketCollection);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            TraTicketEntryFactory.getLocalInstance(ctx).addnew(ticketCollection);
        }
    }

    @Override
    protected String _getInvoiceData(Context ctx, BizCollBillBaseInfo baseInfo, String serialNoStr, Map spareMap) throws BOSException, EASBizException {
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        if (StringUtils.isEmpty((CharSequence)serialNoStr)) {
            return null;
        }
        serialNoSet.addAll(new LinkedHashSet<String>(Arrays.asList(serialNoStr.split(","))));
        Set<String> serialNo = InvoiceUtil.getTicketEntriesSerialNo(ctx, baseInfo, spareMap);
        if (serialNo.size() > 0) {
            serialNoSet.removeAll(serialNo);
        }
        if (serialNoSet.size() < 1) {
            return null;
        }
        spareMap.put("serialNo", StringUtils.join((Object[])serialNoSet.toArray(), (String)","));
        JSONObject invoiceDetailDataJson = InvoiceUtil.getInvoiceDetailDataJson(ctx, baseInfo, spareMap);
        spareMap.remove("serialNo");
        JSONArray invoiceDetailData = InvoiceUtil.getInvoiceDetailData(ctx, invoiceDetailDataJson, spareMap);
        JSONArray invoiceData = new JSONArray();
        int size = invoiceDetailData.size();
        for (int i = 0; i < size; ++i) {
            JSONObject invoice = invoiceDetailData.getJSONObject(i);
            JSONObject convertToBaseInvoiceData = this.convertToBaseInvoiceData(invoice, spareMap);
            invoiceData.add((Object)convertToBaseInvoiceData);
        }
        return invoiceData.toString();
    }

    @Override
    protected Map _refershInvoiceType(Context ctx, CompanyOrgUnitInfo company, Map spareMap) throws BOSException, EASBizException {
        if (company == null) {
            throw new InvoiceException(InvoiceException.CTXCOMPANYNOTNULL);
        }
        String invoiceTypeData = InvoiceUtil.getInvoiceTypeData(ctx, company);
        if (BizCollUtil.objectIsNull(invoiceTypeData)) {
            throw new InvoiceException(InvoiceException.INVOICETYPEDATAISNULL, new Object[]{invoiceTypeData});
        }
        JSONObject invoiceTypeObject = JSONObject.parseObject((String)invoiceTypeData);
        if (invoiceTypeObject == null || invoiceTypeObject.get((Object)"data") == null) {
            throw new InvoiceException(InvoiceException.INVOICETYPEDATAISNULL, new Object[]{invoiceTypeData});
        }
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        HashMap<String, InvoiceTypeInfo> invoiceTypeMap = new HashMap<String, InvoiceTypeInfo>();
        CoreBaseCollection tCollection = new CoreBaseCollection();
        CoreBaseCollection upCollection = new CoreBaseCollection();
        String logStr = "";
        boolean isImportInvoice = spareMap != null && spareMap.get("isImportInvoice") != null ? new Boolean(spareMap.get("isImportInvoice").toString()) : false;
        JSONArray returnDataOut = (JSONArray)invoiceTypeObject.get((Object)"data");
        InvoiceTypeInfo invoiceTypeInfo = null;
        String invoiceTypeNumber = "";
        for (int i = 0; i < returnDataOut.size(); ++i) {
            JSONObject eJsStrOut = returnDataOut.getJSONObject(i);
            invoiceTypeNumber = eJsStrOut.getString("invoiceType");
            invoiceTypeInfo = new InvoiceTypeInfo();
            invoiceTypeInfo.setNumber(invoiceTypeNumber);
            invoiceTypeInfo.setName(eJsStrOut.getString("invoiceTypeName"));
            invoiceTypeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            invoiceTypeInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            if (eJsStrOut.get((Object)"isElectronicInvoice") != null) {
                invoiceTypeInfo.setIsElectronicInvoice(eJsStrOut.getBoolean("isElectronicInvoice"));
            }
            invoiceTypeMap.put(invoiceTypeNumber, invoiceTypeInfo);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FID, FNUMBER");
        sql.append(" ," + this.getMultilingualField(ctx, "FNAME_"));
        sql.append(" ,FISELECTRONICINVOICE FROM T_BC_INVOICETYPE");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (!invoiceTypeMap.containsKey(rs.getString("FNUMBER"))) continue;
                invoiceTypeNumber = rs.getString("FNUMBER");
                invoiceTypeInfo = (InvoiceTypeInfo)invoiceTypeMap.get(invoiceTypeNumber);
                BOSUuid invoiceTypeId = BOSUuid.read((String)rs.getString("FID"));
                invoiceTypeInfo.setId(invoiceTypeId);
                if (rs.getString("FNAME_L2") == null || !invoiceTypeInfo.getName().equals(rs.getString("FNAME_L2")) || invoiceTypeInfo.get("isElectronicInvoice") != null && (rs.getString("FISELECTRONICINVOICE") == null || invoiceTypeInfo.isIsElectronicInvoice() != rs.getBoolean("FISELECTRONICINVOICE"))) {
                    upCollection.add((CoreBaseInfo)invoiceTypeInfo);
                }
                if (isImportInvoice) {
                    resultMap.put(invoiceTypeNumber, invoiceTypeInfo);
                }
                invoiceTypeMap.remove(invoiceTypeNumber);
            }
            if (isImportInvoice) {
                resultMap.putAll(invoiceTypeMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        for (Map.Entry entry : invoiceTypeMap.entrySet()) {
            tCollection.add((CoreBaseInfo)entry.getValue());
        }
        IInvoiceType iServers = InvoiceTypeFactory.getLocalInstance(ctx);
        int addNewSize = tCollection.size();
        int updateSize = upCollection.size();
        if (addNewSize > 0) {
            iServers.saveBatchData(tCollection);
        }
        if (updateSize > 0) {
            iServers.updateBatchData(upCollection);
        }
        if (isImportInvoice) {
            logStr = "\u5355\u636e\u5bfc\u7968\u540c\u6b65\u53d1\u7968\u7c7b\u578b\u6210\u529f\u3002\u65b0\u589e" + addNewSize + "\u6761\uff0c\u66f4\u65b0" + updateSize + "\u6761";
        } else {
            resultMap.put("addNewSize", Integer.valueOf(addNewSize));
            resultMap.put("updateSize", Integer.valueOf(updateSize));
            logStr = "\u540c\u6b65\u53d1\u7968\u7c7b\u578b\u6210\u529f\u3002\u65b0\u589e" + addNewSize + "\u6761\uff0c\u66f4\u65b0" + updateSize + "\u6761";
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_refershInvoiceType", (BOSObjectType)new InvoiceTypeInfo().getBOSType(), null, (String)("_refershInvoiceType" + logStr));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return resultMap;
    }

    protected JSONObject convertToBaseInvoiceData(JSONObject invoice, Map<String, Object> spareMap) {
        return InvoiceUtil.convertToBaseInvoiceData(invoice, spareMap);
    }

    private String getMultilingualField(Context ctx, String field) {
        Locale locale = ctx.getOriginLocale();
        field = locale.equals(LocaleUtils.locale_en_US) ? field + "l1" : (locale.equals(LocaleUtils.locale_zh_CN) ? field + "l2" : field + "l3");
        return field;
    }
}

