/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.MarketActivityBillEntryCollection;
import com.kingdee.eas.cp.bc.MarketActivityBillEntryInfo;
import com.kingdee.eas.cp.bc.MarketActivityBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractMarketActivityBillControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class MarketActivityBillControllerBean
extends AbstractMarketActivityBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.MarketActivityBillControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAddNew(model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkAddNew(model);
        return super._addnew(ctx, model);
    }

    private void checkAddNew(IObjectValue model) throws BOSException, EASBizException {
        MarketActivityBillInfo info = (MarketActivityBillInfo)model;
        MarketActivityBillEntryCollection entries = info.getEntries();
        if (entries.size() < 1) {
            throw new ExpenseReqException(ExpenseReqException.NULL_ENTRY_EXCEPTION);
        }
        MarketActivityBillEntryInfo entryInfo = null;
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = entries.get(i);
            if (StringUtils.isEmpty((String)entryInfo.getName())) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYNAME_EXCEPTION);
            }
            if (entryInfo.getHappenTime() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYTIME_EXCEPTION);
            }
            if (entryInfo.getPurpose() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ACTIVITYCONTENT_EXCEPTION);
            }
            if (entryInfo.getAmount() != null) continue;
            throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
        }
    }

    @Override
    protected String _getBudgetConrolParamNumber(Context ctx) throws BOSException {
        return "CP001";
    }
}

