/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryCollection;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractOtherExpenseBillControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class OtherExpenseBillControllerBean
extends AbstractOtherExpenseBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.OtherExpenseBillControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        super.checkUpdate(ctx, model, action);
        this.checkOtherExpenseValid(action, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        super.checkAddNew(ctx, model, action);
        this.checkOtherExpenseValid(action, model);
    }

    @Override
    protected String _getBudgetConrolParamNumber(Context ctx) throws BOSException {
        return "CP001";
    }

    protected void checkOtherExpenseValid(String action, IObjectValue model) throws BOSException, EASBizException {
        OtherExpenseBillInfo info = (OtherExpenseBillInfo)model;
        OtherExpenseBillEntryCollection entries = info.getEntries();
        OtherExpenseBillEntryInfo entryInfo = null;
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCostedDept()) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COSTDEPT_EXCEPTION);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCompany()) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COMAPNY_EXCEPTION);
        }
        if ("submit".equals(action)) {
            if (entries.size() < 1) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRY_EXCEPTION);
            }
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                entryInfo = entries.get(i);
                if (entryInfo.getExpenseType() == null) {
                    throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
                }
                if (StringUtils.isEmpty((String)entryInfo.getPurpose())) {
                    throw new ExpenseReqException(ExpenseReqException.NULL_REASON_EXCEPTION);
                }
                if (entryInfo.getCurrencyType() == null) {
                    throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
                }
                if (entryInfo.getAmount() == null) {
                    throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
                }
                if (StringUtils.isEmpty((String)entryInfo.getComment()) || entryInfo.getComment().trim().length() <= 200) continue;
                throw new ExpenseReqException(ExpenseReqException.COMMON_TO0_LONG);
            }
        } else {
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                entryInfo = entries.get(i);
                if (entryInfo.getCurrencyType() == null) {
                    throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
                }
                if (StringUtils.isEmpty((String)entryInfo.getComment()) || entryInfo.getComment().trim().length() <= 200) continue;
                throw new ExpenseReqException(ExpenseReqException.COMMON_TO0_LONG);
            }
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherExpenseBillInfo info = (OtherExpenseBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new ExpenseReqException(ExpenseReqException.NUMBER_NOT_DUP);
        }
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        OtherExpenseBillInfo info = (OtherExpenseBillInfo)model;
        OtherExpenseBillEntryCollection entries = info.getEntries();
        OtherExpenseBillEntryInfo entryInfo = null;
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (info.getNumber() == null) {
            throw new ExpAccException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && info.getCostedDept() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COSTDEPT_EXCEPTION);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && info.getCompany() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_COMAPNY_EXCEPTION);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        if (entries.size() < 1) {
            throw new ExpenseReqException(ExpenseReqException.NULL_ENTRY_EXCEPTION);
        }
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = entries.get(i);
            if (entryInfo.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entryInfo.getPurpose())) {
                throw new ExpenseReqException(ExpenseReqException.NULL_REASON_EXCEPTION);
            }
            if (entryInfo.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (entryInfo.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (info.getAmount() == null) {
                throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
            }
            if (info.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (!BizCollUtil.bigDecimalObjectLessThan(entryInfo.getAmountApproved(), entryInfo.getAmount())) {
                throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entryInfo.getAmountApproved(), entryInfo.getAmount()});
            }
            if (StringUtils.isEmpty((String)entryInfo.getComment()) || entryInfo.getComment().trim().length() <= 200) continue;
            throw new ExpenseReqException(ExpenseReqException.COMMON_TO0_LONG);
        }
    }

    @Override
    protected void checkEntry(Context ctx, ExpenseReqBillInfo Info) throws EASBizException {
        OtherExpenseBillInfo info = (OtherExpenseBillInfo)Info;
        OtherExpenseBillEntryInfo entryInfo = null;
        int n = info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            entryInfo = info.getEntries().get(i);
            if (!this.showHeadCompanys.equals("1") && !this.showHeadCompanys.equals("2") || this.fromMbos.booleanValue()) continue;
            if (entryInfo.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entryInfo.getCostCenter() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
        }
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_Expense_Update";
    }
}

