/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseReqBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractOtherExpenseEditUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public class OtherExpenseEditUIHandler
extends AbstractOtherExpenseEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        EntityViewInfo viewInfo = (EntityViewInfo)request.get("viewInfo");
        SettlementTypeCollection scol = SettlementTypeFactory.getLocalInstance((Context)context).getSettlementTypeCollection(viewInfo);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
    }

    @Override
    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.loadFields(request, response, context);
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        OtherExpenseBillInfo info = new OtherExpenseBillInfo();
        this.fillBillHeader(request, response, context, info);
        info.getEntries().add((OtherExpenseBillEntryInfo)this.createNewDetailData());
        info.setAmountControlType(AmountControlTypeEnum.oneTOone);
        return info;
    }

    protected void fillBillHeader(RequestContext request, ResponseContext response, Context context, ExpenseReqBillInfo info) throws EASBizException, BOSException {
        BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(context).forLoanBillCreateNewData();
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        if (person != null) {
            info.setApplier(person);
        }
        info.setPayMode(((DailyLoanBillInfo)baseInfo).getPayMode());
        info.setPrior(PriorEnum.LOW);
        info.setBillDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (ContextUtil.getCurrentUserInfo((Context)context) != null) {
            info.setBiller(ContextUtil.getCurrentUserInfo((Context)context));
        }
        info.setAmount(new BigDecimal("0.00"));
        info.setState(StateEnum.NEW);
        info.setBizReqDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setName(BizCollBillTypeEnum.OTHER_EXPENSE.toString());
        info.setCurrencyType(baseInfo.getCurrencyType());
        info.setApplier(baseInfo.getApplier());
        info.setPosition(baseInfo.getPosition());
        info.setOrgUnit(baseInfo.getOrgUnit());
        info.setApplierCompany(baseInfo.getApplierCompany());
        info.setCostedDept(baseInfo.getCostedDept());
        info.setCompany(baseInfo.getCompany());
    }

    protected IObjectValue createNewDetailData() {
        OtherExpenseBillEntryInfo entryInfo = new OtherExpenseBillEntryInfo();
        entryInfo.setAmount(new BigDecimal("0.0"));
        return entryInfo;
    }

    @Override
    protected void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCopy(request, response, context);
    }
}

