/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractRePaymentBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCollVersion;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IRePaymentBill;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.RePaymentBillEntryCollection;
import com.kingdee.eas.cp.bc.RePaymentBillEntryInfo;
import com.kingdee.eas.cp.bc.RePaymentBillFactory;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryCollection;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryFactory;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryInfo;
import com.kingdee.eas.cp.bc.RePaymentFacadeFactory;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractRePaymentBillControllerBean;
import com.kingdee.eas.cp.bc.app.BizAppUtil;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class RePaymentBillControllerBean
extends AbstractRePaymentBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.RePaymentBillControllerBean");
    public static String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";
    boolean isRelaFi = false;
    boolean isRelaCn = false;
    boolean isMustCheckReceive = false;
    boolean canNotSubmitHistoryPeriod = true;
    boolean isFromWFSubmit = false;
    boolean isWFSubmitNoApprove = false;
    boolean isSubmit = false;
    boolean billHasSubmit = false;
    boolean isEntryAmountZero = false;
    private static final String EXTENDNAMECQ = "cq";
    boolean isFromCq = false;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RePaymentBillInfo rePaymentBillInfo = (RePaymentBillInfo)model;
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.isFromWFSubmit = rePaymentBillInfo.get("isfromwfsubmit") == null ? false : new Boolean(rePaymentBillInfo.get("isfromwfsubmit").toString());
        this.checkUpdatePermission(ctx, currentUser, rePaymentBillInfo.getApplierCompany().getId().toString());
        if (rePaymentBillInfo.getBiller() == null) {
            rePaymentBillInfo.setBiller(currentUser);
        }
        if (rePaymentBillInfo.getCreator() == null) {
            rePaymentBillInfo.setCreator(currentUser);
            if (currentUser != null && !currentUser.getId().equals((Object)rePaymentBillInfo.getBiller().getId())) {
                rePaymentBillInfo.setBiller(currentUser);
            }
        }
        rePaymentBillInfo.setState(StateEnum.SUBMIT);
        if (rePaymentBillInfo.getBillTypeCode() == null) {
            rePaymentBillInfo.setBillTypeCode(BizCollBillTypeEnum.REPAYMENT);
        }
        rePaymentBillInfo.setSubmitDate(new Date());
        AbstractRePaymentBillInfo infoOld = null;
        if (rePaymentBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId()))) {
            infoOld = this.getRePaymentBillInfo(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId()));
        }
        if (infoOld != null) {
            StateEnum state = infoOld.getState();
            if (state == null || state.getValue() >= 60 || state.getValue() == 45) {
                String stateStr = state == null ? "null" : state.getAlias();
                throw new BizCollException(BizCollException.CAN_NOT_SUBMIT, new Object[]{stateStr});
            }
        } else {
            BizCollUtil.verdictRuleNumber(ctx, model);
            if (StringUtils.isEmpty((String)rePaymentBillInfo.getNumber())) {
                throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
            }
        }
        this.isSubmit = true;
        this.billHasSubmit = infoOld != null && infoOld.getState().getValue() >= 25;
        this.checkBill(ctx, rePaymentBillInfo, (RePaymentBillInfo)infoOld, "submit");
        this.reverseCheckEntry(ctx, rePaymentBillInfo, (RePaymentBillInfo)infoOld);
        this.buildRepayBotpRelation(ctx, rePaymentBillInfo, (RePaymentBillInfo)infoOld);
        this.updateModel(ctx, rePaymentBillInfo);
        IObjectPK retValue = super._submit(ctx, model);
        this.setImageNo(ctx, rePaymentBillInfo);
        return retValue;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK retValue;
        RePaymentBillInfo rePaymentBillInfo = (RePaymentBillInfo)model;
        boolean bl = this.isFromWFSubmit = rePaymentBillInfo.get("isfromwfsubmit") == null ? false : new Boolean(rePaymentBillInfo.get("isfromwfsubmit").toString());
        if (!this.isFromWFSubmit) {
            if (rePaymentBillInfo.getBillTypeCode() == null) {
                rePaymentBillInfo.setBillTypeCode(BizCollBillTypeEnum.REPAYMENT);
            }
            if (rePaymentBillInfo.getState() == null) {
                rePaymentBillInfo.setState(StateEnum.DRAFT);
            }
            if (rePaymentBillInfo.getState() == null || StateEnum.NEW.equals((Object)rePaymentBillInfo.getState())) {
                rePaymentBillInfo.setState(StateEnum.DRAFT);
            }
            RePaymentBillInfo infoOld = null;
            if (rePaymentBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId()))) {
                infoOld = this.getRePaymentBillInfo(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId()));
            }
            if (infoOld == null) {
                BizCollUtil.verdictRuleNumber(ctx, (IObjectValue)rePaymentBillInfo);
                if (StringUtils.isEmpty((String)rePaymentBillInfo.getNumber())) {
                    throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
                }
            }
            this.checkBill(ctx, rePaymentBillInfo, infoOld, "save");
            this.buildRepayBotpRelation(ctx, rePaymentBillInfo, infoOld);
            this.updateModel(ctx, rePaymentBillInfo);
            retValue = super._save(ctx, model);
            this.setImageNo(ctx, rePaymentBillInfo);
        } else {
            retValue = this._submit(ctx, model);
        }
        return retValue;
    }

    private void updateModel(Context ctx, RePaymentBillInfo rePaymentBillInfo) {
        if (rePaymentBillInfo.getBizDate() == null) {
            rePaymentBillInfo.setBizDate(rePaymentBillInfo.getBizReqDate());
        }
        if (rePaymentBillInfo.getCreateTime() == null) {
            rePaymentBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizCollUtil.isNumberDup(ctx, model);
        if (StringUtils.isEmpty((String)model.getString("number"))) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)model.getString("number"))) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        if (BizCollUtil.checkNumberDup(ctx, model)) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_DUP);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean idInProcess;
        RePaymentBillInfo info = this.getRePayInfo(ctx, BOSUuid.read((String)pk.toString()));
        BOSUuid id = info.getId();
        if (info.getVersion() == 1) {
            BizAppUtil.updateLoanBillFlag(ctx, info, false);
        }
        if (!this.isFromCq && (idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)id.toString()))) {
            throw new BizCollException(BizCollException.NODELINWORKFLOW);
        }
        StateEnum state = StateEnum.getEnum((Integer)info.get("state"));
        boolean isCanDeleteAbandonBill = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP023");
        Map paramObj = null;
        paramObj = info.get("applierCompany") != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, info.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        boolean bl = isCanDeleteAbandonBill = paramObj.get("CP023") == null ? false : new Boolean(paramObj.get("CP023").toString());
        if (!(StateEnum.DRAFT.equals((Object)state) || StateEnum.ALREADYABANDON.equals((Object)state) && isCanDeleteAbandonBill)) {
            throw new ExpenseReqException(ExpenseReqException.CAN_NOT_DELETE_EXCEPTION);
        }
        super._delete(ctx, pk);
        this.recycleRuleNumber(ctx, pk, info);
    }

    private RePaymentBillInfo getRePayInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        RePaymentBillInfo rePaymentBillInfo = null;
        IRePaymentBill iRepay = RePaymentBillFactory.getLocalInstance(ctx);
        rePaymentBillInfo = iRepay.getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(id), this.getRepaySelector());
        return rePaymentBillInfo;
    }

    protected void setImageNo(Context ctx, RePaymentBillInfo info) throws BOSException, EASBizException {
        if (info.getImageNo() == null || !BillImageMapFactory.getLocalInstance((Context)ctx).exists("SELECT ID WHERE BILLID ='" + info.getId() + "'")) {
            String imageNo = BillImageFacadeFactory.getLocalInstance((Context)ctx).getImageNumber(info.getBOSType().toString(), info.getId().toString(), EXTENDNAMECQ, info.getCqBillId(), info.getImageNo());
            info.setImageNo(imageNo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("imageNo"));
            super.updatePartial(ctx, (CoreBaseInfo)info, selector);
        }
    }

    private void recycleRuleNumber(Context ctx, IObjectPK pk, CoreBillBaseInfo info) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
    }

    protected void setAmountByEntryAmount(RePaymentBillInfo rePaymentBillInfo) {
        RePaymentBillEntryCollection entry = rePaymentBillInfo.getEntries();
        BigDecimal amount = new BigDecimal("0.00");
        int n = entry.size();
        for (int i = 0; i < n; ++i) {
            RePaymentBillEntryInfo en = entry.get(i);
            amount = amount.add(en.getAmount() == null ? BizCollUtil.ZERO : en.getAmount());
        }
        rePaymentBillInfo.setAmount(amount);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        RePaymentBillInfo rePaymentBill = (RePaymentBillInfo)srcBillVO;
        BOSUuid billId = ((RePaymentBillInfo)srcBillVO).getId();
        BOTRelationInfo botObj = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType type = BizCollUtil.getBOSType(botObj.getDestObjectID());
        IRePaymentBill iRePaymentBill = RePaymentBillFactory.getLocalInstance(ctx);
        if (!new VoucherInfo().getBOSType().equals((Object)type)) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
        if (new VoucherInfo().getBOSType().equals((Object)type) || new ReceivingBillInfo().getBOSType().equals((Object)type)) {
            String mode = null;
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                StringBuilder sqlLock = new StringBuilder();
                sqlLock.append("UPDATE T_BC_RePaymentBill SET FID = FID  WHERE FID = ?");
                DbUtil.execute((Context)ctx, (String)sqlLock.toString(), (Object[])new Object[]{rePaymentBill.getId().toString()});
            }
            SelectorItemCollection rePaySic = new SelectorItemCollection();
            rePaySic.add(new SelectorItemInfo("fivouchered"));
            rePaySic.add(new SelectorItemInfo("number"));
            rePaySic.add(new SelectorItemInfo("state"));
            RePaymentBillInfo rePaymentBillInfoOld = RePaymentBillFactory.getLocalInstance(ctx).getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()), rePaySic);
            if (rePaymentBill.getNumber() == null) {
                rePaymentBill.setNumber(rePaymentBillInfoOld.getNumber());
            }
            if (rePaymentBill.getState() == null) {
                rePaymentBill.setState(rePaymentBillInfoOld.getState());
            }
            if (new VoucherInfo().getBOSType().equals((Object)type)) {
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    StateEnum billState = rePaymentBill.getState();
                    if (billState != null && billState.getValue() < 60) {
                        throw new BizCollException(BizCollException.BILLCANNOTVOUCHERSTATE);
                    }
                    if (rePaymentBillInfoOld.isFivouchered()) {
                        throw new BizCollException(BizCollException.NOSAMEVOUCHER);
                    }
                }
                String voucherNumber = null;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(botObj.getDestObjectID()), sic);
                FilterItemInfo filterItem = new FilterItemInfo("sourceBillId", (Object)billId, CompareType.EQUALS);
                FilterItemInfo filterItem1 = new FilterItemInfo("id", (Object)voucher.getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.getFilterItems().add(filterItem1);
                String maskString = "#0 or #1";
                filter.setMaskString(maskString);
                ev.setFilter(filter);
                ev.setSelector(sic);
                VoucherCollection vc = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(ev);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("fivouchered"));
                selector.add(new SelectorItemInfo("voucherNumbers"));
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                    rePaymentBill.setFivouchered(true);
                    voucherNumber = RePaymentBillControllerBean.getVoucherNumber(ctx, rePaymentBill, (IObjectCollection)vc, 0);
                    rePaymentBill.setVoucherNumbers(voucherNumber);
                    iRePaymentBill.updatePartial((CoreBaseInfo)rePaymentBill, selector);
                    RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()));
                } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    if (vc.size() == 1) {
                        rePaymentBill.setFivouchered(false);
                    }
                    rePaymentBill.setVoucherNumbers(RePaymentBillControllerBean.getVoucherNumber(ctx, rePaymentBill, voucher, 1));
                    iRePaymentBill.updatePartial((CoreBaseInfo)rePaymentBill, selector);
                    RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()));
                }
                mode = ",\u51ed\u8bc1mode: " + bOTBillOperStateEnum;
                if (voucherNumber != null) {
                    mode = mode + ",voucherNumber: " + voucherNumber;
                }
            } else if (new ReceivingBillInfo().getBOSType().equals((Object)type)) {
                IExpenseAccountFacade facade;
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) && StateEnum.ISRECEIVEBILL.equals((Object)rePaymentBillInfoOld.getState())) {
                    throw new BizCollException(BizCollException.ISEXITRECEIVEBILL);
                }
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                    facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
                    facade.setState(billId, StateEnum.ISRECEIVEBILL);
                    RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()));
                } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    if (rePaymentBill.getState() != null && rePaymentBill.getState().getValue() > 60) {
                        facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
                        facade.setState(billId, StateEnum.CHECKED);
                        RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(rePaymentBill.getId()));
                    }
                    RePaymentBillReceiveEntryCollection con = rePaymentBill.getReceiveEntries();
                    RePaymentBillReceiveEntryCollection conNew = new RePaymentBillReceiveEntryCollection();
                    if (con.size() > 0) {
                        for (int i = 0; i < con.size(); ++i) {
                            if (con.get(i).getReceiveBillId().equals(botObj.getDestObjectID())) {
                                RePaymentBillReceiveEntryFactory.getLocalInstance(ctx).delete("where receiveBillId='" + botObj.getDestObjectID() + "'");
                                continue;
                            }
                            conNew.add(con.get(i));
                        }
                        rePaymentBill.getReceiveEntries().clear();
                        rePaymentBill.getReceiveEntries().addCollection(conNew);
                        this.buildReceiveBotpRelation(ctx, rePaymentBill);
                    }
                }
                mode = ",\u6536\u6b3e\u5355mode: " + bOTBillOperStateEnum;
            }
            String logStr = "\u8fd8\u6b3e\u5355\u53cd\u5199reverseSave number:" + rePaymentBill.getNumber() + ",state:" + (Object)((Object)rePaymentBill.getState()) + ",BOSType:" + type + mode;
            if (logStr.length() > 1500) {
                logStr = logStr.substring(0, 1500);
            }
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"reverseSave", (BOSObjectType)rePaymentBill.getBOSType(), (IObjectPK)new ObjectUuidPK(rePaymentBill.getId()), (String)logStr);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        }
    }

    public static String getVoucherNumber(Context ctx, RePaymentBillInfo repayBillInfo, IObjectCollection con, int reverseType) throws EASBizException, BOSException {
        String voucherNumbers = "";
        if (reverseType == 0) {
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                if (voucherNumbers.contains(con.getObject(i).getString("number"))) continue;
                voucherNumbers = con.getObject(i).getString("number") + "," + voucherNumbers;
            }
            if (voucherNumbers.length() > 1) {
                voucherNumbers = voucherNumbers.substring(0, voucherNumbers.length() - 1);
            }
        }
        return voucherNumbers;
    }

    public static String getVoucherNumber(Context ctx, RePaymentBillInfo repayBillInfo, VoucherInfo voucher, int reverseType) throws EASBizException, BOSException {
        String voucherNumbers = "";
        if (repayBillInfo.getString("voucherNumbers") != null) {
            voucherNumbers = repayBillInfo.getString("voucherNumbers");
        }
        if ((voucherNumbers = voucherNumbers + ",").contains(voucher.getString("number"))) {
            voucherNumbers = voucherNumbers.replace(voucher.getString("number") + ",", "");
        }
        if (voucherNumbers.length() > 1) {
            voucherNumbers = voucherNumbers.substring(0, voucherNumbers.length() - 1);
        }
        return voucherNumbers;
    }

    protected String _getBudgetConrolParamNumber(Context ctx) throws BOSException {
        return "CP001";
    }

    protected void checkOtherExpenseValid(Context ctx, RePaymentBillInfo info, boolean isShowAccountInfo, boolean checkStandard, boolean beforeYearCanNotSubmit, boolean applyDateBiggerThanCurrentMonth, Map paramMap) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(info.get("number"))) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        if (beforeYearCanNotSubmit) {
            Date date = new Date();
            if (info.getBizReqDate().before(date) && info.getBizReqDate().getYear() < date.getYear()) {
                throw new BizCollException(BizCollException.CANNOTSUBMITLASTYEARBILL);
            }
        }
        Date nextMonthFirstDate = BizCollUtil.getNextMonthFirstDate();
        if (null == info.getBizReqDate()) {
            throw new ExpAccException(ExpAccException.APPLY_DATE_NOT_NULL);
        }
        if (applyDateBiggerThanCurrentMonth && null != info.getBizReqDate() && info.getBizReqDate().compareTo(nextMonthFirstDate) >= 0) {
            throw new BizCollException(BizCollException.REQDATEMUSTLATER);
        }
        if (this.isSubmit && this.canNotSubmitHistoryPeriod && !this.billHasSubmit && (this.isRelaFi || this.isRelaCn) && this.checkEndDate1(this.isRelaFi, this.isRelaCn, ctx, info.getBizReqDate(), info.getApplierCompany())) {
            throw new BizCollException(BizCollException.END_DATE);
        }
        RePaymentBillEntryCollection entries = info.getEntries();
        RePaymentBillEntryInfo entryInfo = null;
        if (isShowAccountInfo && StringUtils.isEmpty((String)info.getPayerName())) {
            throw new BizCollException(BizCollException.PAYERNAMENOTNULL);
        }
        if (info.getCostCenter() != null && BizCollUtil.isSealUpCostCenter(ctx, info.getCostCenter())) {
            throw new BizCollException(BizCollException.COSTCENTERISSEALUP, new Object[]{info.getCostCenter().getName()});
        }
        if (entries.size() < 1) {
            throw new ExpenseReqException(ExpenseReqException.REPAY_NULL_ENTRY_EXCEPTION);
        }
        if (!StringUtils.isEmpty((String)info.getCause()) && info.getCause().length() > 1000) {
            throw new ExpenseReqException(ExpenseReqException.CAUSE_TOO_LONG);
        }
        ProjectInfo project = null;
        BigDecimal payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            BigDecimal loanAmountOri;
            entryInfo = entries.get(i);
            if (entryInfo.getId() == null) {
                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            }
            if (entryInfo.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (entryInfo.getAmount() == null || entryInfo.getAmountOri() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (!this.isEntryAmountZero && BizCollUtil.bigDecimalObjectLessEqual(entryInfo.getAmount(), BizCollUtil.ZERO)) {
                throw new ExpenseReqException(ExpenseReqException.NEGTIVE_ENTRY_AMOUNT_ERROR);
            }
            if (BizCollUtil.ZERO.compareTo(entryInfo.getAmount()) > 0) {
                throw new ExpenseReqException(ExpenseReqException.NEGTIVE_ENTRY_AMOUNT_ERROR);
            }
            if (!StringUtils.isEmpty((String)entryInfo.getRemark()) && entryInfo.getRemark().trim().length() > 200) {
                throw new ExpenseReqException(ExpenseReqException.COMMON_TO0_LONG);
            }
            project = entryInfo.getProject();
            if (project != null && project.getStatus().getValue() == 2) {
                throw new BizCollException(BizCollException.PROJECT_IS_CLOSED);
            }
            if (this.isSubmit && (entryInfo.getCurrency() == null || entryInfo.getLoanCurrency() == null)) {
                throw new ExpenseReqException(ExpenseReqException.TWOCURRENCYISNOTNULL, new Object[]{i + 1});
            }
            BigDecimal amountOri = entryInfo.getAmountOri();
            BigDecimal amount = entryInfo.getAmount();
            if (checkStandard) {
                BigDecimal loanAmount;
                BigDecimal bigDecimal = loanAmount = entryInfo.getLoanAmountBalance() != null ? entryInfo.getLoanAmountBalance() : BizCollUtil.ZERO;
                if (!(entryInfo.getCurrency().getId().equals((Object)entryInfo.getLoanCurrency().getId()) ? amount.compareTo(loanAmount) > 0 : amount.compareTo(loanAmount.add(payPrec)) > 0)) continue;
                throw new ExpenseReqException(ExpenseReqException.AMOUNT_NOT_LOANAMOUNTBALANCE, new Object[]{i + 1 + "", amount, loanAmount});
            }
            BigDecimal exchangeRate = entryInfo.getExchangeRate() == null ? BizCollUtil.ZERO : entryInfo.getExchangeRate();
            BigDecimal amountTmp = BizCollUtil.computeAmount(amountOri, entryInfo.getConvertMode(), exchangeRate);
            if (amountTmp.compareTo(amount) != 0) {
                throw new BizCollException(BizCollException.ENTRY_AMOUNT_ERROR, new Object[]{i + 1 + "", amount.toString(), amountOri.toString(), exchangeRate.toString()});
            }
            BigDecimal bigDecimal = loanAmountOri = entryInfo.getLoanAmountBalanceOri() != null ? entryInfo.getLoanAmountBalanceOri() : BizCollUtil.ZERO;
            if (amountOri.compareTo(loanAmountOri) <= 0) continue;
            throw new ExpenseReqException(ExpenseReqException.AMOUNTORI_NOT_LOANAMOUNTBALANCEORI, new Object[]{i + 1 + "", amountOri, loanAmountOri});
        }
        RePaymentBillReceiveEntryCollection receiveEntries = info.getReceiveEntries();
        if (this.isMustCheckReceive && this.isFromWFSubmit && !this.isWFSubmitNoApprove && receiveEntries.size() < 1) {
            throw new BizCollException(BizCollException.REPAYMENTBILLNOTRELATIONRECEIVEBILL);
        }
        RePaymentBillReceiveEntryInfo receiveInfo = null;
        BigDecimal tempAmount = BizCollUtil.ZERO;
        for (int i = 0; i < receiveEntries.size(); ++i) {
            receiveInfo = receiveEntries.get(i);
            if (receiveInfo.getReceiveAmountLoc() == null) continue;
            tempAmount = tempAmount.add(receiveInfo.getReceiveAmountLoc());
        }
        if (receiveEntries.size() > 0 && tempAmount.compareTo(info.getAmount()) != 0) {
            throw new BizCollException(BizCollException.RECEIVEAMOUNTMUSTEQUALRETURNAMOUNT);
        }
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherExpenseBillInfo info = (OtherExpenseBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new ExpenseReqException(ExpenseReqException.NUMBER_NOT_DUP);
        }
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountBalance"));
        return sic;
    }

    private static SelectorItemCollection getLoanSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isRepay"));
        return sic;
    }

    private SelectorItemCollection getRepaySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("repayDate"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        sic.add(new SelectorItemInfo("repayOrgUnit.id"));
        sic.add(new SelectorItemInfo("repayOrgUnit.name"));
        sic.add(new SelectorItemInfo("repayOrgUnit.number"));
        sic.add(new SelectorItemInfo("costCompany.id"));
        sic.add(new SelectorItemInfo("costCompany.name"));
        sic.add(new SelectorItemInfo("costCompany.number"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        return sic;
    }

    public void buildRepayLoanBotpRelation(Context ctx, RePaymentBillInfo info, RePaymentBillInfo infoOld, Map paramMap) throws EASBizException, BOSException {
        boolean needRebuildLoanBotp = BizCollUtil.checkEntryIsChange(ctx, (IObjectValue)info, (IObjectValue)infoOld, "entries", "sourceBillID", true, null);
        if (needRebuildLoanBotp) {
            if (infoOld != null) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).deleteBotpRelations((IObjectValue)info, paramMap);
                if (BizCollVersion.isRepayOld1Version(infoOld.getVersion())) {
                    BizAppUtil.updateLoanBillFlag(ctx, infoOld, false);
                }
            }
            CommonUtilFacadeFactory.getLocalInstance(ctx).createBotpRelationsCommon((IObjectValue)info, paramMap);
        }
    }

    public void buildReceiveBotpRelation(Context ctx, RePaymentBillInfo rePaymentBillInfo) throws EASBizException, BOSException, UuidException {
        RePaymentBillReceiveEntryCollection con = rePaymentBillInfo.getReceiveEntries();
        RePaymentBillReceiveEntryInfo info = null;
        if (rePaymentBillInfo.getId() != null) {
            BizCollUtil.deleteBotpRelationBySrcBillId(ctx, rePaymentBillInfo.getId().toString());
        }
        if (con.size() > 0) {
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                info = con.get(i);
                BizCollUtil.bulidBotpRelation(ctx, BizCollUtil.rePaymentBillBosType.toString(), rePaymentBillInfo.getId().toString(), BOSUuid.read((String)info.getReceiveBillId()).getType().toString(), info.getReceiveBillId());
            }
        }
    }

    public Map getParamMap(Context ctx, String companyId) throws EASBizException, BOSException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP032");
        paramList.add("CP035");
        paramList.add("CP047");
        paramList.add("CP049");
        paramList.add("CP056");
        paramList.add("CP03401");
        paramList.add("CP058");
        paramList.add("CP080");
        paramList.add("CP085");
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
        return paramMap;
    }

    public void checkBill(Context ctx, RePaymentBillInfo rePaymentBillInfo, RePaymentBillInfo infoOld, String operation) throws EASBizException, BOSException {
        if (rePaymentBillInfo.getId() == null) {
            rePaymentBillInfo.setId(BOSUuid.create((BOSObjectType)rePaymentBillInfo.getBOSType()));
        }
        this.setAmountByEntryAmount(rePaymentBillInfo);
        String applierCompanyId = rePaymentBillInfo.getApplierCompany().getId().toString();
        Map paramMap = this.getParamMap(ctx, applierCompanyId);
        this.isRelaFi = new Boolean(paramMap.get("CP002").toString());
        this.isRelaCn = new Boolean(paramMap.get("CP008").toString());
        boolean beforeYearCanNotSubmit = new Boolean(paramMap.get("CP047").toString());
        boolean applyDateBiggerThanCurrentMonth = paramMap.get("CP056") == null ? false : new Boolean(paramMap.get("CP056").toString());
        boolean isShowAccountInfo = paramMap.get("CP049") == null ? false : new Boolean(paramMap.get("CP049").toString());
        boolean checkStandard = "0".equals(paramMap.get("CP032").toString());
        this.isMustCheckReceive = paramMap.get("CP03401") == null ? false : new Boolean(paramMap.get("CP03401").toString());
        this.canNotSubmitHistoryPeriod = paramMap.get("CP058") == null ? true : new Boolean(paramMap.get("CP058").toString());
        this.isFromWFSubmit = rePaymentBillInfo.get("isfromwfsubmit") == null ? false : new Boolean(rePaymentBillInfo.get("isfromwfsubmit").toString());
        this.isWFSubmitNoApprove = rePaymentBillInfo.get("isWFSubmitNoApprove") == null ? false : new Boolean(rePaymentBillInfo.get("isWFSubmitNoApprove").toString());
        boolean bl = this.isEntryAmountZero = paramMap.get("CP085") == null ? false : new Boolean(paramMap.get("CP085").toString());
        if (operation.equals("submit") || this.isFromWFSubmit) {
            this.checkOtherExpenseValid(ctx, rePaymentBillInfo, isShowAccountInfo, checkStandard, beforeYearCanNotSubmit, applyDateBiggerThanCurrentMonth, paramMap);
        }
        rePaymentBillInfo.setCheckStandard(paramMap.get("CP032").toString());
    }

    public void reverseCheckEntry(Context ctx, RePaymentBillInfo rePaymentBillInfo, RePaymentBillInfo infoOld) throws EASBizException, BOSException {
        if (!BizCollVersion.isRepayOld1Version(rePaymentBillInfo.getVersion())) {
            if (infoOld != null && infoOld.getState().getValue() != 20 && infoOld.getState().getValue() != 40) {
                if (!rePaymentBillInfo.getCheckStandard().equals(infoOld.getCheckStandard()) || this.isEntryChange(infoOld.getEntries(), rePaymentBillInfo.getEntries())) {
                    BizAppUtil.reverseSaveLoanBill(ctx, infoOld, false, false);
                    BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, true, false);
                } else {
                    logger.error((Object)("####reverseCheckEntry isEntryChange is false,nubmer=" + rePaymentBillInfo.getNumber()));
                    BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, true, true);
                }
            } else {
                BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, true, false);
            }
        } else {
            BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, true, true);
        }
    }

    public boolean isEntryChange(RePaymentBillEntryCollection entriesNew, RePaymentBillEntryCollection entriesOld) {
        int sizeOld;
        int sizeNew = entriesNew.size();
        if (sizeNew != (sizeOld = entriesOld.size())) {
            return true;
        }
        ArrayList<String> idsNew = new ArrayList<String>();
        for (int i = 0; i < sizeNew; ++i) {
            RePaymentBillEntryInfo entryInfoNew = entriesNew.get(i);
            String sourceBillEntryId = entryInfoNew.getSourceBillEntryId();
            BigDecimal amountOri = entryInfoNew.getAmountOri();
            String amountOriStr = amountOri == null ? BizCollUtil.ZERO.toString() : amountOri.stripTrailingZeros().toPlainString();
            BigDecimal amount = entryInfoNew.getAmount();
            String amountStr = amount == null ? BizCollUtil.ZERO.toString() : amount.stripTrailingZeros().toPlainString();
            idsNew.add(sourceBillEntryId + amountOriStr + amountStr);
        }
        ArrayList<String> idsOld = new ArrayList<String>();
        for (int j = 0; j < sizeOld; ++j) {
            RePaymentBillEntryInfo entryInfoOld = entriesOld.get(j);
            String sourceBillEntryId = entryInfoOld.getSourceBillEntryId();
            BigDecimal amountOri = entryInfoOld.getAmountOri();
            String amountOriStr = amountOri == null ? BizCollUtil.ZERO.toString() : amountOri.stripTrailingZeros().toPlainString();
            BigDecimal amount = entryInfoOld.getAmount();
            String amountStr = amount == null ? BizCollUtil.ZERO.toString() : amount.stripTrailingZeros().toPlainString();
            idsOld.add(sourceBillEntryId + amountOriStr + amountStr);
        }
        return !idsNew.containsAll(idsOld) || !idsOld.containsAll(idsNew);
    }

    public void buildRepayBotpRelation(Context ctx, RePaymentBillInfo rePaymentBillInfo, RePaymentBillInfo infoOld) throws EASBizException, BOSException {
        boolean needRebuildReceiveBotp = BizCollUtil.checkEntryIsChange(ctx, (IObjectValue)rePaymentBillInfo, (IObjectValue)infoOld, "receiveEntries", "receiveBillId", false, null);
        if (needRebuildReceiveBotp) {
            this.buildReceiveBotpRelation(ctx, rePaymentBillInfo);
        }
        this.buildRepayLoanBotpRelation(ctx, rePaymentBillInfo, infoOld, null);
        if (BizCollVersion.isRepayOld1Version(rePaymentBillInfo.getVersion())) {
            BizAppUtil.updateLoanBillFlag(ctx, rePaymentBillInfo, true);
        }
    }

    public boolean checkEndDate1(boolean b1, boolean b2, Context ctx, Date bizReqDate, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        boolean result = false;
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, company, SystemEnum.CASHMANAGEMENT);
        PeriodInfo periodInfo1 = this.getPeriodInfo(ctx, company, SystemEnum.GENERALLEDGER);
        if (periodInfo == null || periodInfo1 == null) {
            logger.error((Object)"####checkEndDate1 periodInfo is null");
            return false;
        }
        boolean b11 = true;
        boolean b22 = true;
        if (b1) {
            b11 = bizReqDate.before(periodInfo1.getBeginDate());
        }
        if (b2) {
            b22 = bizReqDate.before(periodInfo.getBeginDate());
        }
        result = b1 && b2 ? b11 || b22 : b11 && b22;
        return result;
    }

    public PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo company, SystemEnum systemEnum) throws EASBizException, BOSException {
        PeriodInfo periodInfo = null;
        periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)company);
        return periodInfo;
    }

    @Override
    protected void _abandon(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _ngisc_audit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        StateEnum stateOld;
        model.put("isFromCq", (Object)Boolean.TRUE);
        model.put("sourceSystem", (Object)20);
        RePaymentBillInfo rePaymentBillInfo = (RePaymentBillInfo)model;
        RePaymentBillInfo infoOld = null;
        if (rePaymentBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId())) && (stateOld = (infoOld = this.getRePaymentBillInfo(ctx, (IObjectPK)new ObjectUuidPK(rePaymentBillInfo.getId()))).getState()) != null && stateOld.getValue() >= 60) {
            throw new BizCollException(BizCollException.CAN_NOT_SUBMIT, new Object[]{stateOld.getAlias()});
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP032");
        String applierCompanyId = rePaymentBillInfo.getApplierCompany().getId().toString();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        rePaymentBillInfo.setCheckStandard(paramMap.get("CP032").toString());
        this._save(ctx, pk, (IObjectValue)model);
        this.reverseCheckEntry(ctx, rePaymentBillInfo, infoOld);
        this.buildRepayLoanBotpRelation(ctx, rePaymentBillInfo, infoOld, null);
        boolean needRebuildReceiveBotp = BizCollUtil.checkEntryIsChange(ctx, (IObjectValue)rePaymentBillInfo, (IObjectValue)infoOld, "receiveEntries", "receiveBillId", false, null);
        if (needRebuildReceiveBotp) {
            this.buildReceiveBotpRelation(ctx, rePaymentBillInfo);
        }
        this.setImageNo(ctx, rePaymentBillInfo);
        BOSUuid auditorId = model.getAuditor() == null ? null : model.getAuditor().getId();
        RePaymentFacadeFactory.getLocalInstance(ctx).setAudit(model.getId(), auditorId);
    }

    @Override
    protected void _ngisc_submit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        logger.info((Object)("##_ngisc_submit pk:" + pk));
        model.put("isFromCq", (Object)Boolean.TRUE);
        model.put("sourceSystem", (Object)20);
        RePaymentBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)model);
    }

    @Override
    protected void _ngisc_reverse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().getServiceState().enableServices();
        super._ngisc_reverse(ctx, pk);
        logger.info((Object)String.format("\u96c6\u6210\u4e91\u53cd\u5199\u64cd\u4f5c_isc_reverse\uff1a%s", pk));
    }

    @Override
    protected void _ngisc_unsubmit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        this.isFromCq = true;
        logger.info((Object)("##_ngisc_unsubmit pk:" + pk));
        BOSUuid auditorId = model.getAuditor() == null ? null : model.getAuditor().getId();
        this.endWorkFlow(ctx, pk);
        RePaymentBillInfo rePaymentBillInfo = (RePaymentBillInfo)model;
        if (!BizCollVersion.isRepayOld1Version(rePaymentBillInfo.getVersion())) {
            BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, false, false);
        }
        rePaymentBillInfo.setState(StateEnum.DRAFT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        this.updatePartial(ctx, (CoreBaseInfo)rePaymentBillInfo, selector);
        this._delete(ctx, pk);
    }

    private void endWorkFlow(Context ctx, Object bizObjectId) throws BOSException, WfException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
        enactmentService.abortProcessByHoldedObjectId(bizObjectId.toString());
        logger.info((Object)("##endWorkFlow  bizObjectId:" + bizObjectId));
    }

    @Override
    protected void _ngisc_unaudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        logger.info((Object)("##_ngisc_unaudit pk:" + pk));
        this.isFromCq = true;
        BOSUuid auditorId = model.getAuditor() == null ? null : model.getAuditor().getId();
        RePaymentFacadeFactory.getLocalInstance(ctx).setAntiAudit(BOSUuid.read((String)pk.toString()), auditorId);
        this._delete(ctx, pk);
    }

    protected void checkUpdatePermission(Context ctx, UserInfo userInfo, String companyId) throws EASBizException, BOSException {
        if (!this.isFromWFSubmit) {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(companyId), "cp_bc_RePaymentBill_Update");
        }
    }
}

