/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractRecordsOfLendAndRepayUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordsOfLendAndRepayUIHandler
extends AbstractRecordsOfLendAndRepayUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.RecordsOfLendAndRepayUIHandler");

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    @Override
    protected void _handleActionQuery(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private Map dealWithTime(Object currentTime) {
        Map dateMap = new HashMap();
        if (currentTime instanceof Timestamp) {
            dateMap = this.dealWithTime((Timestamp)currentTime);
        }
        return dateMap;
    }

    private Map dealWithTime(Timestamp currentTime) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        int year = currentTime.getYear();
        int month = currentTime.getMonth();
        Date startDate = new Date(year, month, 1);
        Date endDate = month == 12 ? new Date(year + 1, 1, 1) : new Date(year, month + 1, 1);
        dateMap.put("startDate", startDate);
        dateMap.put("endDate", endDate);
        return dateMap;
    }

    private EntityViewInfo prepareConditionForLoanQuery(Date[] dateArray, PersonInfo applierInfo, Object currentTime, Map paramMap) {
        Map dateMap = this.dealWithTime(currentTime);
        Object startDate = dateMap.get("startDate");
        Object endDate = dateMap.get("endDate");
        boolean isRelaFi = new Boolean(paramMap.get("CP002").toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amountApproved"));
        selector.add(new SelectorItemInfo("bizReqDate"));
        FilterInfo filter = new FilterInfo();
        if (dateArray == null) {
            filter.getFilterItems().add(new FilterItemInfo("bizReqDate", startDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bizReqDate", endDate, CompareType.LESS));
        }
        filter.getFilterItems().add(new FilterItemInfo("applier", (Object)applierInfo.getId(), CompareType.EQUALS));
        if (isRelaFi) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ISPAYBILL, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ALREADYVOUCHER, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CLOSED, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CHECKED, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ALREADYPAYMENT, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4 or #5 or #6 or #7)");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CHECKED, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CLOSED, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sii = new SorterItemInfo("bizReqDate");
        sii.setSortType(SortType.ASCEND);
        evi.getSorter().add(sii);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        return evi;
    }

    private EntityViewInfo getConditionForLoanQuery(RequestContext request, ResponseContext response, Context context, FilterInfo filter) throws EASBizException, BOSException {
        EntityViewInfo vo = new EntityViewInfo();
        FilterInfo filterInfo = filter;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amountApproved"));
        selector.add(new SelectorItemInfo("bizReqDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("amountUsed"));
        selector.add(new SelectorItemInfo("loanState"));
        selector.add(new SelectorItemInfo("id"));
        if (this.isRelatingWithFinance(request, response, context)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ISPAYBILL, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ALREADYVOUCHER, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CLOSED, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CHECKED, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.ALREADYPAYMENT, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4 or #5 or #6 or #7)");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CHECKED, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)StateEnum.CLOSED, CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        }
        vo.setFilter(filter);
        SorterItemInfo sii = new SorterItemInfo("bizReqDate");
        sii.setSortType(SortType.ASCEND);
        vo.getSorter().add(sii);
        vo.getSelector().addObjectCollection((IObjectCollection)selector);
        return vo;
    }

    private EntityViewInfo prepareConditionForReturnQuery(Date[] dateArray, PersonInfo applierInfo, Object currentTime) {
        Map dateMap = this.dealWithTime(currentTime);
        Object startDate = dateMap.get("startDate");
        Object endDate = dateMap.get("endDate");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("returnDate"));
        selector.add(new SelectorItemInfo("returnAmount"));
        selector.add(new SelectorItemInfo("amountApproved"));
        selector.add(new SelectorItemInfo("amountUsed"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applier", (Object)applierInfo.getId(), CompareType.EQUALS));
        if (dateArray == null) {
            filter.getFilterItems().add(new FilterItemInfo("returnDate", startDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("returnDate", endDate, CompareType.LESS));
        }
        filter.getFilterItems().add(new FilterItemInfo("loanstate", (Object)"Y", CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SorterItemInfo sii = new SorterItemInfo("returnDate");
        sii.setSortType(SortType.ASCEND);
        evi.getSorter().add(sii);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        return evi;
    }

    public void handlePrepareRelatingWithFinance(RequestContext request, ResponseContext response, Context context) throws BOSException, EASBizException {
        if ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company) != null && ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company)).getId() != null) {
            BOSUuid companyId = ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company)).getId();
            IParamControl iParam = null;
            iParam = ParamControlFactory.getLocalInstance((Context)context);
            iParam.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CP002");
        }
    }

    private boolean isRelatingWithFinance(RequestContext request, ResponseContext response, Context context) throws BOSException, EASBizException {
        if ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company) != null && ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company)).getId() != null) {
            BOSUuid companyId = ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)OrgType.Company)).getId();
            IParamControl iParam = null;
            try {
                iParam = ParamControlFactory.getLocalInstance((Context)context);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            String value = null;
            try {
                value = iParam.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CP002");
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            if ("true".equals(value)) {
                return true;
            }
        }
        return false;
    }
}

