/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizBaseDataException;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.EvectionLoanBillException;
import com.kingdee.eas.cp.bc.IReimburseLevel;
import com.kingdee.eas.cp.bc.IStaffReimburseLevelSetting;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingFactory;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingInfo;
import com.kingdee.eas.cp.bc.app.AbstractReimburseLevelControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.ReimburseLevelStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReimburseLevelControllerBean
extends AbstractReimburseLevelControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ReimburseLevelControllerBean");
    private static final int MAX_NAME_LENGTH = 255;
    private static final int MAX_NUMBUER_LENGTH = 80;

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private void checkInfo(Context ctx, IObjectValue model) throws EASBizException {
        ReimburseLevelInfo info = (ReimburseLevelInfo)model;
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
        if (info.getName().trim().length() > 255) {
            throw new BizBaseDataException(BizBaseDataException.NAME_TOO_LONG, new Object[]{255});
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_TOO_LONG);
        }
    }

    @Override
    protected void _auditStaffReimburseLevel(Context ctx, List personIds, boolean isAudit) throws BOSException, EASBizException {
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        StringBuilder idListStr = new StringBuilder();
        for (Object personId : personIds) {
            idListStr.append("'").append(personId.toString()).append("',");
        }
        boolean isStaffSetId = true;
        ObjectUuidPK objectUuidPK = new ObjectUuidPK((String)personIds.get(0));
        if (new PersonInfo().getBOSType().equals((Object)objectUuidPK.getObjectType())) {
            isStaffSetId = false;
        }
        String idsStr = idListStr.toString().replaceAll(",$", "");
        String sql = isStaffSetId ? "UPDATE T_BC_STAFFREIMBURSELEVELSET SET FSTATE = ? WHERE FID IN (%s)" : "UPDATE T_BC_STAFFREIMBURSELEVELSET SET FSTATE = ? WHERE FPERSONID IN (%s)";
        sql = String.format(sql, idsStr);
        int fState = isAudit ? 20 : 10;
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{fState});
    }

    @Override
    protected void _enableReimburseLevel(Context ctx, List reimburseLevelIds, boolean isEnable) throws BOSException, EASBizException {
        IReimburseLevel reiburseLevel = ReimburseLevelFactory.getLocalInstance(ctx);
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (Object reimburseLevelId : reimburseLevelIds) {
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId.toString()));
            reimburseLevelInfo.setState(EnableStateEnum.getEnum(isEnable ? 1 : 0));
            coreBaseCollection.add((CoreBaseInfo)reimburseLevelInfo);
        }
        reiburseLevel.updateBatchData(coreBaseCollection);
    }

    @Deprecated
    protected Map _getAdminOrgUnitFilter(Context ctx, String companyOrgUnit) throws BOSException, EASBizException {
        HashMap<String, Object> adminOrgUnitGroup = new HashMap<String, Object>();
        adminOrgUnitGroup.put("field", "adminOrgUnit");
        adminOrgUnitGroup.put("dataType", "ObjectValue");
        adminOrgUnitGroup.put("title", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"DEPARTMENT", (Locale)ctx.getOriginLocale()));
        adminOrgUnitGroup.put("miltiSelect", false);
        adminOrgUnitGroup.put("displayCount", 8);
        adminOrgUnitGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT DISTINCT ADMINORGUNIT.FID AS ADMINORGUNITID, ADMINORGUNIT.FNAME_L2 AS ADMINORGUNITNAME ").append("FROM T_BD_PERSON AS PERSON ").append("INNER JOIN T_ORG_POSITIONMEMBER AS POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPERSONID ").append("INNER JOIN T_ORG_POSITION AS POSITION ON POSITIONMEMBER.FPOSITIONID = POSITION.FID ").append("INNER JOIN T_ORG_ADMIN AS ADMINORGUNIT ON POSITION.FADMINORGUNITID = ADMINORGUNIT.FID ").append("INNER JOIN T_ORG_UNITRELATION AS ORGUNITRELATION ON ADMINORGUNIT.FID = ORGUNITRELATION.FFROMUNITID ").append("INNER JOIN T_ORG_COMPANY AS COMPANYORGUNIT ON ORGUNITRELATION.FTOUNITID = COMPANYORGUNIT.FID ").append("WHERE POSITIONMEMBER.FISPRIMARY = 1 AND COMPANYORGUNIT.FID = '").append(companyOrgUnit).append("'");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (result.next()) {
                String adminOrgUnitId = result.getString("ADMINORGUNITID");
                String adminOrgUnitName = result.getString("ADMINORGUNITNAME");
                HashMap<String, String> filterMap = new HashMap<String, String>();
                filterMap.put("alias", adminOrgUnitName);
                filterMap.put("value", adminOrgUnitId);
                filterItems.add(filterMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        adminOrgUnitGroup.put("filterItems", filterItems);
        return adminOrgUnitGroup;
    }

    @Override
    protected List _getGroupFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String[] cuIds = CommonDataWebUtils.getParentCuIds(ctx, companyInfo.getCU().getId().toString());
        String cuIdsFilter = CommonDataWebUtils.getParentCuIdsFilter(ctx, companyInfo.getCU().getId().toString());
        HashSet<String> cuIdSet = new HashSet<String>(Arrays.asList(cuIds));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.number", cuIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection reimburseLevels = ReimburseLevelFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
        HashMap<String, Object> reimburseLevelGroup = new HashMap<String, Object>();
        reimburseLevelGroup.put("field", "reimburseLevel.id");
        reimburseLevelGroup.put("dataType", "ObjectValue");
        reimburseLevelGroup.put("title", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"REIMBURSELEVEL", (Locale)ctx.getOriginLocale()));
        reimburseLevelGroup.put("miltiSelect", false);
        reimburseLevelGroup.put("displayCount", 8);
        reimburseLevelGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        reimburseLevelGroup.put("filterItems", filterItems);
        reimburseLevelGroup.put("cuIdsFilter", cuIdsFilter);
        HashMap<String, Object> noReimburseLevelMap = new HashMap<String, Object>();
        noReimburseLevelMap.put("alias", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"BLANK_NO_WRITE", (Locale)ctx.getOriginLocale()));
        noReimburseLevelMap.put("value", "null");
        noReimburseLevelMap.put("isDefault", false);
        filterItems.add(noReimburseLevelMap);
        int is = reimburseLevels.size();
        for (int i = 0; i < is; ++i) {
            ReimburseLevelInfo reimburseLevelInfo = (ReimburseLevelInfo)reimburseLevels.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", reimburseLevelInfo.getName());
            filterMap.put("value", reimburseLevelInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        resultList.add(reimburseLevelGroup);
        return resultList;
    }

    @Override
    @Deprecated
    protected List _initCompanyOrgUnitTree(Context ctx) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = user.getId().toString();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FLONGNUMBER, TPOR.FORGID ").append("FROM T_PM_ORGRANGE TPOR INNER JOIN T_ORG_COMPANY TOC ON TPOR.FORGID = TOC.FID ").append("WHERE TPOR.FTYPE = ? AND TPOR.FUSERID = ? ");
        Object[] params = new Object[]{10, userId};
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
        if (result == null || result.size() == 0) {
            return null;
        }
        List<Object> treeList = new ArrayList();
        HashSet<String> numberSet = new HashSet<String>();
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (result.next()) {
                String id = result.getObject("FORGID").toString();
                idList.add(id);
                String longNumber = result.getObject("FLONGNUMBER").toString();
                String[] numbers = longNumber.split("!");
                for (int i = 0; i < numbers.length; ++i) {
                    String number = numbers[i];
                    numberSet.add(number);
                }
            }
            treeList = this.queryNodeByNumber(ctx, numberSet, idList);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return treeList;
    }

    protected List<Map<String, Object>> queryNodeByNumber(Context context, Set<String> numbers, List<String> idList) throws BOSException, SQLException {
        StringBuffer querySql = new StringBuffer();
        StringBuffer numberSb = new StringBuffer("(");
        for (String str : numbers) {
            numberSb.append("'" + str + "',");
        }
        String numberStr = numberSb.toString().replaceAll(",$", ")");
        querySql.append("SELECT FID, FNUMBER, FNAME_L2, FPARENTID ").append("FROM T_ORG_COMPANY TOC ").append("WHERE TOC.FNUMBER IN ").append(numberStr);
        IRowSet result = DbUtil.executeQuery((Context)context, (String)querySql.toString());
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>();
        while (result.next()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            HashMap dataMap = new HashMap();
            String id = (String)result.getObject("FID");
            String name = (String)result.getObject("FNAME_L2");
            String parentId = (String)result.getObject("FPARENTID");
            if (idList.contains(id)) {
                resultMap.put("isCompanyOrgUnit", true);
            }
            resultMap.put("open", true);
            resultMap.put("id", id);
            resultMap.put("data", dataMap);
            resultMap.put("name", name);
            resultMap.put("pId", parentId);
            resultMapList.add(resultMap);
        }
        return resultMapList;
    }

    @Override
    protected void _saveStaffReimburseLevel(Context ctx, String personId, String reimburseLevelId) throws BOSException, EASBizException {
        IStaffReimburseLevelSetting staffReimburseLS = StaffReimburseLevelSettingFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        staffReimburseLS.delete(filterInfo);
        if (StringUtils.isNotEmpty((String)reimburseLevelId)) {
            StaffReimburseLevelSettingInfo staffReimburseLSInfo = new StaffReimburseLevelSettingInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId));
            staffReimburseLSInfo.setPerson(personInfo);
            staffReimburseLSInfo.setReimburseLevel(reimburseLevelInfo);
            staffReimburseLSInfo.setState(ReimburseLevelStateEnum.UnSubmit);
            staffReimburseLS.addnew(staffReimburseLSInfo);
        }
    }

    @Override
    protected void _saveStaffReimburseLevels(Context ctx, List personIdList, String reimburseLevelId) throws BOSException, EASBizException {
        if (personIdList == null || personIdList.size() == 0) {
            return;
        }
        HashSet personIdSet = new HashSet(personIdList);
        IStaffReimburseLevelSetting staffReimburseLS = StaffReimburseLevelSettingFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIdSet, CompareType.INCLUDE));
        staffReimburseLS.delete(filterInfo);
        if (StringUtils.isBlank((String)reimburseLevelId)) {
            return;
        }
        CoreBaseCollection staffReimburseCollection = new CoreBaseCollection();
        for (Object personId : personIdList) {
            StaffReimburseLevelSettingInfo staffReimburseLSInfo = new StaffReimburseLevelSettingInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId.toString()));
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId));
            staffReimburseLSInfo.setPerson(personInfo);
            staffReimburseLSInfo.setReimburseLevel(reimburseLevelInfo);
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            staffReimburseLSInfo.setCU(cu);
            staffReimburseCollection.add((CoreBaseInfo)staffReimburseLSInfo);
        }
        staffReimburseLS.addnewBatchData(staffReimburseCollection);
    }

    @Override
    @Deprecated
    protected Map _getAdminOrgUnitFilter(Context ctx, List companyOrgUnits) throws BOSException, EASBizException {
        if (companyOrgUnits.size() == 1 && StringUtils.isBlank((String)((String)companyOrgUnits.get(0)))) {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            FilterInfo queryOrgRangeFilter = new FilterInfo();
            queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
            queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE));
            queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("org.isCompanyOrgUnit", (Object)true));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(queryOrgRangeFilter);
            OrgRangeCollection orgRangeCollection = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgRangeCollection(entityViewInfo);
            int is = orgRangeCollection.size();
            for (int i = 0; i < is; ++i) {
                companyOrgUnits.add(orgRangeCollection.get(i).getOrg().getId().toString());
            }
        }
        HashMap<String, Object> adminOrgUnitGroup = new HashMap<String, Object>();
        adminOrgUnitGroup.put("field", "adminOrgUnit.id");
        adminOrgUnitGroup.put("dataType", "ObjectValue");
        adminOrgUnitGroup.put("title", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"DEPARTMENT", (Locale)ctx.getOriginLocale()));
        adminOrgUnitGroup.put("miltiSelect", false);
        adminOrgUnitGroup.put("displayCount", 8);
        adminOrgUnitGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT DISTINCT ADMINORGUNIT.FID AS ADMINORGUNITID, ADMINORGUNIT.FNAME_L2 AS ADMINORGUNITNAME ").append("FROM T_BD_PERSON AS PERSON ").append("INNER JOIN T_ORG_POSITIONMEMBER AS POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPERSONID ").append("INNER JOIN T_ORG_POSITION AS POSITION ON POSITIONMEMBER.FPOSITIONID = POSITION.FID ").append("INNER JOIN T_ORG_ADMIN AS ADMINORGUNIT ON POSITION.FADMINORGUNITID = ADMINORGUNIT.FID ").append("INNER JOIN T_ORG_UNITRELATION AS ORGUNITRELATION ON ADMINORGUNIT.FID = ORGUNITRELATION.FFROMUNITID ").append("INNER JOIN T_ORG_COMPANY AS COMPANYORGUNIT ON ORGUNITRELATION.FTOUNITID = COMPANYORGUNIT.FID ").append("WHERE POSITIONMEMBER.FISPRIMARY = 1 AND COMPANYORGUNIT.FID in (");
        int js = companyOrgUnits.size();
        for (int j = 0; j < js; ++j) {
            querySql.append("'" + companyOrgUnits.get(j) + "',");
        }
        querySql.deleteCharAt(querySql.length() - 1).append(")");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (result.next()) {
                String adminOrgUnitId = result.getString("ADMINORGUNITID");
                String adminOrgUnitName = result.getString("ADMINORGUNITNAME");
                HashMap<String, String> filterMap = new HashMap<String, String>();
                filterMap.put("alias", adminOrgUnitName);
                filterMap.put("value", adminOrgUnitId);
                filterItems.add(filterMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        adminOrgUnitGroup.put("filterItems", filterItems);
        return adminOrgUnitGroup;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReimburseLevelInfo info = (ReimburseLevelInfo)model;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        info.setCompany(company);
        this.checkInfo(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        return super._save(ctx, model);
    }

    @Override
    protected Map _getListFilter(Context ctx, String cuId) throws BOSException, EASBizException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] cuIdsFilter = null;
        if (cuId != null) {
            cuIdsFilter = CommonDataWebUtils.getParentCuIds(ctx, cuId);
        }
        map.put("cuIdsFilter", cuIdsFilter);
        return map;
    }

    @Override
    protected Map _getCusPermission(Context ctx, List cuIds) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        HashMap<String, String> result = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        for (int i = 0; i < cuIds.size(); ++i) {
            boolean isHasEditPermission = false;
            isHasEditPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(cuIds.get(i).toString()), "cp_bc_ReimburseLevel_Edit");
            map.put(cuIds.get(i).toString(), isHasEditPermission);
        }
        String json = JSONUtils.convertObjectToJson((Context)ctx, map);
        result.put("permissions", json);
        return result;
    }

    @Override
    protected Set _getCuSet(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String[] cuIds = CommonDataWebUtils.getParentCuIds(ctx, companyInfo.getCU().getId().toString());
        HashSet<String> cuIdSet = new HashSet<String>(Arrays.asList(cuIds));
        return cuIdSet;
    }

    @Override
    public Set getReimburseLevelIds(Context ctx, String companyId) throws BOSException, EASBizException {
        if (companyId == null) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String ctrlId = companyInfo.getCU().getId().toString();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FREIMBURSELEVELID  FROM T_BC_EVECTIONSTANDARD ").append("WHERE FCONTROLUNITID = ? AND FSTATE = 1 ").append("UNION ").append("SELECT FREIMBURSELEVELID  FROM T_BC_EVECTIONSTANDARD ES ,T_BC_EVECTIONSTANDARDASSIGNCU ESACU , T_ORG_CtrlUnit CU ").append("WHERE ESACU.FEVECTIONSTANDARDID = ES.FID AND ES.FCONTROLUNITID = CU.fid ").append(" AND ES.FSTATE = 1 AND ESACU.FASSIGNCUID = ?");
        Object[] params = new Object[]{ctrlId, ctrlId};
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
        if (result == null || result.size() == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (result.next()) {
                idSet.add(result.getString("FREIMBURSELEVELID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return idSet;
    }
}

