/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ImageStateEnum;
import com.kingdee.eas.cp.bc.SSCUnitFactory;
import com.kingdee.eas.cp.bc.SSCUnitInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.helper.WebServiceUtil;
import com.kingdee.eas.cp.bc.image.BaseImageInfo;
import com.kingdee.eas.cp.bc.image.BaseImageList;
import com.kingdee.eas.cp.bc.image.SSCImageUtils;
import com.kingdee.eas.cp.bc.image.SSCXMLTrans;
import com.kingdee.eas.cp.trd.webservice.image.AEServiceException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;

public class SSCTaskCenterHandler {
    private static String res = "com.kingdee.eas.cp.bc.BizCollResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.SSCTaskCenterHandler");

    IQueryExecutor getPersonListQueryExecutor(Context ctx, String currentOrgId) {
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.getPersonQueryPK());
        queryExcu.setObjectView(this.buildPersonViewInfo(currentOrgId));
        return queryExcu;
    }

    EntityViewInfo buildPersonViewInfo(String currentOrgId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)currentOrgId));
        return viewInfo;
    }

    MetaDataPK getPersonQueryPK() {
        return new MetaDataPK("com.kingdee.eas.cp.bc.app.PersonQuery");
    }

    IQueryExecutor getHandlerListQueryExecutor(Context ctx, String sscUnitId) {
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.getHandlerQueryPK());
        queryExcu.setObjectView(this.buildHandlerViewInfo(sscUnitId));
        return queryExcu;
    }

    String getPostAddressId(Context ctx, String imageNo, String billId) throws BOSException, EASBizException {
        if (billId == null || billId.length() == 0) {
            logger.info((Object)"getPostAddressId:billId is null");
            return null;
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(BOSUuid.read((String)billId));
        ExpenseAccountBillInfo billInfo = null;
        BOSObjectType type = uuidPK.getObjectType();
        if (type.toString().equals("4A44F49F")) {
            billInfo = BizAccountBillFactory.getLocalInstance(ctx).getBizAccountBillInfo("select postAddress.id,postAddress.sscCenter where id='" + billId + "'");
        } else if (type.toString().equals("92F938DD")) {
            billInfo = BizAccountOutBillFactory.getLocalInstance(ctx).getBizAccountOutBillInfo("select postAddress.id,postAddress.sscCenter where id='" + billId + "'");
        } else if (type.toString().equals("C57003BC")) {
            billInfo = TravelAccountBillFactory.getLocalInstance(ctx).getTravelAccountBillInfo("select postAddress.id,postAddress.sscCenter where id='" + billId + "'");
        } else if (type.toString().equals("30BD2798")) {
            billInfo = DailyPurchaseAccountBillFactory.getLocalInstance(ctx).getDailyPurchaseAccountBillInfo("select postAddress.id,postAddress.sscCenter where id='" + billId + "'");
        } else {
            return null;
        }
        if (null != billInfo && null != billInfo.getPostAddress()) {
            logger.info((Object)("billInfo postAddress is:" + billInfo.getPostAddress()));
            String result = null;
            boolean localRescan = false;
            try {
                result = WebServiceUtil.getImageWsServiceInstance().getImageStatusInfo(this.buildImageNoXml(imageNo));
                if (result != null) {
                    result = result.replaceAll("\n|\r|%0d|%0a|%0A|%0D", "_");
                }
                logger.info((Object)("ImageStatus is" + result));
                if (result != null && result.indexOf("status") != -1 && (result = result.substring(result.indexOf("status") + 8, result.indexOf("status") + 9)).equals("0")) {
                    localRescan = true;
                }
                logger.info((Object)("localRescan:" + localRescan + ",isSScCenter:" + billInfo.getPostAddress().isIsSscCenter()));
                if (billInfo.getPostAddress().isIsSscCenter() || localRescan) {
                    return billInfo.getPostAddress().getId().toString();
                }
                SSCUnitInfo unitInfo = (SSCUnitInfo)SSCUnitFactory.getLocalInstance(ctx).getValue("select parent.id,id where id='" + billInfo.getPostAddress().getId().toString() + "'");
                return unitInfo.getParent().getId().toString();
            }
            catch (AEServiceException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)((Object)e));
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    void updateSrcBillState(Context ctx, String imageNo, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        BOSObjectType type = new ObjectUuidPK(BOSUuid.read((String)billId)).getObjectType();
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)pk);
        ((BizCollBillBaseInfo)value).setIsRefPaperPark(ImageStateEnum.RESCAN_IAMGE);
        DynamicObjectFactory.getLocalInstance((Context)ctx).update(type, (IObjectPK)pk, value);
    }

    void getBillApplier(Context ctx, String imageNo, String billId, Set personSet) throws BOSException, EASBizException, SQLException {
        logger.info((Object)("getBillApplier,billId:" + billId + ",imageNo:" + imageNo));
        Object billInfo = null;
        String tableName = "";
        BOSObjectType type = new ObjectUuidPK(BOSUuid.read((String)billId)).getObjectType();
        if (type.toString().equals("4A44F49F")) {
            tableName = "T_BC_BizAccountBill";
        } else if (type.toString().equals("92F938DD")) {
            tableName = "T_BC_BizAccountOutBill";
        } else if (type.toString().equals("C57003BC")) {
            tableName = "T_BC_TravelAccountBill";
        } else if (type.toString().equals("30BD2798")) {
            tableName = "T_BC_DailyPurchaseAccountBill";
        }
        String sql = "select FApplierID from " + tableName + " where fid='" + billId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                String applierId = rowSet.getString("FApplierID");
                if (applierId == null) continue;
                personSet.add(applierId);
            }
        }
    }

    EntityViewInfo buildHandlerViewInfo(String sscUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sscUnit.id", (Object)sscUnitId));
        return viewInfo;
    }

    MetaDataPK getHandlerQueryPK() {
        return new MetaDataPK("com.kingdee.eas.cp.bc.app.SSCUnitHandlerQuery");
    }

    String buildImageNoXml(String imageNo) {
        String result = null;
        SSCXMLTrans xmlTrans = new SSCXMLTrans();
        BaseImageList newList = new BaseImageList();
        BaseImageInfo imageInfo = new BaseImageInfo();
        imageInfo.setImageNo(imageNo);
        newList.addImageList(imageInfo);
        result = xmlTrans.bulidXml(newList);
        System.out.print("lutest=" + result);
        return result;
    }

    boolean isImageReady(Context ctx, String imageNo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isRefPaperPark", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("imageNo", (Object)imageNo));
        if ("TA".equals(SSCImageUtils.getPrefix(imageNo))) {
            return TravelAccountBillFactory.getLocalInstance(ctx).exists(filter);
        }
        return BizAccountBillFactory.getLocalInstance(ctx).exists(filter);
    }

    public void sendMail(Context ctx, Set idset, String billId, String imageNumber, String reason) {
        try {
            if (idset != null && idset.size() > 0) {
                String billNumber = imageNumber;
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                BizCollBillBaseInfo sourceinfo = (BizCollBillBaseInfo)iDynamicObject.getValue(BizCollUtil.getBOSType(billId), "select number where id='" + billId + "'");
                if (sourceinfo != null) {
                    billNumber = sourceinfo.getNumber();
                }
                String to = this.getMailPersonStr(ctx, idset);
                System.out.print("************************ to=" + to);
                String subject = EASResource.getString((String)res, (String)"messageStart") + imageNumber + EASResource.getString((String)res, (String)"messageEnd");
                System.out.print("************************ subject=" + subject);
                StringBuffer sb = new StringBuffer(EASResource.getString((String)res, (String)"imageNo"));
                sb.append(imageNumber);
                sb.append(";");
                sb.append(EASResource.getString((String)res, (String)"billNumber"));
                sb.append(billNumber);
                sb.append(";");
                sb.append(EASResource.getString((String)res, (String)"pleaseHandle"));
                String body = sb.toString();
                if (reason != null) {
                    body = body + ";" + reason;
                }
                BizCollUtil.sendMessage(ctx, subject, body, idset);
                System.out.print("************************ body=" + body);
                if (to == null || to.trim().length() == 0) {
                    return;
                }
                MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)body, (String)to, null, null, null);
            }
        }
        catch (Exception e) {
            logger.info((Object)"_____________send message error!");
            e.printStackTrace();
        }
    }

    String getMailPersonStr(Context ctx, Set set) throws BOSException {
        if (set == null || set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        PersonCollection pc = ip.getPersonCollection(evi);
        PersonInfo person = null;
        StringBuffer sb = new StringBuffer();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) continue;
            if (sb.toString().trim().length() > 0) {
                sb.append(",");
            }
            sb.append(pc.get(i).getEmail());
        }
        return sb.toString();
    }
}

