/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryCollection;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryCollection;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillLoanCheckEntryCollection;
import com.kingdee.eas.cp.bc.app.AbstractTravelAccountBillControllerBean;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class TravelAccountBillControllerBean
extends AbstractTravelAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.TravelAccountBillControllerBean");

    @Override
    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        TravelAccountBillInfo info = (TravelAccountBillInfo)model;
        TravelAccountBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            Date toDate;
            entry = info.getEntries().get(i);
            if (entry.getStartDate() == null) {
                throw new ExpAccException(ExpAccException.BEGINDATE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entry.getFrom())) {
                throw new ExpAccException(ExpAccException.BEGIN_NOT_NULL);
            }
            if (entry.getFrom().length() > 80) {
                throw new ExpAccException(ExpAccException.FROM_TOO_LONG);
            }
            if (entry.getEndDate() == null) {
                throw new ExpAccException(ExpAccException.ENDDATE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entry.getTo())) {
                throw new ExpAccException(ExpAccException.END_NOT_NULL);
            }
            if (entry.getTo().length() > 80) {
                throw new ExpAccException(ExpAccException.TO_TOO_LONG);
            }
            if (entry.getVehicle() == null) {
                throw new ExpAccException(ExpAccException.VEHICLE_NOT_NULL);
            }
            Date fromDate = entry.getStartDate();
            if (fromDate.compareTo(toDate = entry.getEndDate()) > 0) {
                throw new ExpAccException(ExpAccException.BEGIN_LT_END);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
            }
            if (entry.getCompany() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
        }
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        TravelAccountBillInfo info = (TravelAccountBillInfo)model;
        String sourceId = info.getSourceBillId();
        TravelAccountBillEntryInfo entry = null;
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (info.getNumber() == null) {
            throw new ExpAccException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            Date toDate;
            entry = info.getEntries().get(i);
            if (entry.getStartDate() == null) {
                throw new ExpAccException(ExpAccException.BEGINDATE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entry.getFrom())) {
                throw new ExpAccException(ExpAccException.BEGIN_NOT_NULL);
            }
            if (entry.getFrom().length() > 200) {
                throw new ExpAccException(ExpAccException.BEGIN_TOO_LONG);
            }
            if (entry.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (entry.getEndDate() == null) {
                throw new ExpAccException(ExpAccException.ENDDATE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entry.getTo())) {
                throw new ExpAccException(ExpAccException.END_NOT_NULL);
            }
            if (entry.getTo().length() > 200) {
                throw new ExpAccException(ExpAccException.END_TOO_LONG);
            }
            if (entry.getVehicle() == null) {
                throw new ExpAccException(ExpAccException.VEHICLE_NOT_NULL);
            }
            Date fromDate = entry.getStartDate();
            if (fromDate.compareTo(toDate = entry.getEndDate()) > 0) {
                throw new ExpAccException(ExpAccException.BEGIN_LT_END);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (sourceId != null && !BizCollUtil.isEvectionReq(sourceId)) {
                if (entry.getAmount() == null) {
                    throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
                }
            } else if (entry.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.bigDecimalObjectLessThan(entry.getAmountApproved(), entry.getAmount())) continue;
            throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entry.getAmountApproved(), entry.getAmount()});
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TravelAccountBillInfo info = (TravelAccountBillInfo)model;
        TravelAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TravelAccountBillInfo info = (TravelAccountBillInfo)model;
        TravelAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        IObjectPK retValue = super._submit(ctx, model);
        if (this.isNeedBudget && this.eveReqBillUseBg && info.getSourceBillId() != null && info.getState().equals((Object)StateEnum.CHECKING)) {
            BOSUuid sourceBillId = BOSUuid.read((String)info.getSourceBillId());
            boolean isAmount = false;
            BigDecimal amountBalance = new BigDecimal("0.00");
            BigDecimal budgetAmount = new BigDecimal("0.00");
            if (new EvectionReqBillInfo().getBOSType().equals((Object)BizCollUtil.getBOSType(info.getSourceBillId()))) {
                EvectionReqBillInfo req = EvectionReqBillFactory.getLocalInstance(ctx).getEvectionReqBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
                EvectionReqBillEntryCollection entries = req.getEntries();
                for (int i = 0; i < entries.size(); ++i) {
                    amountBalance = amountBalance.add(entries.get(i).getAmountBalance());
                    budgetAmount = budgetAmount.add(entries.get(i).getBudgetAmount());
                }
                if (BizCollUtil.bigDecimalObjectLessThan(amountBalance, new BigDecimal("0.0")) && BizCollUtil.bigDecimalObjectLessThan(budgetAmount, new BigDecimal("0.0"))) {
                    isAmount = true;
                }
                if (isAmount) {
                    this.reWriteBillState(ctx, sourceBillId, StateEnum.CLOSED);
                }
            } else if (new OtherExpenseBillInfo().getBOSType().equals((Object)BizCollUtil.getBOSType(info.getSourceBillId()))) {
                OtherExpenseBillInfo oe = OtherExpenseBillFactory.getRemoteInstance().getOtherExpenseBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
                OtherExpenseBillEntryCollection entries = oe.getEntries();
                for (int i = 0; i < entries.size(); ++i) {
                    amountBalance = amountBalance.add(entries.get(i).getAmountBalance());
                    budgetAmount = budgetAmount.add(entries.get(i).getBudgetAmount());
                }
                if (BizCollUtil.bigDecimalObjectLessThan(amountBalance, new BigDecimal("0.0")) && BizCollUtil.bigDecimalObjectLessThan(budgetAmount, new BigDecimal("0.0"))) {
                    isAmount = true;
                }
                if (isAmount) {
                    this.reWriteBillState(ctx, sourceBillId, StateEnum.CLOSED);
                }
            }
        }
        return retValue;
    }

    private void reWriteBillState(Context ctx, BOSUuid id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(id, state);
    }

    @Override
    protected void _ngisc_submit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._ngisc_submit(ctx, pk, model);
        if (model.getSourceBillId() != null && BizCollUtil.getBOSType(model.getSourceBillId()).equals((Object)BizCollUtil.evectionReqBosType)) {
            BizCollUtil.bulidBotpRelation(ctx, BizCollUtil.evectionReqBosType.toString(), model.getSourceBillId(), model.getBOSType().toString(), model.getId().toString());
        }
    }

    @Override
    protected void _ngisc_audit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._ngisc_audit(ctx, pk, model);
        if (model.getSourceBillId() != null && BizCollUtil.getBOSType(model.getSourceBillId()).equals((Object)BizCollUtil.evectionReqBosType)) {
            BizCollUtil.bulidBotpRelation(ctx, BizCollUtil.evectionReqBosType.toString(), model.getSourceBillId(), model.getBOSType().toString(), model.getId().toString());
        }
    }

    @Override
    protected void checkForSubmit(Context ctx, BizCollBillBaseInfo infoOld, BizCollBillBaseInfo info) throws EASBizException, BOSException {
        super.checkForSubmit(ctx, infoOld, info);
        if (info.getBoolean("isBatchSubmit") && this.isTravelStandard) {
            this.validateEvectionStandard(ctx, info);
        }
    }

    protected void validateEvectionStandard(Context ctx, BizCollBillBaseInfo info) throws EASBizException, BOSException {
        if (this.controlType.equals("0")) {
            return;
        }
        TravelAccountBillEntryCollection entries = (TravelAccountBillEntryCollection)((Object)info.get("entries"));
        int entriesSize = entries.size();
        for (int j = 0; j < entriesSize; ++j) {
            TravelAccountBillEntryInfo entry = entries.get(j);
            if (entry.getTravelArea() == null) {
                throw new StandardException(StandardException.AREA_NOT_EMPTY);
            }
            BigDecimal allowanceDays = entry.getAllowanceDays() == null ? BizCollUtil.ZERO : entry.getAllowanceDays();
            BigDecimal allowanceLevel = entry.getAllowanceLevel() == null ? BizCollUtil.ZERO : entry.getAllowanceLevel();
            BigDecimal eventionSubsidy = entry.getEventionSubsidy() == null ? BizCollUtil.ZERO : entry.getEventionSubsidy();
            BigDecimal eventionSubsidyStandard = allowanceLevel.multiply(allowanceDays).setScale(2, 4);
            BigDecimal overAllowance = eventionSubsidy.subtract(eventionSubsidyStandard);
            overAllowance = overAllowance.compareTo(BizCollUtil.ZERO) > 0 ? overAllowance : BizCollUtil.ZERO;
            BigDecimal roomLevel = entry.getRoomLevel() == null ? BizCollUtil.ZERO : entry.getRoomLevel();
            BigDecimal roomDays = entry.getRoomDays() == null ? BizCollUtil.ZERO : entry.getRoomDays();
            BigDecimal hotelExpense = entry.getHotelExpense() == null ? BizCollUtil.ZERO : entry.getHotelExpense();
            BigDecimal hotelExpenseStandard = roomLevel.multiply(roomDays).setScale(2, 4);
            BigDecimal overRoom = hotelExpense.subtract(hotelExpenseStandard);
            BigDecimal bigDecimal = overRoom = overRoom.compareTo(BizCollUtil.ZERO) > 0 ? overRoom : BizCollUtil.ZERO;
            if (overAllowance.compareTo(BizCollUtil.ZERO) <= 0 && overRoom.compareTo(BizCollUtil.ZERO) <= 0) continue;
            if (this.controlType.equals("1")) {
                throw new StandardException(StandardException.EXCEED_STANDARD_NOT_SUBMIT);
            }
            if (this.controlType.equals("2")) {
                if (!StringUtils.isEmpty((String)((TravelAccountBillInfo)info).getOverAmountDesc())) continue;
                throw new StandardException(StandardException.EXCEED_STANDARD_FILL_EXPLANATION_AND_SUBMIT);
            }
            if (!this.controlType.equals("3")) continue;
            throw new StandardException(StandardException.EXCEED_STANDARD_COMFIRM_SUBMIT);
        }
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_TravelAccount_Update";
    }
}

