/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitFilterFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.ControlType;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.app.control.IControl;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountControl
implements IControl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.control.AccountControl");

    @Override
    public List<Map> check(Context ctx, StaffLevelAttriEnum staffLevel, Map valuemap) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        boolean isAcrossYear = false;
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)valuemap.get("billinfo");
        if (staffLevel.equals((Object)StaffLevelAttriEnum.USERDEFINED)) {
            AbstractObjectCollection con = (AbstractObjectCollection)info.get("entries");
            CoreBillEntryBaseInfo entryInfo = null;
            Object result = null;
            ExpenseTypeInfo expenseType = null;
            String billId = null;
            if (info.getId() != null) {
                billId = info.getId().toString();
            }
            CompanyOrgUnitInfo company = info.getApplierCompany();
            try {
                CompanyOrgUnitInfo exCompany = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getFilterWithCompany(company);
                if (exCompany != null) {
                    company = exCompany;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (CoreBillEntryBaseInfo)con.getObject(i);
                expenseType = (ExpenseTypeInfo)entryInfo.get("expenseType");
                if (info.getApplier() == null) {
                    resultList.add(null);
                    continue;
                }
                Date happenTime = (Date)entryInfo.get("happenTime");
                CurrencyInfo currencyInfo = (CurrencyInfo)entryInfo.get("currencyType");
                if (expenseType == null || happenTime == null || currencyInfo == null) {
                    resultList.add(null);
                    continue;
                }
                ControlType controlType = expenseType.getControlType();
                if (controlType == null || controlType.equals((Object)ControlType.No)) {
                    resultList.add(null);
                    continue;
                }
                ControlMethod controlMethod = expenseType.getControlMethod();
                String entryId = entryInfo.getId() == null ? null : entryInfo.getId().toString();
                Map map = this.getLimit(ctx, controlMethod, expenseType, currencyInfo, info.getApplier(), company, happenTime, entryId, billId);
                Calendar now = Calendar.getInstance();
                int curYear = now.get(1);
                int happenYear = 0;
                if (null != happenTime) {
                    now.setTime(happenTime);
                    happenYear = now.get(1);
                }
                if (happenYear < curYear && null != map) {
                    isAcrossYear = true;
                }
                map.put("controlType", controlType);
                map.put("expenseType", expenseType);
                map.put("currencyInfo", currencyInfo);
                map.put("isAcrossYear", isAcrossYear);
                resultList.add(map);
            }
        }
        return resultList;
    }

    public Map getCheckResult(Context ctx, ControlMethod controlMethod, ExpenseTypeInfo expenseType, CurrencyInfo currency, PersonInfo person, Date happenDate) {
        Map<String, Date> map = null;
        if (person != null) {
            map = ControlUtil.getAccountStandard(ctx, person.getId().toString(), currency.getId().toString(), expenseType.getId().toString(), happenDate);
        }
        if (map == null) {
            map = new HashMap<String, BigDecimal>();
            map.put("monthLimit", (Date)((Object)new BigDecimal(0)));
            map.put("effectiveDate", happenDate);
        }
        BigDecimal monthLimit = (BigDecimal)map.get("monthLimit");
        Date effectiveDate = (Date)map.get("effectiveDate");
        Map monthData = ControlUtil.getEffectiveMonth(ctx, effectiveDate, happenDate, controlMethod);
        BigDecimal totalMonthLimit = monthLimit.multiply(new BigDecimal(monthData.get("month").toString()));
        BigDecimal totalAmount = ControlUtil.countAccountEntryAmount(ctx, person.getId().toString(), (Date)monthData.get("beginDate"), (Date)monthData.get("endDate"), expenseType.getId().toString(), currency.getId().toString());
        BigDecimal amountbalance = BizCollUtil.ZERO;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put("totalMonthLimit", totalMonthLimit);
        resultMap.put("totalAmount", totalAmount);
        if (totalMonthLimit.compareTo(totalAmount) > 0) {
            amountbalance = totalMonthLimit.subtract(totalAmount);
        }
        resultMap.put("amountbalance", amountbalance);
        return resultMap;
    }

    public Map getLimit(Context ctx, ControlMethod controlMethod, ExpenseTypeInfo expenseType, CurrencyInfo currency, PersonInfo person, CompanyOrgUnitInfo company, Date happenDate) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        try {
            int i;
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP050");
            Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, company.getId().toString());
            boolean isCalCurCompany = new Boolean(params.get("CP050").toString());
            Map monthData = ControlUtil.getEffectiveMonth(ctx, null, happenDate, controlMethod);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(happenDate);
            int year = calendar.get(1);
            int month = calendar.get(2);
            String[] selectItem = new String[]{"fone", "ftwo", "fthree", "ffour", "ffive", "fsix", "fseven", "feight", "fnine", "ften", "feleven", "ftwelve"};
            String[] selectAdjustItem = new String[]{"foneAdjust", "ftwoAdjust", "fthreeAdjust", "ffourAdjust", "ffiveAdjust", "fsixAdjust", "fsevenAdjust", "feightAdjust", "fnightAdjust", "ftenAdjust", "felevenAdjust", "ftwelveAdjust"};
            StringBuffer oql = new StringBuffer();
            oql.append("select ");
            if (controlMethod.equals((Object)ControlMethod.total)) {
                for (i = 0; i <= month; ++i) {
                    oql.append(selectItem[i]).append(" + ");
                }
                oql.deleteCharAt(oql.length() - 2);
            } else {
                oql.append(selectItem[month]);
            }
            oql.append(" monthLimit,");
            if (controlMethod.equals((Object)ControlMethod.total)) {
                for (i = 0; i <= month; ++i) {
                    oql.append(selectAdjustItem[i]).append(" + ");
                }
                oql.deleteCharAt(oql.length() - 2);
            } else {
                oql.append(selectAdjustItem[month]);
            }
            oql.append(" monthAdjust from t_bc_accountlimit ");
            oql.append(" where fyear = '").append(year).append("' and fpersonid = '").append(person.getId().toString()).append("' ");
            oql.append(" and fcurrencyid = '").append(currency.getId().toString()).append("' and fexpensetypeid = '").append(expenseType.getId().toString()).append("' ");
            oql.append(" and fisstart = 1 ");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), null);
            BigDecimal totalMonthLimit = new BigDecimal(0.0);
            BigDecimal totalMonthAdjust = new BigDecimal(0.0);
            if (rows.next()) {
                if (rows.getBigDecimal("monthLimit") != null) {
                    totalMonthLimit = rows.getBigDecimal("monthLimit");
                }
                if (rows.getBigDecimal("monthAdjust") != null) {
                    totalMonthAdjust = rows.getBigDecimal("monthAdjust");
                }
            }
            if (rows.size() == 0) {
                resultMap.put("amountbalance", BigDecimal.ZERO);
                resultMap.put("totalMonthLimit", BigDecimal.ZERO);
                resultMap.put("totalAmount", BigDecimal.ZERO);
            } else {
                BigDecimal totalAmount = ControlUtil.countAccountEntryAmount(ctx, person.getId().toString(), (Date)monthData.get("beginDate"), (Date)monthData.get("endDate"), expenseType.getId().toString(), currency.getId().toString(), company.getId().toString(), null, null);
                BigDecimal amountbalance = new BigDecimal(0.0);
                amountbalance = totalMonthLimit.subtract(totalAmount.add(totalMonthAdjust));
                resultMap.put("amountbalance", amountbalance);
                resultMap.put("totalMonthLimit", totalMonthLimit);
                resultMap.put("totalAmount", totalAmount);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return resultMap;
    }

    public Map getLimit(Context ctx, ControlMethod controlMethod, ExpenseTypeInfo expenseType, CurrencyInfo currency, PersonInfo person, CompanyOrgUnitInfo company, Date happenDate, String entryId, String billId) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        try {
            int i;
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP050");
            Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, company.getId().toString());
            boolean isCalCurCompany = new Boolean(params.get("CP050").toString());
            CompanyOrgUnitInfo isPramaryCompany = this.getIsPramaryCompanyId(ctx, person.getId().toString());
            Map monthData = ControlUtil.getEffectiveMonth(ctx, null, happenDate, controlMethod);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(happenDate);
            int year = calendar.get(1);
            int month = calendar.get(2);
            String[] selectItem = new String[]{"fone", "ftwo", "fthree", "ffour", "ffive", "fsix", "fseven", "feight", "fnine", "ften", "feleven", "ftwelve"};
            String[] selectAdjustItem = new String[]{"foneAdjust", "ftwoAdjust", "fthreeAdjust", "ffourAdjust", "ffiveAdjust", "fsixAdjust", "fsevenAdjust", "feightAdjust", "fnightAdjust", "ftenAdjust", "felevenAdjust", "ftwelveAdjust"};
            StringBuffer oql = new StringBuffer();
            oql.append("select ");
            if (controlMethod.equals((Object)ControlMethod.total)) {
                for (i = 0; i <= month; ++i) {
                    oql.append("ISNULL(" + selectItem[i] + ", 0)").append(" + ");
                }
                oql.deleteCharAt(oql.length() - 2);
            } else {
                oql.append("ISNULL(" + selectItem[month] + ", 0)");
            }
            oql.append(" monthLimit,");
            if (controlMethod.equals((Object)ControlMethod.total)) {
                for (i = 0; i <= month; ++i) {
                    oql.append("ISNULL(" + selectAdjustItem[i] + ", 0)").append(" + ");
                }
                oql.deleteCharAt(oql.length() - 2);
            } else {
                oql.append("ISNULL(" + selectAdjustItem[month] + ", 0)");
            }
            oql.append(" monthAdjust from t_bc_accountlimit ");
            oql.append(" where fyear = '").append(year).append("' and fpersonid = '").append(person.getId().toString()).append("' ");
            oql.append(" and fcurrencyid = '").append(currency.getId().toString()).append("' and fexpensetypeid = '").append(expenseType.getId().toString()).append("' ");
            oql.append(" and FIsStart = 1");
            if (isCalCurCompany) {
                oql.append(" and fcompanyorgunitid = '").append(company.getId().toString()).append("'");
            } else if (isPramaryCompany != null) {
                oql.append(" and fcompanyorgunitid = '").append(isPramaryCompany.getId().toString()).append("'");
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), null);
            BigDecimal totalMonthLimit = new BigDecimal(0.0);
            BigDecimal totalMonthAdjust = new BigDecimal(0.0);
            if (rows.next()) {
                if (rows.getBigDecimal("monthLimit") != null) {
                    totalMonthLimit = rows.getBigDecimal("monthLimit");
                }
                if (rows.getBigDecimal("monthAdjust") != null) {
                    totalMonthAdjust = rows.getBigDecimal("monthAdjust");
                }
            }
            BigDecimal totalAmount = BigDecimal.ZERO;
            logger.error((Object)("---cpbc---getLimit---sql:" + oql + "\n isCalCurCompany:" + isCalCurCompany + ",totalMonthLimit:" + totalMonthLimit + ",totalMonthAdjust:" + totalMonthAdjust));
            if (rows.size() == 0) {
                resultMap.put("amountbalance", BigDecimal.ZERO);
                resultMap.put("totalMonthLimit", BigDecimal.ZERO);
                resultMap.put("totalAmount", BigDecimal.ZERO);
            } else {
                totalAmount = ControlUtil.countAccountEntryAmount(ctx, person.getId().toString(), (Date)monthData.get("beginDate"), (Date)monthData.get("endDate"), expenseType.getId().toString(), currency.getId().toString(), company.getId().toString(), entryId, billId);
                BigDecimal amountbalance = new BigDecimal(0.0);
                amountbalance = totalMonthLimit.subtract(totalAmount.add(totalMonthAdjust));
                resultMap.put("amountbalance", amountbalance);
                resultMap.put("totalMonthLimit", totalMonthLimit);
                resultMap.put("totalAmount", totalAmount);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public CompanyOrgUnitInfo getIsPramaryCompanyId(Context ctx, String personId) throws EASBizException, BOSException, UuidException {
        OrgUnitCollection unitColl;
        CompanyOrgUnitInfo company = null;
        AdminOrgUnitInfo admin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
        if (admin != null && (unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(admin.getId().toString(), 0, 1)).size() != 0) {
            company = (CompanyOrgUnitInfo)unitColl.get(0);
        }
        return company;
    }
}

