/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ReimburseLevelCollection;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingCollection;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingFactory;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingInfo;
import com.kingdee.eas.cp.bc.app.ReimburseLevelStateEnum;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PersonReimburseLevelSettingListDataImport
extends AbstractBatchDataImport {
    private HashMap<String, PersonInfo> personMap = new HashMap();
    private HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap();
    private HashMap<String, Boolean> personAdminOrgMap = new HashMap();
    private HashMap<String, Set<String>> reimburseChooseCompany = new HashMap();
    private HashSet<String> set = new HashSet();
    private HashSet<String> permissionSet = new HashSet();
    private String fPersonNumber;
    private String fReimburseLevelNumber;
    private String fCompanyOrgUnitNumber;
    private static final Logger logger = Logger.getLogger(PersonReimburseLevelSettingListDataImport.class);

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo superFilter = new FilterInfo();
        FilterInfo bizFilter = new FilterInfo();
        String companyId = (String)this.getContextParameter("companyId");
        if (StringUtils.isNotBlank((String)companyId)) {
            bizFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
        }
        FilterInfo stateFilter = new FilterInfo();
        String state = (String)this.getContextParameter("state");
        if (StringUtils.isNotBlank((String)state)) {
            if ("null".equals(state) || "10".equals(state)) {
                stateFilter.getFilterItems().add(new FilterItemInfo("state", null, CompareType.IS));
                stateFilter.getFilterItems().add(new FilterItemInfo("state", (Object)Integer.parseInt(state)));
                stateFilter.setMaskString("#0 or #1");
            } else {
                stateFilter.getFilterItems().add(new FilterItemInfo("state", (Object)Integer.parseInt(state)));
            }
        }
        FilterInfo reimburseFilter = new FilterInfo();
        String reimburseLevelId = (String)this.getContextParameter("reimburseLevelId");
        if (StringUtils.isNotBlank((String)reimburseLevelId)) {
            if ("null".equals(reimburseLevelId)) {
                reimburseFilter.getFilterItems().add(new FilterItemInfo("reimburseLevel.id", null, CompareType.IS));
                reimburseFilter.getFilterItems().add(new FilterItemInfo("reimburseLevel.id", (Object)""));
                reimburseFilter.setMaskString("#0 or #1");
            } else {
                reimburseFilter.getFilterItems().add(new FilterItemInfo("reimburseLevel.id", (Object)reimburseLevelId));
            }
        }
        FilterInfo personDeletedStatusFilter = new FilterInfo();
        String personDeletedStatus = (String)this.getContextParameter("personDeletedStatus");
        if (StringUtils.isNotBlank((String)personDeletedStatus)) {
            personDeletedStatusFilter.getFilterItems().add(new FilterItemInfo("person.deletedStatus", (Object)2, CompareType.NOTEQUALS));
        }
        FilterInfo employeeTypeInServiceFilter = new FilterInfo();
        String employeeTypeInService = (String)this.getContextParameter("employeeTypeInService");
        if (StringUtils.isNotBlank((String)employeeTypeInService)) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(0);
            hashSet.add(1);
            hashSet.add(4);
            employeeTypeInServiceFilter.getFilterItems().add(new FilterItemInfo("employeeType.inService", hashSet, CompareType.INCLUDE));
        }
        try {
            superFilter.mergeFilter(bizFilter, "and");
            superFilter.mergeFilter(stateFilter, "and");
            superFilter.mergeFilter(reimburseFilter, "and");
            superFilter.mergeFilter(personDeletedStatusFilter, "and");
            superFilter.mergeFilter(employeeTypeInServiceFilter, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return superFilter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.StaffReimburseLevelQuery";
    }

    @Override
    protected String buildTempTableSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FCreatorID varchar(44), \n");
        sql.append("     FLastUpdateUserID varchar(44), \n");
        sql.append("     FControlUnitID varchar(44), \n");
        sql.append("     FPersonID VARCHAR(44), \n");
        sql.append("     FReimburseLevelID VARCHAR(44), \n");
        sql.append("     FAdminOrgUnitID VARCHAR(44), \n");
        sql.append("     FCompanyOrgUnitID VARCHAR(44), \n");
        sql.append("     FCreateTime DateTime, \n");
        sql.append("     FLastUpdateTime DateTime \n");
        sql.append(") \n");
        return sql.toString();
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        StringBuilder sqlInsert = new StringBuilder();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FID,FCreatorID,FLastUpdateUserID,FControlUnitID, \n").append("FPersonID,FReimburseLevelID, \n").append("FAdminOrgUnitID,FCompanyOrgUnitID, \n").append("FCreateTime,FLastUpdateTime) \n").append(" values (newbosid('1D9DDC04'),?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = coll.size() - 1; rowIndex >= 0; --rowIndex) {
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                this.fPersonNumber = this.getData((SimpleRecord)rowData, "FPersonNumber");
                this.fReimburseLevelNumber = this.getData((SimpleRecord)rowData, "FReimburseLevelNumber");
                this.fCompanyOrgUnitNumber = this.getData((SimpleRecord)rowData, "FCompanyOrgUnitNumber");
                if (this.validateInputParam(ctx) || this.checkHasDuplicateDateInExcel(ctx, this.fPersonNumber, this.fCompanyOrgUnitNumber)) continue;
                String fCompanyOrgUnitId = "";
                CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgUnitByNumber(ctx, this.fCompanyOrgUnitNumber);
                if (companyOrgUnitInfo == null) continue;
                fCompanyOrgUnitId = companyOrgUnitInfo.getId().toString();
                String personId = "";
                PersonInfo personInfo = this.getPersonInfoByNumber(ctx, this.fPersonNumber);
                if (personInfo == null) continue;
                personId = personInfo.getId().toString();
                if (this.validatePersonInfo(ctx, fCompanyOrgUnitId, personInfo)) continue;
                ReimburseLevelInfo reimburseLevelInfo = this.getReimburseLevelInfoByNumber(ctx, this.fReimburseLevelNumber);
                String reimburseLevelId = "";
                if (reimburseLevelInfo == null || this.validateReimburseChooseCompany(ctx, fCompanyOrgUnitId, reimburseLevelId = reimburseLevelInfo.getId().toString()) || this.validateRecordInDBByPersonAndCompany(ctx, this.isSltImportUpdate())) continue;
                String fAdminOrgUnitId = "";
                AdminOrgUnitInfo adminOrgUnit = this.getAdminOrgUnitByPersonAndCompanyOrgUnit(ctx, personId, fCompanyOrgUnitId);
                if (adminOrgUnit == null) continue;
                fAdminOrgUnitId = adminOrgUnit.getId().toString();
                this.cuId = companyOrgUnitInfo.getCU().getId().toString();
                pstmtInsert.setString(1, this.userId);
                pstmtInsert.setString(2, this.userId);
                pstmtInsert.setString(3, this.cuId);
                pstmtInsert.setString(4, personId);
                pstmtInsert.setString(5, reimburseLevelId);
                pstmtInsert.setString(6, fAdminOrgUnitId);
                pstmtInsert.setString(7, fCompanyOrgUnitId);
                java.util.Date utilDate = new java.util.Date();
                Date sqlDate = new Date(utilDate.getTime());
                pstmtInsert.setDate(8, sqlDate);
                pstmtInsert.setDate(9, sqlDate);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    private boolean validateReimburseChooseCompany(Context ctx, String fCompanyOrgUnitId, String reimburseLevelId) throws BOSException, EASBizException, TaskRunnerException {
        Set reimburseLevelIds = this.reimburseChooseCompany.get(fCompanyOrgUnitId);
        if (reimburseLevelIds == null) {
            reimburseLevelIds = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelIds(fCompanyOrgUnitId);
            this.reimburseChooseCompany.put(fCompanyOrgUnitId, reimburseLevelIds);
        }
        if (reimburseLevelIds == null || !reimburseLevelIds.contains(reimburseLevelId)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVEL_NOT_CHOOSE_COMPANY", new Object[]{this.fCompanyOrgUnitNumber, this.fReimburseLevelNumber}));
            return true;
        }
        return false;
    }

    private boolean validateRecordInDBByPersonAndCompany(Context ctx, Boolean isImportUpdate) throws BOSException, TaskRunnerException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.number", (Object)this.fPersonNumber));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.number", (Object)this.fCompanyOrgUnitNumber));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        StaffReimburseLevelSettingCollection staffReimburseLevelSettingCollection = StaffReimburseLevelSettingFactory.getLocalInstance(ctx).getStaffReimburseLevelSettingCollection(entityViewInfo);
        if (staffReimburseLevelSettingCollection != null && staffReimburseLevelSettingCollection.size() > 0) {
            StaffReimburseLevelSettingInfo staffReimburseLevelSettingInfo = staffReimburseLevelSettingCollection.get(0);
            if (ReimburseLevelStateEnum.Submit.equals((Object)staffReimburseLevelSettingInfo.getState())) {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISSTATEISSUBMIT", new Object[]{this.fPersonNumber}));
                return true;
            }
            if (!isImportUpdate.booleanValue()) {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBER_AND_FCOMPANYNUMBER_INDB", new Object[]{this.fPersonNumber, this.fCompanyOrgUnitNumber}));
                return true;
            }
        }
        return false;
    }

    private boolean validateInputParam(Context ctx) throws TaskRunnerException {
        if (this.fPersonNumber == null || "".equals(this.fPersonNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNULL", null));
            return true;
        }
        if (this.fReimburseLevelNumber == null || "".equals(this.fReimburseLevelNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVELNUMBERISNULL", null));
            return true;
        }
        if (this.fCompanyOrgUnitNumber == null || "".equals(this.fCompanyOrgUnitNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FCOMPANYNUMBERISNULL", null));
            return true;
        }
        return false;
    }

    private boolean validatePermissionByCompany(Context ctx, String fCompanyOrgUnitId) throws BOSException, EASBizException, TaskRunnerException {
        if (!this.permissionSet.contains(fCompanyOrgUnitId)) {
            boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(fCompanyOrgUnitId), "cp_bc_StaffReimburseLevelSetting_Import");
            if (hasFunctionPermission) {
                this.permissionSet.add(fCompanyOrgUnitId);
            } else {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "HASNOTFUNCTIONPERMISSION", new Object[]{this.fPersonNumber}));
                return true;
            }
        }
        return false;
    }

    private boolean validatePersonInfo(Context ctx, String fCompanyOrgUnitId, PersonInfo personInfo) throws TaskRunnerException, BOSException, SQLException {
        if (personInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONDELETED", new Object[]{this.fPersonNumber}));
            return true;
        }
        String personId = personInfo.getId().toString();
        if (!this.checkPersonInCompany(ctx, personId, fCompanyOrgUnitId)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PERSONNOTINREIMBURSECOMPANY", new Object[]{this.fPersonNumber, this.fCompanyOrgUnitNumber}));
            return true;
        }
        return false;
    }

    private boolean checkHasDuplicateDateInExcel(Context ctx, String fPersonNumber, String fCompanyOrgUnitNumber) throws TaskRunnerException {
        if (this.set.contains(fPersonNumber + fCompanyOrgUnitNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETPYEDUPLICATENUMANDCOM", new Object[]{fPersonNumber, fCompanyOrgUnitNumber}));
            return true;
        }
        this.set.add(fPersonNumber + fCompanyOrgUnitNumber);
        return false;
    }

    private boolean checkPersonInCompany(Context ctx, String personId, String companyId) throws SQLException, BOSException {
        boolean isInCompany = false;
        Boolean isInCompanyBln = this.personAdminOrgMap.get(personId + companyId);
        if (isInCompanyBln == null) {
            String querySql = "SELECT POSITION.FID \nFROM T_ORG_PositionMember PM\nLEFT JOIN T_ORG_Position POSITION  ON PM.FPositionID = POSITION.FID\nLEFT JOIN T_BD_Person PERSON ON PM.FPersonID = PERSON.FID\nLEFT JOIN T_ORG_Admin ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID\nWHERE POSITION.FAdminOrgUnitID IN \n(SELECT DISTINCT RELATION.FFROMUNITID FROM T_ORG_UNITRELATION RELATION \nINNER JOIN T_ORG_TYPERELATION TYPE ON TYPE.FID=RELATION.FTYPERELATIONID \nWHERE RELATION.FTOUNITID=? AND TYPE.FFROMTYPE=0 AND TYPE.FTOTYPE=1) \nAND ADMINORGUNIT.FIsSealUp = 0   AND PERSON.FID = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{companyId, personId});
            if (rowSet.next()) {
                isInCompany = true;
                this.personAdminOrgMap.put(personId + companyId, isInCompany);
            }
        } else {
            isInCompany = isInCompanyBln;
        }
        return isInCompany;
    }

    private AdminOrgUnitInfo getAdminOrgUnitByPersonAndCompanyOrgUnit(Context ctx, String personId, String companyOrgUnitId) throws BOSException, EASBizException, TaskRunnerException {
        String adminOrgIdStr;
        String queryPositionOql;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection adminOrgUnits = iOrgUnitRelation.getFromUnit(companyOrgUnitId, 1, 0);
        HashSet<String> adminOrgIds = new HashSet<String>();
        int is = adminOrgUnits.size();
        for (int i = 0; i < is; ++i) {
            adminOrgIds.add(adminOrgUnits.get(i).getId().toString());
        }
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection positionMembers = iPositionMember.getPositionMemberCollection(String.format(queryPositionOql = "SELECT POSITION.*, POSITION.ADMINORGUNIT.ID, POSITION.ADMINORGUNIT.NAME, POSITION.ADMINORGUNIT.PARENT, POSITION.ADMINORGUNIT.ISCOSTORGUNIT, POSITION.ADMINORGUNIT.LONGNUMBER WHERE PERSON.ID = '%s' AND POSITION.ADMINORGUNIT.ID IN ('%s') AND POSITION.ADMINORGUNIT.ISSEALUP = 0 ORDER BY ISPRIMARY DESC, POSITION.NUMBER ASC", personId, adminOrgIdStr = StringUtils.join((Object[])adminOrgIds.toArray(), (String)"','")));
        if (positionMembers != null && positionMembers.size() > 0) {
            PositionInfo position = positionMembers.get(0).getPosition();
            adminOrgUnitInfo = position.getAdminOrgUnit();
        }
        if (adminOrgUnitInfo == null) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PERSONINCOMPANY_NOPOSTION", new Object[]{this.fPersonNumber, this.fCompanyOrgUnitNumber}));
        }
        return adminOrgUnitInfo;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitByNumber(Context ctx, String companyNumber) throws BOSException, TaskRunnerException {
        CompanyOrgUnitInfo companyOrgUnitInfo = this.companyMap.get(companyNumber);
        if (companyOrgUnitInfo == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)companyNumber));
            filter.setMaskString("#0 or #1");
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (coll != null && coll.size() > 0) {
                if (coll.size() == 1) {
                    companyOrgUnitInfo = coll.get(0);
                    this.companyMap.put(companyNumber, companyOrgUnitInfo);
                    if (companyOrgUnitInfo.getBoolean("isSealUp")) {
                        companyOrgUnitInfo = null;
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "WRONG_STATE", new Object[]{companyNumber}));
                    } else if (!companyOrgUnitInfo.isIsBizUnit()) {
                        companyOrgUnitInfo = null;
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "REIMBURSECOMPANYISBIZUNIT", new Object[]{companyNumber}));
                    }
                } else {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "EXIST_SAME_COMPANY", new Object[]{companyNumber}));
                }
            } else {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FCOMPANYNUMBERISNOTEXISTINBASEINFO", new Object[]{companyNumber}));
            }
        }
        return companyOrgUnitInfo;
    }

    private ReimburseLevelInfo getReimburseLevelInfoByNumber(Context ctx, String fReimburseLevelNumber) throws BOSException, TaskRunnerException {
        ReimburseLevelInfo reimburseLevelInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fReimburseLevelNumber));
        view.setFilter(filter);
        ReimburseLevelCollection coll = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelCollection(view);
        if (coll != null && coll.size() > 0) {
            reimburseLevelInfo = coll.get(0);
        } else {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVELNUMBERISNOTEXISTINBASEINFO", new Object[]{fReimburseLevelNumber}));
        }
        return reimburseLevelInfo;
    }

    private PersonInfo getPersonInfoByNumber(Context ctx, String fPersonNumber) throws BOSException, TaskRunnerException {
        PersonInfo personInfo = this.personMap.get(fPersonNumber);
        if (personInfo == null) {
            String oql = "select id, number, deletedStatus where number = '%s'";
            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(String.format(oql, fPersonNumber));
            if (personCollection.size() > 0) {
                personInfo = personCollection.get(0);
                this.personMap.put(fPersonNumber, personInfo);
            } else {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNOTEXIST", new Object[]{fPersonNumber}));
            }
        }
        return personInfo;
    }

    private Boolean checkReimburseLevelSettingByThreeNumber(Context ctx, String fPersonID, String fCompanyOrgUnitId) throws BOSException, TaskRunnerException {
        StringBuilder sql = new StringBuilder();
        sql.append("select FID from T_BC_StaffReimburseLevelSet \n");
        sql.append("where  FPersonID = '" + fPersonID + "' and FCompanyOrgUnitID = '" + fCompanyOrgUnitId + "' ;\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBER_AND_FCOMPANYNUMBER_INDB", new Object[]{this.fPersonNumber, this.fCompanyOrgUnitNumber}));
            return true;
        }
        return false;
    }

    @Override
    protected int doProcessData(Context ctx) throws Exception {
        return this.submitData(ctx);
    }

    private int submitData(Context ctx) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_BC_StaffReimburseLevelSet where fid in  ( \n");
            sql.append("    select collection.Fid from T_BC_StaffReimburseLevelSet collection ");
            sql.append("    inner join " + this.tempTable + " t ON collection.FPersonID = t.FPersonID and collection.FCompanyOrgUnitID = t.FCompanyOrgUnitID ); \n");
        }
        sql.append("insert into T_BC_StaffReimburseLevelSet ( \n");
        sql.append("    FID, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    FPersonID, \n");
        sql.append("    FReimburseLevelID, \n");
        sql.append("    FAdminOrgUnitID, \n");
        sql.append("    FCompanyOrgUnitID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateTime \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FCreatorID, \n");
        sql.append("    t.FLastUpdateUserID, \n");
        sql.append("    t.FControlUnitID, \n");
        sql.append("    t.FPersonID, \n");
        sql.append("    t.FReimburseLevelID, \n");
        sql.append("    t.FAdminOrgUnitID, \n");
        sql.append("    t.FCompanyOrgUnitID, \n");
        sql.append("    t.FCreateTime, \n");
        sql.append("    t.FLastUpdateTime \n");
        sql.append("from ").append(this.tempTable).append(" t ;\n");
        PersonReimburseLevelSettingListDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FPersonNumber", this.getNotBlankString(rs.getString("person.number")));
            result.put("FPersonName", this.getNotBlankString(rs.getString("person.name")));
            result.put("FReimburseLevelNumber", this.getNotBlankString(rs.getString("reimburseLevel.number")));
            result.put("FReimburseLevelName", this.getNotBlankString(rs.getString("reimburseLevel.name")));
            result.put("FAdminOrgUnitNumber", this.getNotBlankString(rs.getString("adminOrgUnit.name")));
            result.put("FCompanyOrgUnitNumber", this.getNotBlankString(rs.getString("companyOrgUnit.name")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

