/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ReimburseLevelCollection;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReimburseLevelSettingListDataImport
extends AbstractBatchDataImport {
    private HashMap<String, ArrayList<String>> map = new HashMap();
    private HashSet<String> permissionSet = new HashSet();
    private String fPersonNumber;
    private String fExpensetypeNumber;
    private String fReimburseLevelNumber;
    private String fCompanyOrgUnitNumber;
    private String fCompanyOrgUnitName;
    private static final Logger logger = Logger.getLogger(ReimburseLevelSettingListDataImport.class);

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filter = new FilterInfo();
        if (paramMap != null && paramMap.get("filterItems") != null) {
            String filterItems = (String)paramMap.get("filterItems");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.ReimburseLevelSettingQuery";
    }

    @Override
    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FCreatorID varchar(44), \n");
        sql.append("     FLastUpdateUserID varchar(44), \n");
        sql.append("     FControlUnitID varchar(44), \n");
        sql.append("     FPersonID VARCHAR(44), \n");
        sql.append("     FExpenseTypeID VARCHAR(44), \n");
        sql.append("     FReimburseLevelID VARCHAR(44), \n");
        sql.append("     FCompanyOrgUnitId VARCHAR(44), \n");
        sql.append("     FCreateTime DateTime, \n");
        sql.append("     FLastUpdateTime DateTime \n");
        sql.append(") \n");
        return sql.toString();
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FID,FCreatorID,FLastUpdateUserID,FControlUnitID, \n").append("FPersonID,FExpenseTypeID,FReimburseLevelID,FCompanyOrgUnitId, \n").append("FCreateTime,FLastUpdateTime) \n").append(" values (newbosid('9E6EEA88'),?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                String personId;
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                this.fPersonNumber = this.getData((SimpleRecord)rowData, "FPersonNumber");
                this.fExpensetypeNumber = this.getData((SimpleRecord)rowData, "FExpensetypeNumber");
                this.fReimburseLevelNumber = this.getData((SimpleRecord)rowData, "FReimburseLevelNumber");
                this.fCompanyOrgUnitNumber = this.getData((SimpleRecord)rowData, "FCompanyOrgUnitNumber");
                this.fCompanyOrgUnitName = this.getData((SimpleRecord)rowData, "FCompanyOrgUnitName");
                if (this.fPersonNumber == null || "".equals(this.fPersonNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNULL", null));
                    continue;
                }
                if (this.fExpensetypeNumber == null || "".equals(this.fExpensetypeNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FEXPENSETYPENUMBERISNULL", null));
                    continue;
                }
                if (this.fReimburseLevelNumber == null || "".equals(this.fReimburseLevelNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVELNUMBERISNULL", null));
                    continue;
                }
                if (this.fCompanyOrgUnitNumber == null || "".equals(this.fCompanyOrgUnitNumber) || this.fCompanyOrgUnitName == null || "".equals(this.fCompanyOrgUnitName)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FCOMPANYORGUNITNUMBERORNAMEISNOTBEINGINDB", null));
                    continue;
                }
                if (this.checkHasDuplicateDateInExcel(ctx, this.fPersonNumber, this.fExpensetypeNumber, this.fReimburseLevelNumber)) continue;
                CompanyOrgUnitInfo company = this.getCompanyOrgUnitByNumber(ctx, this.fCompanyOrgUnitNumber);
                String companyOrgUnitId = null;
                if (company == null || (personId = this.getPersonInfoByNumber(ctx, this.fPersonNumber, companyOrgUnitId = company.getId().toString())) == null) continue;
                ExpenseTypeInfo expenseTypeInfo = this.getExpenseTypeInfoByNumber(ctx, this.fExpensetypeNumber, company.getLongNumber());
                String expenseTypeId = "";
                if (expenseTypeInfo == null) continue;
                expenseTypeId = expenseTypeInfo.getId().toString();
                ReimburseLevelInfo reimburseLevelInfo = this.getReimburseLevelInfoByNumber(ctx, this.fReimburseLevelNumber);
                if (reimburseLevelInfo == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVELNUMBERISNOTEXISTINBASEINFO", new Object[]{this.fReimburseLevelNumber}));
                    continue;
                }
                if (EnableStateEnum.DISABLE.equals((Object)reimburseLevelInfo.getState())) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSELEVELISDISABLE", new Object[]{this.fReimburseLevelNumber}));
                    continue;
                }
                String reimburseLevelId = "";
                if (reimburseLevelInfo == null) continue;
                reimburseLevelId = reimburseLevelInfo.getId().toString();
                if (!this.isSltImportUpdate() && this.checkReimburseLevelSettingByThreeNumber(ctx, personId, expenseTypeId, companyOrgUnitId).booleanValue() || this.isSltImportUpdate() && this.checkReimburseLevelStateByThreeNumber(ctx, personId, expenseTypeId, companyOrgUnitId)) continue;
                if (!this.permissionSet.contains(companyOrgUnitId)) {
                    Boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(companyOrgUnitId), "cp_bc_ReimburseLevelSetting_Import");
                    if (hasFunctionPermission.booleanValue()) {
                        this.permissionSet.add(companyOrgUnitId);
                    } else {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "HASNOTFUNCTIONPERMISSION", new Object[]{personId}));
                        continue;
                    }
                }
                pstmtInsert.setString(1, this.userId);
                pstmtInsert.setString(2, this.userId);
                pstmtInsert.setString(3, this.cuId);
                pstmtInsert.setString(4, personId);
                pstmtInsert.setString(5, expenseTypeId);
                pstmtInsert.setString(6, reimburseLevelId);
                pstmtInsert.setString(7, companyOrgUnitId);
                java.util.Date utilDate = new java.util.Date();
                Date sqlDate = new Date(utilDate.getTime());
                pstmtInsert.setDate(8, sqlDate);
                pstmtInsert.setDate(9, sqlDate);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    private boolean checkReimburseLevelStateByThreeNumber(Context ctx, String fPersonID, String fExpenseTypeID, String fCompanyOrgUnitId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select fstate from T_BC_ReimburseLevelSetting \n");
        sql.append("where  FPersonID = '" + fPersonID + "' and  FExpenseTypeID = '" + fExpenseTypeID + "' and fcompanyorgunitid = '" + fCompanyOrgUnitId + "';\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next() && Integer.valueOf(rs.getInt(1)) == 20) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FSTATEISSUBMIT", new Object[]{this.fPersonNumber, this.fExpensetypeNumber}));
            return true;
        }
        return false;
    }

    private boolean checkHasDuplicateDateInExcel(Context ctx, String fPersonNumber, String fExpensetypeNumber, String fReimburseLevelNumber) throws Exception {
        if (this.map.containsKey(fPersonNumber)) {
            ArrayList<String> list = this.map.get(fPersonNumber);
            String fExp = list.get(0);
            String fRei = list.get(1);
            if (fExp.equals(fExpensetypeNumber) && fRei.equals(fReimburseLevelNumber) && !this.isSltImportUpdate()) {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISBEING", new Object[]{fPersonNumber, fExpensetypeNumber, fReimburseLevelNumber}));
                return true;
            }
            if (fExp.equals(fExpensetypeNumber) && fRei.equals(fReimburseLevelNumber) && this.isSltImportUpdate()) {
                return true;
            }
            ArrayList<String> listStr = new ArrayList<String>();
            listStr.add(fExpensetypeNumber);
            listStr.add(fReimburseLevelNumber);
            this.map.put(fPersonNumber, list);
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(fExpensetypeNumber);
        list.add(fReimburseLevelNumber);
        this.map.put(fPersonNumber, list);
        return false;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitByNumberOrName(Context ctx, String numberOrName) throws Exception {
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberOrName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)numberOrName, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitCollection collection = icompany.getCompanyOrgUnitCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            CompanyOrgUnitInfo info = collection.get(0);
            return info;
        }
        return null;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitByNumber(Context ctx, String number) throws Exception {
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitCollection collection = icompany.getCompanyOrgUnitCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            CompanyOrgUnitInfo info = collection.get(0);
            return info;
        }
        return null;
    }

    private ReimburseLevelInfo getReimburseLevelInfoByNumber(Context ctx, String fReimburseLevelNumber) throws Exception {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String[] numbers = StringUtils.split((String)cu.getLongNumber(), (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        ReimburseLevelInfo reimburseLevelInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fReimburseLevelNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.number", numberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ReimburseLevelCollection coll = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelCollection(view);
        if (coll != null && coll.size() > 0) {
            reimburseLevelInfo = coll.get(0);
        }
        return reimburseLevelInfo;
    }

    private ExpenseTypeInfo getExpenseTypeInfoByNumber(Context ctx, String fExpensetypeNumber, String companyLongNumber) throws Exception {
        ExpenseTypeInfo expenseTypeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String[] numbers = StringUtils.split((String)companyLongNumber, (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        filter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fExpensetypeNumber));
        view.setFilter(filter);
        ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(view);
        if (coll != null && coll.size() > 0) {
            expenseTypeInfo = coll.get(0);
        } else {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FEXPENSETYPENUMBERISNOTEXISTINBASEINFO", new Object[]{fExpensetypeNumber}));
        }
        return expenseTypeInfo;
    }

    private PersonInfo getPersonInfoByNumber(Context ctx, String fPersonNumber) throws Exception {
        PersonInfo person = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fPersonNumber));
        view.setFilter(filter);
        PersonCollection coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        if (coll != null && coll.size() > 0) {
            person = coll.get(0);
        } else {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNOTEXISTINBASEINFO", new Object[]{fPersonNumber}));
        }
        return person;
    }

    private String getPersonInfoByNumber(Context ctx, String fPersonNumber, String companyId) throws Exception {
        Object person = null;
        String queryPersonSql = "SELECT DISTINCT person.fid FID,person.fnumber FBUMBER FROM T_BD_Person person INNER JOIN  T_ORG_POSITIONMEMBER TOPM ON  TOPM.FPersonID = person.fid INNER JOIN T_ORG_POSITION TOPO ON TOPM.FPOSITIONID = TOPO.FID INNER JOIN T_ORG_ADMIN TOA ON TOA.FID = TOPO.FADMINORGUNITID INNER JOIN T_ORG_UNITRELATION TOUR ON TOUR.FFROMUNITID = TOA.FID INNER JOIN T_ORG_COMPANY TOC ON TOUR.FTOUNITID = TOC.FID INNER JOIN T_ORG_TYPERELATION TOTR ON TOTR.FID = TOUR.FTYPERELATIONID WHERE TOTR.FFROMTYPE = 0 AND TOTR.FTOTYPE = 1 AND TOC.FID = '%s' ";
        String personId = null;
        String personNumber = null;
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(queryPersonSql, companyId));
        while (result.next()) {
            personNumber = result.getString("FBUMBER");
            if (!fPersonNumber.equals(personNumber)) continue;
            personId = result.getString("FID");
            return personId;
        }
        if (personId == null) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNOTEXIST", new Object[]{fPersonNumber}));
        }
        return personId;
    }

    private Boolean checkReimburseLevelSettingByThreeNumber(Context ctx, String fPersonID, String fExpenseTypeID, String fCompanyOrgUnitId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BC_ReimburseLevelSetting \n");
        sql.append("where  FPersonID = '" + fPersonID + "' and  FExpenseTypeID = '" + fExpenseTypeID + "' and fcompanyorgunitid = '" + fCompanyOrgUnitId + "';\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() != 0) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISBEINGINDB", new Object[]{this.fPersonNumber, this.fExpensetypeNumber, this.fReimburseLevelNumber}));
            return true;
        }
        return false;
    }

    @Override
    protected int doProcessData(Context ctx) throws Exception {
        return this.submitData(ctx);
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_BC_ReimburseLevelSetting where fid in  ( \n");
            sql.append("    select collection.Fid from T_BC_ReimburseLevelSetting collection ");
            sql.append("    inner join " + this.tempTable + " t ON collection.FPersonID = t.FPersonID \n");
            sql.append("    AND collection.FExpenseTypeID = t.FExpenseTypeID  AND collection.FCompanyOrgUnitID = t.FCompanyOrgUnitID); \n");
        }
        sql.append("insert into T_BC_ReimburseLevelSetting ( \n");
        sql.append("    FID, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    FPersonID, \n");
        sql.append("    FExpenseTypeID, \n");
        sql.append("    FReimburseLevelID, \n");
        sql.append("    FCompanyOrgUnitID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateTime \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FCreatorID, \n");
        sql.append("    t.FLastUpdateUserID, \n");
        sql.append("    t.FControlUnitID, \n");
        sql.append("    t.FPersonID, \n");
        sql.append("    t.FExpenseTypeID, \n");
        sql.append("    t.FReimburseLevelID, \n");
        sql.append("    t.FCompanyOrgUnitID, \n");
        sql.append("    t.FCreateTime, \n");
        sql.append("    t.FLastUpdateTime \n");
        sql.append("from ").append(this.tempTable).append(" t ;\n");
        ReimburseLevelSettingListDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FPersonNumber", this.getNotBlankString(rs.getString("person.number")));
            result.put("FPersonName", this.getNotBlankString(rs.getString("person.name")));
            result.put("FExpensetypeNumber", this.getNotBlankString(rs.getString("expenseType.number")));
            result.put("FExpensetypeName", this.getNotBlankString(rs.getString("expenseType.name")));
            result.put("FReimburseLevelNumber", this.getNotBlankString(rs.getString("reimburseLevel.number")));
            result.put("FReimburseLevelName", this.getNotBlankString(rs.getString("reimburseLevel.name")));
            result.put("FCompanyOrgUnitNumber", this.getNotBlankString(rs.getString("companyOrgUnit.number")));
            result.put("FCompanyOrgUnitName", this.getNotBlankString(rs.getString("companyOrgUnit.name")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

